# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Optional
from typing_extensions import Literal

from pydantic import Field as FieldInfo

from .._models import BaseModel

__all__ = ["TelnyxCampaignCsp"]


class TelnyxCampaignCsp(BaseModel):
    brand_id: str = FieldInfo(alias="brandId")
    """Unique identifier assigned to the brand."""

    campaign_id: str = FieldInfo(alias="campaignId")
    """Unique identifier for a campaign."""

    csp_id: str = FieldInfo(alias="cspId")
    """Alphanumeric identifier of the CSP associated with this campaign."""

    description: str
    """Summary description of this campaign."""

    mock: bool
    """Campaign created from mock brand.

    Mocked campaign cannot be shared with an upstream CNP.
    """

    sub_usecases: List[str] = FieldInfo(alias="subUsecases")
    """Campaign sub-usecases.

    Must be of defined valid sub-usecase types. Use `/registry/enum/usecase`
    operation to retrieve list of valid sub-usecases
    """

    terms_and_conditions: bool = FieldInfo(alias="termsAndConditions")
    """Is terms & conditions accepted?"""

    usecase: str
    """Campaign usecase.

    Must be of defined valid types. Use `/registry/enum/usecase` operation to
    retrieve usecases available for given brand.
    """

    age_gated: Optional[bool] = FieldInfo(alias="ageGated", default=None)
    """Age gated content in campaign."""

    auto_renewal: Optional[bool] = FieldInfo(alias="autoRenewal", default=None)
    """Campaign subscription auto-renewal status."""

    billed_date: Optional[str] = FieldInfo(alias="billedDate", default=None)
    """Campaign recent billed date."""

    brand_display_name: Optional[str] = FieldInfo(alias="brandDisplayName", default=None)
    """Display or marketing name of the brand."""

    campaign_status: Optional[
        Literal[
            "TCR_PENDING",
            "TCR_SUSPENDED",
            "TCR_EXPIRED",
            "TCR_ACCEPTED",
            "TCR_FAILED",
            "TELNYX_ACCEPTED",
            "TELNYX_FAILED",
            "MNO_PENDING",
            "MNO_ACCEPTED",
            "MNO_REJECTED",
            "MNO_PROVISIONED",
            "MNO_PROVISIONING_FAILED",
        ]
    ] = FieldInfo(alias="campaignStatus", default=None)
    """Campaign status"""

    create_date: Optional[str] = FieldInfo(alias="createDate", default=None)
    """Unix timestamp when campaign was created."""

    direct_lending: Optional[bool] = FieldInfo(alias="directLending", default=None)

    embedded_link: Optional[bool] = FieldInfo(alias="embeddedLink", default=None)
    """Does message generated by the campaign include URL link in SMS?"""

    embedded_link_sample: Optional[str] = FieldInfo(alias="embeddedLinkSample", default=None)
    """Sample of an embedded link that will be sent to subscribers."""

    embedded_phone: Optional[bool] = FieldInfo(alias="embeddedPhone", default=None)
    """Does message generated by the campaign include phone number in SMS?"""

    failure_reasons: Optional[str] = FieldInfo(alias="failureReasons", default=None)
    """Failure reasons if campaign submission failed"""

    help_keywords: Optional[str] = FieldInfo(alias="helpKeywords", default=None)
    """Subscriber help keywords. Multiple keywords are comma separated without space."""

    help_message: Optional[str] = FieldInfo(alias="helpMessage", default=None)
    """Help message of the campaign."""

    is_t_mobile_number_pooling_enabled: Optional[bool] = FieldInfo(alias="isTMobileNumberPoolingEnabled", default=None)
    """
    Indicates whether the campaign has a T-Mobile number pool ID associated with it.
    """

    is_t_mobile_registered: Optional[bool] = FieldInfo(alias="isTMobileRegistered", default=None)
    """Indicates whether the campaign is registered with T-Mobile."""

    is_t_mobile_suspended: Optional[bool] = FieldInfo(alias="isTMobileSuspended", default=None)
    """Indicates whether the campaign is suspended with T-Mobile."""

    message_flow: Optional[str] = FieldInfo(alias="messageFlow", default=None)
    """Message flow description."""

    next_renewal_or_expiration_date: Optional[str] = FieldInfo(alias="nextRenewalOrExpirationDate", default=None)
    """When the campaign would be due for its next renew/bill date."""

    number_pool: Optional[bool] = FieldInfo(alias="numberPool", default=None)
    """Does campaign utilize pool of phone numbers?"""

    optin_keywords: Optional[str] = FieldInfo(alias="optinKeywords", default=None)
    """Subscriber opt-in keywords.

    Multiple keywords are comma separated without space.
    """

    optin_message: Optional[str] = FieldInfo(alias="optinMessage", default=None)
    """Subscriber opt-in message."""

    optout_keywords: Optional[str] = FieldInfo(alias="optoutKeywords", default=None)
    """Subscriber opt-out keywords.

    Multiple keywords are comma separated without space.
    """

    optout_message: Optional[str] = FieldInfo(alias="optoutMessage", default=None)
    """Subscriber opt-out message."""

    privacy_policy_link: Optional[str] = FieldInfo(alias="privacyPolicyLink", default=None)
    """Link to the campaign's privacy policy."""

    reference_id: Optional[str] = FieldInfo(alias="referenceId", default=None)
    """Caller supplied campaign reference ID.

    If supplied, the value must be unique across all submitted campaigns. Can be
    used to prevent duplicate campaign registrations.
    """

    reseller_id: Optional[str] = FieldInfo(alias="resellerId", default=None)
    """
    Alphanumeric identifier of the reseller that you want to associate with this
    campaign.
    """

    sample1: Optional[str] = None
    """Message sample. Some campaign tiers require 1 or more message samples."""

    sample2: Optional[str] = None
    """Message sample. Some campaign tiers require 2 or more message samples."""

    sample3: Optional[str] = None
    """Message sample. Some campaign tiers require 3 or more message samples."""

    sample4: Optional[str] = None
    """Message sample. Some campaign tiers require 4 or more message samples."""

    sample5: Optional[str] = None
    """Message sample. Some campaign tiers require 5 or more message samples."""

    status: Optional[str] = None
    """Current campaign status.

    Possible values: ACTIVE, EXPIRED. A newly created campaign defaults to ACTIVE
    status.
    """

    submission_status: Optional[Literal["CREATED", "FAILED", "PENDING"]] = FieldInfo(
        alias="submissionStatus", default=None
    )
    """Campaign submission status"""

    subscriber_help: Optional[bool] = FieldInfo(alias="subscriberHelp", default=None)
    """Does campaign responds to help keyword(s)?"""

    subscriber_optin: Optional[bool] = FieldInfo(alias="subscriberOptin", default=None)
    """Does campaign require subscriber to opt-in before SMS is sent to subscriber?"""

    subscriber_optout: Optional[bool] = FieldInfo(alias="subscriberOptout", default=None)
    """Does campaign support subscriber opt-out keyword(s)?"""

    tcr_brand_id: Optional[str] = FieldInfo(alias="tcrBrandId", default=None)
    """Unique identifier assigned to the brand by the registry."""

    tcr_campaign_id: Optional[str] = FieldInfo(alias="tcrCampaignId", default=None)
    """Unique identifier assigned to the campaign by the registry."""

    terms_and_conditions_link: Optional[str] = FieldInfo(alias="termsAndConditionsLink", default=None)
    """Link to the campaign's terms and conditions."""

    vertical: Optional[str] = None
    """Business/industry segment of this campaign (Deprecated).

    Must be of defined valid types. Use `/registry/enum/vertical` operation to
    retrieve verticals available for given brand, vertical combination.

    This field is deprecated.
    """

    webhook_failover_url: Optional[str] = FieldInfo(alias="webhookFailoverURL", default=None)
    """Failover webhook to which campaign status updates are sent."""

    webhook_url: Optional[str] = FieldInfo(alias="webhookURL", default=None)
    """Webhook to which campaign status updates are sent."""
