# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Optional
from typing_extensions import Literal

from pydantic import Field as FieldInfo

from .._models import BaseModel

__all__ = ["TelnyxDownstreamCampaign"]


class TelnyxDownstreamCampaign(BaseModel):
    tcr_brand_id: str = FieldInfo(alias="tcrBrandId")
    """Unique identifier assigned to the brand by the registry."""

    tcr_campaign_id: str = FieldInfo(alias="tcrCampaignId")
    """Unique identifier assigned to the campaign by the registry."""

    age_gated: Optional[bool] = FieldInfo(alias="ageGated", default=None)
    """Age gated content in campaign."""

    assigned_phone_numbers_count: Optional[float] = FieldInfo(alias="assignedPhoneNumbersCount", default=None)
    """Number of phone numbers associated with the campaign"""

    brand_display_name: Optional[str] = FieldInfo(alias="brandDisplayName", default=None)
    """Display or marketing name of the brand."""

    campaign_status: Optional[
        Literal[
            "TCR_PENDING",
            "TCR_SUSPENDED",
            "TCR_EXPIRED",
            "TCR_ACCEPTED",
            "TCR_FAILED",
            "TELNYX_ACCEPTED",
            "TELNYX_FAILED",
            "MNO_PENDING",
            "MNO_ACCEPTED",
            "MNO_REJECTED",
            "MNO_PROVISIONED",
            "MNO_PROVISIONING_FAILED",
        ]
    ] = FieldInfo(alias="campaignStatus", default=None)
    """Campaign status"""

    created_at: Optional[str] = FieldInfo(alias="createdAt", default=None)
    """Date and time that the brand was created at."""

    description: Optional[str] = None
    """Summary description of this campaign."""

    direct_lending: Optional[bool] = FieldInfo(alias="directLending", default=None)
    """Direct lending or loan arrangement."""

    embedded_link: Optional[bool] = FieldInfo(alias="embeddedLink", default=None)
    """Does message generated by the campaign include URL link in SMS?"""

    embedded_link_sample: Optional[str] = FieldInfo(alias="embeddedLinkSample", default=None)
    """Sample of an embedded link that will be sent to subscribers."""

    embedded_phone: Optional[bool] = FieldInfo(alias="embeddedPhone", default=None)
    """Does message generated by the campaign include phone number in SMS?"""

    failure_reasons: Optional[str] = FieldInfo(alias="failureReasons", default=None)
    """Failure reasons if campaign submission failed"""

    help_keywords: Optional[str] = FieldInfo(alias="helpKeywords", default=None)
    """Subscriber help keywords. Multiple keywords are comma separated without space."""

    help_message: Optional[str] = FieldInfo(alias="helpMessage", default=None)
    """Help message of the campaign."""

    is_number_pooling_enabled: Optional[bool] = FieldInfo(alias="isNumberPoolingEnabled", default=None)
    """
    Indicates whether the campaign has a T-Mobile number pool ID associated with it.
    """

    message_flow: Optional[str] = FieldInfo(alias="messageFlow", default=None)
    """Message flow description."""

    number_pool: Optional[bool] = FieldInfo(alias="numberPool", default=None)
    """Does campaign utilize pool of phone numbers?"""

    optin_keywords: Optional[str] = FieldInfo(alias="optinKeywords", default=None)
    """Subscriber opt-in keywords.

    Multiple keywords are comma separated without space.
    """

    optin_message: Optional[str] = FieldInfo(alias="optinMessage", default=None)
    """Subscriber opt-in message."""

    optout_keywords: Optional[str] = FieldInfo(alias="optoutKeywords", default=None)
    """Subscriber opt-out keywords.

    Multiple keywords are comma separated without space.
    """

    optout_message: Optional[str] = FieldInfo(alias="optoutMessage", default=None)
    """Subscriber opt-out message."""

    privacy_policy_link: Optional[str] = FieldInfo(alias="privacyPolicyLink", default=None)
    """Link to the campaign's privacy policy."""

    sample1: Optional[str] = None
    """Message sample. Some campaign tiers require 1 or more message samples."""

    sample2: Optional[str] = None
    """Message sample. Some campaign tiers require 2 or more message samples."""

    sample3: Optional[str] = None
    """Message sample. Some campaign tiers require 3 or more message samples."""

    sample4: Optional[str] = None
    """Message sample. Some campaign tiers require 4 or more message samples."""

    sample5: Optional[str] = None
    """Message sample. Some campaign tiers require 5 or more message samples."""

    subscriber_optin: Optional[bool] = FieldInfo(alias="subscriberOptin", default=None)
    """Does campaign require subscriber to opt-in before SMS is sent to subscriber?"""

    subscriber_optout: Optional[bool] = FieldInfo(alias="subscriberOptout", default=None)
    """Does campaign support subscriber opt-out keyword(s)?"""

    sub_usecases: Optional[List[str]] = FieldInfo(alias="subUsecases", default=None)
    """Campaign sub-usecases.

    Must be of defined valid sub-usecase types. Use `/registry/enum/usecase`
    operation to retrieve list of valid sub-usecases
    """

    terms_and_conditions: Optional[bool] = FieldInfo(alias="termsAndConditions", default=None)
    """Is terms & conditions accepted?"""

    terms_and_conditions_link: Optional[str] = FieldInfo(alias="termsAndConditionsLink", default=None)
    """Link to the campaign's terms and conditions."""

    updated_at: Optional[str] = FieldInfo(alias="updatedAt", default=None)
    """Date and time that the brand was last updated at."""

    usecase: Optional[str] = None
    """Campaign usecase.

    Must be of defined valid types. Use `/registry/enum/usecase` operation to
    retrieve usecases available for given brand.
    """

    webhook_failover_url: Optional[str] = FieldInfo(alias="webhookFailoverURL", default=None)
    """Failover webhook to which campaign status updates are sent."""

    webhook_url: Optional[str] = FieldInfo(alias="webhookURL", default=None)
    """Webhook to which campaign status updates are sent."""
