# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, cast

import pytest

from telnyx import Telnyx, AsyncTelnyx
from tests.utils import assert_matches_type
from telnyx.types import (
    BillingGroupListResponse,
    BillingGroupCreateResponse,
    BillingGroupDeleteResponse,
    BillingGroupUpdateResponse,
    BillingGroupRetrieveResponse,
)

base_url = os.environ.get("TEST_API_BASE_URL", "http://127.0.0.1:4010")


class TestBillingGroups:
    parametrize = pytest.mark.parametrize("client", [False, True], indirect=True, ids=["loose", "strict"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_create(self, client: Telnyx) -> None:
        billing_group = client.billing_groups.create()
        assert_matches_type(BillingGroupCreateResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_create_with_all_params(self, client: Telnyx) -> None:
        billing_group = client.billing_groups.create(
            name="string",
        )
        assert_matches_type(BillingGroupCreateResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_raw_response_create(self, client: Telnyx) -> None:
        response = client.billing_groups.with_raw_response.create()

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        billing_group = response.parse()
        assert_matches_type(BillingGroupCreateResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_streaming_response_create(self, client: Telnyx) -> None:
        with client.billing_groups.with_streaming_response.create() as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            billing_group = response.parse()
            assert_matches_type(BillingGroupCreateResponse, billing_group, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_retrieve(self, client: Telnyx) -> None:
        billing_group = client.billing_groups.retrieve(
            "f5586561-8ff0-4291-a0ac-84fe544797bd",
        )
        assert_matches_type(BillingGroupRetrieveResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_raw_response_retrieve(self, client: Telnyx) -> None:
        response = client.billing_groups.with_raw_response.retrieve(
            "f5586561-8ff0-4291-a0ac-84fe544797bd",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        billing_group = response.parse()
        assert_matches_type(BillingGroupRetrieveResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_streaming_response_retrieve(self, client: Telnyx) -> None:
        with client.billing_groups.with_streaming_response.retrieve(
            "f5586561-8ff0-4291-a0ac-84fe544797bd",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            billing_group = response.parse()
            assert_matches_type(BillingGroupRetrieveResponse, billing_group, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_path_params_retrieve(self, client: Telnyx) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `id` but received ''"):
            client.billing_groups.with_raw_response.retrieve(
                "",
            )

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_update(self, client: Telnyx) -> None:
        billing_group = client.billing_groups.update(
            id="f5586561-8ff0-4291-a0ac-84fe544797bd",
        )
        assert_matches_type(BillingGroupUpdateResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_update_with_all_params(self, client: Telnyx) -> None:
        billing_group = client.billing_groups.update(
            id="f5586561-8ff0-4291-a0ac-84fe544797bd",
            name="string",
        )
        assert_matches_type(BillingGroupUpdateResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_raw_response_update(self, client: Telnyx) -> None:
        response = client.billing_groups.with_raw_response.update(
            id="f5586561-8ff0-4291-a0ac-84fe544797bd",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        billing_group = response.parse()
        assert_matches_type(BillingGroupUpdateResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_streaming_response_update(self, client: Telnyx) -> None:
        with client.billing_groups.with_streaming_response.update(
            id="f5586561-8ff0-4291-a0ac-84fe544797bd",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            billing_group = response.parse()
            assert_matches_type(BillingGroupUpdateResponse, billing_group, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_path_params_update(self, client: Telnyx) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `id` but received ''"):
            client.billing_groups.with_raw_response.update(
                id="",
            )

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_list(self, client: Telnyx) -> None:
        billing_group = client.billing_groups.list()
        assert_matches_type(BillingGroupListResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_list_with_all_params(self, client: Telnyx) -> None:
        billing_group = client.billing_groups.list(
            page={
                "number": 1,
                "size": 1,
            },
        )
        assert_matches_type(BillingGroupListResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_raw_response_list(self, client: Telnyx) -> None:
        response = client.billing_groups.with_raw_response.list()

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        billing_group = response.parse()
        assert_matches_type(BillingGroupListResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_streaming_response_list(self, client: Telnyx) -> None:
        with client.billing_groups.with_streaming_response.list() as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            billing_group = response.parse()
            assert_matches_type(BillingGroupListResponse, billing_group, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_delete(self, client: Telnyx) -> None:
        billing_group = client.billing_groups.delete(
            "f5586561-8ff0-4291-a0ac-84fe544797bd",
        )
        assert_matches_type(BillingGroupDeleteResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_raw_response_delete(self, client: Telnyx) -> None:
        response = client.billing_groups.with_raw_response.delete(
            "f5586561-8ff0-4291-a0ac-84fe544797bd",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        billing_group = response.parse()
        assert_matches_type(BillingGroupDeleteResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_streaming_response_delete(self, client: Telnyx) -> None:
        with client.billing_groups.with_streaming_response.delete(
            "f5586561-8ff0-4291-a0ac-84fe544797bd",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            billing_group = response.parse()
            assert_matches_type(BillingGroupDeleteResponse, billing_group, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_path_params_delete(self, client: Telnyx) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `id` but received ''"):
            client.billing_groups.with_raw_response.delete(
                "",
            )


class TestAsyncBillingGroups:
    parametrize = pytest.mark.parametrize(
        "async_client", [False, True, {"http_client": "aiohttp"}], indirect=True, ids=["loose", "strict", "aiohttp"]
    )

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_create(self, async_client: AsyncTelnyx) -> None:
        billing_group = await async_client.billing_groups.create()
        assert_matches_type(BillingGroupCreateResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_create_with_all_params(self, async_client: AsyncTelnyx) -> None:
        billing_group = await async_client.billing_groups.create(
            name="string",
        )
        assert_matches_type(BillingGroupCreateResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_raw_response_create(self, async_client: AsyncTelnyx) -> None:
        response = await async_client.billing_groups.with_raw_response.create()

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        billing_group = await response.parse()
        assert_matches_type(BillingGroupCreateResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_streaming_response_create(self, async_client: AsyncTelnyx) -> None:
        async with async_client.billing_groups.with_streaming_response.create() as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            billing_group = await response.parse()
            assert_matches_type(BillingGroupCreateResponse, billing_group, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_retrieve(self, async_client: AsyncTelnyx) -> None:
        billing_group = await async_client.billing_groups.retrieve(
            "f5586561-8ff0-4291-a0ac-84fe544797bd",
        )
        assert_matches_type(BillingGroupRetrieveResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_raw_response_retrieve(self, async_client: AsyncTelnyx) -> None:
        response = await async_client.billing_groups.with_raw_response.retrieve(
            "f5586561-8ff0-4291-a0ac-84fe544797bd",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        billing_group = await response.parse()
        assert_matches_type(BillingGroupRetrieveResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_streaming_response_retrieve(self, async_client: AsyncTelnyx) -> None:
        async with async_client.billing_groups.with_streaming_response.retrieve(
            "f5586561-8ff0-4291-a0ac-84fe544797bd",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            billing_group = await response.parse()
            assert_matches_type(BillingGroupRetrieveResponse, billing_group, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_path_params_retrieve(self, async_client: AsyncTelnyx) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `id` but received ''"):
            await async_client.billing_groups.with_raw_response.retrieve(
                "",
            )

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_update(self, async_client: AsyncTelnyx) -> None:
        billing_group = await async_client.billing_groups.update(
            id="f5586561-8ff0-4291-a0ac-84fe544797bd",
        )
        assert_matches_type(BillingGroupUpdateResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_update_with_all_params(self, async_client: AsyncTelnyx) -> None:
        billing_group = await async_client.billing_groups.update(
            id="f5586561-8ff0-4291-a0ac-84fe544797bd",
            name="string",
        )
        assert_matches_type(BillingGroupUpdateResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_raw_response_update(self, async_client: AsyncTelnyx) -> None:
        response = await async_client.billing_groups.with_raw_response.update(
            id="f5586561-8ff0-4291-a0ac-84fe544797bd",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        billing_group = await response.parse()
        assert_matches_type(BillingGroupUpdateResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_streaming_response_update(self, async_client: AsyncTelnyx) -> None:
        async with async_client.billing_groups.with_streaming_response.update(
            id="f5586561-8ff0-4291-a0ac-84fe544797bd",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            billing_group = await response.parse()
            assert_matches_type(BillingGroupUpdateResponse, billing_group, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_path_params_update(self, async_client: AsyncTelnyx) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `id` but received ''"):
            await async_client.billing_groups.with_raw_response.update(
                id="",
            )

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_list(self, async_client: AsyncTelnyx) -> None:
        billing_group = await async_client.billing_groups.list()
        assert_matches_type(BillingGroupListResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_list_with_all_params(self, async_client: AsyncTelnyx) -> None:
        billing_group = await async_client.billing_groups.list(
            page={
                "number": 1,
                "size": 1,
            },
        )
        assert_matches_type(BillingGroupListResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_raw_response_list(self, async_client: AsyncTelnyx) -> None:
        response = await async_client.billing_groups.with_raw_response.list()

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        billing_group = await response.parse()
        assert_matches_type(BillingGroupListResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_streaming_response_list(self, async_client: AsyncTelnyx) -> None:
        async with async_client.billing_groups.with_streaming_response.list() as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            billing_group = await response.parse()
            assert_matches_type(BillingGroupListResponse, billing_group, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_delete(self, async_client: AsyncTelnyx) -> None:
        billing_group = await async_client.billing_groups.delete(
            "f5586561-8ff0-4291-a0ac-84fe544797bd",
        )
        assert_matches_type(BillingGroupDeleteResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_raw_response_delete(self, async_client: AsyncTelnyx) -> None:
        response = await async_client.billing_groups.with_raw_response.delete(
            "f5586561-8ff0-4291-a0ac-84fe544797bd",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        billing_group = await response.parse()
        assert_matches_type(BillingGroupDeleteResponse, billing_group, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_streaming_response_delete(self, async_client: AsyncTelnyx) -> None:
        async with async_client.billing_groups.with_streaming_response.delete(
            "f5586561-8ff0-4291-a0ac-84fe544797bd",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            billing_group = await response.parse()
            assert_matches_type(BillingGroupDeleteResponse, billing_group, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_path_params_delete(self, async_client: AsyncTelnyx) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `id` but received ''"):
            await async_client.billing_groups.with_raw_response.delete(
                "",
            )
