# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, cast

import pytest

from telnyx import Telnyx, AsyncTelnyx
from tests.utils import assert_matches_type
from telnyx.types import RequirementTypeListResponse, RequirementTypeRetrieveResponse

base_url = os.environ.get("TEST_API_BASE_URL", "http://127.0.0.1:4010")


class TestRequirementTypes:
    parametrize = pytest.mark.parametrize("client", [False, True], indirect=True, ids=["loose", "strict"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_retrieve(self, client: Telnyx) -> None:
        requirement_type = client.requirement_types.retrieve(
            "a38c217a-8019-48f8-bff6-0fdd9939075b",
        )
        assert_matches_type(RequirementTypeRetrieveResponse, requirement_type, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_raw_response_retrieve(self, client: Telnyx) -> None:
        response = client.requirement_types.with_raw_response.retrieve(
            "a38c217a-8019-48f8-bff6-0fdd9939075b",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        requirement_type = response.parse()
        assert_matches_type(RequirementTypeRetrieveResponse, requirement_type, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_streaming_response_retrieve(self, client: Telnyx) -> None:
        with client.requirement_types.with_streaming_response.retrieve(
            "a38c217a-8019-48f8-bff6-0fdd9939075b",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            requirement_type = response.parse()
            assert_matches_type(RequirementTypeRetrieveResponse, requirement_type, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_path_params_retrieve(self, client: Telnyx) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `id` but received ''"):
            client.requirement_types.with_raw_response.retrieve(
                "",
            )

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_list(self, client: Telnyx) -> None:
        requirement_type = client.requirement_types.list()
        assert_matches_type(RequirementTypeListResponse, requirement_type, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_list_with_all_params(self, client: Telnyx) -> None:
        requirement_type = client.requirement_types.list(
            filter={"name": {"contains": "utility bill"}},
            sort=["name"],
        )
        assert_matches_type(RequirementTypeListResponse, requirement_type, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_raw_response_list(self, client: Telnyx) -> None:
        response = client.requirement_types.with_raw_response.list()

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        requirement_type = response.parse()
        assert_matches_type(RequirementTypeListResponse, requirement_type, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_streaming_response_list(self, client: Telnyx) -> None:
        with client.requirement_types.with_streaming_response.list() as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            requirement_type = response.parse()
            assert_matches_type(RequirementTypeListResponse, requirement_type, path=["response"])

        assert cast(Any, response.is_closed) is True


class TestAsyncRequirementTypes:
    parametrize = pytest.mark.parametrize(
        "async_client", [False, True, {"http_client": "aiohttp"}], indirect=True, ids=["loose", "strict", "aiohttp"]
    )

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_retrieve(self, async_client: AsyncTelnyx) -> None:
        requirement_type = await async_client.requirement_types.retrieve(
            "a38c217a-8019-48f8-bff6-0fdd9939075b",
        )
        assert_matches_type(RequirementTypeRetrieveResponse, requirement_type, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_raw_response_retrieve(self, async_client: AsyncTelnyx) -> None:
        response = await async_client.requirement_types.with_raw_response.retrieve(
            "a38c217a-8019-48f8-bff6-0fdd9939075b",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        requirement_type = await response.parse()
        assert_matches_type(RequirementTypeRetrieveResponse, requirement_type, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_streaming_response_retrieve(self, async_client: AsyncTelnyx) -> None:
        async with async_client.requirement_types.with_streaming_response.retrieve(
            "a38c217a-8019-48f8-bff6-0fdd9939075b",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            requirement_type = await response.parse()
            assert_matches_type(RequirementTypeRetrieveResponse, requirement_type, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_path_params_retrieve(self, async_client: AsyncTelnyx) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `id` but received ''"):
            await async_client.requirement_types.with_raw_response.retrieve(
                "",
            )

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_list(self, async_client: AsyncTelnyx) -> None:
        requirement_type = await async_client.requirement_types.list()
        assert_matches_type(RequirementTypeListResponse, requirement_type, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_list_with_all_params(self, async_client: AsyncTelnyx) -> None:
        requirement_type = await async_client.requirement_types.list(
            filter={"name": {"contains": "utility bill"}},
            sort=["name"],
        )
        assert_matches_type(RequirementTypeListResponse, requirement_type, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_raw_response_list(self, async_client: AsyncTelnyx) -> None:
        response = await async_client.requirement_types.with_raw_response.list()

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        requirement_type = await response.parse()
        assert_matches_type(RequirementTypeListResponse, requirement_type, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_streaming_response_list(self, async_client: AsyncTelnyx) -> None:
        async with async_client.requirement_types.with_streaming_response.list() as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            requirement_type = await response.parse()
            assert_matches_type(RequirementTypeListResponse, requirement_type, path=["response"])

        assert cast(Any, response.is_closed) is True
