# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, cast

import pytest

from telnyx import Telnyx, AsyncTelnyx
from tests.utils import assert_matches_type
from telnyx.types import RequirementListResponse, RequirementRetrieveResponse

base_url = os.environ.get("TEST_API_BASE_URL", "http://127.0.0.1:4010")


class TestRequirements:
    parametrize = pytest.mark.parametrize("client", [False, True], indirect=True, ids=["loose", "strict"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_retrieve(self, client: Telnyx) -> None:
        requirement = client.requirements.retrieve(
            "a9dad8d5-fdbd-49d7-aa23-39bb08a5ebaa",
        )
        assert_matches_type(RequirementRetrieveResponse, requirement, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_raw_response_retrieve(self, client: Telnyx) -> None:
        response = client.requirements.with_raw_response.retrieve(
            "a9dad8d5-fdbd-49d7-aa23-39bb08a5ebaa",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        requirement = response.parse()
        assert_matches_type(RequirementRetrieveResponse, requirement, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_streaming_response_retrieve(self, client: Telnyx) -> None:
        with client.requirements.with_streaming_response.retrieve(
            "a9dad8d5-fdbd-49d7-aa23-39bb08a5ebaa",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            requirement = response.parse()
            assert_matches_type(RequirementRetrieveResponse, requirement, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_path_params_retrieve(self, client: Telnyx) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `id` but received ''"):
            client.requirements.with_raw_response.retrieve(
                "",
            )

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_list(self, client: Telnyx) -> None:
        requirement = client.requirements.list()
        assert_matches_type(RequirementListResponse, requirement, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_list_with_all_params(self, client: Telnyx) -> None:
        requirement = client.requirements.list(
            filter={
                "action": "porting",
                "country_code": "US",
                "phone_number_type": "local",
            },
            page={
                "number": 1,
                "size": 1,
            },
            sort=["country_code"],
        )
        assert_matches_type(RequirementListResponse, requirement, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_raw_response_list(self, client: Telnyx) -> None:
        response = client.requirements.with_raw_response.list()

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        requirement = response.parse()
        assert_matches_type(RequirementListResponse, requirement, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_streaming_response_list(self, client: Telnyx) -> None:
        with client.requirements.with_streaming_response.list() as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            requirement = response.parse()
            assert_matches_type(RequirementListResponse, requirement, path=["response"])

        assert cast(Any, response.is_closed) is True


class TestAsyncRequirements:
    parametrize = pytest.mark.parametrize(
        "async_client", [False, True, {"http_client": "aiohttp"}], indirect=True, ids=["loose", "strict", "aiohttp"]
    )

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_retrieve(self, async_client: AsyncTelnyx) -> None:
        requirement = await async_client.requirements.retrieve(
            "a9dad8d5-fdbd-49d7-aa23-39bb08a5ebaa",
        )
        assert_matches_type(RequirementRetrieveResponse, requirement, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_raw_response_retrieve(self, async_client: AsyncTelnyx) -> None:
        response = await async_client.requirements.with_raw_response.retrieve(
            "a9dad8d5-fdbd-49d7-aa23-39bb08a5ebaa",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        requirement = await response.parse()
        assert_matches_type(RequirementRetrieveResponse, requirement, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_streaming_response_retrieve(self, async_client: AsyncTelnyx) -> None:
        async with async_client.requirements.with_streaming_response.retrieve(
            "a9dad8d5-fdbd-49d7-aa23-39bb08a5ebaa",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            requirement = await response.parse()
            assert_matches_type(RequirementRetrieveResponse, requirement, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_path_params_retrieve(self, async_client: AsyncTelnyx) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `id` but received ''"):
            await async_client.requirements.with_raw_response.retrieve(
                "",
            )

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_list(self, async_client: AsyncTelnyx) -> None:
        requirement = await async_client.requirements.list()
        assert_matches_type(RequirementListResponse, requirement, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_list_with_all_params(self, async_client: AsyncTelnyx) -> None:
        requirement = await async_client.requirements.list(
            filter={
                "action": "porting",
                "country_code": "US",
                "phone_number_type": "local",
            },
            page={
                "number": 1,
                "size": 1,
            },
            sort=["country_code"],
        )
        assert_matches_type(RequirementListResponse, requirement, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_raw_response_list(self, async_client: AsyncTelnyx) -> None:
        response = await async_client.requirements.with_raw_response.list()

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        requirement = await response.parse()
        assert_matches_type(RequirementListResponse, requirement, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_streaming_response_list(self, async_client: AsyncTelnyx) -> None:
        async with async_client.requirements.with_streaming_response.list() as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            requirement = await response.parse()
            assert_matches_type(RequirementListResponse, requirement, path=["response"])

        assert cast(Any, response.is_closed) is True
