###################################################################################################
#  KaptsjaPictureIco creates the Kaptsja_bg.jpg and Kaptsja.ico and puts them in media_dir 
#  Kaptsja is the Dutch phonetic pronunciation of the English word Captcha.
#
#  WARNING: BEFORE CHANGING ANYTHING IN THIS FILE MAKE A BACKUP SO YOU CAN RESTORE !
#  Read the comments in this file as they contain valuable information to understand the effects 
###################################################################################################


import sys
# sys.path.append("/path/to/your/package_or_module")
sys.path.append(r"./scripts")
import base64
from KaptsjaConfiguration import *
import os
import logging
serve_path = os.getcwd()  
try:
    logging.basicConfig(filename=log_file, level=logging.DEBUG, \
        format='%(asctime)s %(levelname)-8s %(message)s', \
        datefmt='%Y-%m-%d %H:%M:%S')
except PermissionError as e:
    print("Check permissions for Kaptsja and its subdirectories.\n\n%s\n\n" % e)
    sys.exit()
except Exception as e:
    print("Start this program from Kaptsja home directory. It was started in %s.\n\n%s\n\n" %(serve_path, e) )
    sys.exit()

def create_Kaptsja_ico(ico_file): # the stadard favicon.ico displayed on Web browser tabs
    ico_encoded = b'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'
    try:
        ico_bin = base64.b64decode(ico_encoded)
        f = open(ico_file, "wb")
        f.write(ico_bin)
        f.close()
        return 0
    except:
        text = "File %s in directory %s.\nFailure to create. Is import base64 missing?  Has value of ico_encoded in KaptsjaHTMLpages.py been corrupted?" % (ico_file, media_dir)
        logging.error(text)
        return 1
    
def create_input_picture(input_picture_file): # the standard favicon.ico displayed on Web browser tabs
    
    pic_encoded = b'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'
    try:
        pic_bin = base64.b64decode(pic_encoded)
        f = open(input_picture_file, "wb")
        f.write(pic_bin)
        f.close()
        return 0
    except:
        text = "File %s in directory %s.\nFailure to create. Is import base64 missing? Has value of pic_encoded in KaptsjaHTMLpages.py been corrupted?" % (ico_file, media_dir)
        logging.error(text)
        return 1

if __name__ == '__main__':

    if not "ico_file" in globals():
       ico_file = media_dir + r"Kaptsja.ico"     
    if os.path.exists(ico_file) == False:
        text = "File %s did not exist in directory %s.\nIt will be created." % (ico_file, media_dir)
        logging.error(text)
        retcode = create_Kaptsja_ico(ico_file)
        if retcode == 0:
            print("File %s did not exist. Now created." % ico_file )
        else:
            print("File %s did not exist. Error occured, while trying to create it. Check log file." % ico_file )
    else:
        print("File %s does exist." % ico_file )

    if not "input_picture_file" in globals():
       input_picture_file = media_dir + r"Kaptsja_bg.jpg" 
    if os.path.exists(input_picture_file) == False:
        text = "File %s did not exist in directory %s.\nIt will be created." % (input_picture_file, media_dir)
        logging.error(text)
        retcode = create_input_picture(input_picture_file)
        if retcode == 0:
            print("File %s did not exist. Now created." % input_picture_file )
        else:
            print("File %s did not exist. Error occured, while trying to create it. Check log file." % input_picture_file )
    else:
        print("File %s does exist." % input_picture_file )
        
