import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DashboardJsonConfig extends cdktf.TerraformMetaArguments {
    /**
     * The JSON formatted definition of the Dashboard.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json.html#dashboard DashboardJson#dashboard}
     *
     * @stability stable
     */
    readonly dashboard: string;
    /**
     * The list of dashboard lists this dashboard belongs to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json.html#dashboard_lists DashboardJson#dashboard_lists}
     *
     * @stability stable
     */
    readonly dashboardLists?: number[];
    /**
     * The URL of the dashboard.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json.html#url DashboardJson#url}
     *
     * @stability stable
     */
    readonly url?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json.html datadog_dashboard_json}.
 *
 * @stability stable
 */
export declare class DashboardJson extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/dashboard_json.html datadog_dashboard_json} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DashboardJsonConfig);
    private _dashboard?;
    /**
     * @stability stable
     */
    get dashboard(): string;
    /**
     * @stability stable
     */
    set dashboard(value: string);
    /**
     * @stability stable
     */
    get dashboardInput(): string | undefined;
    private _dashboardLists?;
    /**
     * @stability stable
     */
    get dashboardLists(): number[] | undefined;
    /**
     * @stability stable
     */
    set dashboardLists(value: number[] | undefined);
    /**
     * @stability stable
     */
    resetDashboardLists(): void;
    /**
     * @stability stable
     */
    get dashboardListsInput(): number[] | undefined;
    /**
     * @stability stable
     */
    get dashboardListsRemoved(): any;
    /**
     * @stability stable
     */
    get id(): string;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string | undefined;
    /**
     * @stability stable
     */
    set url(value: string | undefined);
    /**
     * @stability stable
     */
    resetUrl(): void;
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
