import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DashboardConfig extends cdktf.TerraformMetaArguments {
    /**
     * A list of dashboard lists this dashboard belongs to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#dashboard_lists Dashboard#dashboard_lists}
     *
     * @stability stable
     */
    readonly dashboardLists?: number[];
    /**
     * The description of the dashboard.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#description Dashboard#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Whether this dashboard is read-only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#is_read_only Dashboard#is_read_only}
     *
     * @stability stable
     */
    readonly isReadOnly?: boolean | cdktf.IResolvable;
    /**
     * The layout type of the dashboard. Valid values are `ordered`, `free`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#layout_type Dashboard#layout_type}
     *
     * @stability stable
     */
    readonly layoutType: string;
    /**
     * The list of handles for the users to notify when changes are made to this dashboard.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#notify_list Dashboard#notify_list}
     *
     * @stability stable
     */
    readonly notifyList?: string[];
    /**
     * The reflow type of a new dashboard layout.
     *
     * Set this only when layout type is `ordered`. If set to `fixed`, the dashboard expects all widgets to have a layout, and if it's set to `auto`, widgets should not have layouts. Valid values are `auto`, `fixed`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#reflow_type Dashboard#reflow_type}
     *
     * @stability stable
     */
    readonly reflowType?: string;
    /**
     * Role UUIDs corresponding to users authorized to edit the dashboard. **This feature is currently in beta.**.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#restricted_roles Dashboard#restricted_roles}
     *
     * @stability stable
     */
    readonly restrictedRoles?: string[];
    /**
     * The title of the dashboard.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title: string;
    /**
     * The URL of the dashboard.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#url Dashboard#url}
     *
     * @stability stable
     */
    readonly url?: string;
    /**
     * template_variable block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#template_variable Dashboard#template_variable}
     *
     * @stability stable
     */
    readonly templateVariable?: DashboardTemplateVariable[];
    /**
     * template_variable_preset block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#template_variable_preset Dashboard#template_variable_preset}
     *
     * @stability stable
     */
    readonly templateVariablePreset?: DashboardTemplateVariablePreset[];
    /**
     * widget block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#widget Dashboard#widget}
     *
     * @stability stable
     */
    readonly widget?: DashboardWidget[];
}
/**
 * @stability stable
 */
export interface DashboardTemplateVariable {
    /**
     * The list of values that the template variable drop-down is be limited to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#available_values Dashboard#available_values}
     *
     * @stability stable
     */
    readonly availableValues?: string[];
    /**
     * The default value for the template variable on dashboard load.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#default Dashboard#default}
     *
     * @stability stable
     */
    readonly default?: string;
    /**
     * The name of the variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The tag prefix associated with the variable. Only tags with this prefix appear in the variable dropdown.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#prefix Dashboard#prefix}
     *
     * @stability stable
     */
    readonly prefix?: string;
}
/**
 * @stability stable
 */
export interface DashboardTemplateVariablePresetTemplateVariable {
    /**
     * The name of the template variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * The value that should be assumed by the template variable in this preset.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#value Dashboard#value}
     *
     * @stability stable
     */
    readonly value?: string;
}
/**
 * @stability stable
 */
export interface DashboardTemplateVariablePreset {
    /**
     * The name of the preset.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * template_variable block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#template_variable Dashboard#template_variable}
     *
     * @stability stable
     */
    readonly templateVariable?: DashboardTemplateVariablePresetTemplateVariable[];
}
/**
 * @stability stable
 */
export interface DashboardWidgetAlertGraphDefinition {
    /**
     * The ID of the monitor used by the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#alert_id Dashboard#alert_id}
     *
     * @stability stable
     */
    readonly alertId: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * Type of visualization to use when displaying the widget. Valid values are `timeseries`, `toplist`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#viz_type Dashboard#viz_type}
     *
     * @stability stable
     */
    readonly vizType: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetAlertGraphDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _alertId?;
    /**
     * @stability stable
     */
    get alertId(): string;
    /**
     * @stability stable
     */
    set alertId(value: string);
    /**
     * @stability stable
     */
    get alertIdInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string | undefined;
    /**
     * @stability stable
     */
    set liveSpan(value: string | undefined);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _vizType?;
    /**
     * @stability stable
     */
    get vizType(): string;
    /**
     * @stability stable
     */
    set vizType(value: string);
    /**
     * @stability stable
     */
    get vizTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetAlertValueDefinition {
    /**
     * The ID of the monitor used by the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#alert_id Dashboard#alert_id}
     *
     * @stability stable
     */
    readonly alertId: string;
    /**
     * The precision to use when displaying the value. Use `*` for maximum precision.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#precision Dashboard#precision}
     *
     * @stability stable
     */
    readonly precision?: number;
    /**
     * The alignment of the text in the widget. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#text_align Dashboard#text_align}
     *
     * @stability stable
     */
    readonly textAlign?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * The unit for the value displayed in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#unit Dashboard#unit}
     *
     * @stability stable
     */
    readonly unit?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetAlertValueDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _alertId?;
    /**
     * @stability stable
     */
    get alertId(): string;
    /**
     * @stability stable
     */
    set alertId(value: string);
    /**
     * @stability stable
     */
    get alertIdInput(): string | undefined;
    private _precision?;
    /**
     * @stability stable
     */
    get precision(): number | undefined;
    /**
     * @stability stable
     */
    set precision(value: number | undefined);
    /**
     * @stability stable
     */
    resetPrecision(): void;
    /**
     * @stability stable
     */
    get precisionInput(): number | undefined;
    private _textAlign?;
    /**
     * @stability stable
     */
    get textAlign(): string | undefined;
    /**
     * @stability stable
     */
    set textAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTextAlign(): void;
    /**
     * @stability stable
     */
    get textAlignInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _unit?;
    /**
     * @stability stable
     */
    get unit(): string | undefined;
    /**
     * @stability stable
     */
    set unit(value: string | undefined);
    /**
     * @stability stable
     */
    resetUnit(): void;
    /**
     * @stability stable
     */
    get unitInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionCustomLink {
    /**
     * The flag for toggling context menu link visibility.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#is_hidden Dashboard#is_hidden}
     *
     * @stability stable
     */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
     * The label for the custom link URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * The URL of the custom link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#link Dashboard#link}
     *
     * @stability stable
     */
    readonly link?: string;
    /**
     * The label id that refers to a context menu link item.
     *
     * When override_label is provided, the client request omits the label field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#override_label Dashboard#override_label}
     *
     * @stability stable
     */
    readonly overrideLabel?: string;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetChangeDefinitionRequestApmQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetChangeDefinitionRequestApmQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestApmQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetChangeDefinitionRequestApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetChangeDefinitionRequestApmQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetChangeDefinitionRequestApmQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetChangeDefinitionRequestApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetChangeDefinitionRequestApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetChangeDefinitionRequestLogQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetChangeDefinitionRequestLogQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetChangeDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetChangeDefinitionRequestLogQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetChangeDefinitionRequestLogQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetChangeDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetChangeDefinitionRequestLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestProcessQuery {
    /**
     * A list of processes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#filter_by Dashboard#filter_by}
     *
     * @stability stable
     */
    readonly filterBy?: string[];
    /**
     * The max number of items in the filter list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Your chosen metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Your chosen search term.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_by Dashboard#search_by}
     *
     * @stability stable
     */
    readonly searchBy?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestProcessQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _filterBy?;
    /**
     * @stability stable
     */
    get filterBy(): string[] | undefined;
    /**
     * @stability stable
     */
    set filterBy(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetFilterBy(): void;
    /**
     * @stability stable
     */
    get filterByInput(): string[] | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number | undefined;
    /**
     * @stability stable
     */
    set limit(value: number | undefined);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _searchBy?;
    /**
     * @stability stable
     */
    get searchBy(): string | undefined;
    /**
     * @stability stable
     */
    set searchBy(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchBy(): void;
    /**
     * @stability stable
     */
    get searchByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetChangeDefinitionRequestRumQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetChangeDefinitionRequestRumQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetChangeDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetChangeDefinitionRequestRumQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetChangeDefinitionRequestRumQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetChangeDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetChangeDefinitionRequestRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequestSecurityQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionRequestSecurityQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetChangeDefinitionRequestSecurityQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetChangeDefinitionRequestSecurityQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetChangeDefinitionRequestSecurityQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinitionRequest {
    /**
     * Whether to show absolute or relative change. Valid values are `absolute`, `relative`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#change_type Dashboard#change_type}
     *
     * @stability stable
     */
    readonly changeType?: string;
    /**
     * Choose from when to compare current data to. Valid values are `hour_before`, `day_before`, `week_before`, `month_before`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compare_to Dashboard#compare_to}
     *
     * @stability stable
     */
    readonly compareTo?: string;
    /**
     * A Boolean indicating whether an increase in the value is good (displayed in green) or not (displayed in red).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#increase_good Dashboard#increase_good}
     *
     * @stability stable
     */
    readonly increaseGood?: boolean | cdktf.IResolvable;
    /**
     * What to order by. Valid values are `change`, `name`, `present`, `past`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order_by Dashboard#order_by}
     *
     * @stability stable
     */
    readonly orderBy?: string;
    /**
     * Widget sorting method. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order_dir Dashboard#order_dir}
     *
     * @stability stable
     */
    readonly orderDir?: string;
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * If set to `true`, displays the current value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#show_present Dashboard#show_present}
     *
     * @stability stable
     */
    readonly showPresent?: boolean | cdktf.IResolvable;
    /**
     * apm_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_query Dashboard#apm_query}
     *
     * @stability stable
     */
    readonly apmQuery?: DashboardWidgetChangeDefinitionRequestApmQuery;
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetChangeDefinitionRequestLogQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetChangeDefinitionRequestProcessQuery;
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetChangeDefinitionRequestRumQuery;
    /**
     * security_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#security_query Dashboard#security_query}
     *
     * @stability stable
     */
    readonly securityQuery?: DashboardWidgetChangeDefinitionRequestSecurityQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetChangeDefinition {
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * custom_link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_link Dashboard#custom_link}
     *
     * @stability stable
     */
    readonly customLink?: DashboardWidgetChangeDefinitionCustomLink[];
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetChangeDefinitionRequest[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetChangeDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string | undefined;
    /**
     * @stability stable
     */
    set liveSpan(value: string | undefined);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _customLink?;
    /**
     * @stability stable
     */
    get customLink(): DashboardWidgetChangeDefinitionCustomLink[] | undefined;
    /**
     * @stability stable
     */
    set customLink(value: DashboardWidgetChangeDefinitionCustomLink[] | undefined);
    /**
     * @stability stable
     */
    resetCustomLink(): void;
    /**
     * @stability stable
     */
    get customLinkInput(): DashboardWidgetChangeDefinitionCustomLink[] | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetChangeDefinitionRequest[] | undefined;
    /**
     * @stability stable
     */
    set request(value: DashboardWidgetChangeDefinitionRequest[] | undefined);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): DashboardWidgetChangeDefinitionRequest[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetCheckStatusDefinition {
    /**
     * The check to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#check Dashboard#check}
     *
     * @stability stable
     */
    readonly check: string;
    /**
     * The check group to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group Dashboard#group}
     *
     * @stability stable
     */
    readonly group?: string;
    /**
     * When `grouping = "cluster"`, indicates a list of tags to use for grouping.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: string[];
    /**
     * The kind of grouping to use. Valid values are `check`, `cluster`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#grouping Dashboard#grouping}
     *
     * @stability stable
     */
    readonly grouping: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * A list of tags to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#tags Dashboard#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetCheckStatusDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _check?;
    /**
     * @stability stable
     */
    get check(): string;
    /**
     * @stability stable
     */
    set check(value: string);
    /**
     * @stability stable
     */
    get checkInput(): string | undefined;
    private _group?;
    /**
     * @stability stable
     */
    get group(): string | undefined;
    /**
     * @stability stable
     */
    set group(value: string | undefined);
    /**
     * @stability stable
     */
    resetGroup(): void;
    /**
     * @stability stable
     */
    get groupInput(): string | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): string[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): string[] | undefined;
    private _grouping?;
    /**
     * @stability stable
     */
    get grouping(): string;
    /**
     * @stability stable
     */
    set grouping(value: string);
    /**
     * @stability stable
     */
    get groupingInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string | undefined;
    /**
     * @stability stable
     */
    set liveSpan(value: string | undefined);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[] | undefined;
    /**
     * @stability stable
     */
    set tags(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestApmQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetDistributionDefinitionRequestApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetDistributionDefinitionRequestApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetDistributionDefinitionRequestApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetDistributionDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetDistributionDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetDistributionDefinitionRequestLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestProcessQuery {
    /**
     * A list of processes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#filter_by Dashboard#filter_by}
     *
     * @stability stable
     */
    readonly filterBy?: string[];
    /**
     * The max number of items in the filter list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Your chosen metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Your chosen search term.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_by Dashboard#search_by}
     *
     * @stability stable
     */
    readonly searchBy?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestProcessQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _filterBy?;
    /**
     * @stability stable
     */
    get filterBy(): string[] | undefined;
    /**
     * @stability stable
     */
    set filterBy(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetFilterBy(): void;
    /**
     * @stability stable
     */
    get filterByInput(): string[] | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number | undefined;
    /**
     * @stability stable
     */
    set limit(value: number | undefined);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _searchBy?;
    /**
     * @stability stable
     */
    get searchBy(): string | undefined;
    /**
     * @stability stable
     */
    set searchBy(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchBy(): void;
    /**
     * @stability stable
     */
    get searchByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetDistributionDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetDistributionDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetDistributionDefinitionRequestRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestSecurityQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestSecurityQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetDistributionDefinitionRequestSecurityQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetDistributionDefinitionRequestSecurityQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequestStyle {
    /**
     * A color palette to apply to the widget. The available options are available at: https://docs.datadoghq.com/dashboards/widgets/timeseries/#appearance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionRequestStyleOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _palette?;
    /**
     * @stability stable
     */
    get palette(): string | undefined;
    /**
     * @stability stable
     */
    set palette(value: string | undefined);
    /**
     * @stability stable
     */
    resetPalette(): void;
    /**
     * @stability stable
     */
    get paletteInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinitionRequest {
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * apm_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_query Dashboard#apm_query}
     *
     * @stability stable
     */
    readonly apmQuery?: DashboardWidgetDistributionDefinitionRequestApmQuery;
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetDistributionDefinitionRequestLogQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetDistributionDefinitionRequestProcessQuery;
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetDistributionDefinitionRequestRumQuery;
    /**
     * security_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#security_query Dashboard#security_query}
     *
     * @stability stable
     */
    readonly securityQuery?: DashboardWidgetDistributionDefinitionRequestSecurityQuery;
    /**
     * style block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#style Dashboard#style}
     *
     * @stability stable
     */
    readonly style?: DashboardWidgetDistributionDefinitionRequestStyle;
}
/**
 * @stability stable
 */
export interface DashboardWidgetDistributionDefinition {
    /**
     * The size of the legend displayed in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#legend_size Dashboard#legend_size}
     *
     * @stability stable
     */
    readonly legendSize?: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * Whether or not to show the legend on this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#show_legend Dashboard#show_legend}
     *
     * @stability stable
     */
    readonly showLegend?: boolean | cdktf.IResolvable;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetDistributionDefinitionRequest[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetDistributionDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _legendSize?;
    /**
     * @stability stable
     */
    get legendSize(): string | undefined;
    /**
     * @stability stable
     */
    set legendSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetLegendSize(): void;
    /**
     * @stability stable
     */
    get legendSizeInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string | undefined;
    /**
     * @stability stable
     */
    set liveSpan(value: string | undefined);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _showLegend?;
    /**
     * @stability stable
     */
    get showLegend(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set showLegend(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetShowLegend(): void;
    /**
     * @stability stable
     */
    get showLegendInput(): boolean | cdktf.IResolvable | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetDistributionDefinitionRequest[] | undefined;
    /**
     * @stability stable
     */
    set request(value: DashboardWidgetDistributionDefinitionRequest[] | undefined);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): DashboardWidgetDistributionDefinitionRequest[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetEventStreamDefinition {
    /**
     * The size to use to display an event. Valid values are `s`, `l`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#event_size Dashboard#event_size}
     *
     * @stability stable
     */
    readonly eventSize?: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The query to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * The execution method for multi-value filters, options: `and` or `or`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#tags_execution Dashboard#tags_execution}
     *
     * @stability stable
     */
    readonly tagsExecution?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetEventStreamDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _eventSize?;
    /**
     * @stability stable
     */
    get eventSize(): string | undefined;
    /**
     * @stability stable
     */
    set eventSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetEventSize(): void;
    /**
     * @stability stable
     */
    get eventSizeInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string | undefined;
    /**
     * @stability stable
     */
    set liveSpan(value: string | undefined);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _tagsExecution?;
    /**
     * @stability stable
     */
    get tagsExecution(): string | undefined;
    /**
     * @stability stable
     */
    set tagsExecution(value: string | undefined);
    /**
     * @stability stable
     */
    resetTagsExecution(): void;
    /**
     * @stability stable
     */
    get tagsExecutionInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetEventTimelineDefinition {
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The query to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * The execution method for multi-value filters, options: `and` or `or`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#tags_execution Dashboard#tags_execution}
     *
     * @stability stable
     */
    readonly tagsExecution?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetEventTimelineDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string | undefined;
    /**
     * @stability stable
     */
    set liveSpan(value: string | undefined);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _tagsExecution?;
    /**
     * @stability stable
     */
    get tagsExecution(): string | undefined;
    /**
     * @stability stable
     */
    set tagsExecution(value: string | undefined);
    /**
     * @stability stable
     */
    resetTagsExecution(): void;
    /**
     * @stability stable
     */
    get tagsExecutionInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetFreeTextDefinition {
    /**
     * The color of the text in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#color Dashboard#color}
     *
     * @stability stable
     */
    readonly color?: string;
    /**
     * The size of the text in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#font_size Dashboard#font_size}
     *
     * @stability stable
     */
    readonly fontSize?: string;
    /**
     * The text to display in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#text Dashboard#text}
     *
     * @stability stable
     */
    readonly text: string;
    /**
     * The alignment of the text in the widget. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#text_align Dashboard#text_align}
     *
     * @stability stable
     */
    readonly textAlign?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetFreeTextDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _color?;
    /**
     * @stability stable
     */
    get color(): string | undefined;
    /**
     * @stability stable
     */
    set color(value: string | undefined);
    /**
     * @stability stable
     */
    resetColor(): void;
    /**
     * @stability stable
     */
    get colorInput(): string | undefined;
    private _fontSize?;
    /**
     * @stability stable
     */
    get fontSize(): string | undefined;
    /**
     * @stability stable
     */
    set fontSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetFontSize(): void;
    /**
     * @stability stable
     */
    get fontSizeInput(): string | undefined;
    private _text?;
    /**
     * @stability stable
     */
    get text(): string;
    /**
     * @stability stable
     */
    set text(value: string);
    /**
     * @stability stable
     */
    get textInput(): string | undefined;
    private _textAlign?;
    /**
     * @stability stable
     */
    get textAlign(): string | undefined;
    /**
     * @stability stable
     */
    set textAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTextAlign(): void;
    /**
     * @stability stable
     */
    get textAlignInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionCustomLink {
    /**
     * The flag for toggling context menu link visibility.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#is_hidden Dashboard#is_hidden}
     *
     * @stability stable
     */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
     * The label for the custom link URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * The URL of the custom link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#link Dashboard#link}
     *
     * @stability stable
     */
    readonly link?: string;
    /**
     * The label id that refers to a context menu link item.
     *
     * When override_label is provided, the client request omits the label field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#override_label Dashboard#override_label}
     *
     * @stability stable
     */
    readonly overrideLabel?: string;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormats {
    /**
     * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#comparator Dashboard#comparator}
     *
     * @stability stable
     */
    readonly comparator: string;
    /**
     * The color palette to apply to the background, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_bg_color Dashboard#custom_bg_color}
     *
     * @stability stable
     */
    readonly customBgColor?: string;
    /**
     * The color palette to apply to the foreground, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_fg_color Dashboard#custom_fg_color}
     *
     * @stability stable
     */
    readonly customFgColor?: string;
    /**
     * Setting this to True hides values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#hide_value Dashboard#hide_value}
     *
     * @stability stable
     */
    readonly hideValue?: boolean | cdktf.IResolvable;
    /**
     * Displays an image as the background.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#image_url Dashboard#image_url}
     *
     * @stability stable
     */
    readonly imageUrl?: string;
    /**
     * The metric from the request to correlate with this conditional format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * The color palette to apply.
     *
     * Valid values are `blue`, `custom_bg`, `custom_image`, `custom_text`, `gray_on_white`, `grey`, `green`, `orange`, `red`, `red_on_white`, `white_on_gray`, `white_on_green`, `green_on_white`, `white_on_red`, `white_on_yellow`, `yellow_on_white`, `black_on_light_yellow`, `black_on_light_green`, `black_on_light_red`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette: string;
    /**
     * Defines the displayed timeframe.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#timeframe Dashboard#timeframe}
     *
     * @stability stable
     */
    readonly timeframe?: string;
    /**
     * A value for the comparator.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#value Dashboard#value}
     *
     * @stability stable
     */
    readonly value: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestFormulaLimit {
    /**
     * The number of results to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#count Dashboard#count}
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * The direction of the sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestFormulaLimitOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number | undefined;
    /**
     * @stability stable
     */
    set count(value: number | undefined);
    /**
     * @stability stable
     */
    resetCount(): void;
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string | undefined;
    /**
     * @stability stable
     */
    set order(value: string | undefined);
    /**
     * @stability stable
     */
    resetOrder(): void;
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestFormula {
    /**
     * An expression alias.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#alias Dashboard#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * A list of display modes for each table cell. Valid values are `number`, `bar`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#cell_display_mode Dashboard#cell_display_mode}
     *
     * @stability stable
     */
    readonly cellDisplayMode?: string;
    /**
     * A string expression built from queries, formulas, and functions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#formula_expression Dashboard#formula_expression}
     *
     * @stability stable
     */
    readonly formulaExpression: string;
    /**
     * conditional_formats block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#conditional_formats Dashboard#conditional_formats}
     *
     * @stability stable
     */
    readonly conditionalFormats?: DashboardWidgetGeomapDefinitionRequestFormulaConditionalFormats[];
    /**
     * limit block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: DashboardWidgetGeomapDefinitionRequestFormulaLimit;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGeomapDefinitionRequestLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGeomapDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGeomapDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGeomapDefinitionRequestLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery {
    /**
     * The data source for APM Dependency Stats queries. Valid values are `apm_dependency_stats`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * APM Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * Determines whether stats for upstream or downstream dependencies should be queried.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#is_upstream Dashboard#is_upstream}
     *
     * @stability stable
     */
    readonly isUpstream?: boolean | cdktf.IResolvable;
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of operation on service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#operation_name Dashboard#operation_name}
     *
     * @stability stable
     */
    readonly operationName: string;
    /**
     * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#primary_tag_name Dashboard#primary_tag_name}
     *
     * @stability stable
     */
    readonly primaryTagName?: string;
    /**
     * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#primary_tag_value Dashboard#primary_tag_value}
     *
     * @stability stable
     */
    readonly primaryTagValue?: string;
    /**
     * APM resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#resource_name Dashboard#resource_name}
     *
     * @stability stable
     */
    readonly resourceName: string;
    /**
     * APM service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * APM statistic. Valid values are `avg_duration`, `avg_root_duration`, `avg_spans_per_trace`, `error_rate`, `pct_exec_time`, `pct_of_traces`, `total_traces_count`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#stat Dashboard#stat}
     *
     * @stability stable
     */
    readonly stat: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _isUpstream?;
    /**
     * @stability stable
     */
    get isUpstream(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isUpstream(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsUpstream(): void;
    /**
     * @stability stable
     */
    get isUpstreamInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationName?;
    /**
     * @stability stable
     */
    get operationName(): string;
    /**
     * @stability stable
     */
    set operationName(value: string);
    /**
     * @stability stable
     */
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    /**
     * @stability stable
     */
    get primaryTagName(): string | undefined;
    /**
     * @stability stable
     */
    set primaryTagName(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrimaryTagName(): void;
    /**
     * @stability stable
     */
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    /**
     * @stability stable
     */
    get primaryTagValue(): string | undefined;
    /**
     * @stability stable
     */
    set primaryTagValue(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrimaryTagValue(): void;
    /**
     * @stability stable
     */
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string;
    /**
     * @stability stable
     */
    set resourceName(value: string);
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _stat?;
    /**
     * @stability stable
     */
    get stat(): string;
    /**
     * @stability stable
     */
    set stat(value: string);
    /**
     * @stability stable
     */
    get statInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery {
    /**
     * The data source for APM Resource Stats queries. Valid values are `apm_resource_stats`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * APM Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * Array of fields to group results by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: string[];
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of operation on service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#operation_name Dashboard#operation_name}
     *
     * @stability stable
     */
    readonly operationName?: string;
    /**
     * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#primary_tag_name Dashboard#primary_tag_name}
     *
     * @stability stable
     */
    readonly primaryTagName?: string;
    /**
     * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#primary_tag_value Dashboard#primary_tag_value}
     *
     * @stability stable
     */
    readonly primaryTagValue?: string;
    /**
     * APM resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#resource_name Dashboard#resource_name}
     *
     * @stability stable
     */
    readonly resourceName?: string;
    /**
     * APM service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * APM statistic. Valid values are `errors`, `error_rate`, `hits`, `latency_avg`, `latency_max`, `latency_p50`, `latency_p75`, `latency_p90`, `latency_p95`, `latency_p99`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#stat Dashboard#stat}
     *
     * @stability stable
     */
    readonly stat: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): string[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationName?;
    /**
     * @stability stable
     */
    get operationName(): string | undefined;
    /**
     * @stability stable
     */
    set operationName(value: string | undefined);
    /**
     * @stability stable
     */
    resetOperationName(): void;
    /**
     * @stability stable
     */
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    /**
     * @stability stable
     */
    get primaryTagName(): string | undefined;
    /**
     * @stability stable
     */
    set primaryTagName(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrimaryTagName(): void;
    /**
     * @stability stable
     */
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    /**
     * @stability stable
     */
    get primaryTagValue(): string | undefined;
    /**
     * @stability stable
     */
    set primaryTagValue(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrimaryTagValue(): void;
    /**
     * @stability stable
     */
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string | undefined;
    /**
     * @stability stable
     */
    set resourceName(value: string | undefined);
    /**
     * @stability stable
     */
    resetResourceName(): void;
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _stat?;
    /**
     * @stability stable
     */
    get stat(): string;
    /**
     * @stability stable
     */
    set stat(value: string);
    /**
     * @stability stable
     */
    get statInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute {
    /**
     * The aggregation methods for event platform queries.
     *
     * Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * A time interval in milliseconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
    /**
     * The measurable attribute to compute.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort {
    /**
     * The aggregation methods for the event platform queries.
     *
     * Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The metric used for sorting group by results.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * Direction of sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySortOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string | undefined;
    /**
     * @stability stable
     */
    set metric(value: string | undefined);
    /**
     * @stability stable
     */
    resetMetric(): void;
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string | undefined;
    /**
     * @stability stable
     */
    set order(value: string | undefined);
    /**
     * @stability stable
     */
    resetOrder(): void;
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy {
    /**
     * The event facet.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet: string;
    /**
     * The number of groups to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch {
    /**
     * The events search string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearchOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQueryEventQuery {
    /**
     * The data source for event platform-based queries. Valid values are `logs`, `spans`, `network`, `rum`, `security_signals`, `profiles`, `audit`, `events`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * An array of index names to query in the stream.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#indexes Dashboard#indexes}
     *
     * @stability stable
     */
    readonly indexes?: string[];
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute Dashboard#compute}
     *
     * @stability stable
     */
    readonly compute: DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute[];
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[];
    /**
     * search block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search Dashboard#search}
     *
     * @stability stable
     */
    readonly search?: DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestQueryEventQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _indexes?;
    /**
     * @stability stable
     */
    get indexes(): string[] | undefined;
    /**
     * @stability stable
     */
    set indexes(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetIndexes(): void;
    /**
     * @stability stable
     */
    get indexesInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _compute?;
    /**
     * @stability stable
     */
    get compute(): DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute[];
    /**
     * @stability stable
     */
    set compute(value: DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute[]);
    /**
     * @stability stable
     */
    get computeInput(): DashboardWidgetGeomapDefinitionRequestQueryEventQueryCompute[] | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[] | undefined;
    private _search?;
    private __searchOutput;
    /**
     * @stability stable
     */
    get search(): DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearchOutputReference;
    /**
     * @stability stable
     */
    putSearch(value: DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch | undefined): void;
    /**
     * @stability stable
     */
    resetSearch(): void;
    /**
     * @stability stable
     */
    get searchInput(): DashboardWidgetGeomapDefinitionRequestQueryEventQuerySearch | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQueryMetricQuery {
    /**
     * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The data source for metrics queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource?: string;
    /**
     * The name of the query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The metrics query definition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestQueryMetricQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregator?;
    /**
     * @stability stable
     */
    get aggregator(): string | undefined;
    /**
     * @stability stable
     */
    set aggregator(value: string | undefined);
    /**
     * @stability stable
     */
    resetAggregator(): void;
    /**
     * @stability stable
     */
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string | undefined;
    /**
     * @stability stable
     */
    set dataSource(value: string | undefined);
    /**
     * @stability stable
     */
    resetDataSource(): void;
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQueryProcessQuery {
    /**
     * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The data source for process queries. Valid values are `process`, `container`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * Whether to normalize the CPU percentages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#is_normalized_cpu Dashboard#is_normalized_cpu}
     *
     * @stability stable
     */
    readonly isNormalizedCpu?: boolean | cdktf.IResolvable;
    /**
     * The number of hits to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * The process metric name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The direction of the sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: string;
    /**
     * An array of tags to filter by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#tag_filters Dashboard#tag_filters}
     *
     * @stability stable
     */
    readonly tagFilters?: string[];
    /**
     * The text to use as a filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#text_filter Dashboard#text_filter}
     *
     * @stability stable
     */
    readonly textFilter?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestQueryProcessQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregator?;
    /**
     * @stability stable
     */
    get aggregator(): string | undefined;
    /**
     * @stability stable
     */
    set aggregator(value: string | undefined);
    /**
     * @stability stable
     */
    resetAggregator(): void;
    /**
     * @stability stable
     */
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _isNormalizedCpu?;
    /**
     * @stability stable
     */
    get isNormalizedCpu(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isNormalizedCpu(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsNormalizedCpu(): void;
    /**
     * @stability stable
     */
    get isNormalizedCpuInput(): boolean | cdktf.IResolvable | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number | undefined;
    /**
     * @stability stable
     */
    set limit(value: number | undefined);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sort?;
    /**
     * @stability stable
     */
    get sort(): string | undefined;
    /**
     * @stability stable
     */
    set sort(value: string | undefined);
    /**
     * @stability stable
     */
    resetSort(): void;
    /**
     * @stability stable
     */
    get sortInput(): string | undefined;
    private _tagFilters?;
    /**
     * @stability stable
     */
    get tagFilters(): string[] | undefined;
    /**
     * @stability stable
     */
    set tagFilters(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetTagFilters(): void;
    /**
     * @stability stable
     */
    get tagFiltersInput(): string[] | undefined;
    private _textFilter?;
    /**
     * @stability stable
     */
    get textFilter(): string | undefined;
    /**
     * @stability stable
     */
    set textFilter(value: string | undefined);
    /**
     * @stability stable
     */
    resetTextFilter(): void;
    /**
     * @stability stable
     */
    get textFilterInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestQuery {
    /**
     * apm_dependency_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
     *
     * @stability stable
     */
    readonly apmDependencyStatsQuery?: DashboardWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery;
    /**
     * apm_resource_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_resource_stats_query Dashboard#apm_resource_stats_query}
     *
     * @stability stable
     */
    readonly apmResourceStatsQuery?: DashboardWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery;
    /**
     * event_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#event_query Dashboard#event_query}
     *
     * @stability stable
     */
    readonly eventQuery?: DashboardWidgetGeomapDefinitionRequestQueryEventQuery;
    /**
     * metric_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric_query Dashboard#metric_query}
     *
     * @stability stable
     */
    readonly metricQuery?: DashboardWidgetGeomapDefinitionRequestQueryMetricQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGeomapDefinitionRequestQueryProcessQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequestRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGeomapDefinitionRequestRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGeomapDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGeomapDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGeomapDefinitionRequestRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionRequest {
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * formula block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#formula Dashboard#formula}
     *
     * @stability stable
     */
    readonly formula?: DashboardWidgetGeomapDefinitionRequestFormula[];
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetGeomapDefinitionRequestLogQuery;
    /**
     * query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query?: DashboardWidgetGeomapDefinitionRequestQuery[];
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetGeomapDefinitionRequestRumQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionStyle {
    /**
     * The color palette to apply to the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette: string;
    /**
     * A Boolean indicating whether to flip the palette tones.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#palette_flip Dashboard#palette_flip}
     *
     * @stability stable
     */
    readonly paletteFlip: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionStyleOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _palette?;
    /**
     * @stability stable
     */
    get palette(): string;
    /**
     * @stability stable
     */
    set palette(value: string);
    /**
     * @stability stable
     */
    get paletteInput(): string | undefined;
    private _paletteFlip?;
    /**
     * @stability stable
     */
    get paletteFlip(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set paletteFlip(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get paletteFlipInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinitionView {
    /**
     * The two-letter ISO code of a country to focus the map on (or `WORLD`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#focus Dashboard#focus}
     *
     * @stability stable
     */
    readonly focus: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionViewOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _focus?;
    /**
     * @stability stable
     */
    get focus(): string;
    /**
     * @stability stable
     */
    set focus(value: string);
    /**
     * @stability stable
     */
    get focusInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGeomapDefinition {
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * custom_link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_link Dashboard#custom_link}
     *
     * @stability stable
     */
    readonly customLink?: DashboardWidgetGeomapDefinitionCustomLink[];
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetGeomapDefinitionRequest[];
    /**
     * style block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#style Dashboard#style}
     *
     * @stability stable
     */
    readonly style?: DashboardWidgetGeomapDefinitionStyle;
    /**
     * view block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#view Dashboard#view}
     *
     * @stability stable
     */
    readonly view: DashboardWidgetGeomapDefinitionView;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGeomapDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string | undefined;
    /**
     * @stability stable
     */
    set liveSpan(value: string | undefined);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _customLink?;
    /**
     * @stability stable
     */
    get customLink(): DashboardWidgetGeomapDefinitionCustomLink[] | undefined;
    /**
     * @stability stable
     */
    set customLink(value: DashboardWidgetGeomapDefinitionCustomLink[] | undefined);
    /**
     * @stability stable
     */
    resetCustomLink(): void;
    /**
     * @stability stable
     */
    get customLinkInput(): DashboardWidgetGeomapDefinitionCustomLink[] | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetGeomapDefinitionRequest[] | undefined;
    /**
     * @stability stable
     */
    set request(value: DashboardWidgetGeomapDefinitionRequest[] | undefined);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): DashboardWidgetGeomapDefinitionRequest[] | undefined;
    private _style?;
    private __styleOutput;
    /**
     * @stability stable
     */
    get style(): DashboardWidgetGeomapDefinitionStyleOutputReference;
    /**
     * @stability stable
     */
    putStyle(value: DashboardWidgetGeomapDefinitionStyle | undefined): void;
    /**
     * @stability stable
     */
    resetStyle(): void;
    /**
     * @stability stable
     */
    get styleInput(): DashboardWidgetGeomapDefinitionStyle | undefined;
    private _view?;
    private __viewOutput;
    /**
     * @stability stable
     */
    get view(): DashboardWidgetGeomapDefinitionViewOutputReference;
    /**
     * @stability stable
     */
    putView(value: DashboardWidgetGeomapDefinitionView): void;
    /**
     * @stability stable
     */
    get viewInput(): DashboardWidgetGeomapDefinitionView | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetAlertGraphDefinition {
    /**
     * The ID of the monitor used by the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#alert_id Dashboard#alert_id}
     *
     * @stability stable
     */
    readonly alertId: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * Type of visualization to use when displaying the widget. Valid values are `timeseries`, `toplist`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#viz_type Dashboard#viz_type}
     *
     * @stability stable
     */
    readonly vizType: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetAlertGraphDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _alertId?;
    /**
     * @stability stable
     */
    get alertId(): string;
    /**
     * @stability stable
     */
    set alertId(value: string);
    /**
     * @stability stable
     */
    get alertIdInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string | undefined;
    /**
     * @stability stable
     */
    set liveSpan(value: string | undefined);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _vizType?;
    /**
     * @stability stable
     */
    get vizType(): string;
    /**
     * @stability stable
     */
    set vizType(value: string);
    /**
     * @stability stable
     */
    get vizTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetAlertValueDefinition {
    /**
     * The ID of the monitor used by the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#alert_id Dashboard#alert_id}
     *
     * @stability stable
     */
    readonly alertId: string;
    /**
     * The precision to use when displaying the value. Use `*` for maximum precision.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#precision Dashboard#precision}
     *
     * @stability stable
     */
    readonly precision?: number;
    /**
     * The alignment of the text in the widget. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#text_align Dashboard#text_align}
     *
     * @stability stable
     */
    readonly textAlign?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * The unit for the value displayed in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#unit Dashboard#unit}
     *
     * @stability stable
     */
    readonly unit?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetAlertValueDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _alertId?;
    /**
     * @stability stable
     */
    get alertId(): string;
    /**
     * @stability stable
     */
    set alertId(value: string);
    /**
     * @stability stable
     */
    get alertIdInput(): string | undefined;
    private _precision?;
    /**
     * @stability stable
     */
    get precision(): number | undefined;
    /**
     * @stability stable
     */
    set precision(value: number | undefined);
    /**
     * @stability stable
     */
    resetPrecision(): void;
    /**
     * @stability stable
     */
    get precisionInput(): number | undefined;
    private _textAlign?;
    /**
     * @stability stable
     */
    get textAlign(): string | undefined;
    /**
     * @stability stable
     */
    set textAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTextAlign(): void;
    /**
     * @stability stable
     */
    get textAlignInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _unit?;
    /**
     * @stability stable
     */
    get unit(): string | undefined;
    /**
     * @stability stable
     */
    set unit(value: string | undefined);
    /**
     * @stability stable
     */
    resetUnit(): void;
    /**
     * @stability stable
     */
    get unitInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink {
    /**
     * The flag for toggling context menu link visibility.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#is_hidden Dashboard#is_hidden}
     *
     * @stability stable
     */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
     * The label for the custom link URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * The URL of the custom link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#link Dashboard#link}
     *
     * @stability stable
     */
    readonly link?: string;
    /**
     * The label id that refers to a context menu link item.
     *
     * When override_label is provided, the client request omits the label field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#override_label Dashboard#override_label}
     *
     * @stability stable
     */
    readonly overrideLabel?: string;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestProcessQuery {
    /**
     * A list of processes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#filter_by Dashboard#filter_by}
     *
     * @stability stable
     */
    readonly filterBy?: string[];
    /**
     * The max number of items in the filter list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Your chosen metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Your chosen search term.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_by Dashboard#search_by}
     *
     * @stability stable
     */
    readonly searchBy?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestProcessQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _filterBy?;
    /**
     * @stability stable
     */
    get filterBy(): string[] | undefined;
    /**
     * @stability stable
     */
    set filterBy(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetFilterBy(): void;
    /**
     * @stability stable
     */
    get filterByInput(): string[] | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number | undefined;
    /**
     * @stability stable
     */
    set limit(value: number | undefined);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _searchBy?;
    /**
     * @stability stable
     */
    get searchBy(): string | undefined;
    /**
     * @stability stable
     */
    set searchBy(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchBy(): void;
    /**
     * @stability stable
     */
    get searchByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest {
    /**
     * Whether to show absolute or relative change. Valid values are `absolute`, `relative`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#change_type Dashboard#change_type}
     *
     * @stability stable
     */
    readonly changeType?: string;
    /**
     * Choose from when to compare current data to. Valid values are `hour_before`, `day_before`, `week_before`, `month_before`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compare_to Dashboard#compare_to}
     *
     * @stability stable
     */
    readonly compareTo?: string;
    /**
     * A Boolean indicating whether an increase in the value is good (displayed in green) or not (displayed in red).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#increase_good Dashboard#increase_good}
     *
     * @stability stable
     */
    readonly increaseGood?: boolean | cdktf.IResolvable;
    /**
     * What to order by. Valid values are `change`, `name`, `present`, `past`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order_by Dashboard#order_by}
     *
     * @stability stable
     */
    readonly orderBy?: string;
    /**
     * Widget sorting method. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order_dir Dashboard#order_dir}
     *
     * @stability stable
     */
    readonly orderDir?: string;
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * If set to `true`, displays the current value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#show_present Dashboard#show_present}
     *
     * @stability stable
     */
    readonly showPresent?: boolean | cdktf.IResolvable;
    /**
     * apm_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_query Dashboard#apm_query}
     *
     * @stability stable
     */
    readonly apmQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestApmQuery;
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestLogQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestProcessQuery;
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestRumQuery;
    /**
     * security_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#security_query Dashboard#security_query}
     *
     * @stability stable
     */
    readonly securityQuery?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequestSecurityQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetChangeDefinition {
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * custom_link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_link Dashboard#custom_link}
     *
     * @stability stable
     */
    readonly customLink?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink[];
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetChangeDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string | undefined;
    /**
     * @stability stable
     */
    set liveSpan(value: string | undefined);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _customLink?;
    /**
     * @stability stable
     */
    get customLink(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink[] | undefined;
    /**
     * @stability stable
     */
    set customLink(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink[] | undefined);
    /**
     * @stability stable
     */
    resetCustomLink(): void;
    /**
     * @stability stable
     */
    get customLinkInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionCustomLink[] | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest[] | undefined;
    /**
     * @stability stable
     */
    set request(value: DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest[] | undefined);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): DashboardWidgetGroupDefinitionWidgetChangeDefinitionRequest[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetCheckStatusDefinition {
    /**
     * The check to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#check Dashboard#check}
     *
     * @stability stable
     */
    readonly check: string;
    /**
     * The check group to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group Dashboard#group}
     *
     * @stability stable
     */
    readonly group?: string;
    /**
     * When `grouping = "cluster"`, indicates a list of tags to use for grouping.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: string[];
    /**
     * The kind of grouping to use. Valid values are `check`, `cluster`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#grouping Dashboard#grouping}
     *
     * @stability stable
     */
    readonly grouping: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * A list of tags to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#tags Dashboard#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetCheckStatusDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _check?;
    /**
     * @stability stable
     */
    get check(): string;
    /**
     * @stability stable
     */
    set check(value: string);
    /**
     * @stability stable
     */
    get checkInput(): string | undefined;
    private _group?;
    /**
     * @stability stable
     */
    get group(): string | undefined;
    /**
     * @stability stable
     */
    set group(value: string | undefined);
    /**
     * @stability stable
     */
    resetGroup(): void;
    /**
     * @stability stable
     */
    get groupInput(): string | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): string[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): string[] | undefined;
    private _grouping?;
    /**
     * @stability stable
     */
    get grouping(): string;
    /**
     * @stability stable
     */
    set grouping(value: string);
    /**
     * @stability stable
     */
    get groupingInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string | undefined;
    /**
     * @stability stable
     */
    set liveSpan(value: string | undefined);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[] | undefined;
    /**
     * @stability stable
     */
    set tags(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestProcessQuery {
    /**
     * A list of processes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#filter_by Dashboard#filter_by}
     *
     * @stability stable
     */
    readonly filterBy?: string[];
    /**
     * The max number of items in the filter list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Your chosen metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Your chosen search term.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_by Dashboard#search_by}
     *
     * @stability stable
     */
    readonly searchBy?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestProcessQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _filterBy?;
    /**
     * @stability stable
     */
    get filterBy(): string[] | undefined;
    /**
     * @stability stable
     */
    set filterBy(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetFilterBy(): void;
    /**
     * @stability stable
     */
    get filterByInput(): string[] | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number | undefined;
    /**
     * @stability stable
     */
    set limit(value: number | undefined);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _searchBy?;
    /**
     * @stability stable
     */
    get searchBy(): string | undefined;
    /**
     * @stability stable
     */
    set searchBy(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchBy(): void;
    /**
     * @stability stable
     */
    get searchByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestStyle {
    /**
     * A color palette to apply to the widget. The available options are available at: https://docs.datadoghq.com/dashboards/widgets/timeseries/#appearance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestStyleOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _palette?;
    /**
     * @stability stable
     */
    get palette(): string | undefined;
    /**
     * @stability stable
     */
    set palette(value: string | undefined);
    /**
     * @stability stable
     */
    resetPalette(): void;
    /**
     * @stability stable
     */
    get paletteInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequest {
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * apm_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_query Dashboard#apm_query}
     *
     * @stability stable
     */
    readonly apmQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestApmQuery;
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestLogQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestProcessQuery;
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestRumQuery;
    /**
     * security_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#security_query Dashboard#security_query}
     *
     * @stability stable
     */
    readonly securityQuery?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestSecurityQuery;
    /**
     * style block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#style Dashboard#style}
     *
     * @stability stable
     */
    readonly style?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequestStyle;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetDistributionDefinition {
    /**
     * The size of the legend displayed in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#legend_size Dashboard#legend_size}
     *
     * @stability stable
     */
    readonly legendSize?: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * Whether or not to show the legend on this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#show_legend Dashboard#show_legend}
     *
     * @stability stable
     */
    readonly showLegend?: boolean | cdktf.IResolvable;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequest[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetDistributionDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _legendSize?;
    /**
     * @stability stable
     */
    get legendSize(): string | undefined;
    /**
     * @stability stable
     */
    set legendSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetLegendSize(): void;
    /**
     * @stability stable
     */
    get legendSizeInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string | undefined;
    /**
     * @stability stable
     */
    set liveSpan(value: string | undefined);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _showLegend?;
    /**
     * @stability stable
     */
    get showLegend(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set showLegend(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetShowLegend(): void;
    /**
     * @stability stable
     */
    get showLegendInput(): boolean | cdktf.IResolvable | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequest[] | undefined;
    /**
     * @stability stable
     */
    set request(value: DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequest[] | undefined);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): DashboardWidgetGroupDefinitionWidgetDistributionDefinitionRequest[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetEventStreamDefinition {
    /**
     * The size to use to display an event. Valid values are `s`, `l`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#event_size Dashboard#event_size}
     *
     * @stability stable
     */
    readonly eventSize?: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The query to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * The execution method for multi-value filters, options: `and` or `or`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#tags_execution Dashboard#tags_execution}
     *
     * @stability stable
     */
    readonly tagsExecution?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetEventStreamDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _eventSize?;
    /**
     * @stability stable
     */
    get eventSize(): string | undefined;
    /**
     * @stability stable
     */
    set eventSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetEventSize(): void;
    /**
     * @stability stable
     */
    get eventSizeInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string | undefined;
    /**
     * @stability stable
     */
    set liveSpan(value: string | undefined);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _tagsExecution?;
    /**
     * @stability stable
     */
    get tagsExecution(): string | undefined;
    /**
     * @stability stable
     */
    set tagsExecution(value: string | undefined);
    /**
     * @stability stable
     */
    resetTagsExecution(): void;
    /**
     * @stability stable
     */
    get tagsExecutionInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetEventTimelineDefinition {
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The query to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * The execution method for multi-value filters, options: `and` or `or`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#tags_execution Dashboard#tags_execution}
     *
     * @stability stable
     */
    readonly tagsExecution?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetEventTimelineDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string | undefined;
    /**
     * @stability stable
     */
    set liveSpan(value: string | undefined);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _tagsExecution?;
    /**
     * @stability stable
     */
    get tagsExecution(): string | undefined;
    /**
     * @stability stable
     */
    set tagsExecution(value: string | undefined);
    /**
     * @stability stable
     */
    resetTagsExecution(): void;
    /**
     * @stability stable
     */
    get tagsExecutionInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetFreeTextDefinition {
    /**
     * The color of the text in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#color Dashboard#color}
     *
     * @stability stable
     */
    readonly color?: string;
    /**
     * The size of the text in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#font_size Dashboard#font_size}
     *
     * @stability stable
     */
    readonly fontSize?: string;
    /**
     * The text to display in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#text Dashboard#text}
     *
     * @stability stable
     */
    readonly text: string;
    /**
     * The alignment of the text in the widget. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#text_align Dashboard#text_align}
     *
     * @stability stable
     */
    readonly textAlign?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetFreeTextDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _color?;
    /**
     * @stability stable
     */
    get color(): string | undefined;
    /**
     * @stability stable
     */
    set color(value: string | undefined);
    /**
     * @stability stable
     */
    resetColor(): void;
    /**
     * @stability stable
     */
    get colorInput(): string | undefined;
    private _fontSize?;
    /**
     * @stability stable
     */
    get fontSize(): string | undefined;
    /**
     * @stability stable
     */
    set fontSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetFontSize(): void;
    /**
     * @stability stable
     */
    get fontSizeInput(): string | undefined;
    private _text?;
    /**
     * @stability stable
     */
    get text(): string;
    /**
     * @stability stable
     */
    set text(value: string);
    /**
     * @stability stable
     */
    get textInput(): string | undefined;
    private _textAlign?;
    /**
     * @stability stable
     */
    get textAlign(): string | undefined;
    /**
     * @stability stable
     */
    set textAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTextAlign(): void;
    /**
     * @stability stable
     */
    get textAlignInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionCustomLink {
    /**
     * The flag for toggling context menu link visibility.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#is_hidden Dashboard#is_hidden}
     *
     * @stability stable
     */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
     * The label for the custom link URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * The URL of the custom link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#link Dashboard#link}
     *
     * @stability stable
     */
    readonly link?: string;
    /**
     * The label id that refers to a context menu link item.
     *
     * When override_label is provided, the client request omits the label field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#override_label Dashboard#override_label}
     *
     * @stability stable
     */
    readonly overrideLabel?: string;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormulaConditionalFormats {
    /**
     * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#comparator Dashboard#comparator}
     *
     * @stability stable
     */
    readonly comparator: string;
    /**
     * The color palette to apply to the background, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_bg_color Dashboard#custom_bg_color}
     *
     * @stability stable
     */
    readonly customBgColor?: string;
    /**
     * The color palette to apply to the foreground, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_fg_color Dashboard#custom_fg_color}
     *
     * @stability stable
     */
    readonly customFgColor?: string;
    /**
     * Setting this to True hides values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#hide_value Dashboard#hide_value}
     *
     * @stability stable
     */
    readonly hideValue?: boolean | cdktf.IResolvable;
    /**
     * Displays an image as the background.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#image_url Dashboard#image_url}
     *
     * @stability stable
     */
    readonly imageUrl?: string;
    /**
     * The metric from the request to correlate with this conditional format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * The color palette to apply.
     *
     * Valid values are `blue`, `custom_bg`, `custom_image`, `custom_text`, `gray_on_white`, `grey`, `green`, `orange`, `red`, `red_on_white`, `white_on_gray`, `white_on_green`, `green_on_white`, `white_on_red`, `white_on_yellow`, `yellow_on_white`, `black_on_light_yellow`, `black_on_light_green`, `black_on_light_red`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette: string;
    /**
     * Defines the displayed timeframe.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#timeframe Dashboard#timeframe}
     *
     * @stability stable
     */
    readonly timeframe?: string;
    /**
     * A value for the comparator.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#value Dashboard#value}
     *
     * @stability stable
     */
    readonly value: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormulaLimit {
    /**
     * The number of results to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#count Dashboard#count}
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * The direction of the sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormulaLimitOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number | undefined;
    /**
     * @stability stable
     */
    set count(value: number | undefined);
    /**
     * @stability stable
     */
    resetCount(): void;
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string | undefined;
    /**
     * @stability stable
     */
    set order(value: string | undefined);
    /**
     * @stability stable
     */
    resetOrder(): void;
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormula {
    /**
     * An expression alias.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#alias Dashboard#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * A list of display modes for each table cell. Valid values are `number`, `bar`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#cell_display_mode Dashboard#cell_display_mode}
     *
     * @stability stable
     */
    readonly cellDisplayMode?: string;
    /**
     * A string expression built from queries, formulas, and functions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#formula_expression Dashboard#formula_expression}
     *
     * @stability stable
     */
    readonly formulaExpression: string;
    /**
     * conditional_formats block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#conditional_formats Dashboard#conditional_formats}
     *
     * @stability stable
     */
    readonly conditionalFormats?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormulaConditionalFormats[];
    /**
     * limit block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormulaLimit;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery {
    /**
     * The data source for APM Dependency Stats queries. Valid values are `apm_dependency_stats`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * APM Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * Determines whether stats for upstream or downstream dependencies should be queried.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#is_upstream Dashboard#is_upstream}
     *
     * @stability stable
     */
    readonly isUpstream?: boolean | cdktf.IResolvable;
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of operation on service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#operation_name Dashboard#operation_name}
     *
     * @stability stable
     */
    readonly operationName: string;
    /**
     * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#primary_tag_name Dashboard#primary_tag_name}
     *
     * @stability stable
     */
    readonly primaryTagName?: string;
    /**
     * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#primary_tag_value Dashboard#primary_tag_value}
     *
     * @stability stable
     */
    readonly primaryTagValue?: string;
    /**
     * APM resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#resource_name Dashboard#resource_name}
     *
     * @stability stable
     */
    readonly resourceName: string;
    /**
     * APM service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * APM statistic. Valid values are `avg_duration`, `avg_root_duration`, `avg_spans_per_trace`, `error_rate`, `pct_exec_time`, `pct_of_traces`, `total_traces_count`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#stat Dashboard#stat}
     *
     * @stability stable
     */
    readonly stat: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmDependencyStatsQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _isUpstream?;
    /**
     * @stability stable
     */
    get isUpstream(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isUpstream(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsUpstream(): void;
    /**
     * @stability stable
     */
    get isUpstreamInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationName?;
    /**
     * @stability stable
     */
    get operationName(): string;
    /**
     * @stability stable
     */
    set operationName(value: string);
    /**
     * @stability stable
     */
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    /**
     * @stability stable
     */
    get primaryTagName(): string | undefined;
    /**
     * @stability stable
     */
    set primaryTagName(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrimaryTagName(): void;
    /**
     * @stability stable
     */
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    /**
     * @stability stable
     */
    get primaryTagValue(): string | undefined;
    /**
     * @stability stable
     */
    set primaryTagValue(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrimaryTagValue(): void;
    /**
     * @stability stable
     */
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string;
    /**
     * @stability stable
     */
    set resourceName(value: string);
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _stat?;
    /**
     * @stability stable
     */
    get stat(): string;
    /**
     * @stability stable
     */
    set stat(value: string);
    /**
     * @stability stable
     */
    get statInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery {
    /**
     * The data source for APM Resource Stats queries. Valid values are `apm_resource_stats`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * APM Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * Array of fields to group results by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: string[];
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of operation on service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#operation_name Dashboard#operation_name}
     *
     * @stability stable
     */
    readonly operationName?: string;
    /**
     * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#primary_tag_name Dashboard#primary_tag_name}
     *
     * @stability stable
     */
    readonly primaryTagName?: string;
    /**
     * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#primary_tag_value Dashboard#primary_tag_value}
     *
     * @stability stable
     */
    readonly primaryTagValue?: string;
    /**
     * APM resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#resource_name Dashboard#resource_name}
     *
     * @stability stable
     */
    readonly resourceName?: string;
    /**
     * APM service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * APM statistic. Valid values are `errors`, `error_rate`, `hits`, `latency_avg`, `latency_max`, `latency_p50`, `latency_p75`, `latency_p90`, `latency_p95`, `latency_p99`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#stat Dashboard#stat}
     *
     * @stability stable
     */
    readonly stat: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmResourceStatsQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): string[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationName?;
    /**
     * @stability stable
     */
    get operationName(): string | undefined;
    /**
     * @stability stable
     */
    set operationName(value: string | undefined);
    /**
     * @stability stable
     */
    resetOperationName(): void;
    /**
     * @stability stable
     */
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    /**
     * @stability stable
     */
    get primaryTagName(): string | undefined;
    /**
     * @stability stable
     */
    set primaryTagName(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrimaryTagName(): void;
    /**
     * @stability stable
     */
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    /**
     * @stability stable
     */
    get primaryTagValue(): string | undefined;
    /**
     * @stability stable
     */
    set primaryTagValue(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrimaryTagValue(): void;
    /**
     * @stability stable
     */
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string | undefined;
    /**
     * @stability stable
     */
    set resourceName(value: string | undefined);
    /**
     * @stability stable
     */
    resetResourceName(): void;
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _stat?;
    /**
     * @stability stable
     */
    get stat(): string;
    /**
     * @stability stable
     */
    set stat(value: string);
    /**
     * @stability stable
     */
    get statInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryCompute {
    /**
     * The aggregation methods for event platform queries.
     *
     * Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * A time interval in milliseconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
    /**
     * The measurable attribute to compute.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort {
    /**
     * The aggregation methods for the event platform queries.
     *
     * Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The metric used for sorting group by results.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * Direction of sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBySortOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string | undefined;
    /**
     * @stability stable
     */
    set metric(value: string | undefined);
    /**
     * @stability stable
     */
    resetMetric(): void;
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string | undefined;
    /**
     * @stability stable
     */
    set order(value: string | undefined);
    /**
     * @stability stable
     */
    resetOrder(): void;
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBy {
    /**
     * The event facet.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet: string;
    /**
     * The number of groups to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBySort;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuerySearch {
    /**
     * The events search string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuerySearchOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuery {
    /**
     * The data source for event platform-based queries. Valid values are `logs`, `spans`, `network`, `rum`, `security_signals`, `profiles`, `audit`, `events`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * An array of index names to query in the stream.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#indexes Dashboard#indexes}
     *
     * @stability stable
     */
    readonly indexes?: string[];
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute Dashboard#compute}
     *
     * @stability stable
     */
    readonly compute: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryCompute[];
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[];
    /**
     * search block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search Dashboard#search}
     *
     * @stability stable
     */
    readonly search?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuerySearch;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _indexes?;
    /**
     * @stability stable
     */
    get indexes(): string[] | undefined;
    /**
     * @stability stable
     */
    set indexes(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetIndexes(): void;
    /**
     * @stability stable
     */
    get indexesInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _compute?;
    /**
     * @stability stable
     */
    get compute(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryCompute[];
    /**
     * @stability stable
     */
    set compute(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryCompute[]);
    /**
     * @stability stable
     */
    get computeInput(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryCompute[] | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQueryGroupBy[] | undefined;
    private _search?;
    private __searchOutput;
    /**
     * @stability stable
     */
    get search(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuerySearchOutputReference;
    /**
     * @stability stable
     */
    putSearch(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuerySearch | undefined): void;
    /**
     * @stability stable
     */
    resetSearch(): void;
    /**
     * @stability stable
     */
    get searchInput(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuerySearch | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryMetricQuery {
    /**
     * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The data source for metrics queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource?: string;
    /**
     * The name of the query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The metrics query definition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryMetricQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregator?;
    /**
     * @stability stable
     */
    get aggregator(): string | undefined;
    /**
     * @stability stable
     */
    set aggregator(value: string | undefined);
    /**
     * @stability stable
     */
    resetAggregator(): void;
    /**
     * @stability stable
     */
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string | undefined;
    /**
     * @stability stable
     */
    set dataSource(value: string | undefined);
    /**
     * @stability stable
     */
    resetDataSource(): void;
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryProcessQuery {
    /**
     * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The data source for process queries. Valid values are `process`, `container`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * Whether to normalize the CPU percentages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#is_normalized_cpu Dashboard#is_normalized_cpu}
     *
     * @stability stable
     */
    readonly isNormalizedCpu?: boolean | cdktf.IResolvable;
    /**
     * The number of hits to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * The process metric name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The direction of the sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: string;
    /**
     * An array of tags to filter by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#tag_filters Dashboard#tag_filters}
     *
     * @stability stable
     */
    readonly tagFilters?: string[];
    /**
     * The text to use as a filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#text_filter Dashboard#text_filter}
     *
     * @stability stable
     */
    readonly textFilter?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryProcessQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregator?;
    /**
     * @stability stable
     */
    get aggregator(): string | undefined;
    /**
     * @stability stable
     */
    set aggregator(value: string | undefined);
    /**
     * @stability stable
     */
    resetAggregator(): void;
    /**
     * @stability stable
     */
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _isNormalizedCpu?;
    /**
     * @stability stable
     */
    get isNormalizedCpu(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isNormalizedCpu(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsNormalizedCpu(): void;
    /**
     * @stability stable
     */
    get isNormalizedCpuInput(): boolean | cdktf.IResolvable | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number | undefined;
    /**
     * @stability stable
     */
    set limit(value: number | undefined);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sort?;
    /**
     * @stability stable
     */
    get sort(): string | undefined;
    /**
     * @stability stable
     */
    set sort(value: string | undefined);
    /**
     * @stability stable
     */
    resetSort(): void;
    /**
     * @stability stable
     */
    get sortInput(): string | undefined;
    private _tagFilters?;
    /**
     * @stability stable
     */
    get tagFilters(): string[] | undefined;
    /**
     * @stability stable
     */
    set tagFilters(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetTagFilters(): void;
    /**
     * @stability stable
     */
    get tagFiltersInput(): string[] | undefined;
    private _textFilter?;
    /**
     * @stability stable
     */
    get textFilter(): string | undefined;
    /**
     * @stability stable
     */
    set textFilter(value: string | undefined);
    /**
     * @stability stable
     */
    resetTextFilter(): void;
    /**
     * @stability stable
     */
    get textFilterInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQuery {
    /**
     * apm_dependency_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
     *
     * @stability stable
     */
    readonly apmDependencyStatsQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmDependencyStatsQuery;
    /**
     * apm_resource_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_resource_stats_query Dashboard#apm_resource_stats_query}
     *
     * @stability stable
     */
    readonly apmResourceStatsQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryApmResourceStatsQuery;
    /**
     * event_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#event_query Dashboard#event_query}
     *
     * @stability stable
     */
    readonly eventQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryEventQuery;
    /**
     * metric_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric_query Dashboard#metric_query}
     *
     * @stability stable
     */
    readonly metricQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryMetricQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQueryProcessQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequest {
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * formula block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#formula Dashboard#formula}
     *
     * @stability stable
     */
    readonly formula?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestFormula[];
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestLogQuery;
    /**
     * query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestQuery[];
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequestRumQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionStyle {
    /**
     * The color palette to apply to the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette: string;
    /**
     * A Boolean indicating whether to flip the palette tones.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#palette_flip Dashboard#palette_flip}
     *
     * @stability stable
     */
    readonly paletteFlip: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionStyleOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _palette?;
    /**
     * @stability stable
     */
    get palette(): string;
    /**
     * @stability stable
     */
    set palette(value: string);
    /**
     * @stability stable
     */
    get paletteInput(): string | undefined;
    private _paletteFlip?;
    /**
     * @stability stable
     */
    get paletteFlip(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set paletteFlip(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get paletteFlipInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinitionView {
    /**
     * The two-letter ISO code of a country to focus the map on (or `WORLD`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#focus Dashboard#focus}
     *
     * @stability stable
     */
    readonly focus: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionViewOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _focus?;
    /**
     * @stability stable
     */
    get focus(): string;
    /**
     * @stability stable
     */
    set focus(value: string);
    /**
     * @stability stable
     */
    get focusInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetGeomapDefinition {
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * custom_link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_link Dashboard#custom_link}
     *
     * @stability stable
     */
    readonly customLink?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionCustomLink[];
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequest[];
    /**
     * style block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#style Dashboard#style}
     *
     * @stability stable
     */
    readonly style?: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionStyle;
    /**
     * view block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#view Dashboard#view}
     *
     * @stability stable
     */
    readonly view: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionView;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetGeomapDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string | undefined;
    /**
     * @stability stable
     */
    set liveSpan(value: string | undefined);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _customLink?;
    /**
     * @stability stable
     */
    get customLink(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionCustomLink[] | undefined;
    /**
     * @stability stable
     */
    set customLink(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionCustomLink[] | undefined);
    /**
     * @stability stable
     */
    resetCustomLink(): void;
    /**
     * @stability stable
     */
    get customLinkInput(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionCustomLink[] | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequest[] | undefined;
    /**
     * @stability stable
     */
    set request(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequest[] | undefined);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionRequest[] | undefined;
    private _style?;
    private __styleOutput;
    /**
     * @stability stable
     */
    get style(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionStyleOutputReference;
    /**
     * @stability stable
     */
    putStyle(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionStyle | undefined): void;
    /**
     * @stability stable
     */
    resetStyle(): void;
    /**
     * @stability stable
     */
    get styleInput(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionStyle | undefined;
    private _view?;
    private __viewOutput;
    /**
     * @stability stable
     */
    get view(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionViewOutputReference;
    /**
     * @stability stable
     */
    putView(value: DashboardWidgetGroupDefinitionWidgetGeomapDefinitionView): void;
    /**
     * @stability stable
     */
    get viewInput(): DashboardWidgetGroupDefinitionWidgetGeomapDefinitionView | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionCustomLink {
    /**
     * The flag for toggling context menu link visibility.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#is_hidden Dashboard#is_hidden}
     *
     * @stability stable
     */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
     * The label for the custom link URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * The URL of the custom link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#link Dashboard#link}
     *
     * @stability stable
     */
    readonly link?: string;
    /**
     * The label id that refers to a context menu link item.
     *
     * When override_label is provided, the client request omits the label field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#override_label Dashboard#override_label}
     *
     * @stability stable
     */
    readonly overrideLabel?: string;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionEvent {
    /**
     * The event query to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q: string;
    /**
     * The execution method for multi-value filters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#tags_execution Dashboard#tags_execution}
     *
     * @stability stable
     */
    readonly tagsExecution?: string;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestProcessQuery {
    /**
     * A list of processes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#filter_by Dashboard#filter_by}
     *
     * @stability stable
     */
    readonly filterBy?: string[];
    /**
     * The max number of items in the filter list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Your chosen metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Your chosen search term.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_by Dashboard#search_by}
     *
     * @stability stable
     */
    readonly searchBy?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestProcessQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _filterBy?;
    /**
     * @stability stable
     */
    get filterBy(): string[] | undefined;
    /**
     * @stability stable
     */
    set filterBy(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetFilterBy(): void;
    /**
     * @stability stable
     */
    get filterByInput(): string[] | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number | undefined;
    /**
     * @stability stable
     */
    set limit(value: number | undefined);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _searchBy?;
    /**
     * @stability stable
     */
    get searchBy(): string | undefined;
    /**
     * @stability stable
     */
    set searchBy(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchBy(): void;
    /**
     * @stability stable
     */
    get searchByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestStyle {
    /**
     * A color palette to apply to the widget. The available options are available at: https://docs.datadoghq.com/dashboards/widgets/timeseries/#appearance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestStyleOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _palette?;
    /**
     * @stability stable
     */
    get palette(): string | undefined;
    /**
     * @stability stable
     */
    set palette(value: string | undefined);
    /**
     * @stability stable
     */
    resetPalette(): void;
    /**
     * @stability stable
     */
    get paletteInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequest {
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * apm_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_query Dashboard#apm_query}
     *
     * @stability stable
     */
    readonly apmQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestApmQuery;
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestLogQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestProcessQuery;
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestRumQuery;
    /**
     * security_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#security_query Dashboard#security_query}
     *
     * @stability stable
     */
    readonly securityQuery?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestSecurityQuery;
    /**
     * style block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#style Dashboard#style}
     *
     * @stability stable
     */
    readonly style?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequestStyle;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionYaxis {
    /**
     * Always include zero or fit the axis to the data range.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#include_zero Dashboard#include_zero}
     *
     * @stability stable
     */
    readonly includeZero?: boolean | cdktf.IResolvable;
    /**
     * The label of the axis to display on the graph.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * Specify the maximum value to show on the Y-axis.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#max Dashboard#max}
     *
     * @stability stable
     */
    readonly max?: string;
    /**
     * Specify the minimum value to show on the Y-axis.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#min Dashboard#min}
     *
     * @stability stable
     */
    readonly min?: string;
    /**
     * Specify the scale type, options: `linear`, `log`, `pow`, `sqrt`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#scale Dashboard#scale}
     *
     * @stability stable
     */
    readonly scale?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionYaxisOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _includeZero?;
    /**
     * @stability stable
     */
    get includeZero(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set includeZero(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIncludeZero(): void;
    /**
     * @stability stable
     */
    get includeZeroInput(): boolean | cdktf.IResolvable | undefined;
    private _label?;
    /**
     * @stability stable
     */
    get label(): string | undefined;
    /**
     * @stability stable
     */
    set label(value: string | undefined);
    /**
     * @stability stable
     */
    resetLabel(): void;
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _max?;
    /**
     * @stability stable
     */
    get max(): string | undefined;
    /**
     * @stability stable
     */
    set max(value: string | undefined);
    /**
     * @stability stable
     */
    resetMax(): void;
    /**
     * @stability stable
     */
    get maxInput(): string | undefined;
    private _min?;
    /**
     * @stability stable
     */
    get min(): string | undefined;
    /**
     * @stability stable
     */
    set min(value: string | undefined);
    /**
     * @stability stable
     */
    resetMin(): void;
    /**
     * @stability stable
     */
    get minInput(): string | undefined;
    private _scale?;
    /**
     * @stability stable
     */
    get scale(): string | undefined;
    /**
     * @stability stable
     */
    set scale(value: string | undefined);
    /**
     * @stability stable
     */
    resetScale(): void;
    /**
     * @stability stable
     */
    get scaleInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHeatmapDefinition {
    /**
     * The size of the legend displayed in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#legend_size Dashboard#legend_size}
     *
     * @stability stable
     */
    readonly legendSize?: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * Whether or not to show the legend on this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#show_legend Dashboard#show_legend}
     *
     * @stability stable
     */
    readonly showLegend?: boolean | cdktf.IResolvable;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * custom_link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_link Dashboard#custom_link}
     *
     * @stability stable
     */
    readonly customLink?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionCustomLink[];
    /**
     * event block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#event Dashboard#event}
     *
     * @stability stable
     */
    readonly event?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionEvent[];
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequest[];
    /**
     * yaxis block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#yaxis Dashboard#yaxis}
     *
     * @stability stable
     */
    readonly yaxis?: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionYaxis;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _legendSize?;
    /**
     * @stability stable
     */
    get legendSize(): string | undefined;
    /**
     * @stability stable
     */
    set legendSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetLegendSize(): void;
    /**
     * @stability stable
     */
    get legendSizeInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string | undefined;
    /**
     * @stability stable
     */
    set liveSpan(value: string | undefined);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _showLegend?;
    /**
     * @stability stable
     */
    get showLegend(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set showLegend(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetShowLegend(): void;
    /**
     * @stability stable
     */
    get showLegendInput(): boolean | cdktf.IResolvable | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _customLink?;
    /**
     * @stability stable
     */
    get customLink(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionCustomLink[] | undefined;
    /**
     * @stability stable
     */
    set customLink(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionCustomLink[] | undefined);
    /**
     * @stability stable
     */
    resetCustomLink(): void;
    /**
     * @stability stable
     */
    get customLinkInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionCustomLink[] | undefined;
    private _event?;
    /**
     * @stability stable
     */
    get event(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionEvent[] | undefined;
    /**
     * @stability stable
     */
    set event(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionEvent[] | undefined);
    /**
     * @stability stable
     */
    resetEvent(): void;
    /**
     * @stability stable
     */
    get eventInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionEvent[] | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequest[] | undefined;
    /**
     * @stability stable
     */
    set request(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequest[] | undefined);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionRequest[] | undefined;
    private _yaxis?;
    private __yaxisOutput;
    /**
     * @stability stable
     */
    get yaxis(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionYaxisOutputReference;
    /**
     * @stability stable
     */
    putYaxis(value: DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionYaxis | undefined): void;
    /**
     * @stability stable
     */
    resetYaxis(): void;
    /**
     * @stability stable
     */
    get yaxisInput(): DashboardWidgetGroupDefinitionWidgetHeatmapDefinitionYaxis | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionCustomLink {
    /**
     * The flag for toggling context menu link visibility.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#is_hidden Dashboard#is_hidden}
     *
     * @stability stable
     */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
     * The label for the custom link URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * The URL of the custom link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#link Dashboard#link}
     *
     * @stability stable
     */
    readonly link?: string;
    /**
     * The label id that refers to a context menu link item.
     *
     * When override_label is provided, the client request omits the label field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#override_label Dashboard#override_label}
     *
     * @stability stable
     */
    readonly overrideLabel?: string;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillProcessQuery {
    /**
     * A list of processes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#filter_by Dashboard#filter_by}
     *
     * @stability stable
     */
    readonly filterBy?: string[];
    /**
     * The max number of items in the filter list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Your chosen metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Your chosen search term.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_by Dashboard#search_by}
     *
     * @stability stable
     */
    readonly searchBy?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillProcessQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _filterBy?;
    /**
     * @stability stable
     */
    get filterBy(): string[] | undefined;
    /**
     * @stability stable
     */
    set filterBy(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetFilterBy(): void;
    /**
     * @stability stable
     */
    get filterByInput(): string[] | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number | undefined;
    /**
     * @stability stable
     */
    set limit(value: number | undefined);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _searchBy?;
    /**
     * @stability stable
     */
    get searchBy(): string | undefined;
    /**
     * @stability stable
     */
    set searchBy(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchBy(): void;
    /**
     * @stability stable
     */
    get searchByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFill {
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * apm_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_query Dashboard#apm_query}
     *
     * @stability stable
     */
    readonly apmQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillApmQuery;
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillLogQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillProcessQuery;
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillRumQuery;
    /**
     * security_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#security_query Dashboard#security_query}
     *
     * @stability stable
     */
    readonly securityQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFillSecurityQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeProcessQuery {
    /**
     * A list of processes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#filter_by Dashboard#filter_by}
     *
     * @stability stable
     */
    readonly filterBy?: string[];
    /**
     * The max number of items in the filter list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Your chosen metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Your chosen search term.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_by Dashboard#search_by}
     *
     * @stability stable
     */
    readonly searchBy?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeProcessQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _filterBy?;
    /**
     * @stability stable
     */
    get filterBy(): string[] | undefined;
    /**
     * @stability stable
     */
    set filterBy(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetFilterBy(): void;
    /**
     * @stability stable
     */
    get filterByInput(): string[] | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number | undefined;
    /**
     * @stability stable
     */
    set limit(value: number | undefined);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _searchBy?;
    /**
     * @stability stable
     */
    get searchBy(): string | undefined;
    /**
     * @stability stable
     */
    set searchBy(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchBy(): void;
    /**
     * @stability stable
     */
    get searchByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSize {
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * apm_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_query Dashboard#apm_query}
     *
     * @stability stable
     */
    readonly apmQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeApmQuery;
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeLogQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeProcessQuery;
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeRumQuery;
    /**
     * security_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#security_query Dashboard#security_query}
     *
     * @stability stable
     */
    readonly securityQuery?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSizeSecurityQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequest {
    /**
     * fill block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#fill Dashboard#fill}
     *
     * @stability stable
     */
    readonly fill?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFill[];
    /**
     * size block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#size Dashboard#size}
     *
     * @stability stable
     */
    readonly size?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSize[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _fill?;
    /**
     * @stability stable
     */
    get fill(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFill[] | undefined;
    /**
     * @stability stable
     */
    set fill(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFill[] | undefined);
    /**
     * @stability stable
     */
    resetFill(): void;
    /**
     * @stability stable
     */
    get fillInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestFill[] | undefined;
    private _size?;
    /**
     * @stability stable
     */
    get size(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSize[] | undefined;
    /**
     * @stability stable
     */
    set size(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSize[] | undefined);
    /**
     * @stability stable
     */
    resetSize(): void;
    /**
     * @stability stable
     */
    get sizeInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestSize[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinitionStyle {
    /**
     * The max value to use to color the map.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#fill_max Dashboard#fill_max}
     *
     * @stability stable
     */
    readonly fillMax?: string;
    /**
     * The min value to use to color the map.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#fill_min Dashboard#fill_min}
     *
     * @stability stable
     */
    readonly fillMin?: string;
    /**
     * A color palette to apply to the widget. The available options are available at: https://docs.datadoghq.com/dashboards/widgets/timeseries/#appearance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette?: string;
    /**
     * A Boolean indicating whether to flip the palette tones.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#palette_flip Dashboard#palette_flip}
     *
     * @stability stable
     */
    readonly paletteFlip?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionStyleOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _fillMax?;
    /**
     * @stability stable
     */
    get fillMax(): string | undefined;
    /**
     * @stability stable
     */
    set fillMax(value: string | undefined);
    /**
     * @stability stable
     */
    resetFillMax(): void;
    /**
     * @stability stable
     */
    get fillMaxInput(): string | undefined;
    private _fillMin?;
    /**
     * @stability stable
     */
    get fillMin(): string | undefined;
    /**
     * @stability stable
     */
    set fillMin(value: string | undefined);
    /**
     * @stability stable
     */
    resetFillMin(): void;
    /**
     * @stability stable
     */
    get fillMinInput(): string | undefined;
    private _palette?;
    /**
     * @stability stable
     */
    get palette(): string | undefined;
    /**
     * @stability stable
     */
    set palette(value: string | undefined);
    /**
     * @stability stable
     */
    resetPalette(): void;
    /**
     * @stability stable
     */
    get paletteInput(): string | undefined;
    private _paletteFlip?;
    /**
     * @stability stable
     */
    get paletteFlip(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set paletteFlip(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetPaletteFlip(): void;
    /**
     * @stability stable
     */
    get paletteFlipInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetHostmapDefinition {
    /**
     * The list of tags to group nodes by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group Dashboard#group}
     *
     * @stability stable
     */
    readonly group?: string[];
    /**
     * A Boolean indicating whether to show ungrouped nodes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#no_group_hosts Dashboard#no_group_hosts}
     *
     * @stability stable
     */
    readonly noGroupHosts?: boolean | cdktf.IResolvable;
    /**
     * A Boolean indicating whether to show nodes with no metrics.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#no_metric_hosts Dashboard#no_metric_hosts}
     *
     * @stability stable
     */
    readonly noMetricHosts?: boolean | cdktf.IResolvable;
    /**
     * The type of node used. Valid values are `host`, `container`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#node_type Dashboard#node_type}
     *
     * @stability stable
     */
    readonly nodeType?: string;
    /**
     * The list of tags to filter nodes by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#scope Dashboard#scope}
     *
     * @stability stable
     */
    readonly scope?: string[];
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * custom_link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_link Dashboard#custom_link}
     *
     * @stability stable
     */
    readonly customLink?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionCustomLink[];
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequest;
    /**
     * style block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#style Dashboard#style}
     *
     * @stability stable
     */
    readonly style?: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionStyle;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetHostmapDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _group?;
    /**
     * @stability stable
     */
    get group(): string[] | undefined;
    /**
     * @stability stable
     */
    set group(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetGroup(): void;
    /**
     * @stability stable
     */
    get groupInput(): string[] | undefined;
    private _noGroupHosts?;
    /**
     * @stability stable
     */
    get noGroupHosts(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set noGroupHosts(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetNoGroupHosts(): void;
    /**
     * @stability stable
     */
    get noGroupHostsInput(): boolean | cdktf.IResolvable | undefined;
    private _noMetricHosts?;
    /**
     * @stability stable
     */
    get noMetricHosts(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set noMetricHosts(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetNoMetricHosts(): void;
    /**
     * @stability stable
     */
    get noMetricHostsInput(): boolean | cdktf.IResolvable | undefined;
    private _nodeType?;
    /**
     * @stability stable
     */
    get nodeType(): string | undefined;
    /**
     * @stability stable
     */
    set nodeType(value: string | undefined);
    /**
     * @stability stable
     */
    resetNodeType(): void;
    /**
     * @stability stable
     */
    get nodeTypeInput(): string | undefined;
    private _scope?;
    /**
     * @stability stable
     */
    get scope(): string[] | undefined;
    /**
     * @stability stable
     */
    set scope(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetScope(): void;
    /**
     * @stability stable
     */
    get scopeInput(): string[] | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _customLink?;
    /**
     * @stability stable
     */
    get customLink(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionCustomLink[] | undefined;
    /**
     * @stability stable
     */
    set customLink(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionCustomLink[] | undefined);
    /**
     * @stability stable
     */
    resetCustomLink(): void;
    /**
     * @stability stable
     */
    get customLinkInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionCustomLink[] | undefined;
    private _request?;
    private __requestOutput;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequestOutputReference;
    /**
     * @stability stable
     */
    putRequest(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequest | undefined): void;
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionRequest | undefined;
    private _style?;
    private __styleOutput;
    /**
     * @stability stable
     */
    get style(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionStyleOutputReference;
    /**
     * @stability stable
     */
    putStyle(value: DashboardWidgetGroupDefinitionWidgetHostmapDefinitionStyle | undefined): void;
    /**
     * @stability stable
     */
    resetStyle(): void;
    /**
     * @stability stable
     */
    get styleInput(): DashboardWidgetGroupDefinitionWidgetHostmapDefinitionStyle | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetIframeDefinition {
    /**
     * The URL to use as a data source for the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#url Dashboard#url}
     *
     * @stability stable
     */
    readonly url: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetIframeDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetImageDefinition {
    /**
     * Whether to display a background or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#has_background Dashboard#has_background}
     *
     * @stability stable
     */
    readonly hasBackground?: boolean | cdktf.IResolvable;
    /**
     * Whether to display a border or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#has_border Dashboard#has_border}
     *
     * @stability stable
     */
    readonly hasBorder?: boolean | cdktf.IResolvable;
    /**
     * The horizontal alignment for the widget. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#horizontal_align Dashboard#horizontal_align}
     *
     * @stability stable
     */
    readonly horizontalAlign?: string;
    /**
     * The margins to use around the image.
     *
     * Note: `small` and `large` values are deprecated. Valid values are `sm`, `md`, `lg`, `small`, `large`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#margin Dashboard#margin}
     *
     * @stability stable
     */
    readonly margin?: string;
    /**
     * The preferred method to adapt the dimensions of the image.
     *
     * The values are based on the image `object-fit` CSS properties. Note: `zoom`, `fit` and `center` values are deprecated. Valid values are `fill`, `contain`, `cover`, `none`, `scale-down`, `zoom`, `fit`, `center`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sizing Dashboard#sizing}
     *
     * @stability stable
     */
    readonly sizing?: string;
    /**
     * The URL to use as a data source for the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#url Dashboard#url}
     *
     * @stability stable
     */
    readonly url: string;
    /**
     * The URL in dark mode to use as a data source for the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#url_dark_theme Dashboard#url_dark_theme}
     *
     * @stability stable
     */
    readonly urlDarkTheme?: string;
    /**
     * The vertical alignment for the widget. Valid values are `center`, `top`, `bottom`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#vertical_align Dashboard#vertical_align}
     *
     * @stability stable
     */
    readonly verticalAlign?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetImageDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _hasBackground?;
    /**
     * @stability stable
     */
    get hasBackground(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set hasBackground(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetHasBackground(): void;
    /**
     * @stability stable
     */
    get hasBackgroundInput(): boolean | cdktf.IResolvable | undefined;
    private _hasBorder?;
    /**
     * @stability stable
     */
    get hasBorder(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set hasBorder(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetHasBorder(): void;
    /**
     * @stability stable
     */
    get hasBorderInput(): boolean | cdktf.IResolvable | undefined;
    private _horizontalAlign?;
    /**
     * @stability stable
     */
    get horizontalAlign(): string | undefined;
    /**
     * @stability stable
     */
    set horizontalAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetHorizontalAlign(): void;
    /**
     * @stability stable
     */
    get horizontalAlignInput(): string | undefined;
    private _margin?;
    /**
     * @stability stable
     */
    get margin(): string | undefined;
    /**
     * @stability stable
     */
    set margin(value: string | undefined);
    /**
     * @stability stable
     */
    resetMargin(): void;
    /**
     * @stability stable
     */
    get marginInput(): string | undefined;
    private _sizing?;
    /**
     * @stability stable
     */
    get sizing(): string | undefined;
    /**
     * @stability stable
     */
    set sizing(value: string | undefined);
    /**
     * @stability stable
     */
    resetSizing(): void;
    /**
     * @stability stable
     */
    get sizingInput(): string | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
    private _urlDarkTheme?;
    /**
     * @stability stable
     */
    get urlDarkTheme(): string | undefined;
    /**
     * @stability stable
     */
    set urlDarkTheme(value: string | undefined);
    /**
     * @stability stable
     */
    resetUrlDarkTheme(): void;
    /**
     * @stability stable
     */
    get urlDarkThemeInput(): string | undefined;
    private _verticalAlign?;
    /**
     * @stability stable
     */
    get verticalAlign(): string | undefined;
    /**
     * @stability stable
     */
    set verticalAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetVerticalAlign(): void;
    /**
     * @stability stable
     */
    get verticalAlignInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetLogStreamDefinitionSort {
    /**
     * The facet path for the column.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#column Dashboard#column}
     *
     * @stability stable
     */
    readonly column: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetLogStreamDefinitionSortOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _column?;
    /**
     * @stability stable
     */
    get column(): string;
    /**
     * @stability stable
     */
    set column(value: string);
    /**
     * @stability stable
     */
    get columnInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetLogStreamDefinition {
    /**
     * Stringified list of columns to use, for example: `["column1","column2","column3"]`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#columns Dashboard#columns}
     *
     * @stability stable
     */
    readonly columns?: string[];
    /**
     * An array of index names to query in the stream.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#indexes Dashboard#indexes}
     *
     * @stability stable
     */
    readonly indexes?: string[];
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The number of log lines to display. Valid values are `inline`, `expanded-md`, `expanded-lg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#message_display Dashboard#message_display}
     *
     * @stability stable
     */
    readonly messageDisplay?: string;
    /**
     * The query to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query?: string;
    /**
     * If the date column should be displayed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#show_date_column Dashboard#show_date_column}
     *
     * @stability stable
     */
    readonly showDateColumn?: boolean | cdktf.IResolvable;
    /**
     * If the message column should be displayed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#show_message_column Dashboard#show_message_column}
     *
     * @stability stable
     */
    readonly showMessageColumn?: boolean | cdktf.IResolvable;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * sort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: DashboardWidgetGroupDefinitionWidgetLogStreamDefinitionSort;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetLogStreamDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _columns?;
    /**
     * @stability stable
     */
    get columns(): string[] | undefined;
    /**
     * @stability stable
     */
    set columns(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetColumns(): void;
    /**
     * @stability stable
     */
    get columnsInput(): string[] | undefined;
    private _indexes?;
    /**
     * @stability stable
     */
    get indexes(): string[] | undefined;
    /**
     * @stability stable
     */
    set indexes(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetIndexes(): void;
    /**
     * @stability stable
     */
    get indexesInput(): string[] | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string | undefined;
    /**
     * @stability stable
     */
    set liveSpan(value: string | undefined);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _messageDisplay?;
    /**
     * @stability stable
     */
    get messageDisplay(): string | undefined;
    /**
     * @stability stable
     */
    set messageDisplay(value: string | undefined);
    /**
     * @stability stable
     */
    resetMessageDisplay(): void;
    /**
     * @stability stable
     */
    get messageDisplayInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string | undefined;
    /**
     * @stability stable
     */
    set query(value: string | undefined);
    /**
     * @stability stable
     */
    resetQuery(): void;
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _showDateColumn?;
    /**
     * @stability stable
     */
    get showDateColumn(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set showDateColumn(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetShowDateColumn(): void;
    /**
     * @stability stable
     */
    get showDateColumnInput(): boolean | cdktf.IResolvable | undefined;
    private _showMessageColumn?;
    /**
     * @stability stable
     */
    get showMessageColumn(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set showMessageColumn(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetShowMessageColumn(): void;
    /**
     * @stability stable
     */
    get showMessageColumnInput(): boolean | cdktf.IResolvable | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _sort?;
    private __sortOutput;
    /**
     * @stability stable
     */
    get sort(): DashboardWidgetGroupDefinitionWidgetLogStreamDefinitionSortOutputReference;
    /**
     * @stability stable
     */
    putSort(value: DashboardWidgetGroupDefinitionWidgetLogStreamDefinitionSort | undefined): void;
    /**
     * @stability stable
     */
    resetSort(): void;
    /**
     * @stability stable
     */
    get sortInput(): DashboardWidgetGroupDefinitionWidgetLogStreamDefinitionSort | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetManageStatusDefinition {
    /**
     * Whether to colorize text or background. Valid values are `background`, `text`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#color_preference Dashboard#color_preference}
     *
     * @stability stable
     */
    readonly colorPreference?: string;
    /**
     * The display setting to use. Valid values are `counts`, `countsAndList`, `list`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#display_format Dashboard#display_format}
     *
     * @stability stable
     */
    readonly displayFormat?: string;
    /**
     * A Boolean indicating whether to hide empty categories.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#hide_zero_counts Dashboard#hide_zero_counts}
     *
     * @stability stable
     */
    readonly hideZeroCounts?: boolean | cdktf.IResolvable;
    /**
     * The query to use in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * A Boolean indicating whether to show when monitors/groups last triggered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#show_last_triggered Dashboard#show_last_triggered}
     *
     * @stability stable
     */
    readonly showLastTriggered?: boolean | cdktf.IResolvable;
    /**
     * The method to sort the monitors.
     *
     * Valid values are `name`, `group`, `status`, `tags`, `triggered`, `group,asc`, `group,desc`, `name,asc`, `name,desc`, `status,asc`, `status,desc`, `tags,asc`, `tags,desc`, `triggered,asc`, `triggered,desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: string;
    /**
     * The summary type to use. Valid values are `monitors`, `groups`, `combined`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#summary_type Dashboard#summary_type}
     *
     * @stability stable
     */
    readonly summaryType?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetManageStatusDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _colorPreference?;
    /**
     * @stability stable
     */
    get colorPreference(): string | undefined;
    /**
     * @stability stable
     */
    set colorPreference(value: string | undefined);
    /**
     * @stability stable
     */
    resetColorPreference(): void;
    /**
     * @stability stable
     */
    get colorPreferenceInput(): string | undefined;
    private _displayFormat?;
    /**
     * @stability stable
     */
    get displayFormat(): string | undefined;
    /**
     * @stability stable
     */
    set displayFormat(value: string | undefined);
    /**
     * @stability stable
     */
    resetDisplayFormat(): void;
    /**
     * @stability stable
     */
    get displayFormatInput(): string | undefined;
    private _hideZeroCounts?;
    /**
     * @stability stable
     */
    get hideZeroCounts(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set hideZeroCounts(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetHideZeroCounts(): void;
    /**
     * @stability stable
     */
    get hideZeroCountsInput(): boolean | cdktf.IResolvable | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _showLastTriggered?;
    /**
     * @stability stable
     */
    get showLastTriggered(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set showLastTriggered(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetShowLastTriggered(): void;
    /**
     * @stability stable
     */
    get showLastTriggeredInput(): boolean | cdktf.IResolvable | undefined;
    private _sort?;
    /**
     * @stability stable
     */
    get sort(): string | undefined;
    /**
     * @stability stable
     */
    set sort(value: string | undefined);
    /**
     * @stability stable
     */
    resetSort(): void;
    /**
     * @stability stable
     */
    get sortInput(): string | undefined;
    private _summaryType?;
    /**
     * @stability stable
     */
    get summaryType(): string | undefined;
    /**
     * @stability stable
     */
    set summaryType(value: string | undefined);
    /**
     * @stability stable
     */
    resetSummaryType(): void;
    /**
     * @stability stable
     */
    get summaryTypeInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetNoteDefinition {
    /**
     * The background color of the note.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#background_color Dashboard#background_color}
     *
     * @stability stable
     */
    readonly backgroundColor?: string;
    /**
     * The content of the note.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#content Dashboard#content}
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * The size of the text.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#font_size Dashboard#font_size}
     *
     * @stability stable
     */
    readonly fontSize?: string;
    /**
     * Whether to add padding or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#has_padding Dashboard#has_padding}
     *
     * @stability stable
     */
    readonly hasPadding?: boolean | cdktf.IResolvable;
    /**
     * Whether to show a tick or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#show_tick Dashboard#show_tick}
     *
     * @stability stable
     */
    readonly showTick?: boolean | cdktf.IResolvable;
    /**
     * The alignment of the widget's text. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#text_align Dashboard#text_align}
     *
     * @stability stable
     */
    readonly textAlign?: string;
    /**
     * When `tick = true`, a string indicating on which side of the widget the tick should be displayed.
     *
     * Valid values are `bottom`, `left`, `right`, `top`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#tick_edge Dashboard#tick_edge}
     *
     * @stability stable
     */
    readonly tickEdge?: string;
    /**
     * When `tick = true`, a string with a percent sign indicating the position of the tick, for example: `tick_pos = "50%"` is centered alignment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#tick_pos Dashboard#tick_pos}
     *
     * @stability stable
     */
    readonly tickPos?: string;
    /**
     * The vertical alignment for the widget. Valid values are `center`, `top`, `bottom`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#vertical_align Dashboard#vertical_align}
     *
     * @stability stable
     */
    readonly verticalAlign?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetNoteDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _backgroundColor?;
    /**
     * @stability stable
     */
    get backgroundColor(): string | undefined;
    /**
     * @stability stable
     */
    set backgroundColor(value: string | undefined);
    /**
     * @stability stable
     */
    resetBackgroundColor(): void;
    /**
     * @stability stable
     */
    get backgroundColorInput(): string | undefined;
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _fontSize?;
    /**
     * @stability stable
     */
    get fontSize(): string | undefined;
    /**
     * @stability stable
     */
    set fontSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetFontSize(): void;
    /**
     * @stability stable
     */
    get fontSizeInput(): string | undefined;
    private _hasPadding?;
    /**
     * @stability stable
     */
    get hasPadding(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set hasPadding(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetHasPadding(): void;
    /**
     * @stability stable
     */
    get hasPaddingInput(): boolean | cdktf.IResolvable | undefined;
    private _showTick?;
    /**
     * @stability stable
     */
    get showTick(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set showTick(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetShowTick(): void;
    /**
     * @stability stable
     */
    get showTickInput(): boolean | cdktf.IResolvable | undefined;
    private _textAlign?;
    /**
     * @stability stable
     */
    get textAlign(): string | undefined;
    /**
     * @stability stable
     */
    set textAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTextAlign(): void;
    /**
     * @stability stable
     */
    get textAlignInput(): string | undefined;
    private _tickEdge?;
    /**
     * @stability stable
     */
    get tickEdge(): string | undefined;
    /**
     * @stability stable
     */
    set tickEdge(value: string | undefined);
    /**
     * @stability stable
     */
    resetTickEdge(): void;
    /**
     * @stability stable
     */
    get tickEdgeInput(): string | undefined;
    private _tickPos?;
    /**
     * @stability stable
     */
    get tickPos(): string | undefined;
    /**
     * @stability stable
     */
    set tickPos(value: string | undefined);
    /**
     * @stability stable
     */
    resetTickPos(): void;
    /**
     * @stability stable
     */
    get tickPosInput(): string | undefined;
    private _verticalAlign?;
    /**
     * @stability stable
     */
    get verticalAlign(): string | undefined;
    /**
     * @stability stable
     */
    set verticalAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetVerticalAlign(): void;
    /**
     * @stability stable
     */
    get verticalAlignInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionCustomLink {
    /**
     * The flag for toggling context menu link visibility.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#is_hidden Dashboard#is_hidden}
     *
     * @stability stable
     */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
     * The label for the custom link URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * The URL of the custom link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#link Dashboard#link}
     *
     * @stability stable
     */
    readonly link?: string;
    /**
     * The label id that refers to a context menu link item.
     *
     * When override_label is provided, the client request omits the label field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#override_label Dashboard#override_label}
     *
     * @stability stable
     */
    readonly overrideLabel?: string;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQueryColumns {
    /**
     * A user-assigned alias for the column.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#alias Dashboard#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * A list of display modes for each table cell. Valid values are `number`, `bar`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#cell_display_mode Dashboard#cell_display_mode}
     *
     * @stability stable
     */
    readonly cellDisplayMode?: string;
    /**
     * The column name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQuery {
    /**
     * The environment name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * The operation name associated with the service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The organization's host group name and value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#primary_tag Dashboard#primary_tag}
     *
     * @stability stable
     */
    readonly primaryTag: string;
    /**
     * The resource name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#resource Dashboard#resource}
     *
     * @stability stable
     */
    readonly resource?: string;
    /**
     * The level of detail for the request. Valid values are `service`, `resource`, `span`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#row_type Dashboard#row_type}
     *
     * @stability stable
     */
    readonly rowType: string;
    /**
     * The service name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * columns block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#columns Dashboard#columns}
     *
     * @stability stable
     */
    readonly columns?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQueryColumns[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _primaryTag?;
    /**
     * @stability stable
     */
    get primaryTag(): string;
    /**
     * @stability stable
     */
    set primaryTag(value: string);
    /**
     * @stability stable
     */
    get primaryTagInput(): string | undefined;
    private _resource?;
    /**
     * @stability stable
     */
    get resource(): string | undefined;
    /**
     * @stability stable
     */
    set resource(value: string | undefined);
    /**
     * @stability stable
     */
    resetResource(): void;
    /**
     * @stability stable
     */
    get resourceInput(): string | undefined;
    private _rowType?;
    /**
     * @stability stable
     */
    get rowType(): string;
    /**
     * @stability stable
     */
    set rowType(value: string);
    /**
     * @stability stable
     */
    get rowTypeInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _columns?;
    /**
     * @stability stable
     */
    get columns(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQueryColumns[] | undefined;
    /**
     * @stability stable
     */
    set columns(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQueryColumns[] | undefined);
    /**
     * @stability stable
     */
    resetColumns(): void;
    /**
     * @stability stable
     */
    get columnsInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQueryColumns[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestConditionalFormats {
    /**
     * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#comparator Dashboard#comparator}
     *
     * @stability stable
     */
    readonly comparator: string;
    /**
     * The color palette to apply to the background, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_bg_color Dashboard#custom_bg_color}
     *
     * @stability stable
     */
    readonly customBgColor?: string;
    /**
     * The color palette to apply to the foreground, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_fg_color Dashboard#custom_fg_color}
     *
     * @stability stable
     */
    readonly customFgColor?: string;
    /**
     * Setting this to True hides values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#hide_value Dashboard#hide_value}
     *
     * @stability stable
     */
    readonly hideValue?: boolean | cdktf.IResolvable;
    /**
     * Displays an image as the background.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#image_url Dashboard#image_url}
     *
     * @stability stable
     */
    readonly imageUrl?: string;
    /**
     * The metric from the request to correlate with this conditional format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * The color palette to apply.
     *
     * Valid values are `blue`, `custom_bg`, `custom_image`, `custom_text`, `gray_on_white`, `grey`, `green`, `orange`, `red`, `red_on_white`, `white_on_gray`, `white_on_green`, `green_on_white`, `white_on_red`, `white_on_yellow`, `yellow_on_white`, `black_on_light_yellow`, `black_on_light_green`, `black_on_light_red`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette: string;
    /**
     * Defines the displayed timeframe.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#timeframe Dashboard#timeframe}
     *
     * @stability stable
     */
    readonly timeframe?: string;
    /**
     * A value for the comparator.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#value Dashboard#value}
     *
     * @stability stable
     */
    readonly value: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormulaConditionalFormats {
    /**
     * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#comparator Dashboard#comparator}
     *
     * @stability stable
     */
    readonly comparator: string;
    /**
     * The color palette to apply to the background, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_bg_color Dashboard#custom_bg_color}
     *
     * @stability stable
     */
    readonly customBgColor?: string;
    /**
     * The color palette to apply to the foreground, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_fg_color Dashboard#custom_fg_color}
     *
     * @stability stable
     */
    readonly customFgColor?: string;
    /**
     * Setting this to True hides values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#hide_value Dashboard#hide_value}
     *
     * @stability stable
     */
    readonly hideValue?: boolean | cdktf.IResolvable;
    /**
     * Displays an image as the background.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#image_url Dashboard#image_url}
     *
     * @stability stable
     */
    readonly imageUrl?: string;
    /**
     * The metric from the request to correlate with this conditional format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * The color palette to apply.
     *
     * Valid values are `blue`, `custom_bg`, `custom_image`, `custom_text`, `gray_on_white`, `grey`, `green`, `orange`, `red`, `red_on_white`, `white_on_gray`, `white_on_green`, `green_on_white`, `white_on_red`, `white_on_yellow`, `yellow_on_white`, `black_on_light_yellow`, `black_on_light_green`, `black_on_light_red`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette: string;
    /**
     * Defines the displayed timeframe.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#timeframe Dashboard#timeframe}
     *
     * @stability stable
     */
    readonly timeframe?: string;
    /**
     * A value for the comparator.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#value Dashboard#value}
     *
     * @stability stable
     */
    readonly value: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormulaLimit {
    /**
     * The number of results to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#count Dashboard#count}
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * The direction of the sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormulaLimitOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number | undefined;
    /**
     * @stability stable
     */
    set count(value: number | undefined);
    /**
     * @stability stable
     */
    resetCount(): void;
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string | undefined;
    /**
     * @stability stable
     */
    set order(value: string | undefined);
    /**
     * @stability stable
     */
    resetOrder(): void;
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormula {
    /**
     * An expression alias.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#alias Dashboard#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * A list of display modes for each table cell. Valid values are `number`, `bar`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#cell_display_mode Dashboard#cell_display_mode}
     *
     * @stability stable
     */
    readonly cellDisplayMode?: string;
    /**
     * A string expression built from queries, formulas, and functions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#formula_expression Dashboard#formula_expression}
     *
     * @stability stable
     */
    readonly formulaExpression: string;
    /**
     * conditional_formats block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#conditional_formats Dashboard#conditional_formats}
     *
     * @stability stable
     */
    readonly conditionalFormats?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormulaConditionalFormats[];
    /**
     * limit block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormulaLimit;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestProcessQuery {
    /**
     * A list of processes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#filter_by Dashboard#filter_by}
     *
     * @stability stable
     */
    readonly filterBy?: string[];
    /**
     * The max number of items in the filter list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Your chosen metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Your chosen search term.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_by Dashboard#search_by}
     *
     * @stability stable
     */
    readonly searchBy?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestProcessQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _filterBy?;
    /**
     * @stability stable
     */
    get filterBy(): string[] | undefined;
    /**
     * @stability stable
     */
    set filterBy(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetFilterBy(): void;
    /**
     * @stability stable
     */
    get filterByInput(): string[] | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number | undefined;
    /**
     * @stability stable
     */
    set limit(value: number | undefined);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _searchBy?;
    /**
     * @stability stable
     */
    get searchBy(): string | undefined;
    /**
     * @stability stable
     */
    set searchBy(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchBy(): void;
    /**
     * @stability stable
     */
    get searchByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQuery {
    /**
     * The data source for APM Dependency Stats queries. Valid values are `apm_dependency_stats`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * APM Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * Determines whether stats for upstream or downstream dependencies should be queried.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#is_upstream Dashboard#is_upstream}
     *
     * @stability stable
     */
    readonly isUpstream?: boolean | cdktf.IResolvable;
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of operation on service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#operation_name Dashboard#operation_name}
     *
     * @stability stable
     */
    readonly operationName: string;
    /**
     * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#primary_tag_name Dashboard#primary_tag_name}
     *
     * @stability stable
     */
    readonly primaryTagName?: string;
    /**
     * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#primary_tag_value Dashboard#primary_tag_value}
     *
     * @stability stable
     */
    readonly primaryTagValue?: string;
    /**
     * APM resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#resource_name Dashboard#resource_name}
     *
     * @stability stable
     */
    readonly resourceName: string;
    /**
     * APM service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * APM statistic. Valid values are `avg_duration`, `avg_root_duration`, `avg_spans_per_trace`, `error_rate`, `pct_exec_time`, `pct_of_traces`, `total_traces_count`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#stat Dashboard#stat}
     *
     * @stability stable
     */
    readonly stat: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _isUpstream?;
    /**
     * @stability stable
     */
    get isUpstream(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isUpstream(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsUpstream(): void;
    /**
     * @stability stable
     */
    get isUpstreamInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationName?;
    /**
     * @stability stable
     */
    get operationName(): string;
    /**
     * @stability stable
     */
    set operationName(value: string);
    /**
     * @stability stable
     */
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    /**
     * @stability stable
     */
    get primaryTagName(): string | undefined;
    /**
     * @stability stable
     */
    set primaryTagName(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrimaryTagName(): void;
    /**
     * @stability stable
     */
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    /**
     * @stability stable
     */
    get primaryTagValue(): string | undefined;
    /**
     * @stability stable
     */
    set primaryTagValue(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrimaryTagValue(): void;
    /**
     * @stability stable
     */
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string;
    /**
     * @stability stable
     */
    set resourceName(value: string);
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _stat?;
    /**
     * @stability stable
     */
    get stat(): string;
    /**
     * @stability stable
     */
    set stat(value: string);
    /**
     * @stability stable
     */
    get statInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmResourceStatsQuery {
    /**
     * The data source for APM Resource Stats queries. Valid values are `apm_resource_stats`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * APM Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * Array of fields to group results by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: string[];
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of operation on service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#operation_name Dashboard#operation_name}
     *
     * @stability stable
     */
    readonly operationName?: string;
    /**
     * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#primary_tag_name Dashboard#primary_tag_name}
     *
     * @stability stable
     */
    readonly primaryTagName?: string;
    /**
     * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#primary_tag_value Dashboard#primary_tag_value}
     *
     * @stability stable
     */
    readonly primaryTagValue?: string;
    /**
     * APM resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#resource_name Dashboard#resource_name}
     *
     * @stability stable
     */
    readonly resourceName?: string;
    /**
     * APM service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * APM statistic. Valid values are `errors`, `error_rate`, `hits`, `latency_avg`, `latency_max`, `latency_p50`, `latency_p75`, `latency_p90`, `latency_p95`, `latency_p99`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#stat Dashboard#stat}
     *
     * @stability stable
     */
    readonly stat: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmResourceStatsQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): string[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationName?;
    /**
     * @stability stable
     */
    get operationName(): string | undefined;
    /**
     * @stability stable
     */
    set operationName(value: string | undefined);
    /**
     * @stability stable
     */
    resetOperationName(): void;
    /**
     * @stability stable
     */
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    /**
     * @stability stable
     */
    get primaryTagName(): string | undefined;
    /**
     * @stability stable
     */
    set primaryTagName(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrimaryTagName(): void;
    /**
     * @stability stable
     */
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    /**
     * @stability stable
     */
    get primaryTagValue(): string | undefined;
    /**
     * @stability stable
     */
    set primaryTagValue(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrimaryTagValue(): void;
    /**
     * @stability stable
     */
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string | undefined;
    /**
     * @stability stable
     */
    set resourceName(value: string | undefined);
    /**
     * @stability stable
     */
    resetResourceName(): void;
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _stat?;
    /**
     * @stability stable
     */
    get stat(): string;
    /**
     * @stability stable
     */
    set stat(value: string);
    /**
     * @stability stable
     */
    get statInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryCompute {
    /**
     * The aggregation methods for event platform queries.
     *
     * Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * A time interval in milliseconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
    /**
     * The measurable attribute to compute.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySort {
    /**
     * The aggregation methods for the event platform queries.
     *
     * Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The metric used for sorting group by results.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * Direction of sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySortOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string | undefined;
    /**
     * @stability stable
     */
    set metric(value: string | undefined);
    /**
     * @stability stable
     */
    resetMetric(): void;
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string | undefined;
    /**
     * @stability stable
     */
    set order(value: string | undefined);
    /**
     * @stability stable
     */
    resetOrder(): void;
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBy {
    /**
     * The event facet.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet: string;
    /**
     * The number of groups to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBySort;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuerySearch {
    /**
     * The events search string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuerySearchOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuery {
    /**
     * The data source for event platform-based queries. Valid values are `logs`, `spans`, `network`, `rum`, `security_signals`, `profiles`, `audit`, `events`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * An array of index names to query in the stream.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#indexes Dashboard#indexes}
     *
     * @stability stable
     */
    readonly indexes?: string[];
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute Dashboard#compute}
     *
     * @stability stable
     */
    readonly compute: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryCompute[];
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBy[];
    /**
     * search block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search Dashboard#search}
     *
     * @stability stable
     */
    readonly search?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuerySearch;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _indexes?;
    /**
     * @stability stable
     */
    get indexes(): string[] | undefined;
    /**
     * @stability stable
     */
    set indexes(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetIndexes(): void;
    /**
     * @stability stable
     */
    get indexesInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _compute?;
    /**
     * @stability stable
     */
    get compute(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryCompute[];
    /**
     * @stability stable
     */
    set compute(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryCompute[]);
    /**
     * @stability stable
     */
    get computeInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryCompute[] | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQueryGroupBy[] | undefined;
    private _search?;
    private __searchOutput;
    /**
     * @stability stable
     */
    get search(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuerySearchOutputReference;
    /**
     * @stability stable
     */
    putSearch(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuerySearch | undefined): void;
    /**
     * @stability stable
     */
    resetSearch(): void;
    /**
     * @stability stable
     */
    get searchInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuerySearch | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryMetricQuery {
    /**
     * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The data source for metrics queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource?: string;
    /**
     * The name of the query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The metrics query definition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryMetricQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregator?;
    /**
     * @stability stable
     */
    get aggregator(): string | undefined;
    /**
     * @stability stable
     */
    set aggregator(value: string | undefined);
    /**
     * @stability stable
     */
    resetAggregator(): void;
    /**
     * @stability stable
     */
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string | undefined;
    /**
     * @stability stable
     */
    set dataSource(value: string | undefined);
    /**
     * @stability stable
     */
    resetDataSource(): void;
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryProcessQuery {
    /**
     * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The data source for process queries. Valid values are `process`, `container`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * Whether to normalize the CPU percentages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#is_normalized_cpu Dashboard#is_normalized_cpu}
     *
     * @stability stable
     */
    readonly isNormalizedCpu?: boolean | cdktf.IResolvable;
    /**
     * The number of hits to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * The process metric name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The direction of the sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: string;
    /**
     * An array of tags to filter by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#tag_filters Dashboard#tag_filters}
     *
     * @stability stable
     */
    readonly tagFilters?: string[];
    /**
     * The text to use as a filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#text_filter Dashboard#text_filter}
     *
     * @stability stable
     */
    readonly textFilter?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryProcessQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregator?;
    /**
     * @stability stable
     */
    get aggregator(): string | undefined;
    /**
     * @stability stable
     */
    set aggregator(value: string | undefined);
    /**
     * @stability stable
     */
    resetAggregator(): void;
    /**
     * @stability stable
     */
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _isNormalizedCpu?;
    /**
     * @stability stable
     */
    get isNormalizedCpu(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isNormalizedCpu(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsNormalizedCpu(): void;
    /**
     * @stability stable
     */
    get isNormalizedCpuInput(): boolean | cdktf.IResolvable | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number | undefined;
    /**
     * @stability stable
     */
    set limit(value: number | undefined);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sort?;
    /**
     * @stability stable
     */
    get sort(): string | undefined;
    /**
     * @stability stable
     */
    set sort(value: string | undefined);
    /**
     * @stability stable
     */
    resetSort(): void;
    /**
     * @stability stable
     */
    get sortInput(): string | undefined;
    private _tagFilters?;
    /**
     * @stability stable
     */
    get tagFilters(): string[] | undefined;
    /**
     * @stability stable
     */
    set tagFilters(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetTagFilters(): void;
    /**
     * @stability stable
     */
    get tagFiltersInput(): string[] | undefined;
    private _textFilter?;
    /**
     * @stability stable
     */
    get textFilter(): string | undefined;
    /**
     * @stability stable
     */
    set textFilter(value: string | undefined);
    /**
     * @stability stable
     */
    resetTextFilter(): void;
    /**
     * @stability stable
     */
    get textFilterInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQuery {
    /**
     * apm_dependency_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
     *
     * @stability stable
     */
    readonly apmDependencyStatsQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmDependencyStatsQuery;
    /**
     * apm_resource_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_resource_stats_query Dashboard#apm_resource_stats_query}
     *
     * @stability stable
     */
    readonly apmResourceStatsQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryApmResourceStatsQuery;
    /**
     * event_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#event_query Dashboard#event_query}
     *
     * @stability stable
     */
    readonly eventQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryEventQuery;
    /**
     * metric_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric_query Dashboard#metric_query}
     *
     * @stability stable
     */
    readonly metricQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryMetricQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQueryProcessQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequest {
    /**
     * The aggregator to use for time aggregation. Valid values are `avg`, `last`, `max`, `min`, `sum`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The alias for the column name (defaults to metric name).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#alias Dashboard#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * A list of display modes for each table cell.
     *
     * List items one of `number`, `bar`. Valid values are `number`, `bar`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#cell_display_mode Dashboard#cell_display_mode}
     *
     * @stability stable
     */
    readonly cellDisplayMode?: string[];
    /**
     * The number of lines to show in the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * The sort order for the rows. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * apm_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_query Dashboard#apm_query}
     *
     * @stability stable
     */
    readonly apmQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmQuery;
    /**
     * apm_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_stats_query Dashboard#apm_stats_query}
     *
     * @stability stable
     */
    readonly apmStatsQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestApmStatsQuery;
    /**
     * conditional_formats block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#conditional_formats Dashboard#conditional_formats}
     *
     * @stability stable
     */
    readonly conditionalFormats?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestConditionalFormats[];
    /**
     * formula block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#formula Dashboard#formula}
     *
     * @stability stable
     */
    readonly formula?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestFormula[];
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestLogQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestProcessQuery;
    /**
     * query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestQuery[];
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestRumQuery;
    /**
     * security_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#security_query Dashboard#security_query}
     *
     * @stability stable
     */
    readonly securityQuery?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequestSecurityQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryTableDefinition {
    /**
     * Controls the display of the search bar. Valid values are `always`, `never`, `auto`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#has_search_bar Dashboard#has_search_bar}
     *
     * @stability stable
     */
    readonly hasSearchBar?: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * custom_link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_link Dashboard#custom_link}
     *
     * @stability stable
     */
    readonly customLink?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionCustomLink[];
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequest[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _hasSearchBar?;
    /**
     * @stability stable
     */
    get hasSearchBar(): string | undefined;
    /**
     * @stability stable
     */
    set hasSearchBar(value: string | undefined);
    /**
     * @stability stable
     */
    resetHasSearchBar(): void;
    /**
     * @stability stable
     */
    get hasSearchBarInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string | undefined;
    /**
     * @stability stable
     */
    set liveSpan(value: string | undefined);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _customLink?;
    /**
     * @stability stable
     */
    get customLink(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionCustomLink[] | undefined;
    /**
     * @stability stable
     */
    set customLink(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionCustomLink[] | undefined);
    /**
     * @stability stable
     */
    resetCustomLink(): void;
    /**
     * @stability stable
     */
    get customLinkInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionCustomLink[] | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequest[] | undefined;
    /**
     * @stability stable
     */
    set request(value: DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequest[] | undefined);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): DashboardWidgetGroupDefinitionWidgetQueryTableDefinitionRequest[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionCustomLink {
    /**
     * The flag for toggling context menu link visibility.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#is_hidden Dashboard#is_hidden}
     *
     * @stability stable
     */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
     * The label for the custom link URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * The URL of the custom link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#link Dashboard#link}
     *
     * @stability stable
     */
    readonly link?: string;
    /**
     * The label id that refers to a context menu link item.
     *
     * When override_label is provided, the client request omits the label field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#override_label Dashboard#override_label}
     *
     * @stability stable
     */
    readonly overrideLabel?: string;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestConditionalFormats {
    /**
     * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#comparator Dashboard#comparator}
     *
     * @stability stable
     */
    readonly comparator: string;
    /**
     * The color palette to apply to the background, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_bg_color Dashboard#custom_bg_color}
     *
     * @stability stable
     */
    readonly customBgColor?: string;
    /**
     * The color palette to apply to the foreground, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_fg_color Dashboard#custom_fg_color}
     *
     * @stability stable
     */
    readonly customFgColor?: string;
    /**
     * Setting this to True hides values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#hide_value Dashboard#hide_value}
     *
     * @stability stable
     */
    readonly hideValue?: boolean | cdktf.IResolvable;
    /**
     * Displays an image as the background.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#image_url Dashboard#image_url}
     *
     * @stability stable
     */
    readonly imageUrl?: string;
    /**
     * The metric from the request to correlate with this conditional format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * The color palette to apply.
     *
     * Valid values are `blue`, `custom_bg`, `custom_image`, `custom_text`, `gray_on_white`, `grey`, `green`, `orange`, `red`, `red_on_white`, `white_on_gray`, `white_on_green`, `green_on_white`, `white_on_red`, `white_on_yellow`, `yellow_on_white`, `black_on_light_yellow`, `black_on_light_green`, `black_on_light_red`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette: string;
    /**
     * Defines the displayed timeframe.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#timeframe Dashboard#timeframe}
     *
     * @stability stable
     */
    readonly timeframe?: string;
    /**
     * A value for the comparator.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#value Dashboard#value}
     *
     * @stability stable
     */
    readonly value: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestFormulaConditionalFormats {
    /**
     * The comparator to use. Valid values are `>`, `>=`, `<`, `<=`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#comparator Dashboard#comparator}
     *
     * @stability stable
     */
    readonly comparator: string;
    /**
     * The color palette to apply to the background, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_bg_color Dashboard#custom_bg_color}
     *
     * @stability stable
     */
    readonly customBgColor?: string;
    /**
     * The color palette to apply to the foreground, same values available as palette.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_fg_color Dashboard#custom_fg_color}
     *
     * @stability stable
     */
    readonly customFgColor?: string;
    /**
     * Setting this to True hides values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#hide_value Dashboard#hide_value}
     *
     * @stability stable
     */
    readonly hideValue?: boolean | cdktf.IResolvable;
    /**
     * Displays an image as the background.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#image_url Dashboard#image_url}
     *
     * @stability stable
     */
    readonly imageUrl?: string;
    /**
     * The metric from the request to correlate with this conditional format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * The color palette to apply.
     *
     * Valid values are `blue`, `custom_bg`, `custom_image`, `custom_text`, `gray_on_white`, `grey`, `green`, `orange`, `red`, `red_on_white`, `white_on_gray`, `white_on_green`, `green_on_white`, `white_on_red`, `white_on_yellow`, `yellow_on_white`, `black_on_light_yellow`, `black_on_light_green`, `black_on_light_red`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#palette Dashboard#palette}
     *
     * @stability stable
     */
    readonly palette: string;
    /**
     * Defines the displayed timeframe.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#timeframe Dashboard#timeframe}
     *
     * @stability stable
     */
    readonly timeframe?: string;
    /**
     * A value for the comparator.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#value Dashboard#value}
     *
     * @stability stable
     */
    readonly value: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestFormulaLimit {
    /**
     * The number of results to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#count Dashboard#count}
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * The direction of the sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestFormulaLimitOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number | undefined;
    /**
     * @stability stable
     */
    set count(value: number | undefined);
    /**
     * @stability stable
     */
    resetCount(): void;
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string | undefined;
    /**
     * @stability stable
     */
    set order(value: string | undefined);
    /**
     * @stability stable
     */
    resetOrder(): void;
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestFormula {
    /**
     * An expression alias.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#alias Dashboard#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * A list of display modes for each table cell. Valid values are `number`, `bar`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#cell_display_mode Dashboard#cell_display_mode}
     *
     * @stability stable
     */
    readonly cellDisplayMode?: string;
    /**
     * A string expression built from queries, formulas, and functions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#formula_expression Dashboard#formula_expression}
     *
     * @stability stable
     */
    readonly formulaExpression: string;
    /**
     * conditional_formats block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#conditional_formats Dashboard#conditional_formats}
     *
     * @stability stable
     */
    readonly conditionalFormats?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestFormulaConditionalFormats[];
    /**
     * limit block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestFormulaLimit;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestProcessQuery {
    /**
     * A list of processes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#filter_by Dashboard#filter_by}
     *
     * @stability stable
     */
    readonly filterBy?: string[];
    /**
     * The max number of items in the filter list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Your chosen metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Your chosen search term.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_by Dashboard#search_by}
     *
     * @stability stable
     */
    readonly searchBy?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestProcessQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _filterBy?;
    /**
     * @stability stable
     */
    get filterBy(): string[] | undefined;
    /**
     * @stability stable
     */
    set filterBy(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetFilterBy(): void;
    /**
     * @stability stable
     */
    get filterByInput(): string[] | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number | undefined;
    /**
     * @stability stable
     */
    set limit(value: number | undefined);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _searchBy?;
    /**
     * @stability stable
     */
    get searchBy(): string | undefined;
    /**
     * @stability stable
     */
    set searchBy(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchBy(): void;
    /**
     * @stability stable
     */
    get searchByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryApmDependencyStatsQuery {
    /**
     * The data source for APM Dependency Stats queries. Valid values are `apm_dependency_stats`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * APM Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * Determines whether stats for upstream or downstream dependencies should be queried.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#is_upstream Dashboard#is_upstream}
     *
     * @stability stable
     */
    readonly isUpstream?: boolean | cdktf.IResolvable;
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of operation on service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#operation_name Dashboard#operation_name}
     *
     * @stability stable
     */
    readonly operationName: string;
    /**
     * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#primary_tag_name Dashboard#primary_tag_name}
     *
     * @stability stable
     */
    readonly primaryTagName?: string;
    /**
     * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#primary_tag_value Dashboard#primary_tag_value}
     *
     * @stability stable
     */
    readonly primaryTagValue?: string;
    /**
     * APM resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#resource_name Dashboard#resource_name}
     *
     * @stability stable
     */
    readonly resourceName: string;
    /**
     * APM service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * APM statistic. Valid values are `avg_duration`, `avg_root_duration`, `avg_spans_per_trace`, `error_rate`, `pct_exec_time`, `pct_of_traces`, `total_traces_count`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#stat Dashboard#stat}
     *
     * @stability stable
     */
    readonly stat: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryApmDependencyStatsQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _isUpstream?;
    /**
     * @stability stable
     */
    get isUpstream(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isUpstream(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsUpstream(): void;
    /**
     * @stability stable
     */
    get isUpstreamInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationName?;
    /**
     * @stability stable
     */
    get operationName(): string;
    /**
     * @stability stable
     */
    set operationName(value: string);
    /**
     * @stability stable
     */
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    /**
     * @stability stable
     */
    get primaryTagName(): string | undefined;
    /**
     * @stability stable
     */
    set primaryTagName(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrimaryTagName(): void;
    /**
     * @stability stable
     */
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    /**
     * @stability stable
     */
    get primaryTagValue(): string | undefined;
    /**
     * @stability stable
     */
    set primaryTagValue(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrimaryTagValue(): void;
    /**
     * @stability stable
     */
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string;
    /**
     * @stability stable
     */
    set resourceName(value: string);
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _stat?;
    /**
     * @stability stable
     */
    get stat(): string;
    /**
     * @stability stable
     */
    set stat(value: string);
    /**
     * @stability stable
     */
    get statInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryApmResourceStatsQuery {
    /**
     * The data source for APM Resource Stats queries. Valid values are `apm_resource_stats`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * APM Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#env Dashboard#env}
     *
     * @stability stable
     */
    readonly env: string;
    /**
     * Array of fields to group results by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: string[];
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of operation on service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#operation_name Dashboard#operation_name}
     *
     * @stability stable
     */
    readonly operationName?: string;
    /**
     * The name of the second primary tag used within APM; required when `primary_tag_value` is specified. See https://docs.datadoghq.com/tracing/guide/setting_primary_tags_to_scope/#add-a-second-primary-tag-in-datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#primary_tag_name Dashboard#primary_tag_name}
     *
     * @stability stable
     */
    readonly primaryTagName?: string;
    /**
     * Filter APM data by the second primary tag. `primary_tag_name` must also be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#primary_tag_value Dashboard#primary_tag_value}
     *
     * @stability stable
     */
    readonly primaryTagValue?: string;
    /**
     * APM resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#resource_name Dashboard#resource_name}
     *
     * @stability stable
     */
    readonly resourceName?: string;
    /**
     * APM service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#service Dashboard#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * APM statistic. Valid values are `errors`, `error_rate`, `hits`, `latency_avg`, `latency_max`, `latency_p50`, `latency_p75`, `latency_p90`, `latency_p95`, `latency_p99`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#stat Dashboard#stat}
     *
     * @stability stable
     */
    readonly stat: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryApmResourceStatsQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string;
    /**
     * @stability stable
     */
    set env(value: string);
    /**
     * @stability stable
     */
    get envInput(): string | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): string[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationName?;
    /**
     * @stability stable
     */
    get operationName(): string | undefined;
    /**
     * @stability stable
     */
    set operationName(value: string | undefined);
    /**
     * @stability stable
     */
    resetOperationName(): void;
    /**
     * @stability stable
     */
    get operationNameInput(): string | undefined;
    private _primaryTagName?;
    /**
     * @stability stable
     */
    get primaryTagName(): string | undefined;
    /**
     * @stability stable
     */
    set primaryTagName(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrimaryTagName(): void;
    /**
     * @stability stable
     */
    get primaryTagNameInput(): string | undefined;
    private _primaryTagValue?;
    /**
     * @stability stable
     */
    get primaryTagValue(): string | undefined;
    /**
     * @stability stable
     */
    set primaryTagValue(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrimaryTagValue(): void;
    /**
     * @stability stable
     */
    get primaryTagValueInput(): string | undefined;
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string | undefined;
    /**
     * @stability stable
     */
    set resourceName(value: string | undefined);
    /**
     * @stability stable
     */
    resetResourceName(): void;
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _stat?;
    /**
     * @stability stable
     */
    get stat(): string;
    /**
     * @stability stable
     */
    set stat(value: string);
    /**
     * @stability stable
     */
    get statInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQueryCompute {
    /**
     * The aggregation methods for event platform queries.
     *
     * Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * A time interval in milliseconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
    /**
     * The measurable attribute to compute.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQueryGroupBySort {
    /**
     * The aggregation methods for the event platform queries.
     *
     * Valid values are `count`, `cardinality`, `median`, `pc75`, `pc90`, `pc95`, `pc98`, `pc99`, `sum`, `min`, `max`, `avg`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The metric used for sorting group by results.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * Direction of sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQueryGroupBySortOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string | undefined;
    /**
     * @stability stable
     */
    set metric(value: string | undefined);
    /**
     * @stability stable
     */
    resetMetric(): void;
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string | undefined;
    /**
     * @stability stable
     */
    set order(value: string | undefined);
    /**
     * @stability stable
     */
    resetOrder(): void;
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQueryGroupBy {
    /**
     * The event facet.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet: string;
    /**
     * The number of groups to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQueryGroupBySort;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQuerySearch {
    /**
     * The events search string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQuerySearchOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQuery {
    /**
     * The data source for event platform-based queries. Valid values are `logs`, `spans`, `network`, `rum`, `security_signals`, `profiles`, `audit`, `events`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * An array of index names to query in the stream.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#indexes Dashboard#indexes}
     *
     * @stability stable
     */
    readonly indexes?: string[];
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute Dashboard#compute}
     *
     * @stability stable
     */
    readonly compute: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQueryCompute[];
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQueryGroupBy[];
    /**
     * search block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search Dashboard#search}
     *
     * @stability stable
     */
    readonly search?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQuerySearch;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _indexes?;
    /**
     * @stability stable
     */
    get indexes(): string[] | undefined;
    /**
     * @stability stable
     */
    set indexes(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetIndexes(): void;
    /**
     * @stability stable
     */
    get indexesInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _compute?;
    /**
     * @stability stable
     */
    get compute(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQueryCompute[];
    /**
     * @stability stable
     */
    set compute(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQueryCompute[]);
    /**
     * @stability stable
     */
    get computeInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQueryCompute[] | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQueryGroupBy[] | undefined;
    private _search?;
    private __searchOutput;
    /**
     * @stability stable
     */
    get search(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQuerySearchOutputReference;
    /**
     * @stability stable
     */
    putSearch(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQuerySearch | undefined): void;
    /**
     * @stability stable
     */
    resetSearch(): void;
    /**
     * @stability stable
     */
    get searchInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQuerySearch | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryMetricQuery {
    /**
     * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The data source for metrics queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource?: string;
    /**
     * The name of the query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The metrics query definition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryMetricQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregator?;
    /**
     * @stability stable
     */
    get aggregator(): string | undefined;
    /**
     * @stability stable
     */
    set aggregator(value: string | undefined);
    /**
     * @stability stable
     */
    resetAggregator(): void;
    /**
     * @stability stable
     */
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string | undefined;
    /**
     * @stability stable
     */
    set dataSource(value: string | undefined);
    /**
     * @stability stable
     */
    resetDataSource(): void;
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryProcessQuery {
    /**
     * The aggregation methods available for metrics queries. Valid values are `avg`, `min`, `max`, `sum`, `last`, `area`, `l2norm`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The data source for process queries. Valid values are `process`, `container`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#data_source Dashboard#data_source}
     *
     * @stability stable
     */
    readonly dataSource: string;
    /**
     * Whether to normalize the CPU percentages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#is_normalized_cpu Dashboard#is_normalized_cpu}
     *
     * @stability stable
     */
    readonly isNormalizedCpu?: boolean | cdktf.IResolvable;
    /**
     * The number of hits to return.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * The process metric name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * The name of query for use in formulas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#name Dashboard#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The direction of the sort. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort Dashboard#sort}
     *
     * @stability stable
     */
    readonly sort?: string;
    /**
     * An array of tags to filter by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#tag_filters Dashboard#tag_filters}
     *
     * @stability stable
     */
    readonly tagFilters?: string[];
    /**
     * The text to use as a filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#text_filter Dashboard#text_filter}
     *
     * @stability stable
     */
    readonly textFilter?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryProcessQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregator?;
    /**
     * @stability stable
     */
    get aggregator(): string | undefined;
    /**
     * @stability stable
     */
    set aggregator(value: string | undefined);
    /**
     * @stability stable
     */
    resetAggregator(): void;
    /**
     * @stability stable
     */
    get aggregatorInput(): string | undefined;
    private _dataSource?;
    /**
     * @stability stable
     */
    get dataSource(): string;
    /**
     * @stability stable
     */
    set dataSource(value: string);
    /**
     * @stability stable
     */
    get dataSourceInput(): string | undefined;
    private _isNormalizedCpu?;
    /**
     * @stability stable
     */
    get isNormalizedCpu(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isNormalizedCpu(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsNormalizedCpu(): void;
    /**
     * @stability stable
     */
    get isNormalizedCpuInput(): boolean | cdktf.IResolvable | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number | undefined;
    /**
     * @stability stable
     */
    set limit(value: number | undefined);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sort?;
    /**
     * @stability stable
     */
    get sort(): string | undefined;
    /**
     * @stability stable
     */
    set sort(value: string | undefined);
    /**
     * @stability stable
     */
    resetSort(): void;
    /**
     * @stability stable
     */
    get sortInput(): string | undefined;
    private _tagFilters?;
    /**
     * @stability stable
     */
    get tagFilters(): string[] | undefined;
    /**
     * @stability stable
     */
    set tagFilters(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetTagFilters(): void;
    /**
     * @stability stable
     */
    get tagFiltersInput(): string[] | undefined;
    private _textFilter?;
    /**
     * @stability stable
     */
    get textFilter(): string | undefined;
    /**
     * @stability stable
     */
    set textFilter(value: string | undefined);
    /**
     * @stability stable
     */
    resetTextFilter(): void;
    /**
     * @stability stable
     */
    get textFilterInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQuery {
    /**
     * apm_dependency_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_dependency_stats_query Dashboard#apm_dependency_stats_query}
     *
     * @stability stable
     */
    readonly apmDependencyStatsQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryApmDependencyStatsQuery;
    /**
     * apm_resource_stats_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_resource_stats_query Dashboard#apm_resource_stats_query}
     *
     * @stability stable
     */
    readonly apmResourceStatsQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryApmResourceStatsQuery;
    /**
     * event_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#event_query Dashboard#event_query}
     *
     * @stability stable
     */
    readonly eventQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryEventQuery;
    /**
     * metric_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric_query Dashboard#metric_query}
     *
     * @stability stable
     */
    readonly metricQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryMetricQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQueryProcessQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequest {
    /**
     * The aggregator to use for time aggregation. Valid values are `avg`, `last`, `max`, `min`, `sum`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * apm_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_query Dashboard#apm_query}
     *
     * @stability stable
     */
    readonly apmQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestApmQuery;
    /**
     * audit_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#audit_query Dashboard#audit_query}
     *
     * @stability stable
     */
    readonly auditQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestAuditQuery;
    /**
     * conditional_formats block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#conditional_formats Dashboard#conditional_formats}
     *
     * @stability stable
     */
    readonly conditionalFormats?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestConditionalFormats[];
    /**
     * formula block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#formula Dashboard#formula}
     *
     * @stability stable
     */
    readonly formula?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestFormula[];
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestLogQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestProcessQuery;
    /**
     * query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#query Dashboard#query}
     *
     * @stability stable
     */
    readonly query?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestQuery[];
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestRumQuery;
    /**
     * security_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#security_query Dashboard#security_query}
     *
     * @stability stable
     */
    readonly securityQuery?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequestSecurityQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetQueryValueDefinition {
    /**
     * A Boolean indicating whether to automatically scale the tile.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#autoscale Dashboard#autoscale}
     *
     * @stability stable
     */
    readonly autoscale?: boolean | cdktf.IResolvable;
    /**
     * The unit for the value displayed in the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_unit Dashboard#custom_unit}
     *
     * @stability stable
     */
    readonly customUnit?: string;
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The precision to use when displaying the tile.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#precision Dashboard#precision}
     *
     * @stability stable
     */
    readonly precision?: number;
    /**
     * The alignment of the widget's text. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#text_align Dashboard#text_align}
     *
     * @stability stable
     */
    readonly textAlign?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * custom_link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_link Dashboard#custom_link}
     *
     * @stability stable
     */
    readonly customLink?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionCustomLink[];
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequest[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _autoscale?;
    /**
     * @stability stable
     */
    get autoscale(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set autoscale(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAutoscale(): void;
    /**
     * @stability stable
     */
    get autoscaleInput(): boolean | cdktf.IResolvable | undefined;
    private _customUnit?;
    /**
     * @stability stable
     */
    get customUnit(): string | undefined;
    /**
     * @stability stable
     */
    set customUnit(value: string | undefined);
    /**
     * @stability stable
     */
    resetCustomUnit(): void;
    /**
     * @stability stable
     */
    get customUnitInput(): string | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string | undefined;
    /**
     * @stability stable
     */
    set liveSpan(value: string | undefined);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _precision?;
    /**
     * @stability stable
     */
    get precision(): number | undefined;
    /**
     * @stability stable
     */
    set precision(value: number | undefined);
    /**
     * @stability stable
     */
    resetPrecision(): void;
    /**
     * @stability stable
     */
    get precisionInput(): number | undefined;
    private _textAlign?;
    /**
     * @stability stable
     */
    get textAlign(): string | undefined;
    /**
     * @stability stable
     */
    set textAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTextAlign(): void;
    /**
     * @stability stable
     */
    get textAlignInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _customLink?;
    /**
     * @stability stable
     */
    get customLink(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionCustomLink[] | undefined;
    /**
     * @stability stable
     */
    set customLink(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionCustomLink[] | undefined);
    /**
     * @stability stable
     */
    resetCustomLink(): void;
    /**
     * @stability stable
     */
    get customLinkInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionCustomLink[] | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequest[] | undefined;
    /**
     * @stability stable
     */
    set request(value: DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequest[] | undefined);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): DashboardWidgetGroupDefinitionWidgetQueryValueDefinitionRequest[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionCustomLink {
    /**
     * The flag for toggling context menu link visibility.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#is_hidden Dashboard#is_hidden}
     *
     * @stability stable
     */
    readonly isHidden?: boolean | cdktf.IResolvable;
    /**
     * The label for the custom link URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * The URL of the custom link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#link Dashboard#link}
     *
     * @stability stable
     */
    readonly link?: string;
    /**
     * The label id that refers to a context menu link item.
     *
     * When override_label is provided, the client request omits the label field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#override_label Dashboard#override_label}
     *
     * @stability stable
     */
    readonly overrideLabel?: string;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXProcessQuery {
    /**
     * A list of processes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#filter_by Dashboard#filter_by}
     *
     * @stability stable
     */
    readonly filterBy?: string[];
    /**
     * The max number of items in the filter list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Your chosen metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Your chosen search term.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_by Dashboard#search_by}
     *
     * @stability stable
     */
    readonly searchBy?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXProcessQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _filterBy?;
    /**
     * @stability stable
     */
    get filterBy(): string[] | undefined;
    /**
     * @stability stable
     */
    set filterBy(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetFilterBy(): void;
    /**
     * @stability stable
     */
    get filterByInput(): string[] | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number | undefined;
    /**
     * @stability stable
     */
    set limit(value: number | undefined);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _searchBy?;
    /**
     * @stability stable
     */
    get searchBy(): string | undefined;
    /**
     * @stability stable
     */
    set searchBy(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchBy(): void;
    /**
     * @stability stable
     */
    get searchByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestX {
    /**
     * Aggregator used for the request. Valid values are `avg`, `last`, `max`, `min`, `sum`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * apm_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_query Dashboard#apm_query}
     *
     * @stability stable
     */
    readonly apmQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXApmQuery;
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXLogQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXProcessQuery;
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXRumQuery;
    /**
     * security_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#security_query Dashboard#security_query}
     *
     * @stability stable
     */
    readonly securityQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestXSecurityQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYProcessQuery {
    /**
     * A list of processes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#filter_by Dashboard#filter_by}
     *
     * @stability stable
     */
    readonly filterBy?: string[];
    /**
     * The max number of items in the filter list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * Your chosen metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#metric Dashboard#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Your chosen search term.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_by Dashboard#search_by}
     *
     * @stability stable
     */
    readonly searchBy?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYProcessQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _filterBy?;
    /**
     * @stability stable
     */
    get filterBy(): string[] | undefined;
    /**
     * @stability stable
     */
    set filterBy(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetFilterBy(): void;
    /**
     * @stability stable
     */
    get filterByInput(): string[] | undefined;
    private _limit?;
    /**
     * @stability stable
     */
    get limit(): number | undefined;
    /**
     * @stability stable
     */
    set limit(value: number | undefined);
    /**
     * @stability stable
     */
    resetLimit(): void;
    /**
     * @stability stable
     */
    get limitInput(): number | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _searchBy?;
    /**
     * @stability stable
     */
    get searchBy(): string | undefined;
    /**
     * @stability stable
     */
    set searchBy(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchBy(): void;
    /**
     * @stability stable
     */
    get searchByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryComputeQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryComputeQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryGroupBySortQuery {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Widget sorting methods. Valid values are `asc`, `desc`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#order Dashboard#order}
     *
     * @stability stable
     */
    readonly order: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryGroupBySortQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregation?;
    /**
     * @stability stable
     */
    get aggregation(): string;
    /**
     * @stability stable
     */
    set aggregation(value: string);
    /**
     * @stability stable
     */
    get aggregationInput(): string | undefined;
    private _facet?;
    /**
     * @stability stable
     */
    get facet(): string | undefined;
    /**
     * @stability stable
     */
    set facet(value: string | undefined);
    /**
     * @stability stable
     */
    resetFacet(): void;
    /**
     * @stability stable
     */
    get facetInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): string;
    /**
     * @stability stable
     */
    set order(value: string);
    /**
     * @stability stable
     */
    get orderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryGroupBy {
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * The maximum number of items in the group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#limit Dashboard#limit}
     *
     * @stability stable
     */
    readonly limit?: number;
    /**
     * sort_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#sort_query Dashboard#sort_query}
     *
     * @stability stable
     */
    readonly sortQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryGroupBySortQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryMultiCompute {
    /**
     * The aggregation method.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregation Dashboard#aggregation}
     *
     * @stability stable
     */
    readonly aggregation: string;
    /**
     * The facet name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#facet Dashboard#facet}
     *
     * @stability stable
     */
    readonly facet?: string;
    /**
     * Define the time interval in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#interval Dashboard#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQuery {
    /**
     * The name of the index to query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#index Dashboard#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * The search query to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#search_query Dashboard#search_query}
     *
     * @stability stable
     */
    readonly searchQuery?: string;
    /**
     * compute_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#compute_query Dashboard#compute_query}
     *
     * @stability stable
     */
    readonly computeQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryComputeQuery;
    /**
     * group_by block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#group_by Dashboard#group_by}
     *
     * @stability stable
     */
    readonly groupBy?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryGroupBy[];
    /**
     * multi_compute block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#multi_compute Dashboard#multi_compute}
     *
     * @stability stable
     */
    readonly multiCompute?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryMultiCompute[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _searchQuery?;
    /**
     * @stability stable
     */
    get searchQuery(): string | undefined;
    /**
     * @stability stable
     */
    set searchQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetSearchQuery(): void;
    /**
     * @stability stable
     */
    get searchQueryInput(): string | undefined;
    private _computeQuery?;
    private __computeQueryOutput;
    /**
     * @stability stable
     */
    get computeQuery(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryComputeQueryOutputReference;
    /**
     * @stability stable
     */
    putComputeQuery(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryComputeQuery | undefined): void;
    /**
     * @stability stable
     */
    resetComputeQuery(): void;
    /**
     * @stability stable
     */
    get computeQueryInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryComputeQuery | undefined;
    private _groupBy?;
    /**
     * @stability stable
     */
    get groupBy(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryGroupBy[] | undefined;
    /**
     * @stability stable
     */
    set groupBy(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryGroupBy[] | undefined);
    /**
     * @stability stable
     */
    resetGroupBy(): void;
    /**
     * @stability stable
     */
    get groupByInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryGroupBy[] | undefined;
    private _multiCompute?;
    /**
     * @stability stable
     */
    get multiCompute(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryMultiCompute[] | undefined;
    /**
     * @stability stable
     */
    set multiCompute(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryMultiCompute[] | undefined);
    /**
     * @stability stable
     */
    resetMultiCompute(): void;
    /**
     * @stability stable
     */
    get multiComputeInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQueryMultiCompute[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestY {
    /**
     * Aggregator used for the request. Valid values are `avg`, `last`, `max`, `min`, `sum`, `percentile`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#aggregator Dashboard#aggregator}
     *
     * @stability stable
     */
    readonly aggregator?: string;
    /**
     * The metric query to use for this widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#q Dashboard#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * apm_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#apm_query Dashboard#apm_query}
     *
     * @stability stable
     */
    readonly apmQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYApmQuery;
    /**
     * log_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#log_query Dashboard#log_query}
     *
     * @stability stable
     */
    readonly logQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYLogQuery;
    /**
     * process_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#process_query Dashboard#process_query}
     *
     * @stability stable
     */
    readonly processQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYProcessQuery;
    /**
     * rum_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#rum_query Dashboard#rum_query}
     *
     * @stability stable
     */
    readonly rumQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYRumQuery;
    /**
     * security_query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#security_query Dashboard#security_query}
     *
     * @stability stable
     */
    readonly securityQuery?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestYSecurityQuery;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequest {
    /**
     * x block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#x Dashboard#x}
     *
     * @stability stable
     */
    readonly x?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestX[];
    /**
     * y block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#y Dashboard#y}
     *
     * @stability stable
     */
    readonly y?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestY[];
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _x?;
    /**
     * @stability stable
     */
    get x(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestX[] | undefined;
    /**
     * @stability stable
     */
    set x(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestX[] | undefined);
    /**
     * @stability stable
     */
    resetX(): void;
    /**
     * @stability stable
     */
    get xInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestX[] | undefined;
    private _y?;
    /**
     * @stability stable
     */
    get y(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestY[] | undefined;
    /**
     * @stability stable
     */
    set y(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestY[] | undefined);
    /**
     * @stability stable
     */
    resetY(): void;
    /**
     * @stability stable
     */
    get yInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestY[] | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionXaxis {
    /**
     * Always include zero or fit the axis to the data range.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#include_zero Dashboard#include_zero}
     *
     * @stability stable
     */
    readonly includeZero?: boolean | cdktf.IResolvable;
    /**
     * The label of the axis to display on the graph.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * Specify the maximum value to show on the Y-axis.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#max Dashboard#max}
     *
     * @stability stable
     */
    readonly max?: string;
    /**
     * Specify the minimum value to show on the Y-axis.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#min Dashboard#min}
     *
     * @stability stable
     */
    readonly min?: string;
    /**
     * Specify the scale type, options: `linear`, `log`, `pow`, `sqrt`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#scale Dashboard#scale}
     *
     * @stability stable
     */
    readonly scale?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionXaxisOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _includeZero?;
    /**
     * @stability stable
     */
    get includeZero(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set includeZero(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIncludeZero(): void;
    /**
     * @stability stable
     */
    get includeZeroInput(): boolean | cdktf.IResolvable | undefined;
    private _label?;
    /**
     * @stability stable
     */
    get label(): string | undefined;
    /**
     * @stability stable
     */
    set label(value: string | undefined);
    /**
     * @stability stable
     */
    resetLabel(): void;
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _max?;
    /**
     * @stability stable
     */
    get max(): string | undefined;
    /**
     * @stability stable
     */
    set max(value: string | undefined);
    /**
     * @stability stable
     */
    resetMax(): void;
    /**
     * @stability stable
     */
    get maxInput(): string | undefined;
    private _min?;
    /**
     * @stability stable
     */
    get min(): string | undefined;
    /**
     * @stability stable
     */
    set min(value: string | undefined);
    /**
     * @stability stable
     */
    resetMin(): void;
    /**
     * @stability stable
     */
    get minInput(): string | undefined;
    private _scale?;
    /**
     * @stability stable
     */
    get scale(): string | undefined;
    /**
     * @stability stable
     */
    set scale(value: string | undefined);
    /**
     * @stability stable
     */
    resetScale(): void;
    /**
     * @stability stable
     */
    get scaleInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionYaxis {
    /**
     * Always include zero or fit the axis to the data range.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#include_zero Dashboard#include_zero}
     *
     * @stability stable
     */
    readonly includeZero?: boolean | cdktf.IResolvable;
    /**
     * The label of the axis to display on the graph.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#label Dashboard#label}
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * Specify the maximum value to show on the Y-axis.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#max Dashboard#max}
     *
     * @stability stable
     */
    readonly max?: string;
    /**
     * Specify the minimum value to show on the Y-axis.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#min Dashboard#min}
     *
     * @stability stable
     */
    readonly min?: string;
    /**
     * Specify the scale type, options: `linear`, `log`, `pow`, `sqrt`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#scale Dashboard#scale}
     *
     * @stability stable
     */
    readonly scale?: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionYaxisOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _includeZero?;
    /**
     * @stability stable
     */
    get includeZero(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set includeZero(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIncludeZero(): void;
    /**
     * @stability stable
     */
    get includeZeroInput(): boolean | cdktf.IResolvable | undefined;
    private _label?;
    /**
     * @stability stable
     */
    get label(): string | undefined;
    /**
     * @stability stable
     */
    set label(value: string | undefined);
    /**
     * @stability stable
     */
    resetLabel(): void;
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _max?;
    /**
     * @stability stable
     */
    get max(): string | undefined;
    /**
     * @stability stable
     */
    set max(value: string | undefined);
    /**
     * @stability stable
     */
    resetMax(): void;
    /**
     * @stability stable
     */
    get maxInput(): string | undefined;
    private _min?;
    /**
     * @stability stable
     */
    get min(): string | undefined;
    /**
     * @stability stable
     */
    set min(value: string | undefined);
    /**
     * @stability stable
     */
    resetMin(): void;
    /**
     * @stability stable
     */
    get minInput(): string | undefined;
    private _scale?;
    /**
     * @stability stable
     */
    get scale(): string | undefined;
    /**
     * @stability stable
     */
    set scale(value: string | undefined);
    /**
     * @stability stable
     */
    resetScale(): void;
    /**
     * @stability stable
     */
    get scaleInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetScatterplotDefinition {
    /**
     * List of groups used for colors.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#color_by_groups Dashboard#color_by_groups}
     *
     * @stability stable
     */
    readonly colorByGroups?: string[];
    /**
     * The timeframe to use when displaying the widget.
     *
     * Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `1y`, `alert`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#live_span Dashboard#live_span}
     *
     * @stability stable
     */
    readonly liveSpan?: string;
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * custom_link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#custom_link Dashboard#custom_link}
     *
     * @stability stable
     */
    readonly customLink?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionCustomLink[];
    /**
     * request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#request Dashboard#request}
     *
     * @stability stable
     */
    readonly request?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequest;
    /**
     * xaxis block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#xaxis Dashboard#xaxis}
     *
     * @stability stable
     */
    readonly xaxis?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionXaxis;
    /**
     * yaxis block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#yaxis Dashboard#yaxis}
     *
     * @stability stable
     */
    readonly yaxis?: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionYaxis;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _colorByGroups?;
    /**
     * @stability stable
     */
    get colorByGroups(): string[] | undefined;
    /**
     * @stability stable
     */
    set colorByGroups(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetColorByGroups(): void;
    /**
     * @stability stable
     */
    get colorByGroupsInput(): string[] | undefined;
    private _liveSpan?;
    /**
     * @stability stable
     */
    get liveSpan(): string | undefined;
    /**
     * @stability stable
     */
    set liveSpan(value: string | undefined);
    /**
     * @stability stable
     */
    resetLiveSpan(): void;
    /**
     * @stability stable
     */
    get liveSpanInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _titleAlign?;
    /**
     * @stability stable
     */
    get titleAlign(): string | undefined;
    /**
     * @stability stable
     */
    set titleAlign(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleAlign(): void;
    /**
     * @stability stable
     */
    get titleAlignInput(): string | undefined;
    private _titleSize?;
    /**
     * @stability stable
     */
    get titleSize(): string | undefined;
    /**
     * @stability stable
     */
    set titleSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitleSize(): void;
    /**
     * @stability stable
     */
    get titleSizeInput(): string | undefined;
    private _customLink?;
    /**
     * @stability stable
     */
    get customLink(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionCustomLink[] | undefined;
    /**
     * @stability stable
     */
    set customLink(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionCustomLink[] | undefined);
    /**
     * @stability stable
     */
    resetCustomLink(): void;
    /**
     * @stability stable
     */
    get customLinkInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionCustomLink[] | undefined;
    private _request?;
    private __requestOutput;
    /**
     * @stability stable
     */
    get request(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequestOutputReference;
    /**
     * @stability stable
     */
    putRequest(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequest | undefined): void;
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionRequest | undefined;
    private _xaxis?;
    private __xaxisOutput;
    /**
     * @stability stable
     */
    get xaxis(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionXaxisOutputReference;
    /**
     * @stability stable
     */
    putXaxis(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionXaxis | undefined): void;
    /**
     * @stability stable
     */
    resetXaxis(): void;
    /**
     * @stability stable
     */
    get xaxisInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionXaxis | undefined;
    private _yaxis?;
    private __yaxisOutput;
    /**
     * @stability stable
     */
    get yaxis(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionYaxisOutputReference;
    /**
     * @stability stable
     */
    putYaxis(value: DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionYaxis | undefined): void;
    /**
     * @stability stable
     */
    resetYaxis(): void;
    /**
     * @stability stable
     */
    get yaxisInput(): DashboardWidgetGroupDefinitionWidgetScatterplotDefinitionYaxis | undefined;
}
/**
 * @stability stable
 */
export interface DashboardWidgetGroupDefinitionWidgetServiceLevelObjectiveDefinition {
    /**
     * The global time target of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#global_time_target Dashboard#global_time_target}
     *
     * @stability stable
     */
    readonly globalTimeTarget?: string;
    /**
     * Whether to show the error budget or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#show_error_budget Dashboard#show_error_budget}
     *
     * @stability stable
     */
    readonly showErrorBudget?: boolean | cdktf.IResolvable;
    /**
     * The ID of the service level objective used by the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#slo_id Dashboard#slo_id}
     *
     * @stability stable
     */
    readonly sloId: string;
    /**
     * A list of time windows to display in the widget.
     *
     * Valid values are `7d`, `30d`, `90d`, `week_to_date`, `previous_week`, `month_to_date`, `previous_month`, `global_time`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#time_windows Dashboard#time_windows}
     *
     * @stability stable
     */
    readonly timeWindows: string[];
    /**
     * The title of the widget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title Dashboard#title}
     *
     * @stability stable
     */
    readonly title?: string;
    /**
     * The alignment of the widget's title. Valid values are `center`, `left`, `right`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_align Dashboard#title_align}
     *
     * @stability stable
     */
    readonly titleAlign?: string;
    /**
     * The size of the widget's title (defaults to 16).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#title_size Dashboard#title_size}
     *
     * @stability stable
     */
    readonly titleSize?: string;
    /**
     * The view mode for the widget. Valid values are `overall`, `component`, `both`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#view_mode Dashboard#view_mode}
     *
     * @stability stable
     */
    readonly viewMode: string;
    /**
     * The type of view to use when displaying the widget. Only `detail` is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/dashboard.html#view_type Dashboard#view_type}
     *
     * @stability stable
     */
    readonly viewType: string;
}
/**
 * @stability stable
 */
export declare class DashboardWidgetGroupDefinitionWidgetServiceLevelObjectiveDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _globalTimeTarget?;
    /**
     * @stability stable
     */
    get globalTimeTarget(): string | undefined;
    /**
     * @stability stable
     */
    set globalTimeTarget(value: string | undefined);
    /**
     * @stability stable
     */
    resetGlobalTimeTarget(): void;
    /**
     * @stability stable
     */
    get globalTimeTargetInput(): string | undefined;
    private _showErrorBudget?;
    /**
     * @stability stable
     */
    get showErrorBudget(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set showErrorBudget(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetShowErrorBudget(): void;
    /**
     * @stability stable
     */
    get showErrorBudgetInput(): boolean | cdktf.IResolvable | undefined;
    private _sloId?;
    /**
     * @stability stable
     */
    get sloId(): string;
    /**
     * @stability stable
     */
    set sloId(value: string);
    /**
     * @stability stable
     */
    get sloIdInput(): string | undefined;
    private _timeWindows?;
    /**
     * @stability stable
     */
    get timeWindows(): string[];
    /**
     * @stability stable
     */
    set timeWindows(value: string[]);
    /**
     * @stability stable
     */
    get timeWindowsInput(): string[] | undefined;
    private _title?;
