import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataDatadogApiKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Id for API Key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/api_key.html#id DataDatadogApiKey#id}
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Name for API Key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/api_key.html#name DataDatadogApiKey#name}
     *
     * @stability stable
     */
    readonly name?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/d/api_key.html datadog_api_key}.
 *
 * @stability stable
 */
export declare class DataDatadogApiKey extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/api_key.html datadog_api_key} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataDatadogApiKeyConfig);
    private _id?;
    /**
     * @stability stable
     */
    get id(): string | undefined;
    /**
     * @stability stable
     */
    set id(value: string | undefined);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    /**
     * @stability stable
     */
    get key(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
