import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataDatadogServiceLevelObjectiveConfig extends cdktf.TerraformMetaArguments {
    /**
     * A SLO ID to limit the search.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objective.html#id DataDatadogServiceLevelObjective#id}
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Filter results based on SLO numerator and denominator.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objective.html#metrics_query DataDatadogServiceLevelObjective#metrics_query}
     *
     * @stability stable
     */
    readonly metricsQuery?: string;
    /**
     * Filter results based on SLO names.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objective.html#name_query DataDatadogServiceLevelObjective#name_query}
     *
     * @stability stable
     */
    readonly nameQuery?: string;
    /**
     * Filter results based on a single SLO tag.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objective.html#tags_query DataDatadogServiceLevelObjective#tags_query}
     *
     * @stability stable
     */
    readonly tagsQuery?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objective.html datadog_service_level_objective}.
 *
 * @stability stable
 */
export declare class DataDatadogServiceLevelObjective extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objective.html datadog_service_level_objective} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataDatadogServiceLevelObjectiveConfig);
    private _id?;
    /**
     * @stability stable
     */
    get id(): string | undefined;
    /**
     * @stability stable
     */
    set id(value: string | undefined);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    private _metricsQuery?;
    /**
     * @stability stable
     */
    get metricsQuery(): string | undefined;
    /**
     * @stability stable
     */
    set metricsQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetMetricsQuery(): void;
    /**
     * @stability stable
     */
    get metricsQueryInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _nameQuery?;
    /**
     * @stability stable
     */
    get nameQuery(): string | undefined;
    /**
     * @stability stable
     */
    set nameQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetNameQuery(): void;
    /**
     * @stability stable
     */
    get nameQueryInput(): string | undefined;
    private _tagsQuery?;
    /**
     * @stability stable
     */
    get tagsQuery(): string | undefined;
    /**
     * @stability stable
     */
    set tagsQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetTagsQuery(): void;
    /**
     * @stability stable
     */
    get tagsQueryInput(): string | undefined;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
