import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IntegrationAzureConfig extends cdktf.TerraformMetaArguments {
    /**
     * Your Azure web application ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_azure.html#client_id IntegrationAzure#client_id}
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * (Required for Initial Creation) Your Azure web application secret key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_azure.html#client_secret IntegrationAzure#client_secret}
     *
     * @stability stable
     */
    readonly clientSecret: string;
    /**
     * String of host tag(s) (in the form `key:value,key:value`) defines a filter that Datadog will use when collecting metrics from Azure.
     *
     * Limit the Azure instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog. e.x. `env:production,deploymentgroup:red`
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_azure.html#host_filters IntegrationAzure#host_filters}
     *
     * @stability stable
     */
    readonly hostFilters?: string;
    /**
     * Your Azure Active Directory ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_azure.html#tenant_name IntegrationAzure#tenant_name}
     *
     * @stability stable
     */
    readonly tenantName: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/integration_azure.html datadog_integration_azure}.
 *
 * @stability stable
 */
export declare class IntegrationAzure extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/integration_azure.html datadog_integration_azure} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IntegrationAzureConfig);
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
    private _hostFilters?;
    /**
     * @stability stable
     */
    get hostFilters(): string | undefined;
    /**
     * @stability stable
     */
    set hostFilters(value: string | undefined);
    /**
     * @stability stable
     */
    resetHostFilters(): void;
    /**
     * @stability stable
     */
    get hostFiltersInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _tenantName?;
    /**
     * @stability stable
     */
    get tenantName(): string;
    /**
     * @stability stable
     */
    set tenantName(value: string);
    /**
     * @stability stable
     */
    get tenantNameInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
