import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IntegrationPagerdutyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Your PagerDuty API token.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_pagerduty.html#api_token IntegrationPagerduty#api_token}
     *
     * @stability stable
     */
    readonly apiToken?: string;
    /**
     * Array of your schedule URLs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_pagerduty.html#schedules IntegrationPagerduty#schedules}
     *
     * @stability stable
     */
    readonly schedules?: string[];
    /**
     * Your PagerDuty account’s personalized subdomain name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_pagerduty.html#subdomain IntegrationPagerduty#subdomain}
     *
     * @stability stable
     */
    readonly subdomain: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/integration_pagerduty.html datadog_integration_pagerduty}.
 *
 * @stability stable
 */
export declare class IntegrationPagerduty extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/integration_pagerduty.html datadog_integration_pagerduty} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IntegrationPagerdutyConfig);
    private _apiToken?;
    /**
     * @stability stable
     */
    get apiToken(): string | undefined;
    /**
     * @stability stable
     */
    set apiToken(value: string | undefined);
    /**
     * @stability stable
     */
    resetApiToken(): void;
    /**
     * @stability stable
     */
    get apiTokenInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _schedules?;
    /**
     * @stability stable
     */
    get schedules(): string[] | undefined;
    /**
     * @stability stable
     */
    set schedules(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetSchedules(): void;
    /**
     * @stability stable
     */
    get schedulesInput(): string[] | undefined;
    private _subdomain?;
    /**
     * @stability stable
     */
    get subdomain(): string;
    /**
     * @stability stable
     */
    set subdomain(value: string);
    /**
     * @stability stable
     */
    get subdomainInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
