import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogsIndexConfig extends cdktf.TerraformMetaArguments {
    /**
     * The number of log events you can send in this index per day before you are rate-limited.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index.html#daily_limit LogsIndex#daily_limit}
     *
     * @stability stable
     */
    readonly dailyLimit?: number;
    /**
     * If true, sets the daily_limit value to null and the index is not limited on a daily basis (any specified daily_limit value in the request is ignored).
     *
     * If false or omitted, the index's current daily_limit is maintained.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index.html#disable_daily_limit LogsIndex#disable_daily_limit}
     *
     * @stability stable
     */
    readonly disableDailyLimit?: boolean | cdktf.IResolvable;
    /**
     * The name of the index.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index.html#name LogsIndex#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The number of days before logs are deleted from this index.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index.html#retention_days LogsIndex#retention_days}
     *
     * @stability stable
     */
    readonly retentionDays?: number;
    /**
     * exclusion_filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index.html#exclusion_filter LogsIndex#exclusion_filter}
     *
     * @stability stable
     */
    readonly exclusionFilter?: LogsIndexExclusionFilter[];
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index.html#filter LogsIndex#filter}
     *
     * @stability stable
     */
    readonly filter: LogsIndexFilter;
}
/**
 * @stability stable
 */
export interface LogsIndexExclusionFilterFilter {
    /**
     * Only logs matching the filter criteria and the query of the parent index will be considered for this exclusion filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index.html#query LogsIndex#query}
     *
     * @stability stable
     */
    readonly query?: string;
    /**
     * The fraction of logs excluded by the exclusion filter, when active.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index.html#sample_rate LogsIndex#sample_rate}
     *
     * @stability stable
     */
    readonly sampleRate?: number;
}
/**
 * @stability stable
 */
export interface LogsIndexExclusionFilter {
    /**
     * A boolean stating if the exclusion is active or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index.html#is_enabled LogsIndex#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * The name of the exclusion filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index.html#name LogsIndex#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index.html#filter LogsIndex#filter}
     *
     * @stability stable
     */
    readonly filter?: LogsIndexExclusionFilterFilter[];
}
/**
 * @stability stable
 */
export interface LogsIndexFilter {
    /**
     * Logs filter criteria. Only logs matching this filter criteria are considered for this index.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_index.html#query LogsIndex#query}
     *
     * @stability stable
     */
    readonly query: string;
}
/**
 * @stability stable
 */
export declare class LogsIndexFilterOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/logs_index.html datadog_logs_index}.
 *
 * @stability stable
 */
export declare class LogsIndex extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/logs_index.html datadog_logs_index} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogsIndexConfig);
    private _dailyLimit?;
    /**
     * @stability stable
     */
    get dailyLimit(): number | undefined;
    /**
     * @stability stable
     */
    set dailyLimit(value: number | undefined);
    /**
     * @stability stable
     */
    resetDailyLimit(): void;
    /**
     * @stability stable
     */
    get dailyLimitInput(): number | undefined;
    private _disableDailyLimit?;
    /**
     * @stability stable
     */
    get disableDailyLimit(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set disableDailyLimit(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDisableDailyLimit(): void;
    /**
     * @stability stable
     */
    get disableDailyLimitInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _retentionDays?;
    /**
     * @stability stable
     */
    get retentionDays(): number | undefined;
    /**
     * @stability stable
     */
    set retentionDays(value: number | undefined);
    /**
     * @stability stable
     */
    resetRetentionDays(): void;
    /**
     * @stability stable
     */
    get retentionDaysInput(): number | undefined;
    private _exclusionFilter?;
    /**
     * @stability stable
     */
    get exclusionFilter(): LogsIndexExclusionFilter[] | undefined;
    /**
     * @stability stable
     */
    set exclusionFilter(value: LogsIndexExclusionFilter[] | undefined);
    /**
     * @stability stable
     */
    resetExclusionFilter(): void;
    /**
     * @stability stable
     */
    get exclusionFilterInput(): LogsIndexExclusionFilter[] | undefined;
    private _filter?;
    private __filterOutput;
    /**
     * @stability stable
     */
    get filter(): LogsIndexFilterOutputReference;
    /**
     * @stability stable
     */
    putFilter(value: LogsIndexFilter): void;
    /**
     * @stability stable
     */
    get filterInput(): LogsIndexFilter | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
