import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogsPipelineOrderConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name attribute in the resource `datadog_logs_pipeline_order` needs to be unique.
     *
     * It's recommended to use the same value as the resource name. No related field is available in [Logs Pipeline API](https://docs.datadoghq.com/api/v1/logs-pipelines/#get-pipeline-order).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_pipeline_order.html#name LogsPipelineOrder#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The pipeline IDs list. The order of pipeline IDs in this attribute defines the overall pipeline order for logs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_pipeline_order.html#pipelines LogsPipelineOrder#pipelines}
     *
     * @stability stable
     */
    readonly pipelines: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/logs_pipeline_order.html datadog_logs_pipeline_order}.
 *
 * @stability stable
 */
export declare class LogsPipelineOrder extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/logs_pipeline_order.html datadog_logs_pipeline_order} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogsPipelineOrderConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _pipelines?;
    /**
     * @stability stable
     */
    get pipelines(): string[];
    /**
     * @stability stable
     */
    set pipelines(value: string[]);
    /**
     * @stability stable
     */
    get pipelinesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
