import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MetricMetadataConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of the metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_metadata.html#description MetricMetadata#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The name of the metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_metadata.html#metric MetricMetadata#metric}
     *
     * @stability stable
     */
    readonly metric: string;
    /**
     * Per unit of the metric such as `second` in `bytes per second`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_metadata.html#per_unit MetricMetadata#per_unit}
     *
     * @stability stable
     */
    readonly perUnit?: string;
    /**
     * A short name of the metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_metadata.html#short_name MetricMetadata#short_name}
     *
     * @stability stable
     */
    readonly shortName?: string;
    /**
     * If applicable, statsd flush interval in seconds for the metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_metadata.html#statsd_interval MetricMetadata#statsd_interval}
     *
     * @stability stable
     */
    readonly statsdInterval?: number;
    /**
     * Type of the metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_metadata.html#type MetricMetadata#type}
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Primary unit of the metric such as `byte` or `operation`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_metadata.html#unit MetricMetadata#unit}
     *
     * @stability stable
     */
    readonly unit?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/metric_metadata.html datadog_metric_metadata}.
 *
 * @stability stable
 */
export declare class MetricMetadata extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/metric_metadata.html datadog_metric_metadata} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MetricMetadataConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): string;
    /**
     * @stability stable
     */
    set metric(value: string);
    /**
     * @stability stable
     */
    get metricInput(): string | undefined;
    private _perUnit?;
    /**
     * @stability stable
     */
    get perUnit(): string | undefined;
    /**
     * @stability stable
     */
    set perUnit(value: string | undefined);
    /**
     * @stability stable
     */
    resetPerUnit(): void;
    /**
     * @stability stable
     */
    get perUnitInput(): string | undefined;
    private _shortName?;
    /**
     * @stability stable
     */
    get shortName(): string | undefined;
    /**
     * @stability stable
     */
    set shortName(value: string | undefined);
    /**
     * @stability stable
     */
    resetShortName(): void;
    /**
     * @stability stable
     */
    get shortNameInput(): string | undefined;
    private _statsdInterval?;
    /**
     * @stability stable
     */
    get statsdInterval(): number | undefined;
    /**
     * @stability stable
     */
    set statsdInterval(value: number | undefined);
    /**
     * @stability stable
     */
    resetStatsdInterval(): void;
    /**
     * @stability stable
     */
    get statsdIntervalInput(): number | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string | undefined;
    /**
     * @stability stable
     */
    set type(value: string | undefined);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _unit?;
    /**
     * @stability stable
     */
    get unit(): string | undefined;
    /**
     * @stability stable
     */
    set unit(value: string | undefined);
    /**
     * @stability stable
     */
    resetUnit(): void;
    /**
     * @stability stable
     */
    get unitInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
