import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MetricTagConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Toggle to include/exclude percentiles for a distribution metric.
     *
     * Defaults to false. Can only be applied to metrics that have a metric_type of distribution.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration.html#include_percentiles MetricTagConfiguration#include_percentiles}
     *
     * @stability stable
     */
    readonly includePercentiles?: boolean | cdktf.IResolvable;
    /**
     * The metric name for this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration.html#metric_name MetricTagConfiguration#metric_name}
     *
     * @stability stable
     */
    readonly metricName: string;
    /**
     * The metric's type. This field can't be updated after creation. Valid values are `gauge`, `count`, `rate`, `distribution`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration.html#metric_type MetricTagConfiguration#metric_type}
     *
     * @stability stable
     */
    readonly metricType: string;
    /**
     * A list of tag keys that will be queryable for your metric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration.html#tags MetricTagConfiguration#tags}
     *
     * @stability stable
     */
    readonly tags: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration.html datadog_metric_tag_configuration}.
 *
 * @stability stable
 */
export declare class MetricTagConfiguration extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/metric_tag_configuration.html datadog_metric_tag_configuration} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MetricTagConfigurationConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _includePercentiles?;
    /**
     * @stability stable
     */
    get includePercentiles(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set includePercentiles(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIncludePercentiles(): void;
    /**
     * @stability stable
     */
    get includePercentilesInput(): boolean | cdktf.IResolvable | undefined;
    private _metricName?;
    /**
     * @stability stable
     */
    get metricName(): string;
    /**
     * @stability stable
     */
    set metricName(value: string);
    /**
     * @stability stable
     */
    get metricNameInput(): string | undefined;
    private _metricType?;
    /**
     * @stability stable
     */
    get metricType(): string;
    /**
     * @stability stable
     */
    set metricType(value: string);
    /**
     * @stability stable
     */
    get metricTypeInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
