import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface OrganizationSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name for Organization.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings.html#name OrganizationSettings#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings.html#settings OrganizationSettings#settings}
     *
     * @stability stable
     */
    readonly settings?: OrganizationSettingsSettings;
}
/**
 * @stability stable
 */
export interface OrganizationSettingsSettingsSaml {
    /**
     * Whether or not SAML is enabled for this organization.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings.html#enabled OrganizationSettings#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class OrganizationSettingsSettingsSamlOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface OrganizationSettingsSettingsSamlAutocreateUsersDomains {
    /**
     * List of domains where the SAML automated user creation is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings.html#domains OrganizationSettings#domains}
     *
     * @stability stable
     */
    readonly domains?: string[];
    /**
     * Whether or not the automated user creation based on SAML domain is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings.html#enabled OrganizationSettings#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class OrganizationSettingsSettingsSamlAutocreateUsersDomainsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _domains?;
    /**
     * @stability stable
     */
    get domains(): string[] | undefined;
    /**
     * @stability stable
     */
    set domains(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetDomains(): void;
    /**
     * @stability stable
     */
    get domainsInput(): string[] | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface OrganizationSettingsSettingsSamlIdpInitiatedLogin {
    /**
     * Whether or not a SAML identity provider metadata file was provided to the Datadog organization.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings.html#enabled OrganizationSettings#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class OrganizationSettingsSettingsSamlIdpInitiatedLoginOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface OrganizationSettingsSettingsSamlStrictMode {
    /**
     * Whether or not the SAML strict mode is enabled. If true, all users must log in with SAML.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings.html#enabled OrganizationSettings#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class OrganizationSettingsSettingsSamlStrictModeOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface OrganizationSettingsSettings {
    /**
     * Whether or not the organization users can share widgets outside of Datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings.html#private_widget_share OrganizationSettings#private_widget_share}
     *
     * @stability stable
     */
    readonly privateWidgetShare?: boolean | cdktf.IResolvable;
    /**
     * The access role of the user.
     *
     * Options are `st` (standard user), `adm` (admin user), or `ro` (read-only user). Allowed enum values: `st`, `adm` , `ro`, `ERROR`
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings.html#saml_autocreate_access_role OrganizationSettings#saml_autocreate_access_role}
     *
     * @stability stable
     */
    readonly samlAutocreateAccessRole?: string;
    /**
     * saml block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings.html#saml OrganizationSettings#saml}
     *
     * @stability stable
     */
    readonly saml: OrganizationSettingsSettingsSaml;
    /**
     * saml_autocreate_users_domains block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings.html#saml_autocreate_users_domains OrganizationSettings#saml_autocreate_users_domains}
     *
     * @stability stable
     */
    readonly samlAutocreateUsersDomains: OrganizationSettingsSettingsSamlAutocreateUsersDomains;
    /**
     * saml_idp_initiated_login block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings.html#saml_idp_initiated_login OrganizationSettings#saml_idp_initiated_login}
     *
     * @stability stable
     */
    readonly samlIdpInitiatedLogin: OrganizationSettingsSettingsSamlIdpInitiatedLogin;
    /**
     * saml_strict_mode block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings.html#saml_strict_mode OrganizationSettings#saml_strict_mode}
     *
     * @stability stable
     */
    readonly samlStrictMode: OrganizationSettingsSettingsSamlStrictMode;
}
/**
 * @stability stable
 */
export declare class OrganizationSettingsSettingsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _privateWidgetShare?;
    /**
     * @stability stable
     */
    get privateWidgetShare(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set privateWidgetShare(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetPrivateWidgetShare(): void;
    /**
     * @stability stable
     */
    get privateWidgetShareInput(): boolean | cdktf.IResolvable | undefined;
    private _samlAutocreateAccessRole?;
    /**
     * @stability stable
     */
    get samlAutocreateAccessRole(): string | undefined;
    /**
     * @stability stable
     */
    set samlAutocreateAccessRole(value: string | undefined);
    /**
     * @stability stable
     */
    resetSamlAutocreateAccessRole(): void;
    /**
     * @stability stable
     */
    get samlAutocreateAccessRoleInput(): string | undefined;
    private _saml?;
    private __samlOutput;
    /**
     * @stability stable
     */
    get saml(): OrganizationSettingsSettingsSamlOutputReference;
    /**
     * @stability stable
     */
    putSaml(value: OrganizationSettingsSettingsSaml): void;
    /**
     * @stability stable
     */
    get samlInput(): OrganizationSettingsSettingsSaml | undefined;
    private _samlAutocreateUsersDomains?;
    private __samlAutocreateUsersDomainsOutput;
    /**
     * @stability stable
     */
    get samlAutocreateUsersDomains(): OrganizationSettingsSettingsSamlAutocreateUsersDomainsOutputReference;
    /**
     * @stability stable
     */
    putSamlAutocreateUsersDomains(value: OrganizationSettingsSettingsSamlAutocreateUsersDomains): void;
    /**
     * @stability stable
     */
    get samlAutocreateUsersDomainsInput(): OrganizationSettingsSettingsSamlAutocreateUsersDomains | undefined;
    private _samlIdpInitiatedLogin?;
    private __samlIdpInitiatedLoginOutput;
    /**
     * @stability stable
     */
    get samlIdpInitiatedLogin(): OrganizationSettingsSettingsSamlIdpInitiatedLoginOutputReference;
    /**
     * @stability stable
     */
    putSamlIdpInitiatedLogin(value: OrganizationSettingsSettingsSamlIdpInitiatedLogin): void;
    /**
     * @stability stable
     */
    get samlIdpInitiatedLoginInput(): OrganizationSettingsSettingsSamlIdpInitiatedLogin | undefined;
    private _samlStrictMode?;
    private __samlStrictModeOutput;
    /**
     * @stability stable
     */
    get samlStrictMode(): OrganizationSettingsSettingsSamlStrictModeOutputReference;
    /**
     * @stability stable
     */
    putSamlStrictMode(value: OrganizationSettingsSettingsSamlStrictMode): void;
    /**
     * @stability stable
     */
    get samlStrictModeInput(): OrganizationSettingsSettingsSamlStrictMode | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings.html datadog_organization_settings}.
 *
 * @stability stable
 */
export declare class OrganizationSettings extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/organization_settings.html datadog_organization_settings} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: OrganizationSettingsConfig);
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get publicId(): string;
    private _settings?;
    private __settingsOutput;
    /**
     * @stability stable
     */
    get settings(): OrganizationSettingsSettingsOutputReference;
    /**
     * @stability stable
     */
    putSettings(value: OrganizationSettingsSettings | undefined): void;
    /**
     * @stability stable
     */
    resetSettings(): void;
    /**
     * @stability stable
     */
    get settingsInput(): OrganizationSettingsSettings | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
