import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SecurityMonitoringRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether the rule is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#enabled SecurityMonitoringRule#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Whether the notifications include the triggering group-by values in their title.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#has_extended_title SecurityMonitoringRule#has_extended_title}
     *
     * @stability stable
     */
    readonly hasExtendedTitle?: boolean | cdktf.IResolvable;
    /**
     * Message for generated signals.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#message SecurityMonitoringRule#message}
     *
     * @stability stable
     */
    readonly message: string;
    /**
     * The name of the rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#name SecurityMonitoringRule#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Tags for generated signals.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#tags SecurityMonitoringRule#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * The rule type. Valid values are `log_detection`, `infrastructure_configuration`, `workload_security`, `cloud_configuration`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#type SecurityMonitoringRule#type}
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * case block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#case SecurityMonitoringRule#case}
     *
     * @stability stable
     */
    readonly case: SecurityMonitoringRuleCase[];
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#filter SecurityMonitoringRule#filter}
     *
     * @stability stable
     */
    readonly filter?: SecurityMonitoringRuleFilter[];
    /**
     * options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#options SecurityMonitoringRule#options}
     *
     * @stability stable
     */
    readonly options?: SecurityMonitoringRuleOptions;
    /**
     * query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#query SecurityMonitoringRule#query}
     *
     * @stability stable
     */
    readonly query: SecurityMonitoringRuleQuery[];
}
/**
 * @stability stable
 */
export interface SecurityMonitoringRuleCase {
    /**
     * A rule case contains logical operations (`>`,`>=`, `&&`, `||`) to determine if a signal should be generated based on the event counts in the previously defined queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#condition SecurityMonitoringRule#condition}
     *
     * @stability stable
     */
    readonly condition?: string;
    /**
     * Name of the case.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#name SecurityMonitoringRule#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Notification targets for each rule case.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#notifications SecurityMonitoringRule#notifications}
     *
     * @stability stable
     */
    readonly notifications?: string[];
    /**
     * Severity of the Security Signal. Valid values are `info`, `low`, `medium`, `high`, `critical`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#status SecurityMonitoringRule#status}
     *
     * @stability stable
     */
    readonly status: string;
}
/**
 * @stability stable
 */
export interface SecurityMonitoringRuleFilter {
    /**
     * The type of filtering action. Valid values are `require`, `suppress`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#action SecurityMonitoringRule#action}
     *
     * @stability stable
     */
    readonly action: string;
    /**
     * Query for selecting logs to apply the filtering action.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#query SecurityMonitoringRule#query}
     *
     * @stability stable
     */
    readonly query: string;
}
/**
 * @stability stable
 */
export interface SecurityMonitoringRuleOptionsNewValueOptions {
    /**
     * The duration in days after which a learned value is forgotten.
     *
     * Valid values are `1`, `2`, `7`, `14`, `21`, `28`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#forget_after SecurityMonitoringRule#forget_after}
     *
     * @stability stable
     */
    readonly forgetAfter: number;
    /**
     * The duration in days during which values are learned, and after which signals will be generated for values that weren't learned.
     *
     * If set to 0, a signal will be generated for all new values after the first value is learned. Valid values are `0`, `1`, `7`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#learning_duration SecurityMonitoringRule#learning_duration}
     *
     * @stability stable
     */
    readonly learningDuration: number;
}
/**
 * @stability stable
 */
export declare class SecurityMonitoringRuleOptionsNewValueOptionsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _forgetAfter?;
    /**
     * @stability stable
     */
    get forgetAfter(): number;
    /**
     * @stability stable
     */
    set forgetAfter(value: number);
    /**
     * @stability stable
     */
    get forgetAfterInput(): number | undefined;
    private _learningDuration?;
    /**
     * @stability stable
     */
    get learningDuration(): number;
    /**
     * @stability stable
     */
    set learningDuration(value: number);
    /**
     * @stability stable
     */
    get learningDurationInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface SecurityMonitoringRuleOptions {
    /**
     * The detection method. Valid values are `threshold`, `new_value`, `anomaly_detection`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#detection_method SecurityMonitoringRule#detection_method}
     *
     * @stability stable
     */
    readonly detectionMethod?: string;
    /**
     * A time window is specified to match when at least one of the cases matches true.
     *
     * This is a sliding window and evaluates in real time. Valid values are `0`, `60`, `300`, `600`, `900`, `1800`, `3600`, `7200`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#evaluation_window SecurityMonitoringRule#evaluation_window}
     *
     * @stability stable
     */
    readonly evaluationWindow: number;
    /**
     * Once a signal is generated, the signal will remain “open” if a case is matched at least once within this keep alive window.
     *
     * Valid values are `0`, `60`, `300`, `600`, `900`, `1800`, `3600`, `7200`, `10800`, `21600`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#keep_alive SecurityMonitoringRule#keep_alive}
     *
     * @stability stable
     */
    readonly keepAlive: number;
    /**
     * A signal will “close” regardless of the query being matched once the time exceeds the maximum duration.
     *
     * This time is calculated from the first seen timestamp. Valid values are `0`, `60`, `300`, `600`, `900`, `1800`, `3600`, `7200`, `10800`, `21600`, `43200`, `86400`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#max_signal_duration SecurityMonitoringRule#max_signal_duration}
     *
     * @stability stable
     */
    readonly maxSignalDuration: number;
    /**
     * new_value_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#new_value_options SecurityMonitoringRule#new_value_options}
     *
     * @stability stable
     */
    readonly newValueOptions?: SecurityMonitoringRuleOptionsNewValueOptions;
}
/**
 * @stability stable
 */
export declare class SecurityMonitoringRuleOptionsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _detectionMethod?;
    /**
     * @stability stable
     */
    get detectionMethod(): string | undefined;
    /**
     * @stability stable
     */
    set detectionMethod(value: string | undefined);
    /**
     * @stability stable
     */
    resetDetectionMethod(): void;
    /**
     * @stability stable
     */
    get detectionMethodInput(): string | undefined;
    private _evaluationWindow?;
    /**
     * @stability stable
     */
    get evaluationWindow(): number;
    /**
     * @stability stable
     */
    set evaluationWindow(value: number);
    /**
     * @stability stable
     */
    get evaluationWindowInput(): number | undefined;
    private _keepAlive?;
    /**
     * @stability stable
     */
    get keepAlive(): number;
    /**
     * @stability stable
     */
    set keepAlive(value: number);
    /**
     * @stability stable
     */
    get keepAliveInput(): number | undefined;
    private _maxSignalDuration?;
    /**
     * @stability stable
     */
    get maxSignalDuration(): number;
    /**
     * @stability stable
     */
    set maxSignalDuration(value: number);
    /**
     * @stability stable
     */
    get maxSignalDurationInput(): number | undefined;
    private _newValueOptions?;
    private __newValueOptionsOutput;
    /**
     * @stability stable
     */
    get newValueOptions(): SecurityMonitoringRuleOptionsNewValueOptionsOutputReference;
    /**
     * @stability stable
     */
    putNewValueOptions(value: SecurityMonitoringRuleOptionsNewValueOptions | undefined): void;
    /**
     * @stability stable
     */
    resetNewValueOptions(): void;
    /**
     * @stability stable
     */
    get newValueOptionsInput(): SecurityMonitoringRuleOptionsNewValueOptions | undefined;
}
/**
 * @stability stable
 */
export interface SecurityMonitoringRuleQueryAgentRule {
    /**
     * The Agent rule ID. Must be unique within the rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#agent_rule_id SecurityMonitoringRule#agent_rule_id}
     *
     * @stability stable
     */
    readonly agentRuleId: string;
    /**
     * A Runtime Security expression determines what activity should be collected by the Datadog Agent.
     *
     * These logical expressions can use predefined operators and attributes. Tags cannot be used in Runtime Security expressions. Instead, allow or deny based on tags under the advanced option.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#expression SecurityMonitoringRule#expression}
     *
     * @stability stable
     */
    readonly expression: string;
}
/**
 * @stability stable
 */
export interface SecurityMonitoringRuleQuery {
    /**
     * The aggregation type. Valid values are `count`, `cardinality`, `sum`, `max`, `new_value`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#aggregation SecurityMonitoringRule#aggregation}
     *
     * @stability stable
     */
    readonly aggregation?: string;
    /**
     * Field for which the cardinality is measured. Sent as an array.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#distinct_fields SecurityMonitoringRule#distinct_fields}
     *
     * @stability stable
     */
    readonly distinctFields?: string[];
    /**
     * Fields to group by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#group_by_fields SecurityMonitoringRule#group_by_fields}
     *
     * @stability stable
     */
    readonly groupByFields?: string[];
    /**
     * The target field to aggregate over when using the sum or max aggregations.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#metric SecurityMonitoringRule#metric}
     *
     * @stability stable
     */
    readonly metric?: string;
    /**
     * Name of the query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#name SecurityMonitoringRule#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Query to run on logs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#query SecurityMonitoringRule#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * agent_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html#agent_rule SecurityMonitoringRule#agent_rule}
     *
     * @stability stable
     */
    readonly agentRule?: SecurityMonitoringRuleQueryAgentRule[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html datadog_security_monitoring_rule}.
 *
 * @stability stable
 */
export declare class SecurityMonitoringRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/security_monitoring_rule.html datadog_security_monitoring_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SecurityMonitoringRuleConfig);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _hasExtendedTitle?;
    /**
     * @stability stable
     */
    get hasExtendedTitle(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set hasExtendedTitle(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetHasExtendedTitle(): void;
    /**
     * @stability stable
     */
    get hasExtendedTitleInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _message?;
    /**
     * @stability stable
     */
    get message(): string;
    /**
     * @stability stable
     */
    set message(value: string);
    /**
     * @stability stable
     */
    get messageInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[] | undefined;
    /**
     * @stability stable
     */
    set tags(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string | undefined;
    /**
     * @stability stable
     */
    set type(value: string | undefined);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _case?;
    /**
     * @stability stable
     */
    get case(): SecurityMonitoringRuleCase[];
    /**
     * @stability stable
     */
    set case(value: SecurityMonitoringRuleCase[]);
    /**
     * @stability stable
     */
    get caseInput(): SecurityMonitoringRuleCase[] | undefined;
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): SecurityMonitoringRuleFilter[] | undefined;
    /**
     * @stability stable
     */
    set filter(value: SecurityMonitoringRuleFilter[] | undefined);
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): SecurityMonitoringRuleFilter[] | undefined;
    private _options?;
    private __optionsOutput;
    /**
     * @stability stable
     */
    get options(): SecurityMonitoringRuleOptionsOutputReference;
    /**
     * @stability stable
     */
    putOptions(value: SecurityMonitoringRuleOptions | undefined): void;
    /**
     * @stability stable
     */
    resetOptions(): void;
    /**
     * @stability stable
     */
    get optionsInput(): SecurityMonitoringRuleOptions | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): SecurityMonitoringRuleQuery[];
    /**
     * @stability stable
     */
    set query(value: SecurityMonitoringRuleQuery[]);
    /**
     * @stability stable
     */
    get queryInput(): SecurityMonitoringRuleQuery[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
