import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SloCorrectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Category the SLO correction belongs to. Valid values are `Scheduled Maintenance`, `Outside Business Hours`, `Deployment`, `Other`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction.html#category SloCorrection#category}
     *
     * @stability stable
     */
    readonly category: string;
    /**
     * Description of the correction being made.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction.html#description SloCorrection#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Ending time of the correction in epoch seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction.html#end SloCorrection#end}
     *
     * @stability stable
     */
    readonly end: number;
    /**
     * ID of the SLO that this correction will be applied to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction.html#slo_id SloCorrection#slo_id}
     *
     * @stability stable
     */
    readonly sloId: string;
    /**
     * Starting time of the correction in epoch seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction.html#start SloCorrection#start}
     *
     * @stability stable
     */
    readonly start: number;
    /**
     * The timezone to display in the UI for the correction times (defaults to "UTC").
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction.html#timezone SloCorrection#timezone}
     *
     * @stability stable
     */
    readonly timezone?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction.html datadog_slo_correction}.
 *
 * @stability stable
 */
export declare class SloCorrection extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/slo_correction.html datadog_slo_correction} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SloCorrectionConfig);
    private _category?;
    /**
     * @stability stable
     */
    get category(): string;
    /**
     * @stability stable
     */
    set category(value: string);
    /**
     * @stability stable
     */
    get categoryInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _end?;
    /**
     * @stability stable
     */
    get end(): number;
    /**
     * @stability stable
     */
    set end(value: number);
    /**
     * @stability stable
     */
    get endInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _sloId?;
    /**
     * @stability stable
     */
    get sloId(): string;
    /**
     * @stability stable
     */
    set sloId(value: string);
    /**
     * @stability stable
     */
    get sloIdInput(): string | undefined;
    private _start?;
    /**
     * @stability stable
     */
    get start(): number;
    /**
     * @stability stable
     */
    set start(value: number);
    /**
     * @stability stable
     */
    get startInput(): number | undefined;
    private _timezone?;
    /**
     * @stability stable
     */
    get timezone(): string | undefined;
    /**
     * @stability stable
     */
    set timezone(value: string | undefined);
    /**
     * @stability stable
     */
    resetTimezone(): void;
    /**
     * @stability stable
     */
    get timezoneInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
