import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SyntheticsPrivateLocationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Description of the private location.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_private_location.html#description SyntheticsPrivateLocation#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Synthetics private location name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_private_location.html#name SyntheticsPrivateLocation#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * A list of tags to associate with your synthetics private location.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_private_location.html#tags SyntheticsPrivateLocation#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_private_location.html datadog_synthetics_private_location}.
 *
 * @stability stable
 */
export declare class SyntheticsPrivateLocation extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_private_location.html datadog_synthetics_private_location} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SyntheticsPrivateLocationConfig);
    /**
     * @stability stable
     */
    get config(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[] | undefined;
    /**
     * @stability stable
     */
    set tags(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
