"""
The azure_servicebus integration traces all messages sent by the service bus client.

Enabling
~~~~~~~~

The azure_servicebus integration is enabled by default when using :ref:`import ddtrace.auto<ddtraceauto>`.


Global Configuration
~~~~~~~~~~~~~~~~~~~~

.. py:data:: ddtrace.config.azure_servicebus["service"]

   The service name reported by default for azure service bus clients.

   This option can also be set with the ``DD_AZURE_SERVICEBUS_SERVICE`` environment
   variable.

   Default: ``"azure_servicebus"``

.. py:data:: ddtrace.config.azure_servicebus['distributed_tracing']

   Include distributed tracing headers in service bus messages sent from the azure service bus client.

   This option can also be set with the ``DD_AZURE_SERVICEBUS_DISTRIBUTED_TRACING``
   environment variable.

   Default: ``True``

.. py:data:: ddtrace.config.azure_servicebus['batch_links']

   Add create spans and span links for service bus messages added to and sent in a batch.

   This option can also be set with the ``DD_TRACE_AZURE_SERVICEBUS_BATCH_LINKS_ENABLED``
   environment variable.

   Distributed tracing must also be enabled for span links to be added.

   Default: ``True``
"""
