#[cfg(feature = "crashtracker")]
mod crashtracker;
#[cfg(feature = "profiling")]
pub use datadog_profiling_ffi::*;
mod data_pipeline;
mod ddsketch;
mod ffande;
mod library_config;
mod log;

use pyo3::prelude::*;

/// Dummy function to check if imported lib is generated on windows builds.
#[no_mangle]
pub extern "C" fn ddtrace_force_export_for_windows() {}

#[pymodule]
fn _native(m: &Bound<'_, PyModule>) -> PyResult<()> {
    m.add_class::<ddsketch::DDSketchPy>()?;
    m.add_class::<library_config::PyConfigurator>()?;

    #[cfg(feature = "crashtracker")]
    {
        m.add_class::<crashtracker::StacktraceCollectionPy>()?;
        m.add_class::<crashtracker::CrashtrackerConfigurationPy>()?;
        m.add_class::<crashtracker::CrashtrackerReceiverConfigPy>()?;
        m.add_class::<crashtracker::CrashtrackerMetadataPy>()?;
        m.add_class::<crashtracker::CrashtrackerStatus>()?;
        m.add_function(wrap_pyfunction!(crashtracker::crashtracker_init, m)?)?;
        m.add_function(wrap_pyfunction!(crashtracker::crashtracker_on_fork, m)?)?;
        m.add_function(wrap_pyfunction!(crashtracker::crashtracker_status, m)?)?;
        m.add_function(wrap_pyfunction!(crashtracker::crashtracker_receiver, m)?)?;
    }
    m.add_class::<library_config::PyTracerMetadata>()?;
    m.add_class::<library_config::PyAnonymousFileHandle>()?;
    m.add_wrapped(wrap_pyfunction!(library_config::store_metadata))?;
    data_pipeline::register_data_pipeline(m)?;

    // Add FFAndE function
    m.add_function(wrap_pyfunction!(ffande::ffande_process_config, m)?)?;

    // Add logger submodule
    let logger_module = pyo3::wrap_pymodule!(log::logger);
    m.add_wrapped(logger_module)?;

    Ok(())
}
