from ddtrace.appsec._iast import enable_iast_propagation
from ddtrace.appsec._iast import load_iast
from ddtrace.appsec._iast.main import patch_iast
from ddtrace.contrib.internal.langchain.patch import patch as langchain_patch
from tests.utils import override_env
from tests.utils import override_global_config


# `pytest` automatically calls this function once when tests are run.
def pytest_configure():
    with override_global_config(
        dict(
            _iast_enabled=True,
            _iast_deduplication_enabled=False,
            _iast_request_sampling=100.0,
        )
    ), override_env(dict(_DD_IAST_PATCH_MODULES="tests.appsec.integrations")):
        patch_iast()
        enable_iast_propagation()
        # load_iast needs to happen before langchain_patch call, so that
        # listeners for langchain.patch are set up before they are dispatched.
        load_iast()
        langchain_patch()
