import os

import django

from ddtrace.trace import tracer
from tests.webclient import PingFilter


tracer.configure(trace_processors=[PingFilter()])


ALLOWED_HOSTS = [
    "testserver",
    "localhost",
]

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

DATABASES = {
    "default": {"ENGINE": "django.db.backends.sqlite3", "NAME": ":memory:"},
    "postgres": {
        "ENGINE": "django.db.backends.postgresql",
        "NAME": "postgres",
        "USER": "postgres",
        "PASSWORD": "postgres",
        "HOST": "127.0.0.1",
        "PORT": 5432,
    },
}

django_cache = "django_redis.cache.RedisCache"
if django.VERSION >= (4, 0, 0):
    django_cache = "django.core.cache.backends.redis.RedisCache"


CACHES = {
    "default": {
        "BACKEND": "django.core.cache.backends.locmem.LocMemCache",
        "LOCATION": "unique-snowflake",
    },
    "redis": {
        "BACKEND": django_cache,
        "LOCATION": "redis://127.0.0.1:6379/1",
    },
    "pylibmc": {
        "BACKEND": "django.core.cache.backends.memcached.PyLibMCCache",
        "LOCATION": "127.0.0.1:11211",
    },
}

SITE_ID = 1
SECRET_KEY = "not_very_secret_in_tests"
USE_I18N = True
USE_L10N = True
STATIC_URL = "/static/"
ROOT_URLCONF = "tests.contrib.django.django_app.urls"

TEMPLATES = [
    {
        "BACKEND": "django.template.backends.django.DjangoTemplates",
        "DIRS": [
            os.path.join(BASE_DIR, "templates"),
        ],
        "APP_DIRS": True,
        "OPTIONS": {
            "context_processors": [
                "django.template.context_processors.debug",
                "django.template.context_processors.request",
                "django.contrib.auth.context_processors.auth",
                "django.contrib.messages.context_processors.messages",
            ],
        },
    },
]

MIDDLEWARE = [
    "django.contrib.sessions.middleware.SessionMiddleware",
    "django.middleware.common.CommonMiddleware",
    "django.middleware.csrf.CsrfViewMiddleware",
    "django.contrib.auth.middleware.AuthenticationMiddleware",
    "django.contrib.messages.middleware.MessageMiddleware",
    "django.middleware.clickjacking.XFrameOptionsMiddleware",
    "django.middleware.security.SecurityMiddleware",
    "tests.contrib.django.middleware.ClsMiddleware",
    "tests.contrib.django.middleware.fn_middleware",
    "tests.contrib.django.middleware.EverythingMiddleware",
]

if os.getenv("TEST_INCLUDE_ASYNC_ONLY_MIDDLEWARE") == "1":
    # DEV: Add to the front, since adding at the end causes it to not get called?
    MIDDLEWARE = ["tests.contrib.django.middleware.async_only_middleware"] + MIDDLEWARE

INSTALLED_APPS = [
    "django.contrib.admin",
    "django.contrib.auth",
    "django.contrib.contenttypes",
    "django.contrib.sessions",
    "django_q",
]

Q_CLUSTER = {
    "name": "DjangORM",
    "timeout": 60 * 30,
    "retry": 10000000000,
    "max_attempts": 1,  # Dont re-attempt tasks
}
