#!/bin/bash
#
#
#SBATCH --time=0-08:00:00
#SBATCH --nodes=1
#SBATCH --mem=100000M
#SBATCH --cpus-per-task=16
#SBATCH --array=0-5
#SBATCH --account=GEOG024542

i=${SLURM_ARRAY_TASK_ID}

module  load apptainer/1.3.1 

singularity exec \
-B/user/work/$(whoami):/user/work/$(whoami) \
/user/work/$(whoami)/Abil/studies/wiseman2024/singularity/abil.sif \
python /user/work/$(whoami)/Abil/studies/wiseman2024/hpc_predict.py ${SLURM_CPUS_PER_TASK} ${i}

export SINGULARITY_CACHEDIR=/user/work/$(whoami)/.singularity
