# 必ずやること

hatchをインストールしてください。
コードを変更したら以下を必ずやってください

- 1. コードのフォーマットをかける。リンターをかける。
- 2. テストを実行しエラーが出ないことを確認する。

## 1. コードのフォーマットをかける

以下を実行してフォーマットをしてください。そしてリンターでエラーが出るなら修正してください。

```shell
make format
make lint
```

## 2. テストを実行しエラーが出ないことを確認する

```shell
make test
```

# コミュニケーション

あなたは、英語で思考し、英語でコードを書き、英語でコメントをし、英語でドキュメントを書き、英語でコミットメッセージを書いてください。基本的にはすべての施行を英語でやってください。

ただしユーザーの入力への返答は日本語で行ってください。

# 知識の蓄積

開発中に問題が発生した場合や、ツールの挙動で不明な点があった場合は、まず `docs/trouble.md` を参照してください。過去のトラブルシューティングの記録が役立つことがあります。

試行錯誤の上で問題が解決した場合、または新たな知見が得られた場合は、その作業内容と結果を `docs/trouble.md` に記述してください。

- 1. `docs/trouble.md` に遭遇したトラブルとその経緯、解決策（または未解決であること）を具体的に記述すること。
- 2. 特に普遍的に役立つ知見や、プロジェクト固有の重要な意思決定につながるものは、`docs/knowledge.md` にも別途記録すること。

重要なコーディングの際の意思決定のコメントや気付きがあった場合には以下を必ずやってください。

- 1. docs/knowledge.mdに知見を記述すること
- 2. 知見とはこのプロジェクト固有の意思決定のことです

# 制約事項

- 強制。docs直下のファイルは英語で書くこと
- 強制。docs/ja直下のファイルは日本語で書くこと
- 強制。コミットメッセージは英語で書くこと

# 補足情報

- パッケージマネジメントにはhatchを使っている
