# Defeat Beta API

<a target="new" href="https://pypi.python.org/pypi/defeatbeta-api"><img border=0 src="https://img.shields.io/badge/python-3.9+-blue.svg?style=flat" alt="Python version"></a>
<a target="new" href="https://pypi.python.org/pypi/defeatbeta-api"><img border=0 src="https://img.shields.io/pypi/v/defeatbeta-api.svg?maxAge=60%" alt="PyPi version"></a>
<a target="new" href="https://pypi.python.org/pypi/defeatbeta-api"><img border=0 src="https://img.shields.io/pepy/dt/defeatbeta-api?label=installs&cacheSeconds=0" alt="PyPi downloads"></a>
<a target="new" href="https://github.com/defeat-beta/defeatbeta-api"><img border=0 src="https://img.shields.io/github/stars/defeat-beta/defeatbeta-api.svg?style=social&label=Star&maxAge=60" alt="Star this repo"></a>

An open-source alternative to Yahoo Finance's market data APIs with higher reliability.

See [this documentation](doc/Example_Guide.md) to learn how to use it.

## Introduction

### Key features:

✅ **Reliable Data**: Sources market data directly from Hugging Face's [yahoo-finance-data](https://huggingface.co/datasets/bwzheng2010/yahoo-finance-data) dataset, bypassing Yahoo scraping.

✅ **No Rate Limits**: Hugging Face's infrastructure provides guaranteed access without API throttling or quotas.

✅ **High Performance**: [DuckDB's OLAP engine](https://duckdb.org/) + [cache_httpfs](https://duckdb.org/community_extensions/extensions/cache_httpfs.html) extension delivers sub-second query latency.

✅ **SQL-Compatible**: Python-native interface with full SQL support via DuckDB's optimized execution.

✅ **Extended Financial Data**: Includes [TTM EPS](doc/Value_Examples.md#1-stock-ttm-eps), [TTM PE](doc/Value_Examples.md#2-stock-ttm-pe), [Market Cap](doc/Value_Examples.md#3-stock-historical-market-cap), [PS Ratio](doc/Value_Examples.md#4-stock-historical-ps-ratio), [PB Ratio](doc/Value_Examples.md#5-stock-historical-pb-ratio), [PEG Ratio](doc/Value_Examples.md#6-stock-historical-peg-ratio), [Earnings call transcripts](doc/Info_Examples.md#3-accessing-earnings-call-transcripts), [Stock News](doc/Info_Examples.md#4-accessing-financial-news), [Revenue by segment](doc/Finance_Examples.md#91-stock-revenue-by-segment) and [Revenue by geography](doc/Finance_Examples.md#92-stock-revenue-by-geography) etc. (continuously expanding).

✅ **LLM-Powered Analysis**: [Financial Data Extraction](doc/Transcripts_LLM_Examples.md) — Use Large Language Models (LLMs) to analyze earnings call transcripts and extract key financial data.

### How it compares to yfinance:
`defeatbeta-api` is not superior to `yfinance` in every aspect, but its free and efficient features make it ideal for users needing bulk historical data analysis.

**Advantages over yfinance:**

**1. No rate limits:** defeat-beta avoids Yahoo Finance’s real-time rate limit by fetching data periodically (typically once a week) and uploading it to `Hugging Face`.

**2. Efficient data format:** It uses the Parquet format, supporting flexible SQL queries via `DuckDB`.

**3. High-performance caching:** Data is stored remotely on `Hugging Face` but leverages `cache_httpfs` for local disk caching, ensuring excellent performance.

**4. Multi-source data:** defeat-beta integrates additional data sources, unlike `yfinance` which relies solely on Yahoo Finance data.

**Disadvantages compared to yfinance:**

**Non-real-time data:** defeat-beta updates data on a periodic basis (typically weekly), so it cannot provide real-time data, unlike `yfinance`.

## Quickstart

The list of changes can be found in the [Changelog](CHANGELOG.rst)

### Installation

Install `defeatbeta-api` from [PYPI](https://pypi.org/project/defeatbeta-api/) using `pip`:

**MacOS / Linux**
``` {.sourceCode .bash}
$ pip install defeatbeta-api
```

**Windows**
> ⚠️ Requires WSL/Docker Due to dependencies on cache_httpfs (unsupported on Windows):

Option 1: WSL (Recommended)
1. Install [WSL](https://ubuntu.com/desktop/wsl)
2. In WSL terminal:
``` {.sourceCode .bash}
$ pip install defeatbeta-api
```

Option 2: Docker
1. Install [Docker Desktop](https://docs.docker.com/desktop/setup/install/windows-install/)
2. Run in Linux container:
``` {.sourceCode .bash}
docker run -it python:latest pip install defeatbeta-api
```

### Usage

Instantiate the `Ticker` class with a company's ticker symbol. For example, to get Tesla, Inc. data:

```python
import defeatbeta_api
from defeatbeta_api.data.ticker import Ticker
ticker = Ticker('TSLA')
```
The following examples demonstrate common API usage patterns (see more examples in [this documentation](doc/Example_Guide.md)):

#### Example: Fetching Stock Price Data
```python
ticker.price()
```
```text
>>> ticker.price()
     symbol report_date    open   close    high     low     volume
0      TSLA  2010-06-29    1.27    1.59    1.67    1.17  281494500
1      TSLA  2010-06-30    1.72    1.59    2.03    1.55  257806500
2      TSLA  2010-07-01    1.67    1.46    1.73    1.35  123282000
3      TSLA  2010-07-02    1.53    1.28    1.54    1.25   77097000
4      TSLA  2010-07-06    1.33    1.07    1.33    1.06  103003500
...     ...         ...     ...     ...     ...     ...        ...
3716   TSLA  2025-04-07  223.78  233.29  252.00  214.25  183453800
3717   TSLA  2025-04-08  245.00  221.86  250.44  217.80  171603500
3718   TSLA  2025-04-09  224.69  272.20  274.69  223.88  219433400
3719   TSLA  2025-04-10  260.00  252.40  262.49  239.33  181722600
3720   TSLA  2025-04-11  251.84  252.31  257.74  241.36  128656900

[3721 rows x 7 columns]
```

#### Example: Accessing Financial Statements

```python
statement = ticker.quarterly_income_statement()
print(statement.print_pretty_table())
```
```text
>>> statement=ticker.quarterly_income_statement()
>>> statement.print_pretty_table()
|------------------------------------------------------------+------------+---------------+------------+------------+------------+------------+------------+------------+------------+------------+------------+------------|
|                         Breakdown                          |    TTM     |  2024-12-31   | 2024-09-30 | 2024-06-30 | 2024-03-31 | 2023-12-31 | 2023-09-30 | 2023-06-30 | 2023-03-31 | 2022-12-31 | 2022-09-30 | 2022-06-30 |
|------------------------------------------------------------+------------+---------------+------------+------------+------------+------------+------------+------------+------------+------------+------------+------------|
| +Total Revenue                                             | 97,690,000 | 25,707,000    | 25,182,000 | 25,500,000 | 21,301,000 | 25,167,000 | 23,350,000 | 24,927,000 | *          | *          | *          | 16,934,000 |
|  Operating Revenue                                         | 97,690,000 | 25,707,000    | 25,182,000 | 25,500,000 | 21,301,000 | 25,167,000 | 23,350,000 | 24,927,000 | *          | *          | *          | 16,934,000 |
| Cost of Revenue                                            | 80,240,000 | 21,528,000    | 20,185,000 | 20,922,000 | 17,605,000 | 20,729,000 | 19,172,000 | 20,394,000 | *          | *          | *          | 12,700,000 |
| Gross Profit                                               | 17,450,000 | 4,179,000     | 4,997,000  | 4,578,000  | 3,696,000  | 4,438,000  | 4,178,000  | 4,533,000  | *          | *          | *          | 4,234,000  |
| +Operating Expense                                         | 9,690,000  | 2,589,000     | 2,225,000  | 2,351,000  | 2,525,000  | 2,374,000  | 2,414,000  | 2,134,000  | *          | *          | *          | 1,628,000  |
|  Selling General and Administrative                        | 5,150,000  | 1,313,000     | 1,186,000  | 1,277,000  | 1,374,000  | 1,280,000  | 1,253,000  | 1,191,000  | *          | *          | *          | 961,000    |
|  Research & Development                                    | 4,540,000  | 1,276,000     | 1,039,000  | 1,074,000  | 1,151,000  | 1,094,000  | 1,161,000  | 943,000    | *          | *          | *          | 667,000    |
| Operating Income                                           | 7,760,000  | 1,590,000     | 2,772,000  | 2,227,000  | 1,171,000  | 2,064,000  | 1,764,000  | 2,399,000  | *          | *          | *          | 2,606,000  |
| +Net Non-Operating Interest Income Expense                 | 1,219,000  | 346,000       | 337,000    | 262,000    | 274,000    | 272,000    | 244,000    | 210,000    | *          | *          | *          | -18,000    |
|  Non-Operating Interest Income                             | 1,569,000  | 442,000       | 429,000    | 348,000    | 350,000    | 333,000    | 282,000    | 238,000    | *          | *          | *          | 26,000     |
|  Non-Operating Interest Expense                            | 350,000    | 96,000        | 92,000     | 86,000     | 76,000     | 61,000     | 38,000     | 28,000     | *          | *          | *          | 44,000     |
| +Other Income Expense                                      | 11,000     | 830,000       | -325,000   | -602,000   | 108,000    | -145,000   | 37,000     | 328,000    | *          | *          | *          | -114,000   |
|  +Special Income Charges                                   | -684,000   | -7,000        | -55,000    | -622,000   | *          | 0          | 0          | 0          | *          | -34,000    | 0          | -142,000   |
|   Restructuring & Mergers Acquisition                      | 684,000    | 7,000         | 55,000     | 622,000    | *          | 0          | 0          | 0          | *          | 34,000     | 0          | 142,000    |
|  Other Non Operating Income Expenses                       | 695,000    | 837,000       | -270,000   | 20,000     | 108,000    | -145,000   | 37,000     | 328,000    | *          | *          | *          | 28,000     |
| Pretax Income                                              | 8,990,000  | 2,766,000     | 2,784,000  | 1,887,000  | 1,553,000  | 2,191,000  | 2,045,000  | 2,937,000  | *          | *          | *          | 2,474,000  |
| Tax Provision                                              | 1,837,000  | 434,000       | 601,000    | 393,000    | 409,000    | -5,752,000 | 167,000    | 323,000    | *          | *          | *          | 205,000    |
| +Net Income Common Stockholders                            | 7,130,000  | 2,314,000     | 2,167,000  | 1,478,000  | 1,171,000  | 7,927,000  | 1,851,000  | 2,703,000  | *          | *          | *          | 2,256,000  |
|  +Net Income(Attributable to Parent Company Shareholders)  | 7,130,000  | 2,356,000     | 2,167,000  | 1,478,000  | 1,129,000  | 7,930,000  | 1,853,000  | 2,703,000  | *          | *          | *          | 2,259,000  |
|   +Net Income Including Non-Controlling Interests          | 7,153,000  | 2,332,000     | 2,183,000  | 1,494,000  | 1,144,000  | 7,943,000  | 1,878,000  | 2,614,000  | *          | *          | *          | 2,269,000  |
|    Net Income Continuous Operations                        | 7,153,000  | 2,332,000     | 2,183,000  | 1,494,000  | 1,144,000  | 7,943,000  | 1,878,000  | 2,614,000  | *          | *          | *          | 2,269,000  |
|   Minority Interests                                       | -23,000    | 24,000        | -16,000    | -16,000    | -15,000    | -13,000    | -25,000    | 89,000     | *          | *          | *          | -10,000    |
|  Otherunder Preferred Stock Dividend                       | *          | *             | 0          | *          | -42,000    | *          | 2,000      | 0          | -5,000     | *          | 0          | 3,000      |
| Adjustments for Dilutive Securities                        | 0          | *             | *          | *          | *          | 0          | 0          | 0          | *          | 0          | 0          | 0          |
| Diluted NI Available to Com Stockholders                   | 7,130,000  | 2,314,000     | 2,167,000  | 1,478,000  | 1,171,000  | 7,927,000  | 1,851,000  | 2,703,000  | *          | *          | *          | 2,256,000  |
| Basic EPS                                                  | 3.41       | *             | 0.68       | 0.46       | 0.37       | 2.49       | 0.58       | 0.85       | *          | *          | *          | 0.73       |
| Diluted EPS                                                | 3.1        | *             | 0.62       | 0.42       | 0.34       | 2.27       | 0.53       | 0.78       | *          | *          | *          | 0.65       |
| Basic Average Shares                                       | 3,168,250  | *             | 3,198,000  | 3,191,000  | 3,186,000  | 3,181,000  | 3,176,000  | 3,171,000  | *          | *          | *          | 3,111,000  |
| Diluted Average Shares                                     | 3,480,250  | *             | 3,497,000  | 3,481,000  | 3,484,000  | 3,492,000  | 3,493,000  | 3,478,000  | *          | *          | *          | 3,464,000  |
| Total Operating Income as Reported                         | 7,076,000  | 1,583,000     | 2,717,000  | 1,605,000  | 1,171,000  | 2,064,000  | 1,764,000  | 2,399,000  | *          | *          | *          | 2,464,000  |
| Rent Expense Supplemental                                  | 1,003,000  | 242,000       | 247,000    | 245,000    | 269,000    | 296,000    | 301,000    | 338,000    | *          | *          | *          | *          |
| Total Expenses                                             | 89,930,000 | 24,117,000    | 22,410,000 | 23,273,000 | 20,130,000 | 23,103,000 | 21,586,000 | 22,528,000 | *          | *          | *          | 14,328,000 |
| Net Income from Continuing & Discontinued Operation        | 7,130,000  | 2,356,000     | 2,167,000  | 1,478,000  | 1,129,000  | 7,930,000  | 1,853,000  | 2,703,000  | *          | *          | *          | 2,259,000  |
| Normalized Income                                          | 7,677,200  | 2361901663.05 | 2,209,900  | 1,969,380  | 1,129,000  | 7,930,000  | 1,853,000  | 2,703,000  | *          | *          | *          | 2,389,640  |
| Interest Income                                            | 1,569,000  | 442,000       | 429,000    | 348,000    | 350,000    | 333,000    | 282,000    | 238,000    | *          | *          | *          | 26,000     |
| Interest Expense                                           | 350,000    | 96,000        | 92,000     | 86,000     | 76,000     | 61,000     | 38,000     | 28,000     | *          | *          | *          | 44,000     |
| Net Interest Income                                        | 1,219,000  | 346,000       | 337,000    | 262,000    | 274,000    | 272,000    | 244,000    | 210,000    | *          | *          | *          | -18,000    |
| EBIT                                                       | 9,340,000  | 2,862,000     | 2,876,000  | 1,973,000  | 1,629,000  | 2,252,000  | 2,083,000  | 2,965,000  | *          | *          | *          | 2,518,000  |
| EBITDA                                                     | 14,708,000 | 4,358,000     | 4,224,000  | 3,251,000  | 2,875,000  | 3,484,000  | 3,318,000  | 4,119,000  | *          | *          | *          | *          |
| Reconciled Cost of Revenue                                 | 80,240,000 | 21,528,000    | 20,185,000 | 20,922,000 | 17,605,000 | 20,729,000 | 19,172,000 | 20,394,000 | *          | *          | *          | 12,700,000 |
| Reconciled Depreciation                                    | 5,368,000  | 1,496,000     | 1,348,000  | 1,278,000  | 1,246,000  | 1,232,000  | 1,235,000  | 1,154,000  | *          | *          | *          | 922,000    |
| Net Income from Continuing Operation Net Minority Interest | 7,130,000  | 2,356,000     | 2,167,000  | 1,478,000  | 1,129,000  | 7,930,000  | 1,853,000  | 2,703,000  | *          | *          | *          | 2,259,000  |
| Total Unusual Items Excluding Goodwill                     | -684,000   | -7,000        | -55,000    | -622,000   | *          | 0          | 0          | 0          | *          | -34,000    | 0          | -142,000   |
| Total Unusual Items                                        | -684,000   | -7,000        | -55,000    | -622,000   | *          | 0          | 0          | 0          | *          | -34,000    | 0          | -142,000   |
| Normalized EBITDA                                          | 15,392,000 | 4,365,000     | 4,279,000  | 3,873,000  | 2,875,000  | 3,484,000  | 3,318,000  | 4,119,000  | *          | *          | *          | 3,582,000  |
| Tax Rate for Calcs                                         | 0.2        | 0.16          | 0.22       | 0.21       | 0.26       | 0.21       | 0.08       | 0.11       | *          | *          | *          | 0.08       |
| Tax Effect of Unusual Items                                | -136,800   | -1098336.95   | -12,100    | -130,620   | 0          | 0          | 0          | 0          | *          | *          | *          | -11,360    |
|------------------------------------------------------------+------------+---------------+------------+------------+------------+------------+------------+------------+------------+------------+------------+------------|
```

#### Example: Accessing Earnings Call Transcripts
##### Fetching transcripts list
```python
transcripts = ticker.earning_call_transcripts()
transcripts.get_transcripts_list()
```
```text
>>> transcripts = ticker.earning_call_transcripts()
>>> transcripts.get_transcripts_list()
   symbol  fiscal_year  fiscal_quarter report_date                                        transcripts  transcripts_id
0    TSLA         2011               2  2011-08-03  [{'paragraph_number': 1, 'speaker': 'Executive...          303288
1    TSLA         2011               3  2011-11-03  [{'paragraph_number': 1, 'speaker': 'Executive...          303289
2    TSLA         2011               4  2012-02-16  [{'paragraph_number': 1, 'speaker': 'Operator'...          303290
3    TSLA         2012               1  2012-05-09  [{'paragraph_number': 1, 'speaker': 'Executive...          303291
4    TSLA         2012               2  2012-07-25  [{'paragraph_number': 1, 'speaker': 'Executive...          303292
5    TSLA         2012               3  2012-11-05  [{'paragraph_number': 1, 'speaker': 'Executive...          303293
6    TSLA         2012               4  2013-02-20  [{'paragraph_number': 1, 'speaker': 'Executive...          303294
7    TSLA         2013               1  2013-05-08  [{'paragraph_number': 1, 'speaker': 'Executive...          303295
8    TSLA         2013               2  2013-08-07  [{'paragraph_number': 1, 'speaker': 'Executive...          303296
9    TSLA         2013               3  2013-11-05  [{'paragraph_number': 1, 'speaker': 'Executive...          303297
10   TSLA         2013               4  2014-02-19  [{'paragraph_number': 1, 'speaker': 'Executive...          303298
11   TSLA         2014               1  2014-05-08  [{'paragraph_number': 1, 'speaker': 'Executive...          303299
12   TSLA         2014               2  2014-08-01  [{'paragraph_number': 1, 'speaker': 'Executive...          303300
13   TSLA         2014               3  2014-11-05  [{'paragraph_number': 1, 'speaker': 'Executive...          303301
14   TSLA         2014               4  2015-02-12  [{'paragraph_number': 1, 'speaker': 'Executive...          303302
15   TSLA         2015               1  2015-05-05  [{'paragraph_number': 1, 'speaker': 'Executive...          303303
16   TSLA         2015               2  2015-07-30  [{'paragraph_number': 1, 'speaker': 'Executive...          303304
17   TSLA         2015               3  2015-10-30  [{'paragraph_number': 1, 'speaker': 'Executive...          303305
18   TSLA         2015               4  2016-02-10  [{'paragraph_number': 1, 'speaker': 'Executive...          303306
19   TSLA         2016               1  2016-05-05  [{'paragraph_number': 1, 'speaker': 'Executive...          303308
20   TSLA         2016               2  2016-08-03  [{'paragraph_number': 1, 'speaker': 'Executive...          303310
21   TSLA         2016               3  2016-10-27  [{'paragraph_number': 1, 'speaker': 'Executive...          303312
22   TSLA         2016               4  2017-02-23  [{'paragraph_number': 1, 'speaker': 'Executive...          303314
23   TSLA         2017               1  2017-05-04  [{'paragraph_number': 1, 'speaker': 'Executive...          303316
24   TSLA         2017               2  2017-08-03  [{'paragraph_number': 1, 'speaker': 'Executive...          303318
25   TSLA         2017               3  2017-11-02  [{'paragraph_number': 1, 'speaker': 'Executive...          303320
26   TSLA         2017               4  2018-02-07  [{'paragraph_number': 1, 'speaker': 'Executive...          303322
27   TSLA         2018               1  2018-05-03  [{'paragraph_number': 1, 'speaker': 'Executive...          303324
28   TSLA         2018               2  2018-08-02  [{'paragraph_number': 1, 'speaker': 'Executive...          303327
29   TSLA         2018               3  2018-10-25  [{'paragraph_number': 1, 'speaker': 'Executive...          303329
30   TSLA         2018               4  2019-01-31  [{'paragraph_number': 1, 'speaker': 'Operator'...          303331
31   TSLA         2019               1  2019-04-25  [{'paragraph_number': 1, 'speaker': 'Operator'...          303333
32   TSLA         2019               2  2019-07-24  [{'paragraph_number': 1, 'speaker': 'Operator'...          303335
33   TSLA         2019               3  2019-10-24  [{'paragraph_number': 1, 'speaker': 'Operator'...          303337
34   TSLA         2019               4  2020-01-30  [{'paragraph_number': 1, 'speaker': 'Operator'...          303339
35   TSLA         2020               1  2020-04-29  [{'paragraph_number': 1, 'speaker': 'Operator'...          303341
36   TSLA         2020               2  2020-07-22  [{'paragraph_number': 1, 'speaker': 'Operator'...          303343
37   TSLA         2020               3  2020-10-21  [{'paragraph_number': 1, 'speaker': 'Operator'...          303345
38   TSLA         2020               4  2021-01-27  [{'paragraph_number': 1, 'speaker': 'Operator'...          303347
39   TSLA         2021               1  2021-04-27  [{'paragraph_number': 1, 'speaker': 'Operator'...          303349
40   TSLA         2021               2  2021-07-26  [{'paragraph_number': 1, 'speaker': 'Operator'...          303350
41   TSLA         2021               3  2021-10-20  [{'paragraph_number': 1, 'speaker': 'Lars Mora...          303352
42   TSLA         2021               4  2022-01-26  [{'paragraph_number': 1, 'speaker': 'Martin Vi...          303355
43   TSLA         2022               1  2022-04-20  [{'paragraph_number': 1, 'speaker': 'Martin Vi...          303358
44   TSLA         2022               2  2022-07-20  [{'paragraph_number': 1, 'speaker': 'Martin Vi...          303360
45   TSLA         2022               3  2022-10-19  [{'paragraph_number': 1, 'speaker': 'Martin Vi...          303362
46   TSLA         2022               4  2023-01-25  [{'paragraph_number': 1, 'speaker': 'Martin Vi...          303364
47   TSLA         2023               1  2023-04-19  [{'paragraph_number': 1, 'speaker': 'Martin Vi...          303366
48   TSLA         2023               2  2023-07-19  [{'paragraph_number': 1, 'speaker': 'Martin Vi...          303370
49   TSLA         2023               3  2023-10-18  [{'paragraph_number': 1, 'speaker': 'Elon Musk...          303372
50   TSLA         2023               4  2024-01-24  [{'paragraph_number': 1, 'speaker': 'Martin Vi...          303374
51   TSLA         2024               1  2024-04-23  [{'paragraph_number': 1, 'speaker': 'Martin Vi...          303376
52   TSLA         2024               2  2024-07-24  [{'paragraph_number': 1, 'speaker': 'Travis Ax...          303378
53   TSLA         2024               3  2024-10-23  [{'paragraph_number': 1, 'speaker': 'Travis Ax...          303380
54   TSLA         2024               4  2025-01-29  [{'paragraph_number': 1, 'speaker': 'Operator'...          486436
```

##### Fetching the Q4 2024 Earnings Call Transcript
```python
transcripts = ticker.earning_call_transcripts()
transcripts.get_transcript(2024, 4)
```
```text
>>> transcripts.get_transcript(2024, 4)
    paragraph_number         speaker                                            content
0                  1        Operator  Good afternoon, everyone and welcome to Tesla'...
1                  2       Elon Musk  Thank you. So, in summary, in Q4, we set a rec...
2                  3  Travis Axelrod  Great. Thank you very much, Elon. And, Vaibhav...
3                  4  Vaibhav Taneja  Yeah, I'll talk about things on Earth. As Elon...
4                  5  Travis Axelrod  Great. Thank you very much, Vaibhav. Now, we w...
..               ...             ...                                                ...
74                75  Vaibhav Taneja  So, is your question, Dan, that how do we marr...
75                76  Travis Axelrod                 Go ahead and unmute yourself, Dan.
76                77        Dan Levy  Yeah. More so just how much more aggressively ...
77                78       Elon Musk  Well, right now, the constraint we're trying t...
78                79  Travis Axelrod  Great. Alrighty. And with that, I think we are...

[79 rows x 3 columns]
```

##### Print Formatted Table of 2024 Q4 Earnings Call

```python
transcripts = ticker.earning_call_transcripts()
transcripts.print_pretty_table(2024, 4)
```
```text
>>> transcripts.print_pretty_table(2024, 4)
Earnings Call Transcripts FY2024 Q4 (Reported on 2025-01-29)
+--------------------+-------------------------------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
|   paragraph_number | speaker                             | content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
+====================+=====================================+=========================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================+
|                  1 | Operator                            | Good afternoon, everyone and welcome to Tesla's Fourth Quarter 2024 Q&A Webcast. My name is Travis Axelrod, the Head of Investor Relations here at Tesla, and I am joined today by Elon Musk and Vaibhav Taneja and a number of other executives. Our Q4 results were announced at about 3.00 p.m. Central Time in the update deck we published at the same link as this webcast. During this call, we will discuss our business outlook and make forward-looking statements. These comments are based on our predictions and expectations as of today. Actual events or results could differ materially due to a number of risks and uncertainties, including those mentioned in our most recent filings with the SEC. During the question-and-answer portion of today's call, please limit yourself to one question and one follow-up. Please use the raise hand button to join the question queue. Before we jump into Q&A, Elon has some opening remarks. Elon?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
+--------------------+-------------------------------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
|                  2 | Elon Musk                           | Thank you. So, in summary, in Q4, we set a record and delivered vehicles at an annualized rate of nearly 2 million a year. So, congratulations to the Tesla team on excellent work, achieving record production and deliveries. Model Y was the best-selling vehicle of any kind for 2024. That's worth noting. Not just the best electric vehicle, the best vehicle of any kind on earth, number one was Model Y. We're staying focused on maximizing volumes and obviously doubling down for, I don't know what, it really, I was going to say doubling down on autonomy, but really it's like autonomy is like 10x-ing. Frankly, doubling is not even enough. We made many critical investments in 2024 in manufacturing AI and robotics that will bear immense fruit in the future, immense. Like it's, in fact, to such a scale that it is difficult to comprehend. And I've said this before, and I'll stand by it. I see a path, I'm not saying it's an easy path, but I see a path for Tesla being the most valuable company in the world by far, not even close. Like, maybe several times more than, I mean, there is a path where Tesla is worth more than the next top five companies combined. There's a path to that. I mean, I think it's like an incredibly, just like a difficult path, but it is an achievable path. So -- and that is overwhelmingly due to autonomous vehicles and autonomous humanoid robots. So, our focus is actually building towards that. And that's where we're laying the ground. We laid the ground work for that in 2024. We'll continue to lay the ground work for that in 2025. In fact, more than laid the groundwork actually, so it would be building the structure, it’d be we're building the manufacturing lines and like -- like, setting up for what I think will be an epic 2026 and a ridiculous ‘27 and ‘28. Ridiculously good. That is my prediction. As yet, very few people understand the value of Full Self Driving and our ability to monetize the fleet. I've -- some of these things I've said for quite a long time and I know people said, well, Elon is the boy who cried wolf like several times but I'm telling you there's a damn wolf this time and you can drive it. In fact, it can drive you. It's a self-driving wolf. For a lot of people, like their experience of Tesla autonomy is like, if it's even a year old, if it's even two years old, it's like meeting someone when they're like a toddler and thinking that they're going to be a toddler forever. But obviously they're not going to be a toddler forever if they grow up. But if their last experience was like, FSD was a toddler, it's like, well, it's grown up now. Have you seen it? It's like walks and talks. And that's really what we've got. And it's difficult for people to understand this because human intuition is linear as opposed to what we're seeing is exponential progress. So, that's why my number one recommendation for anyone who doubts is simply try it. Have you tried it? When's the last time you tried it? And the only people who are skeptical, the only people who are skeptical are those who have not tried it. So, a car goes -- a passenger car typically has only about 10 hours of utility per week out of 168. A very small percentage. Once that car is autonomous, my rough estimate is that it is in use for at least a third of the hours of the week. So, call it 50, maybe 55 hours of the week. And it can be useful both for cargo delivery and people delivery. So, even let's say people are asleep, but you can deliver packages in the middle of the night or resupply restaurants or whatever the case may be, whatever people need at all hours of the day or night. That same asset, the thing that these things that already exist with no incremental cost change, just a software update, now have five times or more the utility than they currently have. I think this will be the largest asset value increase in human history. Maybe there's something bigger, but I just don't know what it is. And so people who look in the rearview mirror are looking for past precedent, except I don't think there is one. So -- but the reality of autonomy is upon us. And I repeat my advice, try driving the car or let it drive you. So, now it works very well in the US, but of course it will over time work just as well everywhere else. So, we're working hard to grow our annual volumes. Our constraint this year -- our current constraint is battery packs this year, but we're working on addressing that constraint. And I think we will make progress on addressing that constraint. And then things are really going to go ballistic next year, and really ballistic in ‘27 and ‘28. So, yeah. So, a bit more on Full Self Driving. Our Q4 Vehicle Safety Report shows continued year-over-year improvement in safety for vehicles so that the safety numbers, if somebody has supervised Full Self Driving turned on or not, the safety differences are gigantic. So, and people have seen the immense improvement with Version 13 and with incremental versions in Version 13 and then Version 14 is going to be yet another step beyond that that is very significant. We launched the Cortex training cluster at Gigafactory Austin, which was a significant contributor to FSD advancement, and we continue to invest in training infrastructure out of Texas headquarters. So, the training needs for Optimus or Optimus humanoid robot are probably at least ultimately 10x of what's needed for the car, at least to get to the full range of useful roles. You can say, how many different roles are there for a humanoid robot versus a car? Humanoid robot has probably, well, 1000 times more uses and more complex things than in a car. That doesn't mean the training scales by a 1000, but it's probably 10x. Now you can do this progressively. So it doesn't mean like, or Tesla is going to spend like $500 billion in training compute. Because we obviously train Optimus to do enough tasks to match the output of Optimus robots. And obviously, the cost of training is dropping dramatically with time. So, it is one of those things where I think long-term, Optimus will be -- Optimus has the potential to be north of $10 trillion in revenue. Like, it's really bananas. So that you can obviously afford a lot of training compute in that situation. In fact, even $500 billion training compute in that situation would be quite a good deal. Yeah. The future's going to be incredibly different from the past, that's for sure. We live at this unbelievable inflection point in human history. So, yeah. So, the proof is in the pudding. So, we're going to be launching unsupervised Full Self Driving as a paid service in Austin in June. So -- and I've talked with the team. We feel confident in being able to do an initial launch of unsupervised, no one in the car, Full Self Driving in Austin in June. We already have Tesla's operating autonomously unsupervised Full Self Driving at our factory in Fremont and we’ll soon be doing that at our factory in Texas. So, thousands of cars every day are driving with no one in them at our Fremont factory in California. They will soon be doing that in Austin and then elsewhere in the world for the rest of our factories which is pretty cool. And the cars aren't just driving to exactly the same spot because obviously it all, [went and collide] (ph) at the same spot. The cars are actually programmed with what lane they need to park in to be picked up for delivery. So, they drive from the factory end of line to their specific - to their destination parking spot and then could be picked up for delivery to customers and then doing this reliably every day, thousands of times a day. It's pretty cool. Like I said, the Teslas will be in the wild with no one in them, in June in Austin. So, what I'm saying is this is not some far-off mythical situation. It's literally, five, six months away, five months away kind of thing. And while we're stepping into -- putting our toe in the water gently at first, just to make sure everything's cool, our solution is a generalized AI solution. It does not require high precision maps of a locality. So we just want to be cautious. It's not that it doesn't work beyond Austin. In fact, it does. We just want to be, put a toe in the water, make sure everything is okay, then put a few more toes in the water, then put a foot in the water with safety of the general public and those in the car as our top priority. With regard to Optimus, obviously I'm making these revenue predictions that sound absolutely insane. I realize that. But they are, I think, they will prove to be accurate. Yeah. Now, with Optimus, there's a lot of uncertainty on the exact timing, because it's not like a train arriving at the station for Optimus. We are designing the train and the station and in real time while also building the tracks. And so they're like, people shouldn’t say like, why didn't the train arrive exactly at 12:05? We're literally designing the train and the track and the station in real time while you're saying, how can we predict this thing with absolute precision? It's impossible. The normal internal plan calls for roughly 10,000 Optimus robots to be built this year. Will we succeed in building 10,000 exactly by the end of December this year? Probably not, but will we succeed in making several thousand? Yes, I think we will. Will those several thousand Optimus robots be doing useful things by the end of year? Yes, I'm confident they will do useful things. The Optimus in use at the Tesla factories, production design one, will inform how - what we change for production design two, which we expect to launch next year. And our goal is to ramp prompt Optimus production faster than maybe anything's ever been ramped. Meaning, like aspirationally an order of magnitude ramp per year. Now, if we aspire to an order of magnitude ramp per year, perhaps we only end up with a half order of magnitude per year. But that's the kind of growth that we're talking about. It doesn't take very many years before we're making 100 million of these things a year. If you go up by, let's say, a factor, by 5x per year, insane. Not 50%, 500%. So, these are big growth numbers. Yeah. But we do need to be -- this is an entirely new supply chain, is entirely new technology. There's nothing off the shelf to use. We try desperately with Optimus to use any existing motors, any actuators, sensors, nothing worked for our humanoid robot, at any price. We had to design everything from physics first principles to work for a humanoid robot and with the most sophisticated hand that has ever been made before, by far. And Optimus will be able to like play the piano and be able to thread a needle. I mean this is the level of precision no one has been able to achieve. And so it's really something special. So, yeah, so -- and my prediction long term is that Optimus will be overwhelmingly the value of the company. Regarding energy, back to Earth. Mr. Elon, can you come back here for a minute? Okay, back to Earth. Energy storage is a big deal and will become, it's already super important, will become incredibly important in the future. And it is something that enables far greater energy output to the grid than is currently possible. Because the grid, the grids are -- the vast majority of the grid has no energy storage capability. So, they have to design the power plants to, for very high peaks and assuming that there's no energy storage. Once you have grid energy storage and home-based energy storage, the actual total energy output per year of the grid is dramatically greater than people think. Maybe it's at least double. This will drive the demand of stationary battery packs, and especially the grid scale ones, to insane, basically as much demand as we could possibly make. So, we have our second factory, which is in Shanghai, that's starting operation and we're building a third factory. So we're trying to ramp output of the stationary battery storage as quickly as possible. Now, there is a challenge here where we have to be careful to that we're not robbing from one pocket to take to another pocket because for a given gigawatt hours per year of the cell output, we have to say, does it go into stationary applications or mobile applications? It can't go both into both. So, we have to make that trade-off. Yeah. But overall, the demand for total gigawatt hours of batteries, whether mobile or stationary, that will grow in a very, very big way over time. So, in conclusion, 2025 really is a pivotal year for Tesla. And when we look back on 2025 and the launch of unsupervised Full Self Driving, true real-world AI that actually works, I think they may regard it as the biggest year in Tesla history, maybe even bigger than our first car, the Roadster or the Model S, so the Model 3 or Model Y. In fact, I think it probably will be viewed ‘25 as maybe the most important year in Tesla's history. There is no company in the world that is as good at real-world AI as Tesla. I don't even know who’s in second place. Like, you say like who's in second place for real-world AI. I would need a very big telescope to see them. That's how far behind they are. All right. |
+--------------------+-------------------------------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
|                  3 | Travis Axelrod                      | Great. Thank you very much, Elon. And, Vaibhav has some opening remarks as well.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
+--------------------+-------------------------------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
|                  4 | Vaibhav Taneja                      | Yeah, I'll talk about things on Earth. As Elon mentioned, in Q4, we set records in vehicle deliveries and energy storage deployments in an uncertain macro environment. We were able to grow auto and energy storage volumes both sequentially and on a year-on-year basis. For this, I would like to thank the efforts of everyone at Tesla to make this a reality and our customers who helped us achieve this feat. Coming into the fourth quarter, our focus was to reduce inventory levels in the automotive business and we accomplished that by ending the quarter with the lowest finished good inventory in the last two years. This was a result of offering not only attractive financing options but also other discounts and programs which impacted ASPs. While we saw volume growth in almost all regions that we operate in, we hit a new record for deliveries in the Greater China market. This is an encouraging trend since we grew volume in a highly competitive BEV market. On the automotive margin front, we saw a quarter-over-quarter decline primarily due to lower ASPs and due to the recognition of FSD related revenue in Q3 from feature releases. Our journey on cost reduction continues, and we were able to get our overall cost per car down below $35,000, primarily by material costs. This was despite increased depreciation and other costs as we prepare for the transition to the new Model Y for which we recently started taking orders in all markets. All our factories will start producing the new Model Y next month while we feel confident in our team’s abilities to ramp production quickly, know that it is an unprecedented change and we are not aware of anybody else taking the best-selling car on the planet and updating all factories at the same time. This changeover will result in several weeks of lost production in the quarter. As a result, margins will be impacted due to idle capacity and other ramp related costs, as is common in any launch, but will be overcome as production is ramped. We will be introducing several new products throughout 2025. We are still on track to launch a more affordable model in the first half of 2025 and will continue to expand our lineup from there. From a dollar-for-dollar basis, we believe we have the most compelling lineup today compared to the industry, and it will continue to get better from here. As always, all our products come with the best software in the industry, autonomy features and capable of full autonomy in the future. And despite the premium experience, the total cost of ownership is close to mass market, less premium competitors. Energy storage deployments reached an all-time high in Q4, and this -- and resulted in -- but declined sequentially. This was a result of higher -- sorry, growth came from Megapack and Powerwall. Both businesses continue to be supply constrained, and like Elon mentioned, we're trying to ramp up production with Megafactory Shanghai coming online this quarter onwards. While quarterly deployments will likely continue to fluctuate sequentially, we expect at least 50% growth in deployments year-over-year in 2025. Gross profit and margins in the service and other business was up year-over-year but declined sequentially. This was the result of higher service center costs and lower profit from used car business. The businesses within service and other primarily support our new car business, especially through their impact on total cost of ownership. Therefore, while we manage them to be positive on a GAAP basis, we do not expect similar margins as the rest of the business. There's a lot of uncertainty around tariffs. Over the years, we've tried to localize our supply chain in every market, but we are still very reliant on parts from across the world for all our businesses. Therefore, the imposition of tariffs, which is very likely, and any [Indiscernible] will have an impact on our business and profitability. Our operating expenses grew both year-over-year and sequentially. The biggest driver of the increase was R&D as we continue to invest in AI-related initiatives. The remaining increase came from growth in our sales capabilities and marketing efforts from referral program. For 2025, we expect operating expenses to increase to support our growth initiatives. It is important to point out that the net income in Q4 was impacted by a $600 million mark-to-market benefit from Bitcoin due to the adoption of a new accounting standard for digital assets, whereby we will change -- we will take mark-to-market adjustments through other income every reporting period going forward. Our free cash flow for the quarter was $2 billion, and despite CapEx increase of over $2.4 billion in 2024, we were able to generate free cash flow of $3.6 billion for the year. CapEx efficiency is something we are extremely focused on. While we have invested in AI-related initiatives, we have done so in a very targeted manner to utilize the spend to get immediate benefits. The build-out of Cortex was accelerated because of the role -- actually to accelerate the rollout of FSD Version 13. Accumulative AI-related CapEx, including infrastructure, so far has been approximately $5 billion. And for 2025, we expect our CapEx to be flat on a year-over-year basis. In conclusion, like Elon said, 2025 is going to be a pivotal year for Tesla. There are a lot of investments which we have made and will continue to make in this coming year, which will set the pace for the next phase of growth. And it is something which now I'm getting out of earth, it is going to be out of this world. And we just are putting the right foundation. And that's all I have.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
+--------------------+-------------------------------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
|                  5 | Travis Axelrod                      | Great. Thank you very much, Vaibhav. Now, we will move over to investor questions and we'll start with say.com. The first question is, is unsupervised FSD still planned to be released in Texas and California this year? What hurdles still exist to make that happen? You addressed the Texas piece, I think, already, so...                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
|                   ...                                   ...                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                                                                                                                                                                                                                                                  
+--------------------+-------------------------------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
|                 75 | Vaibhav Taneja                      | So, is your question, Dan, that how do we marry our future growth aspects with FSD?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
+--------------------+-------------------------------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
|                 76 | Travis Axelrod                      | Go ahead and unmute yourself, Dan.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
+--------------------+-------------------------------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
|                 77 | Dan Levy                            | Yeah. More so just how much more aggressively you would be willing to sell your cars versus in light of your improvements on FSD.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
+--------------------+-------------------------------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
|                 78 | Elon Musk                           | Well, right now, the constraint we're trying to solve is battery production as opposed to demand. So, there are -- now Q1, we've got this massive factory retooling for the new Model Y, for example. That obviously has a short-term impact on output. But the problem we are seeing with, in fact, we're talking that the executive team and I were talking about just before this call was we've got to figure out how to increase total gigawatt hours of battery production this year one way or another. That's the constraint on our output.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
+--------------------+-------------------------------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
|                 79 | Travis Axelrod                      | Great. Alrighty. And with that, I think we are all done for today. So, thanks, everyone, so much for all your questions. We look forward to talking to you next quarter. Thank you very much, and goodbye.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
+--------------------+-------------------------------------+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
```
##### Accessing Financial News

```python
news = ticker.news()
news.print_pretty_table("b67526eb-581a-35b2-8357-b4f282fe876f")
```
```text
>>> news.print_pretty_table("b67526eb-581a-35b2-8357-b4f282fe876f")
                           3 of the Cheapest Artificial Intelligence Stocks to Buy Right Now                            
╭──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮
│                                           Motley Fool / 2025-06-06 / STORY                                           │
│                                                  [AMD, BABA, GOOG]                                                   │
│          https://finance.yahoo.com/m/b67526eb-581a-35b2-8357-b4f282fe876f/3-of-the-cheapest-artificial.html          │
│                                                                                                                      │
│Key Points                                                                                                            │
│                                                                                                                      │
│The tech companies listed here are all investing heavily in artificial intelligence.                                  │
│                                                                                                                      │
│Their valuations are modest when factoring in their long-term growth opportunities.                                   │
│                                                                                                                      │
│10 stocks we like better than Alphabet ›                                                                              │
│                                                                                                                      │
│Want to add some promising artificial intelligence (AI) stocks to your portfolio, without paying an obscene price?    │
│While many stocks are trading at inflated valuations, there are still many good options out there to consider, which  │
│can deliver strong returns for your portfolio.                                                                        │
│                                                                                                                      │
│Three AI stocks that possess a lot of upside and are among the cheapest options for growth investors to buy right now │
│are Alphabet (NASDAQ: GOOG)(NASDAQ: GOOGL), Alibaba Group Holdings (NYSE: BABA), and Advanced Micro Devices (NASDAQ:  │
│AMD). Here's why it may not be too late to invest in these stocks.                                                    │
│                                                                                                                      │
│Alphabet                                                                                                              │
│                                                                                                                      │
│Shares of Alphabet are down around 11% this year as investors are concerned about antitrust issues and a possible     │
│breakup of the business, or at the very least, changes to its core operations. But there's a lot to like about the    │
│business. The company is planning to spend $75 billion on capital expenditures this year as it works on creating next-│
│generation technologies.                                                                                              │
│                                                                                                                      │
│Alphabet's core business also still looks solid. Investors shouldn't forget that while ChatGPT has been around for    │
│multiple years now, Alphabet's ad business still remains strong -- the popular chatbot hasn't made a big dent in the  │
│company's earnings. During the first three months of this year, Alphabet's revenue totaled $90.2 billion, which came  │
│in better than expectations and rose by 12% year over year.                                                           │
│                                                                                                                      │
│Earlier this year, it announced plans to acquire cybersecurity company Wiz for $32 billion. It's a great asset to add │
│into the mix to enhance its growth prospects even further. Alphabet already has its own chatbot, Gemini, a robotaxi in│
│Waymo, plus its amazingly popular core assets -- YouTube and Google Search. With an abundance of growth potential,    │
│Alphabet looks like a steal of a deal, trading at just 19 times its trailing earnings.                                │
│                                                                                                                      │
│Alibaba Group Holdings                                                                                                │
│                                                                                                                      │
│If you're looking for more of a discounted AI stock to buy, then Alibaba may be to your liking. At 15 times its       │
│trailing earnings, its valuation is low and it compensates investors for the risk that comes with buying shares of    │
│this Chinese company.                                                                                                 │
│                                                                                                                      │
│Alibaba recently released its latest AI model, Qwen3, which uses "hybrid reasoning" that can balance deep-thinking    │
│tasks alongside more standardized questions where speed is important. Tech giant Apple has partnered with Alibaba and │
│is integrating the Chinese company's AI in its new iPhones, which is a great testament to the effectiveness and       │
│potential for Alibaba's AI in the future.                                                                             │
│                                                                                                                      │
│During the first three months of the year, Alibaba says its AI-related product revenue grew by triple digits for a    │
│seventh straight quarter. Although its total revenue grew by just 7% to $32.6 billion, Alibaba's vast business (which │
│includes online retail, cloud, and logistics) is why its AI revenue isn't standing out more. But there's potential for│
│it to be a huge growth catalyst for years to come.                                                                    │
│                                                                                                                      │
│Advanced Micro Devices                                                                                                │
│                                                                                                                      │
│Investing in a top chipmaker is another good way to gain a position in AI. Advanced Micro Devices, also known as AMD, │
│is one of Nvidia's main rivals.                                                                                       │
│                                                                                                                      │
│The stock doesn't look terribly cheap as it's trading at a price-to-earnings multiple of 80. But when you look at its │
│price/earnings-to-growth (PEG) multiple, which factors in how much growth analysts are expecting over the coming      │
│years, that ratio is at less than 0.6. For growth investors, anything less than one is a good multiple for PEG, and   │
│AMD is well below that level.                                                                                         │
│                                                                                                                      │
│The company's business has been doing well recently with AMD's revenue rising by 36% for the period ending March 29,  │
│totaling $7.4 billion. Its new AI chips are proving to be in high demand, and if the company can keep on this pace,   │
│then there could be a lot of upside for AMD down the road.                                                            │
│                                                                                                                      │
│CEO Lisa Su has previously forecast that its AI chip business could bring in tens of billions in potential revenue in │
│the future. And if those projections turn out true, then this could indeed become one of the best AI stocks to buy    │
│right now.                                                                                                            │
│                                                                                                                      │
│Should you invest $1,000 in Alphabet right now?                                                                       │
│                                                                                                                      │
│Before you buy stock in Alphabet, consider this:                                                                      │
│                                                                                                                      │
│The Motley Fool Stock Advisor analyst team just identified what they believe are the 10 best stocks for investors to  │
│buy now… and Alphabet wasn’t one of them. The 10 stocks that made the cut could produce monster returns in the coming │
│years.                                                                                                                │
│                                                                                                                      │
│Consider when Netflix made this list on December 17, 2004... if you invested $1,000 at the time of our                │
│recommendation, you’d have $668,538!* Or when Nvidia made this list on April 15, 2005... if you invested $1,000 at the│
│time of our recommendation, you’d have $869,841!*                                                                     │
│                                                                                                                      │
│Now, it’s worth noting Stock Advisor’s total average return is 789% — a market-crushing outperformance compared       │
│to 172% for the S&P 500. Don’t miss out on the latest top 10 list, available when you join Stock Advisor.             │
│                                                                                                                      │
│See the 10 stocks »                                                                                                   │
│                                                                                                                      │
│*Stock Advisor returns as of June 2, 2025                                                                             │
│                                                                                                                      │
│Suzanne Frey, an executive at Alphabet, is a member of The Motley Fool's board of directors. David Jagielski has no   │
│position in any of the stocks mentioned. The Motley Fool has positions in and recommends Advanced Micro Devices,      │
│Alphabet, Apple, and Nvidia. The Motley Fool recommends Alibaba Group. The Motley Fool has a disclosure policy.       │
│                                                                                                                      │
│3 of the Cheapest Artificial Intelligence Stocks to Buy Right Now was originally published by The Motley Fool         │
│                                                                                                                      │
╰──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯
```

### Advanced Usage

See [Advanced Usage](doc/Advanced_Guide) for details.