# 🧲 **Magg** - *The MCP Aggregator*

[//]: # ([![Tests]&#40;https://img.shields.io/github/actions/workflow/status/sitbon/magg/test.yml?style=flat-square&label=tests&#41;]&#40;https://github.com/sitbon/magg/actions/workflows/test.yml&#41;)
[![Python Version](https://img.shields.io/pypi/pyversions/magg?style=flat-square&logo=python&logoColor=white)](https://pypi.org/project/magg/)
[![PyPI Version](https://img.shields.io/pypi/v/magg?style=flat-square&logo=pypi&logoColor=white)](https://pypi.org/project/magg/)
[![GitHub Release](https://img.shields.io/github/v/release/sitbon/magg?style=flat-square&logo=github)](https://github.com/sitbon/magg/releases)
[![DeepWiki](https://img.shields.io/badge/DeepWiki-sitbon%2Fmagg-blue.svg?logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACwAAAAyCAYAAAAnWDnqAAAAAXNSR0IArs4c6QAAA05JREFUaEPtmUtyEzEQhtWTQyQLHNak2AB7ZnyXZMEjXMGeK/AIi+QuHrMnbChYY7MIh8g01fJoopFb0uhhEqqcbWTp06/uv1saEDv4O3n3dV60RfP947Mm9/SQc0ICFQgzfc4CYZoTPAswgSJCCUJUnAAoRHOAUOcATwbmVLWdGoH//PB8mnKqScAhsD0kYP3j/Yt5LPQe2KvcXmGvRHcDnpxfL2zOYJ1mFwrryWTz0advv1Ut4CJgf5uhDuDj5eUcAUoahrdY/56ebRWeraTjMt/00Sh3UDtjgHtQNHwcRGOC98BJEAEymycmYcWwOprTgcB6VZ5JK5TAJ+fXGLBm3FDAmn6oPPjR4rKCAoJCal2eAiQp2x0vxTPB3ALO2CRkwmDy5WohzBDwSEFKRwPbknEggCPB/imwrycgxX2NzoMCHhPkDwqYMr9tRcP5qNrMZHkVnOjRMWwLCcr8ohBVb1OMjxLwGCvjTikrsBOiA6fNyCrm8V1rP93iVPpwaE+gO0SsWmPiXB+jikdf6SizrT5qKasx5j8ABbHpFTx+vFXp9EnYQmLx02h1QTTrl6eDqxLnGjporxl3NL3agEvXdT0WmEost648sQOYAeJS9Q7bfUVoMGnjo4AZdUMQku50McDcMWcBPvr0SzbTAFDfvJqwLzgxwATnCgnp4wDl6Aa+Ax283gghmj+vj7feE2KBBRMW3FzOpLOADl0Isb5587h/U4gGvkt5v60Z1VLG8BhYjbzRwyQZemwAd6cCR5/XFWLYZRIMpX39AR0tjaGGiGzLVyhse5C9RKC6ai42ppWPKiBagOvaYk8lO7DajerabOZP46Lby5wKjw1HCRx7p9sVMOWGzb/vA1hwiWc6jm3MvQDTogQkiqIhJV0nBQBTU+3okKCFDy9WwferkHjtxib7t3xIUQtHxnIwtx4mpg26/HfwVNVDb4oI9RHmx5WGelRVlrtiw43zboCLaxv46AZeB3IlTkwouebTr1y2NjSpHz68WNFjHvupy3q8TFn3Hos2IAk4Ju5dCo8B3wP7VPr/FGaKiG+T+v+TQqIrOqMTL1VdWV1DdmcbO8KXBz6esmYWYKPwDL5b5FA1a0hwapHiom0r/cKaoqr+27/XcrS5UwSMbQAAAABJRU5ErkJggg==)](https://deepwiki.com/sitbon/magg)
[![Downloads](https://img.shields.io/pypi/dm/magg?style=flat-square)](https://pypistats.org/packages/magg)
<!-- DeepWiki badge generated by https://deepwiki.ryoppippi.com/ -->

[![Tests](https://github.com/sitbon/magg/actions/workflows/test.yml/badge.svg)](https://github.com/sitbon/magg/actions/workflows/test.yml)
[![Docker](https://github.com/sitbon/magg/actions/workflows/docker-publish.yml/badge.svg)](https://github.com/sitbon/magg/actions/workflows/docker-publish.yml)

A *[Model Context Protocol](https://modelcontextprotocol.io/)* server that manages, aggregates, and proxies other MCP servers, enabling LLMs to dynamically extend their own capabilities.

## What is Magg?

Magg is a meta-MCP server that acts as a central hub for managing multiple MCP servers. It provides tools that allow LLMs to:

- Search for new MCP servers and discover setup instructions
- Add and configure MCP servers dynamically
- Enable/disable servers on demand
- Aggregate tools from multiple servers under unified prefixes
- Persist configurations across sessions

Think of Magg as a "package manager for LLM tools" - it lets AI assistants install and manage their own capabilities at runtime.

## Features

- **Self-Service Tool Management**: LLMs can search for and add new MCP servers without human intervention.
- **Dynamic Configuration Reloading**: Automatically detects and applies config changes without restarting.
- **Automatic Tool Proxying**: Tools from added servers are automatically exposed with configurable prefixes.
- **ProxyMCP Tool**: A built-in tool that proxies the MCP protocol to itself, for clients that don't support notifications or dynamic tool updates (which is most of them currently).
- **Smart Configuration**: Uses MCP sampling to intelligently configure servers from just a URL.
- **Persistent Configuration**: Maintains server configurations in `.magg/config.json`.
- **Multiple Transport Support**: Works with stdio, HTTP, and in-memory transports.
- **Bearer Token Authentication**: Optional RSA-based JWT authentication for secure HTTP access.
- **Docker Support**: Pre-built images for production, staging, and development workflows.
- **Health Monitoring**: Built-in `magg_status` and `magg_check` tools for server health checks.
- **Real-time Messaging**: Full support for MCP notifications and messages - receive tool/resource updates and progress notifications from backend servers.
- **Python 3.12+ Support**: Fully compatible with Python 3.12 and 3.13.
- **Kit Management**: Bundle related MCP servers into kits for easy loading/unloading as a group.
- **MBro CLI**: Included [MCP Browser](docs/mbro.md) for interactive exploration and management of MCP servers, with script support for automation.

## Installation

### Prerequisites

- Python 3.12 or higher (3.13+ recommended)
- `uv` (recommended) - Install from [astral.sh/uv](https://astral.sh/uv)

### Quick Install (Recommended)

The easiest way to install Magg is as a tool using `uv`:

```bash
# Install Magg as a tool
uv tool install magg

# Run with stdio transport (for Claude Desktop, Cline, etc.)
magg serve

# Run with HTTP transport (for system-wide access)
magg serve --http
```

### Alternative: Run Directly from GitHub

You can also run Magg directly from GitHub without installing:

```bash
# Run with stdio transport
uvx --from git+https://github.com/sitbon/magg.git magg

# Run with HTTP transport
uvx --from git+https://github.com/sitbon/magg.git magg serve --http
```

### Local Development

For development, clone the repository and install in editable mode:

```bash
# Clone the repository
git clone https://github.com/sitbon/magg.git
cd magg

# Install in development mode with dev dependencies
uv sync --dev

# Or with poetry
poetry install --with dev

# Run the CLI
magg --help
```

### Docker

Magg is available as pre-built Docker images from GitHub Container Registry:

```bash
# Run production image (WARNING log level)
docker run -p 8000:8000 ghcr.io/sitbon/magg:latest

# Run with authentication (mount or set private key)
docker run -p 8000:8000 \
  -v ~/.ssh/magg:/home/magg/.ssh/magg:ro \
  ghcr.io/sitbon/magg:latest

# Or with environment variable
docker run -p 8000:8000 \
  -e MAGG_PRIVATE_KEY="$(cat ~/.ssh/magg/magg.key)" \
  ghcr.io/sitbon/magg:latest

# Run beta image (INFO log level)
docker run -p 8000:8000 ghcr.io/sitbon/magg:beta

# Run with custom config directory
docker run -p 8000:8000 \
  -v /path/to/config:/home/magg/.magg \
  ghcr.io/sitbon/magg:latest
```

#### Docker Image Strategy

Magg uses a multi-stage Docker build with three target stages:

- **`pro` (Production)**: Minimal image with WARNING log level, suitable for production deployments
- **`pre` (Pre-production)**: Same as production but with INFO log level for staging/testing (available but not published)
- **`dev` (Development)**: Includes development dependencies and DEBUG logging for troubleshooting

Images are automatically published to GitHub Container Registry with the following tags:

- **Version tags** (from main branch): `1.2.3`, `1.2`, `dev`, `1.2-dev`, `1.2-dev-py3.12`, etc.
- **Branch tags** (from beta branch): `beta`, `beta-dev`
- **Python-specific dev tags**: `beta-dev-py3.12`, `beta-dev-py3.13`, etc.

#### Docker Compose

For easier management, use Docker Compose:

```bash
# Clone the repository
git clone https://github.com/sitbon/magg.git
cd magg

# Run production version
docker compose up magg

# Run staging version (on port 8001)
docker compose up magg-beta

# Run development version (on port 8008)
# This uses ./.magg/config.json for configuration
docker compose up magg-dev

# Build and run with custom registry
REGISTRY=my.registry.com docker compose build
REGISTRY=my.registry.com docker compose push
```

See `compose.yaml` and `.env.example` for configuration options.

## Usage

### Running Magg

Magg can run in three modes:

1. **Stdio Mode** (default) - For integration with Claude Desktop, Cline, Cursor, etc.:
   ```bash
   magg serve
   ```

2. **HTTP Mode** - For system-wide access or web integrations:
   ```bash
   magg serve --http --port 8000
   ```

3. **Hybrid Mode** - Both stdio and HTTP simultaneously:
   ```bash
   magg serve --hybrid
   magg serve --hybrid --port 8080  # Custom port
   ```
   
   This is particularly useful when you want to use Magg through an MCP client while also allowing HTTP access. For example:
   
   **With Claude Code:**
   ```bash
   # Configure Claude Code to use Magg in hybrid mode
   claude mcp add magg -- magg serve --hybrid --port 42000
   ```
   
   **With mbro:**
   ```bash
   # mbro hosts Magg and connects via stdio
   mbro connect magg "magg serve --hybrid --port 8080"
   
   # Other mbro instances can connect via HTTP
   mbro connect magg http://localhost:8080
   ```

### Available Tools

Once Magg is running, it exposes the following tools to LLMs:

- `magg_list_servers` - List all configured MCP servers
- `magg_add_server` - Add a new MCP server
- `magg_remove_server` - Remove a server
- `magg_enable_server` / `magg_disable_server` - Toggle server availability
- `magg_search_servers` - Search for MCP servers online
- `magg_list_tools` - List all available tools from all servers
- `magg_smart_configure` - Intelligently configure a server from a URL
- `magg_analyze_servers` - Analyze configured servers and suggest improvements
- `magg_status` - Get server and tool statistics
- `magg_check` - Health check servers with repair actions (report/remount/unmount/disable)
- `magg_reload_config` - Reload configuration from disk and apply changes
- `magg_load_kit` - Load a kit and its servers into the configuration
- `magg_unload_kit` - Unload a kit and optionally its servers from the configuration
- `magg_list_kits` - List all available kits with their status
- `magg_kit_info` - Get detailed information about a specific kit

### Quick Inspection with MBro

Magg includes the `mbro` (MCP Browser) CLI tool for interactive exploration. A unique feature is the ability to connect to Magg in stdio mode for quick inspection:

```bash
# Connect mbro to a Magg instance via stdio (no HTTP server needed)
mbro connect local-magg magg serve

# Now inspect your Magg setup from the MCP client perspective
mbro:local-magg> call magg_status
mbro:local-magg> call magg_list_servers
```

MBro also supports:
- **Scripts**: Create `.mbro` files with commands for automation
- **Shell-style arguments**: Use `key=value` syntax instead of JSON
- **Tab completion**: Rich parameter hints after connecting

See the [MBro Documentation](docs/mbro.md) for details.

### Authentication

Magg supports optional bearer token authentication to secure access:

#### Quick Start

1. **Initialize authentication** (creates RSA keypair):
   ```bash
   magg auth init
   ```

2. **Generate a JWT token** for clients:
   ```bash
   # Generate token (displays on screen)
   magg auth token
   
   # Export as environment variable
   export MAGG_JWT=$(magg auth token -q)
   ```

3. **Connect with authentication**:
   - Using `MaggClient` (auto-loads from MAGG_JWT):
     ```python
     from magg.client import MaggClient
     
     async def main():
         async with MaggClient("http://localhost:8000/mcp") as client:
             tools = await client.list_tools()
     ```
   - Using FastMCP with explicit token:
     ```python
     from fastmcp import Client
     from fastmcp.client import BearerAuth
     
     jwt_token = "your-jwt-token-here"
     async with Client("http://localhost:8000/mcp", auth=BearerAuth(jwt_token)) as client:
         tools = await client.list_tools()
     ```

#### Key Management

- Keys are stored in `~/.ssh/magg/` by default
- Private key can be set via `MAGG_PRIVATE_KEY` environment variable
- To disable auth, remove keys or set non-existent `key_path` in `.magg/auth.json`

#### Authentication Commands

- `magg auth init` - Initialize authentication (generates RSA keypair)
- `magg auth status` - Check authentication configuration
- `magg auth token` - Generate JWT token
- `magg auth public-key` - Display public key (for verification)
- `magg auth private-key` - Display private key (for backup)

See [examples/authentication.py](examples/authentication.py) for more usage patterns.

### Configuration

Magg stores its configuration in `.magg/config.json` in your current working directory. This allows for project-specific tool configurations.

#### Dynamic Configuration Reloading

Magg supports automatic configuration reloading without requiring a restart:

- **Automatic file watching**: Detects changes to `config.json` and reloads automatically (uses watchdog when available)
- **SIGHUP signal**: Send `kill -HUP <pid>` to trigger immediate reload (Unix-like systems)
- **MCP tool**: Use `magg_reload_config` tool from any MCP client
- **Smart transitions**: Only affected servers are restarted during reload

Configuration reload is enabled by default. You can control it with:
- `MAGG_AUTO_RELOAD=false` - Disable automatic reloading
- `MAGG_RELOAD_POLL_INTERVAL=5.0` - Set polling interval in seconds (when watchdog unavailable)

See [Configuration Reload Documentation](docs/config-reload.md) for detailed information.

#### Environment Variables

Magg supports several environment variables for configuration:
- `MAGG_CONFIG_PATH` - Path to config file (default: `.magg/config.json`)
- `MAGG_LOG_LEVEL` - Logging level: DEBUG, INFO, WARNING, ERROR, CRITICAL (default: INFO)
- `MAGG_STDERR_SHOW=1` - Show stderr output from subprocess MCP servers (default: suppressed)
- `MAGG_AUTO_RELOAD` - Enable/disable config auto-reload (default: true)
- `MAGG_RELOAD_POLL_INTERVAL` - Config polling interval in seconds (default: 1.0)
- `MAGG_READ_ONLY=true` - Run in read-only mode
- `MAGG_SELF_PREFIX` - Prefix for Magg tools (default: "magg"). Tools will be named as `{prefix}{sep}{tool}` (e.g., `magg_list_servers`)
- `MAGG_PREFIX_SEP` - Separator between prefix and tool name (default: "_")

Example configuration:
```json
{
  "servers": {
    "calculator": {
      "name": "calculator",
      "source": "https://github.com/executeautomation/calculator-mcp",
      "command": "npx @executeautomation/calculator-mcp",
      "prefix": "calc",
      "enabled": true
    }
  }
}
```

### Adding Servers

Servers can be added in several ways:

1. **Using the LLM** (recommended):
   ```
   "Add the Playwright MCP server"
   "Search for and add a calculator tool"
   ```

2. **Manual configuration** via `magg_add_server`:
   ```
   name: playwright
   url: https://github.com/microsoft/playwright-mcp
   command: npx @playwright/mcp@latest
   prefix: pw
   ```

3. **Direct config editing**: Edit `.magg/config.json` directly

### Real-time Notifications with MaggClient

The `MaggClient` now supports real-time notifications from backend MCP servers:

```python
from magg import MaggClient, MaggMessageHandler

# Using callbacks
handler = MaggMessageHandler(
    on_tool_list_changed=lambda n: print("Tools changed!"),
    on_progress=lambda n: print(f"Progress: {n.params.progress}")
)

async with MaggClient("http://localhost:8000/mcp", message_handler=handler) as client:
    # Client will receive notifications while connected
    tools = await client.list_tools()
```

See [Messaging Documentation](docs/messaging.md) for advanced usage including custom message handlers.

### Kit Management

Magg supports organizing related MCP servers into "kits" - bundles that can be loaded and unloaded as a group:

```bash
# List available kits
magg kit list

# Load a kit (adds all its servers)
magg kit load web-tools

# Unload a kit (removes servers only in that kit)
magg kit unload web-tools

# Get information about a kit
magg kit info web-tools
```

You can also manage kits programmatically through Magg's tools when connected via an MCP client:
- `magg_list_kits` - List all available kits
- `magg_load_kit` - Load a kit and its servers
- `magg_unload_kit` - Unload a kit
- `magg_kit_info` - Get detailed kit information

Kits are JSON files stored in `~/.magg/kit.d/` or `.magg/kit.d/` that define a collection of related servers. See [Kit Documentation](docs/kits.md) for details on creating and managing kits.

### MBro Scripts

Automate common workflows with MBro scripts:

```bash
# Create a setup script
cat > setup.mbro <<EOF
# Connect to Magg and check status
connect magg magg serve
call magg_status
call magg_list_servers

# Add a new server if needed
call magg_add_server name=calculator source="npx -y @modelcontextprotocol/server-calculator"
EOF

# Run the script
mbro -x setup.mbro
```

## Documentation

For more documentation, see [docs/](docs/index.md).

## Appearances

Magg appears in multiple locations. Please feel free to submit a PR to add more appearances below in alphabetical order.

### Listing, Index, and other MCP Sites

* [DeepWiki](https://deepwiki.com/sitbon/magg) - AI-generated documentation
* [Glama.ai](https://glama.ai/mcp/servers/@sitbon/magg) - MCP server listing and hosting

### Awesome GitHub MCP Lists

* [@punkpeye/awesome-mcp-servers](https://github.com/punkpeye/awesome-mcp-servers)
* [@wong2/awesome-mcp-servers](https://github.com/wong2/awesome-mcp-servers)
