"""
RIT API Client - Python wrapper for the Rotman Interactive Trader REST API.

This package provides a comprehensive interface for interacting with the RIT API,
with built-in error handling, rate limiting, and pandas DataFrame support.

Example usage:
    >>> from rit_client import RITClient
    >>> client = RITClient()
    >>> securities = client.get_securities()
    >>> news = client.get_news(limit=10)
"""

from .client import RITClient
from .exceptions import (
    RITException,
    RateLimitException,
    AuthenticationException,
    EndpointNotAvailableException,
    OrderException,
    InvalidParameterException,
)
from .config import Config
from .__version__ import __version__, __author__, __description__

__all__ = [
    # Main client
    "RITClient",
    # Exceptions
    "RITException",
    "RateLimitException",
    "AuthenticationException",
    "EndpointNotAvailableException",
    "OrderException",
    "InvalidParameterException",
    # Configuration
    "Config",
    # Metadata
    "__version__",
    "__author__",
    "__description__",
]
