"""
Configuration for RIT API client.
"""

import os
from dotenv import load_dotenv

load_dotenv()


class Config:
    """RIT API configuration."""

    RIT_API_KEY = os.environ.get("RIT_API_KEY")
    BASE_URL = os.environ.get("RIT_BASE_URL", "http://localhost:9999/v1")
    MAX_RETRIES = int(os.environ.get("RIT_MAX_RETRIES", "3"))
    RETRY_DELAY = float(os.environ.get("RIT_RETRY_DELAY", "0.5"))
    TIMEOUT = int(os.environ.get("RIT_TIMEOUT", "10"))

    @classmethod
    def validate(cls):
        """Validate required configuration."""
        if not cls.RIT_API_KEY:
            raise ValueError(
                "RIT_API_KEY not found in environment variables. "
                "Please create a .env file with RIT_API_KEY=your_key"
            )
