"""
Custom exceptions for the RIT API wrapper.
"""


class RITException(Exception):
    """Base exception for RIT API errors."""
    pass


class RateLimitException(RITException):
    """Raised when API rate limit is exceeded."""
    def __init__(self, wait_time: float, message: str = "Rate limit exceeded"):
        self.wait_time = wait_time
        self.message = f"{message}. Retry after {wait_time} seconds."
        super().__init__(self.message)


class AuthenticationException(RITException):
    """Raised when authentication fails."""
    pass


class EndpointNotAvailableException(RITException):
    """Raised when an endpoint is not available in the current case."""
    pass


class OrderException(RITException):
    """Raised when order placement or management fails."""
    pass


class InvalidParameterException(RITException):
    """Raised when invalid parameters are provided."""
    pass
