import unittest

import numpy as np

from inmoose.deseq2 import makeExampleDESeqDataSet, varianceStabilizingTransformation


class Test(unittest.TestCase):
    def test_varianceStabilizingTransform(self):
        """check that variance StabilizingTransform works as expected"""
        dds = makeExampleDESeqDataSet(n=15, m=12, seed=42)
        vst = varianceStabilizingTransformation(dds)

        ref = np.array(
            [
                [
                    3.823017,
                    3.8230169,
                    5.985321,
                    4.913315,
                    4.161231,
                    1.494246,
                    4.823440,
                    5.450071,
                    3.823017,
                    1.3401978,
                    3.595272,
                    3.823017,
                ],
                [
                    -0.451858,
                    0.6581684,
                    2.810054,
                    1.254434,
                    -0.451858,
                    4.077032,
                    -0.451858,
                    -0.451858,
                    4.086414,
                    -0.4518580,
                    1.546176,
                    2.955590,
                ],
                [
                    8.061588,
                    6.3072368,
                    4.637324,
                    1.851704,
                    4.161231,
                    7.255872,
                    0.824648,
                    5.171055,
                    5.671037,
                    5.1710549,
                    5.919773,
                    8.977944,
                ],
                [
                    4.243021,
                    6.7404002,
                    6.359506,
                    2.576007,
                    5.365497,
                    5.015233,
                    2.906480,
                    8.951864,
                    4.671504,
                    5.9054920,
                    6.892472,
                    5.308661,
                ],
                [
                    2.178302,
                    -0.4518580,
                    1.105434,
                    -0.451858,
                    1.395415,
                    -0.451858,
                    -0.451858,
                    3.694642,
                    3.500141,
                    0.6253966,
                    3.595272,
                    -0.451858,
                ],
                [
                    2.955590,
                    -0.4518580,
                    -0.451858,
                    2.576007,
                    1.847902,
                    1.494246,
                    0.824648,
                    3.183966,
                    3.500141,
                    1.3401978,
                    3.135366,
                    4.359573,
                ],
                [
                    -0.451858,
                    3.3285650,
                    1.664144,
                    2.261056,
                    1.641409,
                    2.586723,
                    4.623337,
                    6.141930,
                    -0.451858,
                    -0.4518580,
                    2.834227,
                    6.598715,
                ],
                [
                    4.359573,
                    2.0207666,
                    4.118937,
                    1.851704,
                    4.233253,
                    2.920369,
                    -0.451858,
                    3.183966,
                    2.057386,
                    1.0399000,
                    1.012888,
                    4.359573,
                ],
                [
                    2.178302,
                    -0.4518580,
                    -0.451858,
                    6.038225,
                    5.755725,
                    3.416888,
                    2.327658,
                    3.183966,
                    3.082433,
                    3.9153624,
                    5.408736,
                    -0.451858,
                ],
                [
                    3.226560,
                    3.2613786,
                    2.992774,
                    3.553961,
                    2.184300,
                    1.494246,
                    0.824648,
                    -0.451858,
                    -0.451858,
                    1.0399000,
                    3.264959,
                    -0.451858,
                ],
                [
                    5.249530,
                    1.0834807,
                    2.992774,
                    3.925805,
                    4.896815,
                    6.210543,
                    4.823440,
                    6.519649,
                    5.630417,
                    -0.4518580,
                    4.875050,
                    7.268652,
                ],
                [
                    4.749485,
                    4.3272243,
                    4.791961,
                    5.117967,
                    2.962466,
                    4.791961,
                    4.791961,
                    4.367923,
                    6.588150,
                    5.6595787,
                    4.791961,
                    4.749485,
                ],
                [
                    5.472762,
                    2.3195612,
                    3.154617,
                    3.688910,
                    4.896815,
                    4.791961,
                    4.163592,
                    3.183966,
                    2.816266,
                    3.1140628,
                    1.012888,
                    6.972229,
                ],
                [
                    3.650416,
                    4.1161861,
                    4.335770,
                    6.507277,
                    6.111061,
                    8.069817,
                    5.319135,
                    5.736698,
                    5.786454,
                    -0.4518580,
                    7.342527,
                    7.587853,
                ],
                [
                    4.910890,
                    1.6362631,
                    4.690736,
                    6.817270,
                    1.847902,
                    6.556714,
                    3.832819,
                    3.694642,
                    -0.451858,
                    4.9890014,
                    2.210771,
                    4.116186,
                ],
            ]
        )

        self.assertTrue(np.allclose(vst.X, ref.T, atol=2e-2))

        ref = np.array(
            [
                [
                    3.701496,
                    3.7014964,
                    5.958395,
                    4.8565583,
                    4.0653149,
                    0.8610695,
                    4.7630157,
                    5.411009,
                    3.701496,
                    0.6327990,
                    3.4527199,
                    3.701496,
                ],
                [
                    -2.822746,
                    -0.4959506,
                    2.562285,
                    0.5019767,
                    -2.8227460,
                    3.9753014,
                    -2.8227460,
                    -2.822746,
                    3.985348,
                    -2.8227460,
                    0.9362035,
                    2.732023,
                ],
                [
                    8.055215,
                    6.2857065,
                    4.568530,
                    1.3618038,
                    4.0653149,
                    7.2447271,
                    -0.2002053,
                    5.123623,
                    5.637539,
                    5.1236227,
                    5.8915925,
                    8.974568,
                ],
                [
                    4.152433,
                    6.7244620,
                    6.338743,
                    2.2835920,
                    5.3240677,
                    4.9623662,
                    2.6750276,
                    8.948426,
                    4.604330,
                    5.8770306,
                    6.8781302,
                    5.265561,
                ],
                [
                    1.790356,
                    -2.8227460,
                    0.267767,
                    -2.8227460,
                    0.7155806,
                    -2.8227460,
                    -2.8227460,
                    3.561685,
                    3.347746,
                    -0.5558881,
                    3.4527199,
                    -2.822746,
                ],
                [
                    2.732023,
                    -2.8227460,
                    -2.822746,
                    2.2835920,
                    1.3566659,
                    0.8610695,
                    -0.2002053,
                    2.993639,
                    3.347746,
                    0.6327990,
                    2.9384128,
                    4.276066,
                ],
                [
                    -2.822746,
                    3.1566484,
                    1.103729,
                    1.8953193,
                    1.0717726,
                    2.2965211,
                    4.5538679,
                    6.117780,
                    -2.822746,
                    -2.8227460,
                    2.5906548,
                    6.581130,
                ],
                [
                    4.276066,
                    1.5866643,
                    4.020143,
                    1.3618038,
                    4.1420452,
                    2.6911747,
                    -2.8227460,
                    2.993639,
                    1.634489,
                    0.1617874,
                    0.1175492,
                    4.276066,
                ],
                [
                    1.790356,
                    -2.8227460,
                    -2.822746,
                    6.0122710,
                    5.7241411,
                    3.2553183,
                    1.9788499,
                    2.993639,
                    2.877997,
                    3.8014500,
                    5.3685344,
                    -2.822746,
                ],
                [
                    3.041855,
                    3.0811437,
                    2.774996,
                    3.4072156,
                    1.7980092,
                    0.8610695,
                    -0.2002053,
                    -2.822746,
                    -2.822746,
                    0.1617874,
                    3.0851780,
                    -2.822746,
                ],
                [
                    5.204619,
                    0.2324742,
                    2.774996,
                    3.8127224,
                    4.8394025,
                    6.1875168,
                    4.7630157,
                    6.501071,
                    5.595959,
                    -2.8227460,
                    4.8167596,
                    7.257606,
                ],
                [
                    4.685865,
                    4.2418104,
                    4.730196,
                    5.0687489,
                    2.7399816,
                    4.7301962,
                    4.7301962,
                    4.284902,
                    6.570435,
                    5.6258120,
                    4.7301962,
                    4.685865,
                ],
                [
                    5.434311,
                    1.9687389,
                    2.960316,
                    3.5554177,
                    4.8394025,
                    4.7301962,
                    4.0678339,
                    2.993639,
                    2.569582,
                    2.9141319,
                    0.1175492,
                    6.958660,
                ],
                [
                    3.513271,
                    4.0172023,
                    4.250864,
                    6.4885385,
                    6.0863872,
                    8.0634801,
                    5.2763471,
                    5.704694,
                    5.755538,
                    -2.8227460,
                    7.3320319,
                    7.579001,
                ],
                [
                    4.854038,
                    1.0645175,
                    4.624456,
                    6.8021604,
                    1.3566659,
                    6.5386078,
                    3.7121294,
                    3.561685,
                    -2.822746,
                    4.9351593,
                    1.8316982,
                    4.017202,
                ],
            ]
        )

        dds = makeExampleDESeqDataSet(n=15, m=12, seed=42)
        vst = varianceStabilizingTransformation(dds, fitType="mean")

        self.assertTrue(np.allclose(vst.X, ref.T, atol=3e-2))
