import unittest

import numpy as np

from inmoose.edgepy import addPriorCount
from inmoose.utils import rnbinom


class test_addPriorCount(unittest.TestCase):
    def setUp(self):
        y = np.array(rnbinom(80, size=5, mu=20, seed=42)).reshape((20, 4))
        self.y = np.vstack(([0, 0, 0, 0], [0, 0, 2, 2], y))

    def test_addPriorCount(self):
        ref = np.array(
            [
                [0.9275688, 1.042111, 1.053341, 0.9769792],
                [0.9275688, 1.042111, 3.053341, 2.9769792],
                [25.9275688, 20.042111, 12.053341, 23.9769792],
                [10.9275688, 18.042111, 11.053341, 17.9769792],
                [14.9275688, 36.042111, 28.053341, 2.9769792],
                [15.9275688, 8.042111, 29.053341, 29.9769792],
                [20.9275688, 16.042111, 34.053341, 25.9769792],
                [7.9275688, 36.042111, 29.053341, 28.9769792],
                [15.9275688, 15.042111, 20.053341, 16.9769792],
                [5.9275688, 25.042111, 23.053341, 30.9769792],
                [35.9275688, 22.042111, 15.053341, 22.9769792],
                [13.9275688, 23.042111, 16.053341, 19.9769792],
                [34.9275688, 23.042111, 8.053341, 29.9769792],
                [30.9275688, 33.042111, 18.053341, 13.9769792],
                [26.9275688, 16.042111, 24.053341, 26.9769792],
                [20.9275688, 26.042111, 39.053341, 38.9769792],
                [17.9275688, 21.042111, 14.053341, 15.9769792],
                [9.9275688, 49.042111, 36.053341, 8.9769792],
                [41.9275688, 22.042111, 43.053341, 17.9769792],
                [39.9275688, 34.042111, 41.053341, 25.9769792],
                [21.9275688, 21.042111, 23.053341, 33.9769792],
                [17.9275688, 20.042111, 24.053341, 18.9769792],
            ]
        )
        oref = np.full((22, 4), [6.027929, 6.144366, 6.155085, 6.079828])
        (yres, offsetres) = addPriorCount(self.y)
        self.assertTrue(np.allclose(yres, ref, atol=0, rtol=1e-6))
        self.assertTrue(np.allclose(offsetres, oref, atol=0, rtol=1e-6))

        with self.assertRaisesRegex(
            ValueError, expected_regex="count matrix must be numeric"
        ):
            addPriorCount(np.array(["foo", "bar"]))
