# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CheckArgs', 'Check']

@pulumi.input_type
class CheckArgs:
    def __init__(__self__, *,
                 activated: pulumi.Input[bool],
                 frequency: pulumi.Input[int],
                 type: pulumi.Input[str],
                 alert_channel_subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input['CheckAlertChannelSubscriptionArgs']]]] = None,
                 alert_settings: Optional[pulumi.Input['CheckAlertSettingsArgs']] = None,
                 degraded_response_time: Optional[pulumi.Input[int]] = None,
                 double_check: Optional[pulumi.Input[bool]] = None,
                 environment_variable: Optional[pulumi.Input[Sequence[pulumi.Input['CheckEnvironmentVariableArgs']]]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 frequency_offset: Optional[pulumi.Input[int]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 group_order: Optional[pulumi.Input[int]] = None,
                 local_setup_script: Optional[pulumi.Input[str]] = None,
                 local_teardown_script: Optional[pulumi.Input[str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_response_time: Optional[pulumi.Input[int]] = None,
                 muted: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 request: Optional[pulumi.Input['CheckRequestArgs']] = None,
                 retry_strategy: Optional[pulumi.Input['CheckRetryStrategyArgs']] = None,
                 run_parallel: Optional[pulumi.Input[bool]] = None,
                 runtime_id: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None,
                 setup_snippet_id: Optional[pulumi.Input[int]] = None,
                 should_fail: Optional[pulumi.Input[bool]] = None,
                 ssl_check: Optional[pulumi.Input[bool]] = None,
                 ssl_check_domain: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 teardown_snippet_id: Optional[pulumi.Input[int]] = None,
                 use_global_alert_settings: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Check resource.
        :param pulumi.Input[bool] activated: Determines if the check is running or not. Possible values `true`, and `false`.
        :param pulumi.Input[int] frequency: The frequency in minutes to run the check. Possible values are `0`, `1`, `2`, `5`, `10`, `15`, `30`, `60`, `120`, `180`, `360`, `720`, and `1440`.
        :param pulumi.Input[str] type: The type of the check. Possible values are `API`, `BROWSER`, and `MULTI_STEP`.
        :param pulumi.Input[Sequence[pulumi.Input['CheckAlertChannelSubscriptionArgs']]] alert_channel_subscriptions: An array of channel IDs and whether they're activated or not. If you don't set at least one alert subscription for your check, we won't be able to alert you in case something goes wrong with it.
        :param pulumi.Input[int] degraded_response_time: The response time in milliseconds starting from which a check should be considered degraded. Possible values are between 0 and 30000. (Default `15000`).
        :param pulumi.Input[bool] double_check: Setting this to `true` will trigger a retry when a check fails from the failing region and another, randomly selected region before marking the check as failed.
        :param pulumi.Input[Sequence[pulumi.Input['CheckEnvironmentVariableArgs']]] environment_variable: Key/value pairs for setting environment variables during check execution, add locked = true to keep value hidden, add secret = true to create a secret variable. These are only relevant for browser checks. Use global environment variables whenever possible.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Key/value pairs for setting environment variables during check execution. These are only relevant for browser checks. Use global environment variables whenever possible.
        :param pulumi.Input[int] frequency_offset: This property only valid for API high frequency checks. To create a hight frequency check, the property `frequency` must be `0` and `frequency_offset` could be `10`, `20` or `30`.
        :param pulumi.Input[int] group_id: The id of the check group this check is part of.
        :param pulumi.Input[int] group_order: The position of this check in a check group. It determines in what order checks are run when a group is triggered from the API or from CI/CD.
        :param pulumi.Input[str] local_setup_script: A valid piece of Node.js code to run in the setup phase.
        :param pulumi.Input[str] local_teardown_script: A valid piece of Node.js code to run in the teardown phase.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: An array of one or more data center locations where to run the this check. (Default ["us-east-1"])
        :param pulumi.Input[int] max_response_time: The response time in milliseconds starting from which a check should be considered failing. Possible values are between 0 and 30000. (Default `30000`).
        :param pulumi.Input[bool] muted: Determines if any notifications will be sent out when a check fails/degrades/recovers.
        :param pulumi.Input[str] name: The name of the check.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_locations: An array of one or more private locations slugs.
        :param pulumi.Input['CheckRequestArgs'] request: An API check might have one request config.
        :param pulumi.Input['CheckRetryStrategyArgs'] retry_strategy: A strategy for retrying failed check runs.
        :param pulumi.Input[bool] run_parallel: Determines if the check should run in all selected locations in parallel or round-robin.
        :param pulumi.Input[str] runtime_id: The id of the runtime to use for this check.
        :param pulumi.Input[str] script: A valid piece of Node.js JavaScript code describing a browser interaction with the Puppeteer/Playwright framework or a reference to an external JavaScript file.
        :param pulumi.Input[int] setup_snippet_id: An ID reference to a snippet to use in the setup phase of an API check.
        :param pulumi.Input[bool] should_fail: Allows to invert the behaviour of when a check is considered to fail. Allows for validating error status like 404.
        :param pulumi.Input[bool] ssl_check: Determines if the SSL certificate should be validated for expiry.
        :param pulumi.Input[str] ssl_check_domain: A valid fully qualified domain name (FQDN) to check its SSL certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags for organizing and filtering checks.
        :param pulumi.Input[int] teardown_snippet_id: An ID reference to a snippet to use in the teardown phase of an API check.
        :param pulumi.Input[bool] use_global_alert_settings: When true, the account level alert settings will be used, not the alert setting defined on this check.
        """
        pulumi.set(__self__, "activated", activated)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "type", type)
        if alert_channel_subscriptions is not None:
            pulumi.set(__self__, "alert_channel_subscriptions", alert_channel_subscriptions)
        if alert_settings is not None:
            pulumi.set(__self__, "alert_settings", alert_settings)
        if degraded_response_time is not None:
            pulumi.set(__self__, "degraded_response_time", degraded_response_time)
        if double_check is not None:
            warnings.warn("""The property `double_check` is deprecated and will be removed in a future version. To enable retries for failed check runs, use the `retry_strategy` property instead.""", DeprecationWarning)
            pulumi.log.warn("""double_check is deprecated: The property `double_check` is deprecated and will be removed in a future version. To enable retries for failed check runs, use the `retry_strategy` property instead.""")
        if double_check is not None:
            pulumi.set(__self__, "double_check", double_check)
        if environment_variable is not None:
            pulumi.set(__self__, "environment_variable", environment_variable)
        if environment_variables is not None:
            warnings.warn("""The property `environment_variables` is deprecated and will be removed in a future version. Consider using the new `environment_variable` list.""", DeprecationWarning)
            pulumi.log.warn("""environment_variables is deprecated: The property `environment_variables` is deprecated and will be removed in a future version. Consider using the new `environment_variable` list.""")
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if frequency_offset is not None:
            pulumi.set(__self__, "frequency_offset", frequency_offset)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if group_order is not None:
            pulumi.set(__self__, "group_order", group_order)
        if local_setup_script is not None:
            pulumi.set(__self__, "local_setup_script", local_setup_script)
        if local_teardown_script is not None:
            pulumi.set(__self__, "local_teardown_script", local_teardown_script)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if max_response_time is not None:
            pulumi.set(__self__, "max_response_time", max_response_time)
        if muted is not None:
            pulumi.set(__self__, "muted", muted)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_locations is not None:
            pulumi.set(__self__, "private_locations", private_locations)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if retry_strategy is not None:
            pulumi.set(__self__, "retry_strategy", retry_strategy)
        if run_parallel is not None:
            pulumi.set(__self__, "run_parallel", run_parallel)
        if runtime_id is not None:
            pulumi.set(__self__, "runtime_id", runtime_id)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if setup_snippet_id is not None:
            pulumi.set(__self__, "setup_snippet_id", setup_snippet_id)
        if should_fail is not None:
            pulumi.set(__self__, "should_fail", should_fail)
        if ssl_check is not None:
            warnings.warn("""The property `ssl_check` is deprecated and it's ignored by the Checkly Public API. It will be removed in a future version.""", DeprecationWarning)
            pulumi.log.warn("""ssl_check is deprecated: The property `ssl_check` is deprecated and it's ignored by the Checkly Public API. It will be removed in a future version.""")
        if ssl_check is not None:
            pulumi.set(__self__, "ssl_check", ssl_check)
        if ssl_check_domain is not None:
            pulumi.set(__self__, "ssl_check_domain", ssl_check_domain)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if teardown_snippet_id is not None:
            pulumi.set(__self__, "teardown_snippet_id", teardown_snippet_id)
        if use_global_alert_settings is not None:
            pulumi.set(__self__, "use_global_alert_settings", use_global_alert_settings)

    @property
    @pulumi.getter
    def activated(self) -> pulumi.Input[bool]:
        """
        Determines if the check is running or not. Possible values `true`, and `false`.
        """
        return pulumi.get(self, "activated")

    @activated.setter
    def activated(self, value: pulumi.Input[bool]):
        pulumi.set(self, "activated", value)

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Input[int]:
        """
        The frequency in minutes to run the check. Possible values are `0`, `1`, `2`, `5`, `10`, `15`, `30`, `60`, `120`, `180`, `360`, `720`, and `1440`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input[int]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the check. Possible values are `API`, `BROWSER`, and `MULTI_STEP`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="alertChannelSubscriptions")
    def alert_channel_subscriptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CheckAlertChannelSubscriptionArgs']]]]:
        """
        An array of channel IDs and whether they're activated or not. If you don't set at least one alert subscription for your check, we won't be able to alert you in case something goes wrong with it.
        """
        return pulumi.get(self, "alert_channel_subscriptions")

    @alert_channel_subscriptions.setter
    def alert_channel_subscriptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CheckAlertChannelSubscriptionArgs']]]]):
        pulumi.set(self, "alert_channel_subscriptions", value)

    @property
    @pulumi.getter(name="alertSettings")
    def alert_settings(self) -> Optional[pulumi.Input['CheckAlertSettingsArgs']]:
        return pulumi.get(self, "alert_settings")

    @alert_settings.setter
    def alert_settings(self, value: Optional[pulumi.Input['CheckAlertSettingsArgs']]):
        pulumi.set(self, "alert_settings", value)

    @property
    @pulumi.getter(name="degradedResponseTime")
    def degraded_response_time(self) -> Optional[pulumi.Input[int]]:
        """
        The response time in milliseconds starting from which a check should be considered degraded. Possible values are between 0 and 30000. (Default `15000`).
        """
        return pulumi.get(self, "degraded_response_time")

    @degraded_response_time.setter
    def degraded_response_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "degraded_response_time", value)

    @property
    @pulumi.getter(name="doubleCheck")
    @_utilities.deprecated("""The property `double_check` is deprecated and will be removed in a future version. To enable retries for failed check runs, use the `retry_strategy` property instead.""")
    def double_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Setting this to `true` will trigger a retry when a check fails from the failing region and another, randomly selected region before marking the check as failed.
        """
        return pulumi.get(self, "double_check")

    @double_check.setter
    def double_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "double_check", value)

    @property
    @pulumi.getter(name="environmentVariable")
    def environment_variable(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CheckEnvironmentVariableArgs']]]]:
        """
        Key/value pairs for setting environment variables during check execution, add locked = true to keep value hidden, add secret = true to create a secret variable. These are only relevant for browser checks. Use global environment variables whenever possible.
        """
        return pulumi.get(self, "environment_variable")

    @environment_variable.setter
    def environment_variable(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CheckEnvironmentVariableArgs']]]]):
        pulumi.set(self, "environment_variable", value)

    @property
    @pulumi.getter(name="environmentVariables")
    @_utilities.deprecated("""The property `environment_variables` is deprecated and will be removed in a future version. Consider using the new `environment_variable` list.""")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key/value pairs for setting environment variables during check execution. These are only relevant for browser checks. Use global environment variables whenever possible.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="frequencyOffset")
    def frequency_offset(self) -> Optional[pulumi.Input[int]]:
        """
        This property only valid for API high frequency checks. To create a hight frequency check, the property `frequency` must be `0` and `frequency_offset` could be `10`, `20` or `30`.
        """
        return pulumi.get(self, "frequency_offset")

    @frequency_offset.setter
    def frequency_offset(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "frequency_offset", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[int]]:
        """
        The id of the check group this check is part of.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="groupOrder")
    def group_order(self) -> Optional[pulumi.Input[int]]:
        """
        The position of this check in a check group. It determines in what order checks are run when a group is triggered from the API or from CI/CD.
        """
        return pulumi.get(self, "group_order")

    @group_order.setter
    def group_order(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_order", value)

    @property
    @pulumi.getter(name="localSetupScript")
    def local_setup_script(self) -> Optional[pulumi.Input[str]]:
        """
        A valid piece of Node.js code to run in the setup phase.
        """
        return pulumi.get(self, "local_setup_script")

    @local_setup_script.setter
    def local_setup_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_setup_script", value)

    @property
    @pulumi.getter(name="localTeardownScript")
    def local_teardown_script(self) -> Optional[pulumi.Input[str]]:
        """
        A valid piece of Node.js code to run in the teardown phase.
        """
        return pulumi.get(self, "local_teardown_script")

    @local_teardown_script.setter
    def local_teardown_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_teardown_script", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of one or more data center locations where to run the this check. (Default ["us-east-1"])
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter(name="maxResponseTime")
    def max_response_time(self) -> Optional[pulumi.Input[int]]:
        """
        The response time in milliseconds starting from which a check should be considered failing. Possible values are between 0 and 30000. (Default `30000`).
        """
        return pulumi.get(self, "max_response_time")

    @max_response_time.setter
    def max_response_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_response_time", value)

    @property
    @pulumi.getter
    def muted(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if any notifications will be sent out when a check fails/degrades/recovers.
        """
        return pulumi.get(self, "muted")

    @muted.setter
    def muted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "muted", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the check.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateLocations")
    def private_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of one or more private locations slugs.
        """
        return pulumi.get(self, "private_locations")

    @private_locations.setter
    def private_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_locations", value)

    @property
    @pulumi.getter
    def request(self) -> Optional[pulumi.Input['CheckRequestArgs']]:
        """
        An API check might have one request config.
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: Optional[pulumi.Input['CheckRequestArgs']]):
        pulumi.set(self, "request", value)

    @property
    @pulumi.getter(name="retryStrategy")
    def retry_strategy(self) -> Optional[pulumi.Input['CheckRetryStrategyArgs']]:
        """
        A strategy for retrying failed check runs.
        """
        return pulumi.get(self, "retry_strategy")

    @retry_strategy.setter
    def retry_strategy(self, value: Optional[pulumi.Input['CheckRetryStrategyArgs']]):
        pulumi.set(self, "retry_strategy", value)

    @property
    @pulumi.getter(name="runParallel")
    def run_parallel(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if the check should run in all selected locations in parallel or round-robin.
        """
        return pulumi.get(self, "run_parallel")

    @run_parallel.setter
    def run_parallel(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "run_parallel", value)

    @property
    @pulumi.getter(name="runtimeId")
    def runtime_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the runtime to use for this check.
        """
        return pulumi.get(self, "runtime_id")

    @runtime_id.setter
    def runtime_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_id", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[str]]:
        """
        A valid piece of Node.js JavaScript code describing a browser interaction with the Puppeteer/Playwright framework or a reference to an external JavaScript file.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter(name="setupSnippetId")
    def setup_snippet_id(self) -> Optional[pulumi.Input[int]]:
        """
        An ID reference to a snippet to use in the setup phase of an API check.
        """
        return pulumi.get(self, "setup_snippet_id")

    @setup_snippet_id.setter
    def setup_snippet_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "setup_snippet_id", value)

    @property
    @pulumi.getter(name="shouldFail")
    def should_fail(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows to invert the behaviour of when a check is considered to fail. Allows for validating error status like 404.
        """
        return pulumi.get(self, "should_fail")

    @should_fail.setter
    def should_fail(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_fail", value)

    @property
    @pulumi.getter(name="sslCheck")
    @_utilities.deprecated("""The property `ssl_check` is deprecated and it's ignored by the Checkly Public API. It will be removed in a future version.""")
    def ssl_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if the SSL certificate should be validated for expiry.
        """
        return pulumi.get(self, "ssl_check")

    @ssl_check.setter
    def ssl_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl_check", value)

    @property
    @pulumi.getter(name="sslCheckDomain")
    def ssl_check_domain(self) -> Optional[pulumi.Input[str]]:
        """
        A valid fully qualified domain name (FQDN) to check its SSL certificate.
        """
        return pulumi.get(self, "ssl_check_domain")

    @ssl_check_domain.setter
    def ssl_check_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_check_domain", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags for organizing and filtering checks.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="teardownSnippetId")
    def teardown_snippet_id(self) -> Optional[pulumi.Input[int]]:
        """
        An ID reference to a snippet to use in the teardown phase of an API check.
        """
        return pulumi.get(self, "teardown_snippet_id")

    @teardown_snippet_id.setter
    def teardown_snippet_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "teardown_snippet_id", value)

    @property
    @pulumi.getter(name="useGlobalAlertSettings")
    def use_global_alert_settings(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, the account level alert settings will be used, not the alert setting defined on this check.
        """
        return pulumi.get(self, "use_global_alert_settings")

    @use_global_alert_settings.setter
    def use_global_alert_settings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_global_alert_settings", value)


@pulumi.input_type
class _CheckState:
    def __init__(__self__, *,
                 activated: Optional[pulumi.Input[bool]] = None,
                 alert_channel_subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input['CheckAlertChannelSubscriptionArgs']]]] = None,
                 alert_settings: Optional[pulumi.Input['CheckAlertSettingsArgs']] = None,
                 degraded_response_time: Optional[pulumi.Input[int]] = None,
                 double_check: Optional[pulumi.Input[bool]] = None,
                 environment_variable: Optional[pulumi.Input[Sequence[pulumi.Input['CheckEnvironmentVariableArgs']]]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 frequency: Optional[pulumi.Input[int]] = None,
                 frequency_offset: Optional[pulumi.Input[int]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 group_order: Optional[pulumi.Input[int]] = None,
                 local_setup_script: Optional[pulumi.Input[str]] = None,
                 local_teardown_script: Optional[pulumi.Input[str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_response_time: Optional[pulumi.Input[int]] = None,
                 muted: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 request: Optional[pulumi.Input['CheckRequestArgs']] = None,
                 retry_strategy: Optional[pulumi.Input['CheckRetryStrategyArgs']] = None,
                 run_parallel: Optional[pulumi.Input[bool]] = None,
                 runtime_id: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None,
                 setup_snippet_id: Optional[pulumi.Input[int]] = None,
                 should_fail: Optional[pulumi.Input[bool]] = None,
                 ssl_check: Optional[pulumi.Input[bool]] = None,
                 ssl_check_domain: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 teardown_snippet_id: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 use_global_alert_settings: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Check resources.
        :param pulumi.Input[bool] activated: Determines if the check is running or not. Possible values `true`, and `false`.
        :param pulumi.Input[Sequence[pulumi.Input['CheckAlertChannelSubscriptionArgs']]] alert_channel_subscriptions: An array of channel IDs and whether they're activated or not. If you don't set at least one alert subscription for your check, we won't be able to alert you in case something goes wrong with it.
        :param pulumi.Input[int] degraded_response_time: The response time in milliseconds starting from which a check should be considered degraded. Possible values are between 0 and 30000. (Default `15000`).
        :param pulumi.Input[bool] double_check: Setting this to `true` will trigger a retry when a check fails from the failing region and another, randomly selected region before marking the check as failed.
        :param pulumi.Input[Sequence[pulumi.Input['CheckEnvironmentVariableArgs']]] environment_variable: Key/value pairs for setting environment variables during check execution, add locked = true to keep value hidden, add secret = true to create a secret variable. These are only relevant for browser checks. Use global environment variables whenever possible.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Key/value pairs for setting environment variables during check execution. These are only relevant for browser checks. Use global environment variables whenever possible.
        :param pulumi.Input[int] frequency: The frequency in minutes to run the check. Possible values are `0`, `1`, `2`, `5`, `10`, `15`, `30`, `60`, `120`, `180`, `360`, `720`, and `1440`.
        :param pulumi.Input[int] frequency_offset: This property only valid for API high frequency checks. To create a hight frequency check, the property `frequency` must be `0` and `frequency_offset` could be `10`, `20` or `30`.
        :param pulumi.Input[int] group_id: The id of the check group this check is part of.
        :param pulumi.Input[int] group_order: The position of this check in a check group. It determines in what order checks are run when a group is triggered from the API or from CI/CD.
        :param pulumi.Input[str] local_setup_script: A valid piece of Node.js code to run in the setup phase.
        :param pulumi.Input[str] local_teardown_script: A valid piece of Node.js code to run in the teardown phase.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: An array of one or more data center locations where to run the this check. (Default ["us-east-1"])
        :param pulumi.Input[int] max_response_time: The response time in milliseconds starting from which a check should be considered failing. Possible values are between 0 and 30000. (Default `30000`).
        :param pulumi.Input[bool] muted: Determines if any notifications will be sent out when a check fails/degrades/recovers.
        :param pulumi.Input[str] name: The name of the check.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_locations: An array of one or more private locations slugs.
        :param pulumi.Input['CheckRequestArgs'] request: An API check might have one request config.
        :param pulumi.Input['CheckRetryStrategyArgs'] retry_strategy: A strategy for retrying failed check runs.
        :param pulumi.Input[bool] run_parallel: Determines if the check should run in all selected locations in parallel or round-robin.
        :param pulumi.Input[str] runtime_id: The id of the runtime to use for this check.
        :param pulumi.Input[str] script: A valid piece of Node.js JavaScript code describing a browser interaction with the Puppeteer/Playwright framework or a reference to an external JavaScript file.
        :param pulumi.Input[int] setup_snippet_id: An ID reference to a snippet to use in the setup phase of an API check.
        :param pulumi.Input[bool] should_fail: Allows to invert the behaviour of when a check is considered to fail. Allows for validating error status like 404.
        :param pulumi.Input[bool] ssl_check: Determines if the SSL certificate should be validated for expiry.
        :param pulumi.Input[str] ssl_check_domain: A valid fully qualified domain name (FQDN) to check its SSL certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags for organizing and filtering checks.
        :param pulumi.Input[int] teardown_snippet_id: An ID reference to a snippet to use in the teardown phase of an API check.
        :param pulumi.Input[str] type: The type of the check. Possible values are `API`, `BROWSER`, and `MULTI_STEP`.
        :param pulumi.Input[bool] use_global_alert_settings: When true, the account level alert settings will be used, not the alert setting defined on this check.
        """
        if activated is not None:
            pulumi.set(__self__, "activated", activated)
        if alert_channel_subscriptions is not None:
            pulumi.set(__self__, "alert_channel_subscriptions", alert_channel_subscriptions)
        if alert_settings is not None:
            pulumi.set(__self__, "alert_settings", alert_settings)
        if degraded_response_time is not None:
            pulumi.set(__self__, "degraded_response_time", degraded_response_time)
        if double_check is not None:
            warnings.warn("""The property `double_check` is deprecated and will be removed in a future version. To enable retries for failed check runs, use the `retry_strategy` property instead.""", DeprecationWarning)
            pulumi.log.warn("""double_check is deprecated: The property `double_check` is deprecated and will be removed in a future version. To enable retries for failed check runs, use the `retry_strategy` property instead.""")
        if double_check is not None:
            pulumi.set(__self__, "double_check", double_check)
        if environment_variable is not None:
            pulumi.set(__self__, "environment_variable", environment_variable)
        if environment_variables is not None:
            warnings.warn("""The property `environment_variables` is deprecated and will be removed in a future version. Consider using the new `environment_variable` list.""", DeprecationWarning)
            pulumi.log.warn("""environment_variables is deprecated: The property `environment_variables` is deprecated and will be removed in a future version. Consider using the new `environment_variable` list.""")
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if frequency_offset is not None:
            pulumi.set(__self__, "frequency_offset", frequency_offset)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if group_order is not None:
            pulumi.set(__self__, "group_order", group_order)
        if local_setup_script is not None:
            pulumi.set(__self__, "local_setup_script", local_setup_script)
        if local_teardown_script is not None:
            pulumi.set(__self__, "local_teardown_script", local_teardown_script)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if max_response_time is not None:
            pulumi.set(__self__, "max_response_time", max_response_time)
        if muted is not None:
            pulumi.set(__self__, "muted", muted)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_locations is not None:
            pulumi.set(__self__, "private_locations", private_locations)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if retry_strategy is not None:
            pulumi.set(__self__, "retry_strategy", retry_strategy)
        if run_parallel is not None:
            pulumi.set(__self__, "run_parallel", run_parallel)
        if runtime_id is not None:
            pulumi.set(__self__, "runtime_id", runtime_id)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if setup_snippet_id is not None:
            pulumi.set(__self__, "setup_snippet_id", setup_snippet_id)
        if should_fail is not None:
            pulumi.set(__self__, "should_fail", should_fail)
        if ssl_check is not None:
            warnings.warn("""The property `ssl_check` is deprecated and it's ignored by the Checkly Public API. It will be removed in a future version.""", DeprecationWarning)
            pulumi.log.warn("""ssl_check is deprecated: The property `ssl_check` is deprecated and it's ignored by the Checkly Public API. It will be removed in a future version.""")
        if ssl_check is not None:
            pulumi.set(__self__, "ssl_check", ssl_check)
        if ssl_check_domain is not None:
            pulumi.set(__self__, "ssl_check_domain", ssl_check_domain)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if teardown_snippet_id is not None:
            pulumi.set(__self__, "teardown_snippet_id", teardown_snippet_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if use_global_alert_settings is not None:
            pulumi.set(__self__, "use_global_alert_settings", use_global_alert_settings)

    @property
    @pulumi.getter
    def activated(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if the check is running or not. Possible values `true`, and `false`.
        """
        return pulumi.get(self, "activated")

    @activated.setter
    def activated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "activated", value)

    @property
    @pulumi.getter(name="alertChannelSubscriptions")
    def alert_channel_subscriptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CheckAlertChannelSubscriptionArgs']]]]:
        """
        An array of channel IDs and whether they're activated or not. If you don't set at least one alert subscription for your check, we won't be able to alert you in case something goes wrong with it.
        """
        return pulumi.get(self, "alert_channel_subscriptions")

    @alert_channel_subscriptions.setter
    def alert_channel_subscriptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CheckAlertChannelSubscriptionArgs']]]]):
        pulumi.set(self, "alert_channel_subscriptions", value)

    @property
    @pulumi.getter(name="alertSettings")
    def alert_settings(self) -> Optional[pulumi.Input['CheckAlertSettingsArgs']]:
        return pulumi.get(self, "alert_settings")

    @alert_settings.setter
    def alert_settings(self, value: Optional[pulumi.Input['CheckAlertSettingsArgs']]):
        pulumi.set(self, "alert_settings", value)

    @property
    @pulumi.getter(name="degradedResponseTime")
    def degraded_response_time(self) -> Optional[pulumi.Input[int]]:
        """
        The response time in milliseconds starting from which a check should be considered degraded. Possible values are between 0 and 30000. (Default `15000`).
        """
        return pulumi.get(self, "degraded_response_time")

    @degraded_response_time.setter
    def degraded_response_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "degraded_response_time", value)

    @property
    @pulumi.getter(name="doubleCheck")
    @_utilities.deprecated("""The property `double_check` is deprecated and will be removed in a future version. To enable retries for failed check runs, use the `retry_strategy` property instead.""")
    def double_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Setting this to `true` will trigger a retry when a check fails from the failing region and another, randomly selected region before marking the check as failed.
        """
        return pulumi.get(self, "double_check")

    @double_check.setter
    def double_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "double_check", value)

    @property
    @pulumi.getter(name="environmentVariable")
    def environment_variable(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CheckEnvironmentVariableArgs']]]]:
        """
        Key/value pairs for setting environment variables during check execution, add locked = true to keep value hidden, add secret = true to create a secret variable. These are only relevant for browser checks. Use global environment variables whenever possible.
        """
        return pulumi.get(self, "environment_variable")

    @environment_variable.setter
    def environment_variable(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CheckEnvironmentVariableArgs']]]]):
        pulumi.set(self, "environment_variable", value)

    @property
    @pulumi.getter(name="environmentVariables")
    @_utilities.deprecated("""The property `environment_variables` is deprecated and will be removed in a future version. Consider using the new `environment_variable` list.""")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key/value pairs for setting environment variables during check execution. These are only relevant for browser checks. Use global environment variables whenever possible.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[int]]:
        """
        The frequency in minutes to run the check. Possible values are `0`, `1`, `2`, `5`, `10`, `15`, `30`, `60`, `120`, `180`, `360`, `720`, and `1440`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter(name="frequencyOffset")
    def frequency_offset(self) -> Optional[pulumi.Input[int]]:
        """
        This property only valid for API high frequency checks. To create a hight frequency check, the property `frequency` must be `0` and `frequency_offset` could be `10`, `20` or `30`.
        """
        return pulumi.get(self, "frequency_offset")

    @frequency_offset.setter
    def frequency_offset(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "frequency_offset", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[int]]:
        """
        The id of the check group this check is part of.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="groupOrder")
    def group_order(self) -> Optional[pulumi.Input[int]]:
        """
        The position of this check in a check group. It determines in what order checks are run when a group is triggered from the API or from CI/CD.
        """
        return pulumi.get(self, "group_order")

    @group_order.setter
    def group_order(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_order", value)

    @property
    @pulumi.getter(name="localSetupScript")
    def local_setup_script(self) -> Optional[pulumi.Input[str]]:
        """
        A valid piece of Node.js code to run in the setup phase.
        """
        return pulumi.get(self, "local_setup_script")

    @local_setup_script.setter
    def local_setup_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_setup_script", value)

    @property
    @pulumi.getter(name="localTeardownScript")
    def local_teardown_script(self) -> Optional[pulumi.Input[str]]:
        """
        A valid piece of Node.js code to run in the teardown phase.
        """
        return pulumi.get(self, "local_teardown_script")

    @local_teardown_script.setter
    def local_teardown_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_teardown_script", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of one or more data center locations where to run the this check. (Default ["us-east-1"])
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter(name="maxResponseTime")
    def max_response_time(self) -> Optional[pulumi.Input[int]]:
        """
        The response time in milliseconds starting from which a check should be considered failing. Possible values are between 0 and 30000. (Default `30000`).
        """
        return pulumi.get(self, "max_response_time")

    @max_response_time.setter
    def max_response_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_response_time", value)

    @property
    @pulumi.getter
    def muted(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if any notifications will be sent out when a check fails/degrades/recovers.
        """
        return pulumi.get(self, "muted")

    @muted.setter
    def muted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "muted", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the check.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateLocations")
    def private_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of one or more private locations slugs.
        """
        return pulumi.get(self, "private_locations")

    @private_locations.setter
    def private_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_locations", value)

    @property
    @pulumi.getter
    def request(self) -> Optional[pulumi.Input['CheckRequestArgs']]:
        """
        An API check might have one request config.
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: Optional[pulumi.Input['CheckRequestArgs']]):
        pulumi.set(self, "request", value)

    @property
    @pulumi.getter(name="retryStrategy")
    def retry_strategy(self) -> Optional[pulumi.Input['CheckRetryStrategyArgs']]:
        """
        A strategy for retrying failed check runs.
        """
        return pulumi.get(self, "retry_strategy")

    @retry_strategy.setter
    def retry_strategy(self, value: Optional[pulumi.Input['CheckRetryStrategyArgs']]):
        pulumi.set(self, "retry_strategy", value)

    @property
    @pulumi.getter(name="runParallel")
    def run_parallel(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if the check should run in all selected locations in parallel or round-robin.
        """
        return pulumi.get(self, "run_parallel")

    @run_parallel.setter
    def run_parallel(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "run_parallel", value)

    @property
    @pulumi.getter(name="runtimeId")
    def runtime_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the runtime to use for this check.
        """
        return pulumi.get(self, "runtime_id")

    @runtime_id.setter
    def runtime_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_id", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[str]]:
        """
        A valid piece of Node.js JavaScript code describing a browser interaction with the Puppeteer/Playwright framework or a reference to an external JavaScript file.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter(name="setupSnippetId")
    def setup_snippet_id(self) -> Optional[pulumi.Input[int]]:
        """
        An ID reference to a snippet to use in the setup phase of an API check.
        """
        return pulumi.get(self, "setup_snippet_id")

    @setup_snippet_id.setter
    def setup_snippet_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "setup_snippet_id", value)

    @property
    @pulumi.getter(name="shouldFail")
    def should_fail(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows to invert the behaviour of when a check is considered to fail. Allows for validating error status like 404.
        """
        return pulumi.get(self, "should_fail")

    @should_fail.setter
    def should_fail(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_fail", value)

    @property
    @pulumi.getter(name="sslCheck")
    @_utilities.deprecated("""The property `ssl_check` is deprecated and it's ignored by the Checkly Public API. It will be removed in a future version.""")
    def ssl_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if the SSL certificate should be validated for expiry.
        """
        return pulumi.get(self, "ssl_check")

    @ssl_check.setter
    def ssl_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl_check", value)

    @property
    @pulumi.getter(name="sslCheckDomain")
    def ssl_check_domain(self) -> Optional[pulumi.Input[str]]:
        """
        A valid fully qualified domain name (FQDN) to check its SSL certificate.
        """
        return pulumi.get(self, "ssl_check_domain")

    @ssl_check_domain.setter
    def ssl_check_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_check_domain", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags for organizing and filtering checks.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="teardownSnippetId")
    def teardown_snippet_id(self) -> Optional[pulumi.Input[int]]:
        """
        An ID reference to a snippet to use in the teardown phase of an API check.
        """
        return pulumi.get(self, "teardown_snippet_id")

    @teardown_snippet_id.setter
    def teardown_snippet_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "teardown_snippet_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the check. Possible values are `API`, `BROWSER`, and `MULTI_STEP`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="useGlobalAlertSettings")
    def use_global_alert_settings(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, the account level alert settings will be used, not the alert setting defined on this check.
        """
        return pulumi.get(self, "use_global_alert_settings")

    @use_global_alert_settings.setter
    def use_global_alert_settings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_global_alert_settings", value)


class Check(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activated: Optional[pulumi.Input[bool]] = None,
                 alert_channel_subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CheckAlertChannelSubscriptionArgs', 'CheckAlertChannelSubscriptionArgsDict']]]]] = None,
                 alert_settings: Optional[pulumi.Input[Union['CheckAlertSettingsArgs', 'CheckAlertSettingsArgsDict']]] = None,
                 degraded_response_time: Optional[pulumi.Input[int]] = None,
                 double_check: Optional[pulumi.Input[bool]] = None,
                 environment_variable: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CheckEnvironmentVariableArgs', 'CheckEnvironmentVariableArgsDict']]]]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 frequency: Optional[pulumi.Input[int]] = None,
                 frequency_offset: Optional[pulumi.Input[int]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 group_order: Optional[pulumi.Input[int]] = None,
                 local_setup_script: Optional[pulumi.Input[str]] = None,
                 local_teardown_script: Optional[pulumi.Input[str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_response_time: Optional[pulumi.Input[int]] = None,
                 muted: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 request: Optional[pulumi.Input[Union['CheckRequestArgs', 'CheckRequestArgsDict']]] = None,
                 retry_strategy: Optional[pulumi.Input[Union['CheckRetryStrategyArgs', 'CheckRetryStrategyArgsDict']]] = None,
                 run_parallel: Optional[pulumi.Input[bool]] = None,
                 runtime_id: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None,
                 setup_snippet_id: Optional[pulumi.Input[int]] = None,
                 should_fail: Optional[pulumi.Input[bool]] = None,
                 ssl_check: Optional[pulumi.Input[bool]] = None,
                 ssl_check_domain: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 teardown_snippet_id: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 use_global_alert_settings: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Checks allows you to monitor key webapp flows, backend API's and set up alerting, so you get a notification when things break or slow down.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] activated: Determines if the check is running or not. Possible values `true`, and `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CheckAlertChannelSubscriptionArgs', 'CheckAlertChannelSubscriptionArgsDict']]]] alert_channel_subscriptions: An array of channel IDs and whether they're activated or not. If you don't set at least one alert subscription for your check, we won't be able to alert you in case something goes wrong with it.
        :param pulumi.Input[int] degraded_response_time: The response time in milliseconds starting from which a check should be considered degraded. Possible values are between 0 and 30000. (Default `15000`).
        :param pulumi.Input[bool] double_check: Setting this to `true` will trigger a retry when a check fails from the failing region and another, randomly selected region before marking the check as failed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CheckEnvironmentVariableArgs', 'CheckEnvironmentVariableArgsDict']]]] environment_variable: Key/value pairs for setting environment variables during check execution, add locked = true to keep value hidden, add secret = true to create a secret variable. These are only relevant for browser checks. Use global environment variables whenever possible.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Key/value pairs for setting environment variables during check execution. These are only relevant for browser checks. Use global environment variables whenever possible.
        :param pulumi.Input[int] frequency: The frequency in minutes to run the check. Possible values are `0`, `1`, `2`, `5`, `10`, `15`, `30`, `60`, `120`, `180`, `360`, `720`, and `1440`.
        :param pulumi.Input[int] frequency_offset: This property only valid for API high frequency checks. To create a hight frequency check, the property `frequency` must be `0` and `frequency_offset` could be `10`, `20` or `30`.
        :param pulumi.Input[int] group_id: The id of the check group this check is part of.
        :param pulumi.Input[int] group_order: The position of this check in a check group. It determines in what order checks are run when a group is triggered from the API or from CI/CD.
        :param pulumi.Input[str] local_setup_script: A valid piece of Node.js code to run in the setup phase.
        :param pulumi.Input[str] local_teardown_script: A valid piece of Node.js code to run in the teardown phase.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: An array of one or more data center locations where to run the this check. (Default ["us-east-1"])
        :param pulumi.Input[int] max_response_time: The response time in milliseconds starting from which a check should be considered failing. Possible values are between 0 and 30000. (Default `30000`).
        :param pulumi.Input[bool] muted: Determines if any notifications will be sent out when a check fails/degrades/recovers.
        :param pulumi.Input[str] name: The name of the check.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_locations: An array of one or more private locations slugs.
        :param pulumi.Input[Union['CheckRequestArgs', 'CheckRequestArgsDict']] request: An API check might have one request config.
        :param pulumi.Input[Union['CheckRetryStrategyArgs', 'CheckRetryStrategyArgsDict']] retry_strategy: A strategy for retrying failed check runs.
        :param pulumi.Input[bool] run_parallel: Determines if the check should run in all selected locations in parallel or round-robin.
        :param pulumi.Input[str] runtime_id: The id of the runtime to use for this check.
        :param pulumi.Input[str] script: A valid piece of Node.js JavaScript code describing a browser interaction with the Puppeteer/Playwright framework or a reference to an external JavaScript file.
        :param pulumi.Input[int] setup_snippet_id: An ID reference to a snippet to use in the setup phase of an API check.
        :param pulumi.Input[bool] should_fail: Allows to invert the behaviour of when a check is considered to fail. Allows for validating error status like 404.
        :param pulumi.Input[bool] ssl_check: Determines if the SSL certificate should be validated for expiry.
        :param pulumi.Input[str] ssl_check_domain: A valid fully qualified domain name (FQDN) to check its SSL certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags for organizing and filtering checks.
        :param pulumi.Input[int] teardown_snippet_id: An ID reference to a snippet to use in the teardown phase of an API check.
        :param pulumi.Input[str] type: The type of the check. Possible values are `API`, `BROWSER`, and `MULTI_STEP`.
        :param pulumi.Input[bool] use_global_alert_settings: When true, the account level alert settings will be used, not the alert setting defined on this check.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CheckArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Checks allows you to monitor key webapp flows, backend API's and set up alerting, so you get a notification when things break or slow down.

        :param str resource_name: The name of the resource.
        :param CheckArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CheckArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activated: Optional[pulumi.Input[bool]] = None,
                 alert_channel_subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CheckAlertChannelSubscriptionArgs', 'CheckAlertChannelSubscriptionArgsDict']]]]] = None,
                 alert_settings: Optional[pulumi.Input[Union['CheckAlertSettingsArgs', 'CheckAlertSettingsArgsDict']]] = None,
                 degraded_response_time: Optional[pulumi.Input[int]] = None,
                 double_check: Optional[pulumi.Input[bool]] = None,
                 environment_variable: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CheckEnvironmentVariableArgs', 'CheckEnvironmentVariableArgsDict']]]]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 frequency: Optional[pulumi.Input[int]] = None,
                 frequency_offset: Optional[pulumi.Input[int]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 group_order: Optional[pulumi.Input[int]] = None,
                 local_setup_script: Optional[pulumi.Input[str]] = None,
                 local_teardown_script: Optional[pulumi.Input[str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_response_time: Optional[pulumi.Input[int]] = None,
                 muted: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 request: Optional[pulumi.Input[Union['CheckRequestArgs', 'CheckRequestArgsDict']]] = None,
                 retry_strategy: Optional[pulumi.Input[Union['CheckRetryStrategyArgs', 'CheckRetryStrategyArgsDict']]] = None,
                 run_parallel: Optional[pulumi.Input[bool]] = None,
                 runtime_id: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None,
                 setup_snippet_id: Optional[pulumi.Input[int]] = None,
                 should_fail: Optional[pulumi.Input[bool]] = None,
                 ssl_check: Optional[pulumi.Input[bool]] = None,
                 ssl_check_domain: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 teardown_snippet_id: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 use_global_alert_settings: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CheckArgs.__new__(CheckArgs)

            if activated is None and not opts.urn:
                raise TypeError("Missing required property 'activated'")
            __props__.__dict__["activated"] = activated
            __props__.__dict__["alert_channel_subscriptions"] = alert_channel_subscriptions
            __props__.__dict__["alert_settings"] = alert_settings
            __props__.__dict__["degraded_response_time"] = degraded_response_time
            __props__.__dict__["double_check"] = double_check
            __props__.__dict__["environment_variable"] = environment_variable
            __props__.__dict__["environment_variables"] = environment_variables
            if frequency is None and not opts.urn:
                raise TypeError("Missing required property 'frequency'")
            __props__.__dict__["frequency"] = frequency
            __props__.__dict__["frequency_offset"] = frequency_offset
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["group_order"] = group_order
            __props__.__dict__["local_setup_script"] = local_setup_script
            __props__.__dict__["local_teardown_script"] = local_teardown_script
            __props__.__dict__["locations"] = locations
            __props__.__dict__["max_response_time"] = max_response_time
            __props__.__dict__["muted"] = muted
            __props__.__dict__["name"] = name
            __props__.__dict__["private_locations"] = private_locations
            __props__.__dict__["request"] = request
            __props__.__dict__["retry_strategy"] = retry_strategy
            __props__.__dict__["run_parallel"] = run_parallel
            __props__.__dict__["runtime_id"] = runtime_id
            __props__.__dict__["script"] = script
            __props__.__dict__["setup_snippet_id"] = setup_snippet_id
            __props__.__dict__["should_fail"] = should_fail
            __props__.__dict__["ssl_check"] = ssl_check
            __props__.__dict__["ssl_check_domain"] = ssl_check_domain
            __props__.__dict__["tags"] = tags
            __props__.__dict__["teardown_snippet_id"] = teardown_snippet_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["use_global_alert_settings"] = use_global_alert_settings
        super(Check, __self__).__init__(
            'checkly:index/check:Check',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activated: Optional[pulumi.Input[bool]] = None,
            alert_channel_subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CheckAlertChannelSubscriptionArgs', 'CheckAlertChannelSubscriptionArgsDict']]]]] = None,
            alert_settings: Optional[pulumi.Input[Union['CheckAlertSettingsArgs', 'CheckAlertSettingsArgsDict']]] = None,
            degraded_response_time: Optional[pulumi.Input[int]] = None,
            double_check: Optional[pulumi.Input[bool]] = None,
            environment_variable: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CheckEnvironmentVariableArgs', 'CheckEnvironmentVariableArgsDict']]]]] = None,
            environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            frequency: Optional[pulumi.Input[int]] = None,
            frequency_offset: Optional[pulumi.Input[int]] = None,
            group_id: Optional[pulumi.Input[int]] = None,
            group_order: Optional[pulumi.Input[int]] = None,
            local_setup_script: Optional[pulumi.Input[str]] = None,
            local_teardown_script: Optional[pulumi.Input[str]] = None,
            locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            max_response_time: Optional[pulumi.Input[int]] = None,
            muted: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            private_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            request: Optional[pulumi.Input[Union['CheckRequestArgs', 'CheckRequestArgsDict']]] = None,
            retry_strategy: Optional[pulumi.Input[Union['CheckRetryStrategyArgs', 'CheckRetryStrategyArgsDict']]] = None,
            run_parallel: Optional[pulumi.Input[bool]] = None,
            runtime_id: Optional[pulumi.Input[str]] = None,
            script: Optional[pulumi.Input[str]] = None,
            setup_snippet_id: Optional[pulumi.Input[int]] = None,
            should_fail: Optional[pulumi.Input[bool]] = None,
            ssl_check: Optional[pulumi.Input[bool]] = None,
            ssl_check_domain: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            teardown_snippet_id: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[str]] = None,
            use_global_alert_settings: Optional[pulumi.Input[bool]] = None) -> 'Check':
        """
        Get an existing Check resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] activated: Determines if the check is running or not. Possible values `true`, and `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CheckAlertChannelSubscriptionArgs', 'CheckAlertChannelSubscriptionArgsDict']]]] alert_channel_subscriptions: An array of channel IDs and whether they're activated or not. If you don't set at least one alert subscription for your check, we won't be able to alert you in case something goes wrong with it.
        :param pulumi.Input[int] degraded_response_time: The response time in milliseconds starting from which a check should be considered degraded. Possible values are between 0 and 30000. (Default `15000`).
        :param pulumi.Input[bool] double_check: Setting this to `true` will trigger a retry when a check fails from the failing region and another, randomly selected region before marking the check as failed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CheckEnvironmentVariableArgs', 'CheckEnvironmentVariableArgsDict']]]] environment_variable: Key/value pairs for setting environment variables during check execution, add locked = true to keep value hidden, add secret = true to create a secret variable. These are only relevant for browser checks. Use global environment variables whenever possible.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Key/value pairs for setting environment variables during check execution. These are only relevant for browser checks. Use global environment variables whenever possible.
        :param pulumi.Input[int] frequency: The frequency in minutes to run the check. Possible values are `0`, `1`, `2`, `5`, `10`, `15`, `30`, `60`, `120`, `180`, `360`, `720`, and `1440`.
        :param pulumi.Input[int] frequency_offset: This property only valid for API high frequency checks. To create a hight frequency check, the property `frequency` must be `0` and `frequency_offset` could be `10`, `20` or `30`.
        :param pulumi.Input[int] group_id: The id of the check group this check is part of.
        :param pulumi.Input[int] group_order: The position of this check in a check group. It determines in what order checks are run when a group is triggered from the API or from CI/CD.
        :param pulumi.Input[str] local_setup_script: A valid piece of Node.js code to run in the setup phase.
        :param pulumi.Input[str] local_teardown_script: A valid piece of Node.js code to run in the teardown phase.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: An array of one or more data center locations where to run the this check. (Default ["us-east-1"])
        :param pulumi.Input[int] max_response_time: The response time in milliseconds starting from which a check should be considered failing. Possible values are between 0 and 30000. (Default `30000`).
        :param pulumi.Input[bool] muted: Determines if any notifications will be sent out when a check fails/degrades/recovers.
        :param pulumi.Input[str] name: The name of the check.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_locations: An array of one or more private locations slugs.
        :param pulumi.Input[Union['CheckRequestArgs', 'CheckRequestArgsDict']] request: An API check might have one request config.
        :param pulumi.Input[Union['CheckRetryStrategyArgs', 'CheckRetryStrategyArgsDict']] retry_strategy: A strategy for retrying failed check runs.
        :param pulumi.Input[bool] run_parallel: Determines if the check should run in all selected locations in parallel or round-robin.
        :param pulumi.Input[str] runtime_id: The id of the runtime to use for this check.
        :param pulumi.Input[str] script: A valid piece of Node.js JavaScript code describing a browser interaction with the Puppeteer/Playwright framework or a reference to an external JavaScript file.
        :param pulumi.Input[int] setup_snippet_id: An ID reference to a snippet to use in the setup phase of an API check.
        :param pulumi.Input[bool] should_fail: Allows to invert the behaviour of when a check is considered to fail. Allows for validating error status like 404.
        :param pulumi.Input[bool] ssl_check: Determines if the SSL certificate should be validated for expiry.
        :param pulumi.Input[str] ssl_check_domain: A valid fully qualified domain name (FQDN) to check its SSL certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags for organizing and filtering checks.
        :param pulumi.Input[int] teardown_snippet_id: An ID reference to a snippet to use in the teardown phase of an API check.
        :param pulumi.Input[str] type: The type of the check. Possible values are `API`, `BROWSER`, and `MULTI_STEP`.
        :param pulumi.Input[bool] use_global_alert_settings: When true, the account level alert settings will be used, not the alert setting defined on this check.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CheckState.__new__(_CheckState)

        __props__.__dict__["activated"] = activated
        __props__.__dict__["alert_channel_subscriptions"] = alert_channel_subscriptions
        __props__.__dict__["alert_settings"] = alert_settings
        __props__.__dict__["degraded_response_time"] = degraded_response_time
        __props__.__dict__["double_check"] = double_check
        __props__.__dict__["environment_variable"] = environment_variable
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["frequency_offset"] = frequency_offset
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["group_order"] = group_order
        __props__.__dict__["local_setup_script"] = local_setup_script
        __props__.__dict__["local_teardown_script"] = local_teardown_script
        __props__.__dict__["locations"] = locations
        __props__.__dict__["max_response_time"] = max_response_time
        __props__.__dict__["muted"] = muted
        __props__.__dict__["name"] = name
        __props__.__dict__["private_locations"] = private_locations
        __props__.__dict__["request"] = request
        __props__.__dict__["retry_strategy"] = retry_strategy
        __props__.__dict__["run_parallel"] = run_parallel
        __props__.__dict__["runtime_id"] = runtime_id
        __props__.__dict__["script"] = script
        __props__.__dict__["setup_snippet_id"] = setup_snippet_id
        __props__.__dict__["should_fail"] = should_fail
        __props__.__dict__["ssl_check"] = ssl_check
        __props__.__dict__["ssl_check_domain"] = ssl_check_domain
        __props__.__dict__["tags"] = tags
        __props__.__dict__["teardown_snippet_id"] = teardown_snippet_id
        __props__.__dict__["type"] = type
        __props__.__dict__["use_global_alert_settings"] = use_global_alert_settings
        return Check(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def activated(self) -> pulumi.Output[bool]:
        """
        Determines if the check is running or not. Possible values `true`, and `false`.
        """
        return pulumi.get(self, "activated")

    @property
    @pulumi.getter(name="alertChannelSubscriptions")
    def alert_channel_subscriptions(self) -> pulumi.Output[Optional[Sequence['outputs.CheckAlertChannelSubscription']]]:
        """
        An array of channel IDs and whether they're activated or not. If you don't set at least one alert subscription for your check, we won't be able to alert you in case something goes wrong with it.
        """
        return pulumi.get(self, "alert_channel_subscriptions")

    @property
    @pulumi.getter(name="alertSettings")
    def alert_settings(self) -> pulumi.Output['outputs.CheckAlertSettings']:
        return pulumi.get(self, "alert_settings")

    @property
    @pulumi.getter(name="degradedResponseTime")
    def degraded_response_time(self) -> pulumi.Output[Optional[int]]:
        """
        The response time in milliseconds starting from which a check should be considered degraded. Possible values are between 0 and 30000. (Default `15000`).
        """
        return pulumi.get(self, "degraded_response_time")

    @property
    @pulumi.getter(name="doubleCheck")
    @_utilities.deprecated("""The property `double_check` is deprecated and will be removed in a future version. To enable retries for failed check runs, use the `retry_strategy` property instead.""")
    def double_check(self) -> pulumi.Output[Optional[bool]]:
        """
        Setting this to `true` will trigger a retry when a check fails from the failing region and another, randomly selected region before marking the check as failed.
        """
        return pulumi.get(self, "double_check")

    @property
    @pulumi.getter(name="environmentVariable")
    def environment_variable(self) -> pulumi.Output[Optional[Sequence['outputs.CheckEnvironmentVariable']]]:
        """
        Key/value pairs for setting environment variables during check execution, add locked = true to keep value hidden, add secret = true to create a secret variable. These are only relevant for browser checks. Use global environment variables whenever possible.
        """
        return pulumi.get(self, "environment_variable")

    @property
    @pulumi.getter(name="environmentVariables")
    @_utilities.deprecated("""The property `environment_variables` is deprecated and will be removed in a future version. Consider using the new `environment_variable` list.""")
    def environment_variables(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key/value pairs for setting environment variables during check execution. These are only relevant for browser checks. Use global environment variables whenever possible.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[int]:
        """
        The frequency in minutes to run the check. Possible values are `0`, `1`, `2`, `5`, `10`, `15`, `30`, `60`, `120`, `180`, `360`, `720`, and `1440`.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="frequencyOffset")
    def frequency_offset(self) -> pulumi.Output[Optional[int]]:
        """
        This property only valid for API high frequency checks. To create a hight frequency check, the property `frequency` must be `0` and `frequency_offset` could be `10`, `20` or `30`.
        """
        return pulumi.get(self, "frequency_offset")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[Optional[int]]:
        """
        The id of the check group this check is part of.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupOrder")
    def group_order(self) -> pulumi.Output[Optional[int]]:
        """
        The position of this check in a check group. It determines in what order checks are run when a group is triggered from the API or from CI/CD.
        """
        return pulumi.get(self, "group_order")

    @property
    @pulumi.getter(name="localSetupScript")
    def local_setup_script(self) -> pulumi.Output[Optional[str]]:
        """
        A valid piece of Node.js code to run in the setup phase.
        """
        return pulumi.get(self, "local_setup_script")

    @property
    @pulumi.getter(name="localTeardownScript")
    def local_teardown_script(self) -> pulumi.Output[Optional[str]]:
        """
        A valid piece of Node.js code to run in the teardown phase.
        """
        return pulumi.get(self, "local_teardown_script")

    @property
    @pulumi.getter
    def locations(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array of one or more data center locations where to run the this check. (Default ["us-east-1"])
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="maxResponseTime")
    def max_response_time(self) -> pulumi.Output[Optional[int]]:
        """
        The response time in milliseconds starting from which a check should be considered failing. Possible values are between 0 and 30000. (Default `30000`).
        """
        return pulumi.get(self, "max_response_time")

    @property
    @pulumi.getter
    def muted(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if any notifications will be sent out when a check fails/degrades/recovers.
        """
        return pulumi.get(self, "muted")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the check.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLocations")
    def private_locations(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array of one or more private locations slugs.
        """
        return pulumi.get(self, "private_locations")

    @property
    @pulumi.getter
    def request(self) -> pulumi.Output[Optional['outputs.CheckRequest']]:
        """
        An API check might have one request config.
        """
        return pulumi.get(self, "request")

    @property
    @pulumi.getter(name="retryStrategy")
    def retry_strategy(self) -> pulumi.Output['outputs.CheckRetryStrategy']:
        """
        A strategy for retrying failed check runs.
        """
        return pulumi.get(self, "retry_strategy")

    @property
    @pulumi.getter(name="runParallel")
    def run_parallel(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if the check should run in all selected locations in parallel or round-robin.
        """
        return pulumi.get(self, "run_parallel")

    @property
    @pulumi.getter(name="runtimeId")
    def runtime_id(self) -> pulumi.Output[Optional[str]]:
        """
        The id of the runtime to use for this check.
        """
        return pulumi.get(self, "runtime_id")

    @property
    @pulumi.getter
    def script(self) -> pulumi.Output[Optional[str]]:
        """
        A valid piece of Node.js JavaScript code describing a browser interaction with the Puppeteer/Playwright framework or a reference to an external JavaScript file.
        """
        return pulumi.get(self, "script")

    @property
    @pulumi.getter(name="setupSnippetId")
    def setup_snippet_id(self) -> pulumi.Output[Optional[int]]:
        """
        An ID reference to a snippet to use in the setup phase of an API check.
        """
        return pulumi.get(self, "setup_snippet_id")

    @property
    @pulumi.getter(name="shouldFail")
    def should_fail(self) -> pulumi.Output[Optional[bool]]:
        """
        Allows to invert the behaviour of when a check is considered to fail. Allows for validating error status like 404.
        """
        return pulumi.get(self, "should_fail")

    @property
    @pulumi.getter(name="sslCheck")
    @_utilities.deprecated("""The property `ssl_check` is deprecated and it's ignored by the Checkly Public API. It will be removed in a future version.""")
    def ssl_check(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if the SSL certificate should be validated for expiry.
        """
        return pulumi.get(self, "ssl_check")

    @property
    @pulumi.getter(name="sslCheckDomain")
    def ssl_check_domain(self) -> pulumi.Output[Optional[str]]:
        """
        A valid fully qualified domain name (FQDN) to check its SSL certificate.
        """
        return pulumi.get(self, "ssl_check_domain")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of tags for organizing and filtering checks.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="teardownSnippetId")
    def teardown_snippet_id(self) -> pulumi.Output[Optional[int]]:
        """
        An ID reference to a snippet to use in the teardown phase of an API check.
        """
        return pulumi.get(self, "teardown_snippet_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the check. Possible values are `API`, `BROWSER`, and `MULTI_STEP`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="useGlobalAlertSettings")
    def use_global_alert_settings(self) -> pulumi.Output[Optional[bool]]:
        """
        When true, the account level alert settings will be used, not the alert setting defined on this check.
        """
        return pulumi.get(self, "use_global_alert_settings")

