# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HeartbeatCheckArgs', 'HeartbeatCheck']

@pulumi.input_type
class HeartbeatCheckArgs:
    def __init__(__self__, *,
                 activated: pulumi.Input[bool],
                 heartbeat: pulumi.Input['HeartbeatCheckHeartbeatArgs'],
                 alert_channel_subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input['HeartbeatCheckAlertChannelSubscriptionArgs']]]] = None,
                 alert_settings: Optional[pulumi.Input['HeartbeatCheckAlertSettingsArgs']] = None,
                 muted: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_global_alert_settings: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a HeartbeatCheck resource.
        :param pulumi.Input[bool] activated: Determines if the check is running or not. Possible values `true`, and `false`.
        :param pulumi.Input[bool] muted: Determines if any notifications will be sent out when a check fails/degrades/recovers.
        :param pulumi.Input[str] name: The name of the check.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags for organizing and filtering checks.
        :param pulumi.Input[bool] use_global_alert_settings: When true, the account level alert settings will be used, not the alert setting defined on this check.
        """
        pulumi.set(__self__, "activated", activated)
        pulumi.set(__self__, "heartbeat", heartbeat)
        if alert_channel_subscriptions is not None:
            pulumi.set(__self__, "alert_channel_subscriptions", alert_channel_subscriptions)
        if alert_settings is not None:
            pulumi.set(__self__, "alert_settings", alert_settings)
        if muted is not None:
            pulumi.set(__self__, "muted", muted)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_global_alert_settings is not None:
            pulumi.set(__self__, "use_global_alert_settings", use_global_alert_settings)

    @property
    @pulumi.getter
    def activated(self) -> pulumi.Input[bool]:
        """
        Determines if the check is running or not. Possible values `true`, and `false`.
        """
        return pulumi.get(self, "activated")

    @activated.setter
    def activated(self, value: pulumi.Input[bool]):
        pulumi.set(self, "activated", value)

    @property
    @pulumi.getter
    def heartbeat(self) -> pulumi.Input['HeartbeatCheckHeartbeatArgs']:
        return pulumi.get(self, "heartbeat")

    @heartbeat.setter
    def heartbeat(self, value: pulumi.Input['HeartbeatCheckHeartbeatArgs']):
        pulumi.set(self, "heartbeat", value)

    @property
    @pulumi.getter(name="alertChannelSubscriptions")
    def alert_channel_subscriptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HeartbeatCheckAlertChannelSubscriptionArgs']]]]:
        return pulumi.get(self, "alert_channel_subscriptions")

    @alert_channel_subscriptions.setter
    def alert_channel_subscriptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HeartbeatCheckAlertChannelSubscriptionArgs']]]]):
        pulumi.set(self, "alert_channel_subscriptions", value)

    @property
    @pulumi.getter(name="alertSettings")
    def alert_settings(self) -> Optional[pulumi.Input['HeartbeatCheckAlertSettingsArgs']]:
        return pulumi.get(self, "alert_settings")

    @alert_settings.setter
    def alert_settings(self, value: Optional[pulumi.Input['HeartbeatCheckAlertSettingsArgs']]):
        pulumi.set(self, "alert_settings", value)

    @property
    @pulumi.getter
    def muted(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if any notifications will be sent out when a check fails/degrades/recovers.
        """
        return pulumi.get(self, "muted")

    @muted.setter
    def muted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "muted", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the check.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags for organizing and filtering checks.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="useGlobalAlertSettings")
    def use_global_alert_settings(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, the account level alert settings will be used, not the alert setting defined on this check.
        """
        return pulumi.get(self, "use_global_alert_settings")

    @use_global_alert_settings.setter
    def use_global_alert_settings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_global_alert_settings", value)


@pulumi.input_type
class _HeartbeatCheckState:
    def __init__(__self__, *,
                 activated: Optional[pulumi.Input[bool]] = None,
                 alert_channel_subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input['HeartbeatCheckAlertChannelSubscriptionArgs']]]] = None,
                 alert_settings: Optional[pulumi.Input['HeartbeatCheckAlertSettingsArgs']] = None,
                 heartbeat: Optional[pulumi.Input['HeartbeatCheckHeartbeatArgs']] = None,
                 muted: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_global_alert_settings: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering HeartbeatCheck resources.
        :param pulumi.Input[bool] activated: Determines if the check is running or not. Possible values `true`, and `false`.
        :param pulumi.Input[bool] muted: Determines if any notifications will be sent out when a check fails/degrades/recovers.
        :param pulumi.Input[str] name: The name of the check.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags for organizing and filtering checks.
        :param pulumi.Input[bool] use_global_alert_settings: When true, the account level alert settings will be used, not the alert setting defined on this check.
        """
        if activated is not None:
            pulumi.set(__self__, "activated", activated)
        if alert_channel_subscriptions is not None:
            pulumi.set(__self__, "alert_channel_subscriptions", alert_channel_subscriptions)
        if alert_settings is not None:
            pulumi.set(__self__, "alert_settings", alert_settings)
        if heartbeat is not None:
            pulumi.set(__self__, "heartbeat", heartbeat)
        if muted is not None:
            pulumi.set(__self__, "muted", muted)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_global_alert_settings is not None:
            pulumi.set(__self__, "use_global_alert_settings", use_global_alert_settings)

    @property
    @pulumi.getter
    def activated(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if the check is running or not. Possible values `true`, and `false`.
        """
        return pulumi.get(self, "activated")

    @activated.setter
    def activated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "activated", value)

    @property
    @pulumi.getter(name="alertChannelSubscriptions")
    def alert_channel_subscriptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HeartbeatCheckAlertChannelSubscriptionArgs']]]]:
        return pulumi.get(self, "alert_channel_subscriptions")

    @alert_channel_subscriptions.setter
    def alert_channel_subscriptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HeartbeatCheckAlertChannelSubscriptionArgs']]]]):
        pulumi.set(self, "alert_channel_subscriptions", value)

    @property
    @pulumi.getter(name="alertSettings")
    def alert_settings(self) -> Optional[pulumi.Input['HeartbeatCheckAlertSettingsArgs']]:
        return pulumi.get(self, "alert_settings")

    @alert_settings.setter
    def alert_settings(self, value: Optional[pulumi.Input['HeartbeatCheckAlertSettingsArgs']]):
        pulumi.set(self, "alert_settings", value)

    @property
    @pulumi.getter
    def heartbeat(self) -> Optional[pulumi.Input['HeartbeatCheckHeartbeatArgs']]:
        return pulumi.get(self, "heartbeat")

    @heartbeat.setter
    def heartbeat(self, value: Optional[pulumi.Input['HeartbeatCheckHeartbeatArgs']]):
        pulumi.set(self, "heartbeat", value)

    @property
    @pulumi.getter
    def muted(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if any notifications will be sent out when a check fails/degrades/recovers.
        """
        return pulumi.get(self, "muted")

    @muted.setter
    def muted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "muted", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the check.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags for organizing and filtering checks.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="useGlobalAlertSettings")
    def use_global_alert_settings(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, the account level alert settings will be used, not the alert setting defined on this check.
        """
        return pulumi.get(self, "use_global_alert_settings")

    @use_global_alert_settings.setter
    def use_global_alert_settings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_global_alert_settings", value)


class HeartbeatCheck(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activated: Optional[pulumi.Input[bool]] = None,
                 alert_channel_subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HeartbeatCheckAlertChannelSubscriptionArgs', 'HeartbeatCheckAlertChannelSubscriptionArgsDict']]]]] = None,
                 alert_settings: Optional[pulumi.Input[Union['HeartbeatCheckAlertSettingsArgs', 'HeartbeatCheckAlertSettingsArgsDict']]] = None,
                 heartbeat: Optional[pulumi.Input[Union['HeartbeatCheckHeartbeatArgs', 'HeartbeatCheckHeartbeatArgsDict']]] = None,
                 muted: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_global_alert_settings: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Heartbeats allows you to monitor your cron jobs and set up alerting, so you get a notification when things break or slow down.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_checkly as checkly

        example_heartbeat = checkly.HeartbeatCheck("example-heartbeat",
            name="Example heartbeat",
            activated=True,
            heartbeat={
                "period": 7,
                "period_unit": "days",
                "grace": 1,
                "grace_unit": "days",
            },
            use_global_alert_settings=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] activated: Determines if the check is running or not. Possible values `true`, and `false`.
        :param pulumi.Input[bool] muted: Determines if any notifications will be sent out when a check fails/degrades/recovers.
        :param pulumi.Input[str] name: The name of the check.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags for organizing and filtering checks.
        :param pulumi.Input[bool] use_global_alert_settings: When true, the account level alert settings will be used, not the alert setting defined on this check.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HeartbeatCheckArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Heartbeats allows you to monitor your cron jobs and set up alerting, so you get a notification when things break or slow down.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_checkly as checkly

        example_heartbeat = checkly.HeartbeatCheck("example-heartbeat",
            name="Example heartbeat",
            activated=True,
            heartbeat={
                "period": 7,
                "period_unit": "days",
                "grace": 1,
                "grace_unit": "days",
            },
            use_global_alert_settings=True)
        ```

        :param str resource_name: The name of the resource.
        :param HeartbeatCheckArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HeartbeatCheckArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activated: Optional[pulumi.Input[bool]] = None,
                 alert_channel_subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HeartbeatCheckAlertChannelSubscriptionArgs', 'HeartbeatCheckAlertChannelSubscriptionArgsDict']]]]] = None,
                 alert_settings: Optional[pulumi.Input[Union['HeartbeatCheckAlertSettingsArgs', 'HeartbeatCheckAlertSettingsArgsDict']]] = None,
                 heartbeat: Optional[pulumi.Input[Union['HeartbeatCheckHeartbeatArgs', 'HeartbeatCheckHeartbeatArgsDict']]] = None,
                 muted: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_global_alert_settings: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HeartbeatCheckArgs.__new__(HeartbeatCheckArgs)

            if activated is None and not opts.urn:
                raise TypeError("Missing required property 'activated'")
            __props__.__dict__["activated"] = activated
            __props__.__dict__["alert_channel_subscriptions"] = alert_channel_subscriptions
            __props__.__dict__["alert_settings"] = alert_settings
            if heartbeat is None and not opts.urn:
                raise TypeError("Missing required property 'heartbeat'")
            __props__.__dict__["heartbeat"] = heartbeat
            __props__.__dict__["muted"] = muted
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["use_global_alert_settings"] = use_global_alert_settings
        super(HeartbeatCheck, __self__).__init__(
            'checkly:index/heartbeatCheck:HeartbeatCheck',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activated: Optional[pulumi.Input[bool]] = None,
            alert_channel_subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HeartbeatCheckAlertChannelSubscriptionArgs', 'HeartbeatCheckAlertChannelSubscriptionArgsDict']]]]] = None,
            alert_settings: Optional[pulumi.Input[Union['HeartbeatCheckAlertSettingsArgs', 'HeartbeatCheckAlertSettingsArgsDict']]] = None,
            heartbeat: Optional[pulumi.Input[Union['HeartbeatCheckHeartbeatArgs', 'HeartbeatCheckHeartbeatArgsDict']]] = None,
            muted: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            use_global_alert_settings: Optional[pulumi.Input[bool]] = None) -> 'HeartbeatCheck':
        """
        Get an existing HeartbeatCheck resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] activated: Determines if the check is running or not. Possible values `true`, and `false`.
        :param pulumi.Input[bool] muted: Determines if any notifications will be sent out when a check fails/degrades/recovers.
        :param pulumi.Input[str] name: The name of the check.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags for organizing and filtering checks.
        :param pulumi.Input[bool] use_global_alert_settings: When true, the account level alert settings will be used, not the alert setting defined on this check.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HeartbeatCheckState.__new__(_HeartbeatCheckState)

        __props__.__dict__["activated"] = activated
        __props__.__dict__["alert_channel_subscriptions"] = alert_channel_subscriptions
        __props__.__dict__["alert_settings"] = alert_settings
        __props__.__dict__["heartbeat"] = heartbeat
        __props__.__dict__["muted"] = muted
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["use_global_alert_settings"] = use_global_alert_settings
        return HeartbeatCheck(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def activated(self) -> pulumi.Output[bool]:
        """
        Determines if the check is running or not. Possible values `true`, and `false`.
        """
        return pulumi.get(self, "activated")

    @property
    @pulumi.getter(name="alertChannelSubscriptions")
    def alert_channel_subscriptions(self) -> pulumi.Output[Optional[Sequence['outputs.HeartbeatCheckAlertChannelSubscription']]]:
        return pulumi.get(self, "alert_channel_subscriptions")

    @property
    @pulumi.getter(name="alertSettings")
    def alert_settings(self) -> pulumi.Output['outputs.HeartbeatCheckAlertSettings']:
        return pulumi.get(self, "alert_settings")

    @property
    @pulumi.getter
    def heartbeat(self) -> pulumi.Output['outputs.HeartbeatCheckHeartbeat']:
        return pulumi.get(self, "heartbeat")

    @property
    @pulumi.getter
    def muted(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if any notifications will be sent out when a check fails/degrades/recovers.
        """
        return pulumi.get(self, "muted")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the check.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of tags for organizing and filtering checks.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="useGlobalAlertSettings")
    def use_global_alert_settings(self) -> pulumi.Output[Optional[bool]]:
        """
        When true, the account level alert settings will be used, not the alert setting defined on this check.
        """
        return pulumi.get(self, "use_global_alert_settings")

