# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'AlertChannelCall',
    'AlertChannelEmail',
    'AlertChannelOpsgenie',
    'AlertChannelPagerduty',
    'AlertChannelSlack',
    'AlertChannelSms',
    'AlertChannelWebhook',
    'CheckAlertChannelSubscription',
    'CheckAlertSettings',
    'CheckAlertSettingsParallelRunFailureThreshold',
    'CheckAlertSettingsReminder',
    'CheckAlertSettingsRunBasedEscalation',
    'CheckAlertSettingsSslCertificate',
    'CheckAlertSettingsTimeBasedEscalation',
    'CheckEnvironmentVariable',
    'CheckGroupAlertChannelSubscription',
    'CheckGroupAlertSettings',
    'CheckGroupAlertSettingsParallelRunFailureThreshold',
    'CheckGroupAlertSettingsReminder',
    'CheckGroupAlertSettingsRunBasedEscalation',
    'CheckGroupAlertSettingsSslCertificate',
    'CheckGroupAlertSettingsTimeBasedEscalation',
    'CheckGroupApiCheckDefaults',
    'CheckGroupApiCheckDefaultsAssertion',
    'CheckGroupApiCheckDefaultsBasicAuth',
    'CheckGroupEnvironmentVariable',
    'CheckGroupRetryStrategy',
    'CheckRequest',
    'CheckRequestAssertion',
    'CheckRequestBasicAuth',
    'CheckRetryStrategy',
    'HeartbeatCheckAlertChannelSubscription',
    'HeartbeatCheckAlertSettings',
    'HeartbeatCheckAlertSettingsParallelRunFailureThreshold',
    'HeartbeatCheckAlertSettingsReminder',
    'HeartbeatCheckAlertSettingsRunBasedEscalation',
    'HeartbeatCheckAlertSettingsSslCertificate',
    'HeartbeatCheckAlertSettingsTimeBasedEscalation',
    'HeartbeatCheckHeartbeat',
    'TcpCheckAlertChannelSubscription',
    'TcpCheckAlertSettings',
    'TcpCheckAlertSettingsParallelRunFailureThreshold',
    'TcpCheckAlertSettingsReminder',
    'TcpCheckAlertSettingsRunBasedEscalation',
    'TcpCheckAlertSettingsTimeBasedEscalation',
    'TcpCheckRequest',
    'TcpCheckRequestAssertion',
    'TcpCheckRetryStrategy',
]

@pulumi.output_type
class AlertChannelCall(dict):
    def __init__(__self__, *,
                 name: str,
                 number: str):
        """
        :param str name: The name of this alert channel
        :param str number: The mobile number to receive the alerts
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "number", number)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of this alert channel
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def number(self) -> str:
        """
        The mobile number to receive the alerts
        """
        return pulumi.get(self, "number")


@pulumi.output_type
class AlertChannelEmail(dict):
    def __init__(__self__, *,
                 address: str):
        """
        :param str address: The email address of this email alert channel.
        """
        pulumi.set(__self__, "address", address)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The email address of this email alert channel.
        """
        return pulumi.get(self, "address")


@pulumi.output_type
class AlertChannelOpsgenie(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertChannelOpsgenie. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertChannelOpsgenie.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertChannelOpsgenie.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 name: str,
                 priority: str,
                 region: str):
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> str:
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")


@pulumi.output_type
class AlertChannelPagerduty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceKey":
            suggest = "service_key"
        elif key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertChannelPagerduty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertChannelPagerduty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertChannelPagerduty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_key: str,
                 account: Optional[str] = None,
                 service_name: Optional[str] = None):
        pulumi.set(__self__, "service_key", service_key)
        if account is not None:
            pulumi.set(__self__, "account", account)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="serviceKey")
    def service_key(self) -> str:
        return pulumi.get(self, "service_key")

    @property
    @pulumi.getter
    def account(self) -> Optional[str]:
        return pulumi.get(self, "account")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        return pulumi.get(self, "service_name")


@pulumi.output_type
class AlertChannelSlack(dict):
    def __init__(__self__, *,
                 channel: str,
                 url: str):
        """
        :param str channel: The name of the alert's Slack channel
        :param str url: The Slack webhook URL
        """
        pulumi.set(__self__, "channel", channel)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def channel(self) -> str:
        """
        The name of the alert's Slack channel
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The Slack webhook URL
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class AlertChannelSms(dict):
    def __init__(__self__, *,
                 name: str,
                 number: str):
        """
        :param str name: The name of this alert channel
        :param str number: The mobile number to receive the alerts
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "number", number)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of this alert channel
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def number(self) -> str:
        """
        The mobile number to receive the alerts
        """
        return pulumi.get(self, "number")


@pulumi.output_type
class AlertChannelWebhook(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryParameters":
            suggest = "query_parameters"
        elif key == "webhookSecret":
            suggest = "webhook_secret"
        elif key == "webhookType":
            suggest = "webhook_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertChannelWebhook. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertChannelWebhook.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertChannelWebhook.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 url: str,
                 headers: Optional[Mapping[str, str]] = None,
                 method: Optional[str] = None,
                 query_parameters: Optional[Mapping[str, str]] = None,
                 template: Optional[str] = None,
                 webhook_secret: Optional[str] = None,
                 webhook_type: Optional[str] = None):
        """
        :param str method: (Default `POST`)
        :param str webhook_type: Type of the webhook. Possible values are 'WEBHOOK*DISCORD', 'WEBHOOK*FIREHYDRANT', 'WEBHOOK*GITLAB*ALERT', 'WEBHOOK*SPIKESH', 'WEBHOOK*SPLUNK', 'WEBHOOK*MSTEAMS' and 'WEBHOOK*TELEGRAM'.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if query_parameters is not None:
            pulumi.set(__self__, "query_parameters", query_parameters)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if webhook_secret is not None:
            pulumi.set(__self__, "webhook_secret", webhook_secret)
        if webhook_type is not None:
            pulumi.set(__self__, "webhook_type", webhook_type)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        (Default `POST`)
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="queryParameters")
    def query_parameters(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "query_parameters")

    @property
    @pulumi.getter
    def template(self) -> Optional[str]:
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="webhookSecret")
    def webhook_secret(self) -> Optional[str]:
        return pulumi.get(self, "webhook_secret")

    @property
    @pulumi.getter(name="webhookType")
    def webhook_type(self) -> Optional[str]:
        """
        Type of the webhook. Possible values are 'WEBHOOK*DISCORD', 'WEBHOOK*FIREHYDRANT', 'WEBHOOK*GITLAB*ALERT', 'WEBHOOK*SPIKESH', 'WEBHOOK*SPLUNK', 'WEBHOOK*MSTEAMS' and 'WEBHOOK*TELEGRAM'.
        """
        return pulumi.get(self, "webhook_type")


@pulumi.output_type
class CheckAlertChannelSubscription(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelId":
            suggest = "channel_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckAlertChannelSubscription. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckAlertChannelSubscription.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckAlertChannelSubscription.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 activated: bool,
                 channel_id: int):
        pulumi.set(__self__, "activated", activated)
        pulumi.set(__self__, "channel_id", channel_id)

    @property
    @pulumi.getter
    def activated(self) -> bool:
        return pulumi.get(self, "activated")

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> int:
        return pulumi.get(self, "channel_id")


@pulumi.output_type
class CheckAlertSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "escalationType":
            suggest = "escalation_type"
        elif key == "parallelRunFailureThresholds":
            suggest = "parallel_run_failure_thresholds"
        elif key == "runBasedEscalations":
            suggest = "run_based_escalations"
        elif key == "sslCertificates":
            suggest = "ssl_certificates"
        elif key == "timeBasedEscalations":
            suggest = "time_based_escalations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckAlertSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckAlertSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckAlertSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 escalation_type: Optional[str] = None,
                 parallel_run_failure_thresholds: Optional[Sequence['outputs.CheckAlertSettingsParallelRunFailureThreshold']] = None,
                 reminders: Optional[Sequence['outputs.CheckAlertSettingsReminder']] = None,
                 run_based_escalations: Optional[Sequence['outputs.CheckAlertSettingsRunBasedEscalation']] = None,
                 ssl_certificates: Optional[Sequence['outputs.CheckAlertSettingsSslCertificate']] = None,
                 time_based_escalations: Optional[Sequence['outputs.CheckAlertSettingsTimeBasedEscalation']] = None):
        """
        :param str escalation_type: Determines what type of escalation to use. Possible values are `RUN_BASED` or `TIME_BASED`.
        """
        if escalation_type is not None:
            pulumi.set(__self__, "escalation_type", escalation_type)
        if parallel_run_failure_thresholds is not None:
            pulumi.set(__self__, "parallel_run_failure_thresholds", parallel_run_failure_thresholds)
        if reminders is not None:
            pulumi.set(__self__, "reminders", reminders)
        if run_based_escalations is not None:
            pulumi.set(__self__, "run_based_escalations", run_based_escalations)
        if ssl_certificates is not None:
            pulumi.set(__self__, "ssl_certificates", ssl_certificates)
        if time_based_escalations is not None:
            pulumi.set(__self__, "time_based_escalations", time_based_escalations)

    @property
    @pulumi.getter(name="escalationType")
    def escalation_type(self) -> Optional[str]:
        """
        Determines what type of escalation to use. Possible values are `RUN_BASED` or `TIME_BASED`.
        """
        return pulumi.get(self, "escalation_type")

    @property
    @pulumi.getter(name="parallelRunFailureThresholds")
    def parallel_run_failure_thresholds(self) -> Optional[Sequence['outputs.CheckAlertSettingsParallelRunFailureThreshold']]:
        return pulumi.get(self, "parallel_run_failure_thresholds")

    @property
    @pulumi.getter
    def reminders(self) -> Optional[Sequence['outputs.CheckAlertSettingsReminder']]:
        return pulumi.get(self, "reminders")

    @property
    @pulumi.getter(name="runBasedEscalations")
    def run_based_escalations(self) -> Optional[Sequence['outputs.CheckAlertSettingsRunBasedEscalation']]:
        return pulumi.get(self, "run_based_escalations")

    @property
    @pulumi.getter(name="sslCertificates")
    @_utilities.deprecated("""This property is deprecated and it's ignored by the Checkly Public API. It will be removed in a future version.""")
    def ssl_certificates(self) -> Optional[Sequence['outputs.CheckAlertSettingsSslCertificate']]:
        return pulumi.get(self, "ssl_certificates")

    @property
    @pulumi.getter(name="timeBasedEscalations")
    def time_based_escalations(self) -> Optional[Sequence['outputs.CheckAlertSettingsTimeBasedEscalation']]:
        return pulumi.get(self, "time_based_escalations")


@pulumi.output_type
class CheckAlertSettingsParallelRunFailureThreshold(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 percentage: Optional[int] = None):
        """
        :param bool enabled: Applicable only for checks scheduled in parallel in multiple locations.
        :param int percentage: Possible values are `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `100`, and `100`. (Default `10`).
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Applicable only for checks scheduled in parallel in multiple locations.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def percentage(self) -> Optional[int]:
        """
        Possible values are `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `100`, and `100`. (Default `10`).
        """
        return pulumi.get(self, "percentage")


@pulumi.output_type
class CheckAlertSettingsReminder(dict):
    def __init__(__self__, *,
                 amount: Optional[int] = None,
                 interval: Optional[int] = None):
        """
        :param int amount: How many reminders to send out after the initial alert notification. Possible values are `0`, `1`, `2`, `3`, `4`, `5`, and `100000`
        :param int interval: Possible values are `5`, `10`, `15`, and `30`. (Default `5`).
        """
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)

    @property
    @pulumi.getter
    def amount(self) -> Optional[int]:
        """
        How many reminders to send out after the initial alert notification. Possible values are `0`, `1`, `2`, `3`, `4`, `5`, and `100000`
        """
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        Possible values are `5`, `10`, `15`, and `30`. (Default `5`).
        """
        return pulumi.get(self, "interval")


@pulumi.output_type
class CheckAlertSettingsRunBasedEscalation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failedRunThreshold":
            suggest = "failed_run_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckAlertSettingsRunBasedEscalation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckAlertSettingsRunBasedEscalation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckAlertSettingsRunBasedEscalation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failed_run_threshold: Optional[int] = None):
        """
        :param int failed_run_threshold: After how many failed consecutive check runs an alert notification should be sent. Possible values are between 1 and 5. (Default `1`).
        """
        if failed_run_threshold is not None:
            pulumi.set(__self__, "failed_run_threshold", failed_run_threshold)

    @property
    @pulumi.getter(name="failedRunThreshold")
    def failed_run_threshold(self) -> Optional[int]:
        """
        After how many failed consecutive check runs an alert notification should be sent. Possible values are between 1 and 5. (Default `1`).
        """
        return pulumi.get(self, "failed_run_threshold")


@pulumi.output_type
class CheckAlertSettingsSslCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertThreshold":
            suggest = "alert_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckAlertSettingsSslCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckAlertSettingsSslCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckAlertSettingsSslCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alert_threshold: Optional[int] = None,
                 enabled: Optional[bool] = None):
        """
        :param int alert_threshold: How long before SSL certificate expiry to send alerts. Possible values `3`, `7`, `14`, `30`. (Default `3`).
        :param bool enabled: Determines if alert notifications should be sent for expiring SSL certificates. Possible values `true`, and `false`. (Default `false`).
        """
        if alert_threshold is not None:
            pulumi.set(__self__, "alert_threshold", alert_threshold)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="alertThreshold")
    def alert_threshold(self) -> Optional[int]:
        """
        How long before SSL certificate expiry to send alerts. Possible values `3`, `7`, `14`, `30`. (Default `3`).
        """
        return pulumi.get(self, "alert_threshold")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Determines if alert notifications should be sent for expiring SSL certificates. Possible values `true`, and `false`. (Default `false`).
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class CheckAlertSettingsTimeBasedEscalation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minutesFailingThreshold":
            suggest = "minutes_failing_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckAlertSettingsTimeBasedEscalation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckAlertSettingsTimeBasedEscalation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckAlertSettingsTimeBasedEscalation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 minutes_failing_threshold: Optional[int] = None):
        """
        :param int minutes_failing_threshold: After how many minutes after a check starts failing an alert should be sent. Possible values are `5`, `10`, `15`, and `30`. (Default `5`).
        """
        if minutes_failing_threshold is not None:
            pulumi.set(__self__, "minutes_failing_threshold", minutes_failing_threshold)

    @property
    @pulumi.getter(name="minutesFailingThreshold")
    def minutes_failing_threshold(self) -> Optional[int]:
        """
        After how many minutes after a check starts failing an alert should be sent. Possible values are `5`, `10`, `15`, and `30`. (Default `5`).
        """
        return pulumi.get(self, "minutes_failing_threshold")


@pulumi.output_type
class CheckEnvironmentVariable(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str,
                 locked: Optional[bool] = None,
                 secret: Optional[bool] = None):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def locked(self) -> Optional[bool]:
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def secret(self) -> Optional[bool]:
        return pulumi.get(self, "secret")


@pulumi.output_type
class CheckGroupAlertChannelSubscription(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelId":
            suggest = "channel_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckGroupAlertChannelSubscription. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckGroupAlertChannelSubscription.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckGroupAlertChannelSubscription.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 activated: bool,
                 channel_id: int):
        pulumi.set(__self__, "activated", activated)
        pulumi.set(__self__, "channel_id", channel_id)

    @property
    @pulumi.getter
    def activated(self) -> bool:
        return pulumi.get(self, "activated")

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> int:
        return pulumi.get(self, "channel_id")


@pulumi.output_type
class CheckGroupAlertSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "escalationType":
            suggest = "escalation_type"
        elif key == "parallelRunFailureThresholds":
            suggest = "parallel_run_failure_thresholds"
        elif key == "runBasedEscalations":
            suggest = "run_based_escalations"
        elif key == "sslCertificates":
            suggest = "ssl_certificates"
        elif key == "timeBasedEscalations":
            suggest = "time_based_escalations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckGroupAlertSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckGroupAlertSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckGroupAlertSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 escalation_type: Optional[str] = None,
                 parallel_run_failure_thresholds: Optional[Sequence['outputs.CheckGroupAlertSettingsParallelRunFailureThreshold']] = None,
                 reminders: Optional[Sequence['outputs.CheckGroupAlertSettingsReminder']] = None,
                 run_based_escalations: Optional[Sequence['outputs.CheckGroupAlertSettingsRunBasedEscalation']] = None,
                 ssl_certificates: Optional[Sequence['outputs.CheckGroupAlertSettingsSslCertificate']] = None,
                 time_based_escalations: Optional[Sequence['outputs.CheckGroupAlertSettingsTimeBasedEscalation']] = None):
        """
        :param str escalation_type: Determines what type of escalation to use. Possible values are `RUN_BASED` or `TIME_BASED`.
        """
        if escalation_type is not None:
            pulumi.set(__self__, "escalation_type", escalation_type)
        if parallel_run_failure_thresholds is not None:
            pulumi.set(__self__, "parallel_run_failure_thresholds", parallel_run_failure_thresholds)
        if reminders is not None:
            pulumi.set(__self__, "reminders", reminders)
        if run_based_escalations is not None:
            pulumi.set(__self__, "run_based_escalations", run_based_escalations)
        if ssl_certificates is not None:
            pulumi.set(__self__, "ssl_certificates", ssl_certificates)
        if time_based_escalations is not None:
            pulumi.set(__self__, "time_based_escalations", time_based_escalations)

    @property
    @pulumi.getter(name="escalationType")
    def escalation_type(self) -> Optional[str]:
        """
        Determines what type of escalation to use. Possible values are `RUN_BASED` or `TIME_BASED`.
        """
        return pulumi.get(self, "escalation_type")

    @property
    @pulumi.getter(name="parallelRunFailureThresholds")
    def parallel_run_failure_thresholds(self) -> Optional[Sequence['outputs.CheckGroupAlertSettingsParallelRunFailureThreshold']]:
        return pulumi.get(self, "parallel_run_failure_thresholds")

    @property
    @pulumi.getter
    def reminders(self) -> Optional[Sequence['outputs.CheckGroupAlertSettingsReminder']]:
        return pulumi.get(self, "reminders")

    @property
    @pulumi.getter(name="runBasedEscalations")
    def run_based_escalations(self) -> Optional[Sequence['outputs.CheckGroupAlertSettingsRunBasedEscalation']]:
        return pulumi.get(self, "run_based_escalations")

    @property
    @pulumi.getter(name="sslCertificates")
    @_utilities.deprecated("""This property is deprecated and it's ignored by the Checkly Public API. It will be removed in a future version.""")
    def ssl_certificates(self) -> Optional[Sequence['outputs.CheckGroupAlertSettingsSslCertificate']]:
        return pulumi.get(self, "ssl_certificates")

    @property
    @pulumi.getter(name="timeBasedEscalations")
    def time_based_escalations(self) -> Optional[Sequence['outputs.CheckGroupAlertSettingsTimeBasedEscalation']]:
        return pulumi.get(self, "time_based_escalations")


@pulumi.output_type
class CheckGroupAlertSettingsParallelRunFailureThreshold(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 percentage: Optional[int] = None):
        """
        :param bool enabled: Applicable only for checks scheduled in parallel in multiple locations.
        :param int percentage: Possible values are `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `100`, and `100`. (Default `10`).
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Applicable only for checks scheduled in parallel in multiple locations.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def percentage(self) -> Optional[int]:
        """
        Possible values are `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `100`, and `100`. (Default `10`).
        """
        return pulumi.get(self, "percentage")


@pulumi.output_type
class CheckGroupAlertSettingsReminder(dict):
    def __init__(__self__, *,
                 amount: Optional[int] = None,
                 interval: Optional[int] = None):
        """
        :param int amount: How many reminders to send out after the initial alert notification. Possible values are `0`, `1`, `2`, `3`, `4`, `5`, and `100000`
        :param int interval: Possible values are `5`, `10`, `15`, and `30`. (Default `5`).
        """
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)

    @property
    @pulumi.getter
    def amount(self) -> Optional[int]:
        """
        How many reminders to send out after the initial alert notification. Possible values are `0`, `1`, `2`, `3`, `4`, `5`, and `100000`
        """
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        Possible values are `5`, `10`, `15`, and `30`. (Default `5`).
        """
        return pulumi.get(self, "interval")


@pulumi.output_type
class CheckGroupAlertSettingsRunBasedEscalation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failedRunThreshold":
            suggest = "failed_run_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckGroupAlertSettingsRunBasedEscalation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckGroupAlertSettingsRunBasedEscalation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckGroupAlertSettingsRunBasedEscalation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failed_run_threshold: Optional[int] = None):
        """
        :param int failed_run_threshold: After how many failed consecutive check runs an alert notification should be sent. Possible values are between 1 and 5. (Default `1`).
        """
        if failed_run_threshold is not None:
            pulumi.set(__self__, "failed_run_threshold", failed_run_threshold)

    @property
    @pulumi.getter(name="failedRunThreshold")
    def failed_run_threshold(self) -> Optional[int]:
        """
        After how many failed consecutive check runs an alert notification should be sent. Possible values are between 1 and 5. (Default `1`).
        """
        return pulumi.get(self, "failed_run_threshold")


@pulumi.output_type
class CheckGroupAlertSettingsSslCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertThreshold":
            suggest = "alert_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckGroupAlertSettingsSslCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckGroupAlertSettingsSslCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckGroupAlertSettingsSslCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alert_threshold: Optional[int] = None,
                 enabled: Optional[bool] = None):
        """
        :param int alert_threshold: At what moment in time to start alerting on SSL certificates. Possible values `3`, `7`, `14`, `30`. (Default `3`).
        :param bool enabled: Determines if alert notifications should be sent for expiring SSL certificates.
        """
        if alert_threshold is not None:
            pulumi.set(__self__, "alert_threshold", alert_threshold)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="alertThreshold")
    def alert_threshold(self) -> Optional[int]:
        """
        At what moment in time to start alerting on SSL certificates. Possible values `3`, `7`, `14`, `30`. (Default `3`).
        """
        return pulumi.get(self, "alert_threshold")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Determines if alert notifications should be sent for expiring SSL certificates.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class CheckGroupAlertSettingsTimeBasedEscalation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minutesFailingThreshold":
            suggest = "minutes_failing_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckGroupAlertSettingsTimeBasedEscalation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckGroupAlertSettingsTimeBasedEscalation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckGroupAlertSettingsTimeBasedEscalation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 minutes_failing_threshold: Optional[int] = None):
        """
        :param int minutes_failing_threshold: After how many minutes after a check starts failing an alert should be sent. Possible values are `5`, `10`, `15`, and `30`. (Default `5`).
        """
        if minutes_failing_threshold is not None:
            pulumi.set(__self__, "minutes_failing_threshold", minutes_failing_threshold)

    @property
    @pulumi.getter(name="minutesFailingThreshold")
    def minutes_failing_threshold(self) -> Optional[int]:
        """
        After how many minutes after a check starts failing an alert should be sent. Possible values are `5`, `10`, `15`, and `30`. (Default `5`).
        """
        return pulumi.get(self, "minutes_failing_threshold")


@pulumi.output_type
class CheckGroupApiCheckDefaults(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuth":
            suggest = "basic_auth"
        elif key == "queryParameters":
            suggest = "query_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckGroupApiCheckDefaults. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckGroupApiCheckDefaults.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckGroupApiCheckDefaults.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assertions: Optional[Sequence['outputs.CheckGroupApiCheckDefaultsAssertion']] = None,
                 basic_auth: Optional['outputs.CheckGroupApiCheckDefaultsBasicAuth'] = None,
                 headers: Optional[Mapping[str, str]] = None,
                 query_parameters: Optional[Mapping[str, str]] = None,
                 url: Optional[str] = None):
        """
        :param str url: The base url for this group which you can reference with the `GROUP_BASE_URL` variable in all group checks.
        """
        if assertions is not None:
            pulumi.set(__self__, "assertions", assertions)
        if basic_auth is not None:
            pulumi.set(__self__, "basic_auth", basic_auth)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_parameters is not None:
            pulumi.set(__self__, "query_parameters", query_parameters)
        if url is None:
            url = ''
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def assertions(self) -> Optional[Sequence['outputs.CheckGroupApiCheckDefaultsAssertion']]:
        return pulumi.get(self, "assertions")

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> Optional['outputs.CheckGroupApiCheckDefaultsBasicAuth']:
        return pulumi.get(self, "basic_auth")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="queryParameters")
    def query_parameters(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "query_parameters")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The base url for this group which you can reference with the `GROUP_BASE_URL` variable in all group checks.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class CheckGroupApiCheckDefaultsAssertion(dict):
    def __init__(__self__, *,
                 comparison: str,
                 source: str,
                 target: str,
                 property: Optional[str] = None):
        """
        :param str comparison: The type of comparison to be executed between expected and actual value of the assertion. Possible values `EQUALS`, `NOT_EQUALS`, `HAS_KEY`, `NOT_HAS_KEY`, `HAS_VALUE`, `NOT_HAS_VALUE`, `IS_EMPTY`, `NOT_EMPTY`, `GREATER_THAN`, `LESS_THAN`, `CONTAINS`, `NOT_CONTAINS`, `IS_NULL`, and `NOT_NULL`.
        :param str source: The source of the asserted value. Possible values `STATUS_CODE`, `JSON_BODY`, `HEADERS`, `TEXT_BODY`, and `RESPONSE_TIME`.
        """
        pulumi.set(__self__, "comparison", comparison)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "target", target)
        if property is not None:
            pulumi.set(__self__, "property", property)

    @property
    @pulumi.getter
    def comparison(self) -> str:
        """
        The type of comparison to be executed between expected and actual value of the assertion. Possible values `EQUALS`, `NOT_EQUALS`, `HAS_KEY`, `NOT_HAS_KEY`, `HAS_VALUE`, `NOT_HAS_VALUE`, `IS_EMPTY`, `NOT_EMPTY`, `GREATER_THAN`, `LESS_THAN`, `CONTAINS`, `NOT_CONTAINS`, `IS_NULL`, and `NOT_NULL`.
        """
        return pulumi.get(self, "comparison")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source of the asserted value. Possible values `STATUS_CODE`, `JSON_BODY`, `HEADERS`, `TEXT_BODY`, and `RESPONSE_TIME`.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def target(self) -> str:
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def property(self) -> Optional[str]:
        return pulumi.get(self, "property")


@pulumi.output_type
class CheckGroupApiCheckDefaultsBasicAuth(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


@pulumi.output_type
class CheckGroupEnvironmentVariable(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str,
                 locked: Optional[bool] = None,
                 secret: Optional[bool] = None):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def locked(self) -> Optional[bool]:
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def secret(self) -> Optional[bool]:
        return pulumi.get(self, "secret")


@pulumi.output_type
class CheckGroupRetryStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseBackoffSeconds":
            suggest = "base_backoff_seconds"
        elif key == "maxDurationSeconds":
            suggest = "max_duration_seconds"
        elif key == "maxRetries":
            suggest = "max_retries"
        elif key == "sameRegion":
            suggest = "same_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckGroupRetryStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckGroupRetryStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckGroupRetryStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 base_backoff_seconds: Optional[int] = None,
                 max_duration_seconds: Optional[int] = None,
                 max_retries: Optional[int] = None,
                 same_region: Optional[bool] = None):
        """
        :param str type: Determines which type of retry strategy to use. Possible values are `FIXED`, `LINEAR`, or `EXPONENTIAL`.
        :param int base_backoff_seconds: The number of seconds to wait before the first retry attempt.
        :param int max_duration_seconds: The total amount of time to continue retrying the check (maximum 600 seconds).
        :param int max_retries: The maximum number of times to retry the check. Value must be between 1 and 10.
        :param bool same_region: Whether retries should be run in the same region as the initial check run.
        """
        pulumi.set(__self__, "type", type)
        if base_backoff_seconds is not None:
            pulumi.set(__self__, "base_backoff_seconds", base_backoff_seconds)
        if max_duration_seconds is not None:
            pulumi.set(__self__, "max_duration_seconds", max_duration_seconds)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if same_region is not None:
            pulumi.set(__self__, "same_region", same_region)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Determines which type of retry strategy to use. Possible values are `FIXED`, `LINEAR`, or `EXPONENTIAL`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="baseBackoffSeconds")
    def base_backoff_seconds(self) -> Optional[int]:
        """
        The number of seconds to wait before the first retry attempt.
        """
        return pulumi.get(self, "base_backoff_seconds")

    @property
    @pulumi.getter(name="maxDurationSeconds")
    def max_duration_seconds(self) -> Optional[int]:
        """
        The total amount of time to continue retrying the check (maximum 600 seconds).
        """
        return pulumi.get(self, "max_duration_seconds")

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[int]:
        """
        The maximum number of times to retry the check. Value must be between 1 and 10.
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter(name="sameRegion")
    def same_region(self) -> Optional[bool]:
        """
        Whether retries should be run in the same region as the initial check run.
        """
        return pulumi.get(self, "same_region")


@pulumi.output_type
class CheckRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuth":
            suggest = "basic_auth"
        elif key == "bodyType":
            suggest = "body_type"
        elif key == "followRedirects":
            suggest = "follow_redirects"
        elif key == "ipFamily":
            suggest = "ip_family"
        elif key == "queryParameters":
            suggest = "query_parameters"
        elif key == "skipSsl":
            suggest = "skip_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: str,
                 assertions: Optional[Sequence['outputs.CheckRequestAssertion']] = None,
                 basic_auth: Optional['outputs.CheckRequestBasicAuth'] = None,
                 body: Optional[str] = None,
                 body_type: Optional[str] = None,
                 follow_redirects: Optional[bool] = None,
                 headers: Optional[Mapping[str, str]] = None,
                 ip_family: Optional[str] = None,
                 method: Optional[str] = None,
                 query_parameters: Optional[Mapping[str, str]] = None,
                 skip_ssl: Optional[bool] = None):
        """
        :param Sequence['CheckRequestAssertionArgs'] assertions: A request can have multiple assertions.
        :param 'CheckRequestBasicAuthArgs' basic_auth: Set up HTTP basic authentication (username & password).
        :param str body: The body of the request.
        :param str body_type: The `Content-Type` header of the request. Possible values `NONE`, `JSON`, `FORM`, `RAW`, and `GRAPHQL`.
        :param str ip_family: IP Family to be used when executing the api check. The value can be either IPv4 or IPv6.
        :param str method: The HTTP method to use for this API check. Possible values are `GET`, `POST`, `PUT`, `HEAD`, `DELETE`, `PATCH`. (Default `GET`).
        """
        pulumi.set(__self__, "url", url)
        if assertions is not None:
            pulumi.set(__self__, "assertions", assertions)
        if basic_auth is not None:
            pulumi.set(__self__, "basic_auth", basic_auth)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if body_type is not None:
            pulumi.set(__self__, "body_type", body_type)
        if follow_redirects is not None:
            pulumi.set(__self__, "follow_redirects", follow_redirects)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if ip_family is not None:
            pulumi.set(__self__, "ip_family", ip_family)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if query_parameters is not None:
            pulumi.set(__self__, "query_parameters", query_parameters)
        if skip_ssl is not None:
            pulumi.set(__self__, "skip_ssl", skip_ssl)

    @property
    @pulumi.getter
    def url(self) -> str:
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def assertions(self) -> Optional[Sequence['outputs.CheckRequestAssertion']]:
        """
        A request can have multiple assertions.
        """
        return pulumi.get(self, "assertions")

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> Optional['outputs.CheckRequestBasicAuth']:
        """
        Set up HTTP basic authentication (username & password).
        """
        return pulumi.get(self, "basic_auth")

    @property
    @pulumi.getter
    def body(self) -> Optional[str]:
        """
        The body of the request.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="bodyType")
    def body_type(self) -> Optional[str]:
        """
        The `Content-Type` header of the request. Possible values `NONE`, `JSON`, `FORM`, `RAW`, and `GRAPHQL`.
        """
        return pulumi.get(self, "body_type")

    @property
    @pulumi.getter(name="followRedirects")
    def follow_redirects(self) -> Optional[bool]:
        return pulumi.get(self, "follow_redirects")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="ipFamily")
    def ip_family(self) -> Optional[str]:
        """
        IP Family to be used when executing the api check. The value can be either IPv4 or IPv6.
        """
        return pulumi.get(self, "ip_family")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        The HTTP method to use for this API check. Possible values are `GET`, `POST`, `PUT`, `HEAD`, `DELETE`, `PATCH`. (Default `GET`).
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="queryParameters")
    def query_parameters(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "query_parameters")

    @property
    @pulumi.getter(name="skipSsl")
    def skip_ssl(self) -> Optional[bool]:
        return pulumi.get(self, "skip_ssl")


@pulumi.output_type
class CheckRequestAssertion(dict):
    def __init__(__self__, *,
                 comparison: str,
                 source: str,
                 property: Optional[str] = None,
                 target: Optional[str] = None):
        """
        :param str comparison: The type of comparison to be executed between expected and actual value of the assertion. Possible values `EQUALS`, `NOT_EQUALS`, `HAS_KEY`, `NOT_HAS_KEY`, `HAS_VALUE`, `NOT_HAS_VALUE`, `IS_EMPTY`, `NOT_EMPTY`, `GREATER_THAN`, `LESS_THAN`, `CONTAINS`, `NOT_CONTAINS`, `IS_NULL`, and `NOT_NULL`.
        :param str source: The source of the asserted value. Possible values `STATUS_CODE`, `JSON_BODY`, `HEADERS`, `TEXT_BODY`, and `RESPONSE_TIME`.
        """
        pulumi.set(__self__, "comparison", comparison)
        pulumi.set(__self__, "source", source)
        if property is not None:
            pulumi.set(__self__, "property", property)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def comparison(self) -> str:
        """
        The type of comparison to be executed between expected and actual value of the assertion. Possible values `EQUALS`, `NOT_EQUALS`, `HAS_KEY`, `NOT_HAS_KEY`, `HAS_VALUE`, `NOT_HAS_VALUE`, `IS_EMPTY`, `NOT_EMPTY`, `GREATER_THAN`, `LESS_THAN`, `CONTAINS`, `NOT_CONTAINS`, `IS_NULL`, and `NOT_NULL`.
        """
        return pulumi.get(self, "comparison")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source of the asserted value. Possible values `STATUS_CODE`, `JSON_BODY`, `HEADERS`, `TEXT_BODY`, and `RESPONSE_TIME`.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def property(self) -> Optional[str]:
        return pulumi.get(self, "property")


@pulumi.output_type
class CheckRequestBasicAuth(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


@pulumi.output_type
class CheckRetryStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseBackoffSeconds":
            suggest = "base_backoff_seconds"
        elif key == "maxDurationSeconds":
            suggest = "max_duration_seconds"
        elif key == "maxRetries":
            suggest = "max_retries"
        elif key == "sameRegion":
            suggest = "same_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckRetryStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckRetryStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckRetryStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 base_backoff_seconds: Optional[int] = None,
                 max_duration_seconds: Optional[int] = None,
                 max_retries: Optional[int] = None,
                 same_region: Optional[bool] = None):
        """
        :param str type: Determines which type of retry strategy to use. Possible values are `FIXED`, `LINEAR`, or `EXPONENTIAL`.
        :param int base_backoff_seconds: The number of seconds to wait before the first retry attempt.
        :param int max_duration_seconds: The total amount of time to continue retrying the check (maximum 600 seconds).
        :param int max_retries: The maximum number of times to retry the check. Value must be between 1 and 10.
        :param bool same_region: Whether retries should be run in the same region as the initial check run.
        """
        pulumi.set(__self__, "type", type)
        if base_backoff_seconds is not None:
            pulumi.set(__self__, "base_backoff_seconds", base_backoff_seconds)
        if max_duration_seconds is not None:
            pulumi.set(__self__, "max_duration_seconds", max_duration_seconds)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if same_region is not None:
            pulumi.set(__self__, "same_region", same_region)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Determines which type of retry strategy to use. Possible values are `FIXED`, `LINEAR`, or `EXPONENTIAL`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="baseBackoffSeconds")
    def base_backoff_seconds(self) -> Optional[int]:
        """
        The number of seconds to wait before the first retry attempt.
        """
        return pulumi.get(self, "base_backoff_seconds")

    @property
    @pulumi.getter(name="maxDurationSeconds")
    def max_duration_seconds(self) -> Optional[int]:
        """
        The total amount of time to continue retrying the check (maximum 600 seconds).
        """
        return pulumi.get(self, "max_duration_seconds")

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[int]:
        """
        The maximum number of times to retry the check. Value must be between 1 and 10.
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter(name="sameRegion")
    def same_region(self) -> Optional[bool]:
        """
        Whether retries should be run in the same region as the initial check run.
        """
        return pulumi.get(self, "same_region")


@pulumi.output_type
class HeartbeatCheckAlertChannelSubscription(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelId":
            suggest = "channel_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HeartbeatCheckAlertChannelSubscription. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HeartbeatCheckAlertChannelSubscription.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HeartbeatCheckAlertChannelSubscription.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 activated: bool,
                 channel_id: int):
        pulumi.set(__self__, "activated", activated)
        pulumi.set(__self__, "channel_id", channel_id)

    @property
    @pulumi.getter
    def activated(self) -> bool:
        return pulumi.get(self, "activated")

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> int:
        return pulumi.get(self, "channel_id")


@pulumi.output_type
class HeartbeatCheckAlertSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "escalationType":
            suggest = "escalation_type"
        elif key == "parallelRunFailureThresholds":
            suggest = "parallel_run_failure_thresholds"
        elif key == "runBasedEscalations":
            suggest = "run_based_escalations"
        elif key == "sslCertificates":
            suggest = "ssl_certificates"
        elif key == "timeBasedEscalations":
            suggest = "time_based_escalations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HeartbeatCheckAlertSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HeartbeatCheckAlertSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HeartbeatCheckAlertSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 escalation_type: Optional[str] = None,
                 parallel_run_failure_thresholds: Optional[Sequence['outputs.HeartbeatCheckAlertSettingsParallelRunFailureThreshold']] = None,
                 reminders: Optional[Sequence['outputs.HeartbeatCheckAlertSettingsReminder']] = None,
                 run_based_escalations: Optional[Sequence['outputs.HeartbeatCheckAlertSettingsRunBasedEscalation']] = None,
                 ssl_certificates: Optional[Sequence['outputs.HeartbeatCheckAlertSettingsSslCertificate']] = None,
                 time_based_escalations: Optional[Sequence['outputs.HeartbeatCheckAlertSettingsTimeBasedEscalation']] = None):
        """
        :param str escalation_type: Determines what type of escalation to use. Possible values are `RUN_BASED` or `TIME_BASED`.
        """
        if escalation_type is not None:
            pulumi.set(__self__, "escalation_type", escalation_type)
        if parallel_run_failure_thresholds is not None:
            pulumi.set(__self__, "parallel_run_failure_thresholds", parallel_run_failure_thresholds)
        if reminders is not None:
            pulumi.set(__self__, "reminders", reminders)
        if run_based_escalations is not None:
            pulumi.set(__self__, "run_based_escalations", run_based_escalations)
        if ssl_certificates is not None:
            pulumi.set(__self__, "ssl_certificates", ssl_certificates)
        if time_based_escalations is not None:
            pulumi.set(__self__, "time_based_escalations", time_based_escalations)

    @property
    @pulumi.getter(name="escalationType")
    def escalation_type(self) -> Optional[str]:
        """
        Determines what type of escalation to use. Possible values are `RUN_BASED` or `TIME_BASED`.
        """
        return pulumi.get(self, "escalation_type")

    @property
    @pulumi.getter(name="parallelRunFailureThresholds")
    def parallel_run_failure_thresholds(self) -> Optional[Sequence['outputs.HeartbeatCheckAlertSettingsParallelRunFailureThreshold']]:
        return pulumi.get(self, "parallel_run_failure_thresholds")

    @property
    @pulumi.getter
    def reminders(self) -> Optional[Sequence['outputs.HeartbeatCheckAlertSettingsReminder']]:
        return pulumi.get(self, "reminders")

    @property
    @pulumi.getter(name="runBasedEscalations")
    def run_based_escalations(self) -> Optional[Sequence['outputs.HeartbeatCheckAlertSettingsRunBasedEscalation']]:
        return pulumi.get(self, "run_based_escalations")

    @property
    @pulumi.getter(name="sslCertificates")
    @_utilities.deprecated("""This property is deprecated and it's ignored by the Checkly Public API. It will be removed in a future version.""")
    def ssl_certificates(self) -> Optional[Sequence['outputs.HeartbeatCheckAlertSettingsSslCertificate']]:
        return pulumi.get(self, "ssl_certificates")

    @property
    @pulumi.getter(name="timeBasedEscalations")
    def time_based_escalations(self) -> Optional[Sequence['outputs.HeartbeatCheckAlertSettingsTimeBasedEscalation']]:
        return pulumi.get(self, "time_based_escalations")


@pulumi.output_type
class HeartbeatCheckAlertSettingsParallelRunFailureThreshold(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 percentage: Optional[int] = None):
        """
        :param bool enabled: Applicable only for checks scheduled in parallel in multiple locations.
        :param int percentage: Possible values are `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `100`, and `100`. (Default `10`).
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Applicable only for checks scheduled in parallel in multiple locations.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def percentage(self) -> Optional[int]:
        """
        Possible values are `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `100`, and `100`. (Default `10`).
        """
        return pulumi.get(self, "percentage")


@pulumi.output_type
class HeartbeatCheckAlertSettingsReminder(dict):
    def __init__(__self__, *,
                 amount: Optional[int] = None,
                 interval: Optional[int] = None):
        """
        :param int amount: How many reminders to send out after the initial alert notification. Possible values are `0`, `1`, `2`, `3`, `4`, `5`, and `100000`
        :param int interval: Possible values are `5`, `10`, `15`, and `30`. (Default `5`).
        """
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)

    @property
    @pulumi.getter
    def amount(self) -> Optional[int]:
        """
        How many reminders to send out after the initial alert notification. Possible values are `0`, `1`, `2`, `3`, `4`, `5`, and `100000`
        """
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        Possible values are `5`, `10`, `15`, and `30`. (Default `5`).
        """
        return pulumi.get(self, "interval")


@pulumi.output_type
class HeartbeatCheckAlertSettingsRunBasedEscalation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failedRunThreshold":
            suggest = "failed_run_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HeartbeatCheckAlertSettingsRunBasedEscalation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HeartbeatCheckAlertSettingsRunBasedEscalation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HeartbeatCheckAlertSettingsRunBasedEscalation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failed_run_threshold: Optional[int] = None):
        """
        :param int failed_run_threshold: After how many failed consecutive check runs an alert notification should be sent. Possible values are between 1 and 5. (Default `1`).
        """
        if failed_run_threshold is not None:
            pulumi.set(__self__, "failed_run_threshold", failed_run_threshold)

    @property
    @pulumi.getter(name="failedRunThreshold")
    def failed_run_threshold(self) -> Optional[int]:
        """
        After how many failed consecutive check runs an alert notification should be sent. Possible values are between 1 and 5. (Default `1`).
        """
        return pulumi.get(self, "failed_run_threshold")


@pulumi.output_type
class HeartbeatCheckAlertSettingsSslCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertThreshold":
            suggest = "alert_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HeartbeatCheckAlertSettingsSslCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HeartbeatCheckAlertSettingsSslCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HeartbeatCheckAlertSettingsSslCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alert_threshold: Optional[int] = None,
                 enabled: Optional[bool] = None):
        """
        :param int alert_threshold: How long before SSL certificate expiry to send alerts. Possible values `3`, `7`, `14`, `30`. (Default `3`).
        :param bool enabled: Determines if alert notifications should be sent for expiring SSL certificates. Possible values `true`, and `false`. (Default `false`).
        """
        if alert_threshold is not None:
            pulumi.set(__self__, "alert_threshold", alert_threshold)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="alertThreshold")
    def alert_threshold(self) -> Optional[int]:
        """
        How long before SSL certificate expiry to send alerts. Possible values `3`, `7`, `14`, `30`. (Default `3`).
        """
        return pulumi.get(self, "alert_threshold")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Determines if alert notifications should be sent for expiring SSL certificates. Possible values `true`, and `false`. (Default `false`).
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class HeartbeatCheckAlertSettingsTimeBasedEscalation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minutesFailingThreshold":
            suggest = "minutes_failing_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HeartbeatCheckAlertSettingsTimeBasedEscalation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HeartbeatCheckAlertSettingsTimeBasedEscalation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HeartbeatCheckAlertSettingsTimeBasedEscalation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 minutes_failing_threshold: Optional[int] = None):
        """
        :param int minutes_failing_threshold: After how many minutes after a check starts failing an alert should be sent. Possible values are `5`, `10`, `15`, and `30`. (Default `5`).
        """
        if minutes_failing_threshold is not None:
            pulumi.set(__self__, "minutes_failing_threshold", minutes_failing_threshold)

    @property
    @pulumi.getter(name="minutesFailingThreshold")
    def minutes_failing_threshold(self) -> Optional[int]:
        """
        After how many minutes after a check starts failing an alert should be sent. Possible values are `5`, `10`, `15`, and `30`. (Default `5`).
        """
        return pulumi.get(self, "minutes_failing_threshold")


@pulumi.output_type
class HeartbeatCheckHeartbeat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "graceUnit":
            suggest = "grace_unit"
        elif key == "periodUnit":
            suggest = "period_unit"
        elif key == "pingToken":
            suggest = "ping_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HeartbeatCheckHeartbeat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HeartbeatCheckHeartbeat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HeartbeatCheckHeartbeat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 grace: int,
                 grace_unit: str,
                 period: int,
                 period_unit: str,
                 ping_token: Optional[str] = None):
        """
        :param int grace: How long Checkly should wait before triggering any alerts when a ping does not arrive within the set period.
        :param str grace_unit: Possible values `seconds`, `minutes`, `hours` and `days`.
        :param int period: How often you expect a ping to the ping URL.
        :param str period_unit: Possible values `seconds`, `minutes`, `hours` and `days`.
        :param str ping_token: Custom token to generate your ping URL. Checkly will expect a ping to `https://ping.checklyhq.com/[PING_TOKEN]`.
        """
        pulumi.set(__self__, "grace", grace)
        pulumi.set(__self__, "grace_unit", grace_unit)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "period_unit", period_unit)
        if ping_token is not None:
            pulumi.set(__self__, "ping_token", ping_token)

    @property
    @pulumi.getter
    def grace(self) -> int:
        """
        How long Checkly should wait before triggering any alerts when a ping does not arrive within the set period.
        """
        return pulumi.get(self, "grace")

    @property
    @pulumi.getter(name="graceUnit")
    def grace_unit(self) -> str:
        """
        Possible values `seconds`, `minutes`, `hours` and `days`.
        """
        return pulumi.get(self, "grace_unit")

    @property
    @pulumi.getter
    def period(self) -> int:
        """
        How often you expect a ping to the ping URL.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> str:
        """
        Possible values `seconds`, `minutes`, `hours` and `days`.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter(name="pingToken")
    def ping_token(self) -> Optional[str]:
        """
        Custom token to generate your ping URL. Checkly will expect a ping to `https://ping.checklyhq.com/[PING_TOKEN]`.
        """
        return pulumi.get(self, "ping_token")


@pulumi.output_type
class TcpCheckAlertChannelSubscription(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelId":
            suggest = "channel_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TcpCheckAlertChannelSubscription. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TcpCheckAlertChannelSubscription.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TcpCheckAlertChannelSubscription.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 activated: bool,
                 channel_id: int):
        pulumi.set(__self__, "activated", activated)
        pulumi.set(__self__, "channel_id", channel_id)

    @property
    @pulumi.getter
    def activated(self) -> bool:
        return pulumi.get(self, "activated")

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> int:
        return pulumi.get(self, "channel_id")


@pulumi.output_type
class TcpCheckAlertSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "escalationType":
            suggest = "escalation_type"
        elif key == "parallelRunFailureThresholds":
            suggest = "parallel_run_failure_thresholds"
        elif key == "runBasedEscalations":
            suggest = "run_based_escalations"
        elif key == "timeBasedEscalations":
            suggest = "time_based_escalations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TcpCheckAlertSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TcpCheckAlertSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TcpCheckAlertSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 escalation_type: Optional[str] = None,
                 parallel_run_failure_thresholds: Optional[Sequence['outputs.TcpCheckAlertSettingsParallelRunFailureThreshold']] = None,
                 reminders: Optional[Sequence['outputs.TcpCheckAlertSettingsReminder']] = None,
                 run_based_escalations: Optional[Sequence['outputs.TcpCheckAlertSettingsRunBasedEscalation']] = None,
                 time_based_escalations: Optional[Sequence['outputs.TcpCheckAlertSettingsTimeBasedEscalation']] = None):
        """
        :param str escalation_type: Determines what type of escalation to use. Possible values are `RUN_BASED` or `TIME_BASED`.
        """
        if escalation_type is not None:
            pulumi.set(__self__, "escalation_type", escalation_type)
        if parallel_run_failure_thresholds is not None:
            pulumi.set(__self__, "parallel_run_failure_thresholds", parallel_run_failure_thresholds)
        if reminders is not None:
            pulumi.set(__self__, "reminders", reminders)
        if run_based_escalations is not None:
            pulumi.set(__self__, "run_based_escalations", run_based_escalations)
        if time_based_escalations is not None:
            pulumi.set(__self__, "time_based_escalations", time_based_escalations)

    @property
    @pulumi.getter(name="escalationType")
    def escalation_type(self) -> Optional[str]:
        """
        Determines what type of escalation to use. Possible values are `RUN_BASED` or `TIME_BASED`.
        """
        return pulumi.get(self, "escalation_type")

    @property
    @pulumi.getter(name="parallelRunFailureThresholds")
    def parallel_run_failure_thresholds(self) -> Optional[Sequence['outputs.TcpCheckAlertSettingsParallelRunFailureThreshold']]:
        return pulumi.get(self, "parallel_run_failure_thresholds")

    @property
    @pulumi.getter
    def reminders(self) -> Optional[Sequence['outputs.TcpCheckAlertSettingsReminder']]:
        return pulumi.get(self, "reminders")

    @property
    @pulumi.getter(name="runBasedEscalations")
    def run_based_escalations(self) -> Optional[Sequence['outputs.TcpCheckAlertSettingsRunBasedEscalation']]:
        return pulumi.get(self, "run_based_escalations")

    @property
    @pulumi.getter(name="timeBasedEscalations")
    def time_based_escalations(self) -> Optional[Sequence['outputs.TcpCheckAlertSettingsTimeBasedEscalation']]:
        return pulumi.get(self, "time_based_escalations")


@pulumi.output_type
class TcpCheckAlertSettingsParallelRunFailureThreshold(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 percentage: Optional[int] = None):
        """
        :param bool enabled: Applicable only for checks scheduled in parallel in multiple locations.
        :param int percentage: Possible values are `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `100`, and `100`. (Default `10`).
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Applicable only for checks scheduled in parallel in multiple locations.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def percentage(self) -> Optional[int]:
        """
        Possible values are `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `100`, and `100`. (Default `10`).
        """
        return pulumi.get(self, "percentage")


@pulumi.output_type
class TcpCheckAlertSettingsReminder(dict):
    def __init__(__self__, *,
                 amount: Optional[int] = None,
                 interval: Optional[int] = None):
        """
        :param int amount: How many reminders to send out after the initial alert notification. Possible values are `0`, `1`, `2`, `3`, `4`, `5`, and `100000`
        :param int interval: Possible values are `5`, `10`, `15`, and `30`. (Default `5`).
        """
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)

    @property
    @pulumi.getter
    def amount(self) -> Optional[int]:
        """
        How many reminders to send out after the initial alert notification. Possible values are `0`, `1`, `2`, `3`, `4`, `5`, and `100000`
        """
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        Possible values are `5`, `10`, `15`, and `30`. (Default `5`).
        """
        return pulumi.get(self, "interval")


@pulumi.output_type
class TcpCheckAlertSettingsRunBasedEscalation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failedRunThreshold":
            suggest = "failed_run_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TcpCheckAlertSettingsRunBasedEscalation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TcpCheckAlertSettingsRunBasedEscalation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TcpCheckAlertSettingsRunBasedEscalation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failed_run_threshold: Optional[int] = None):
        """
        :param int failed_run_threshold: After how many failed consecutive check runs an alert notification should be sent. Possible values are between 1 and 5. (Default `1`).
        """
        if failed_run_threshold is not None:
            pulumi.set(__self__, "failed_run_threshold", failed_run_threshold)

    @property
    @pulumi.getter(name="failedRunThreshold")
    def failed_run_threshold(self) -> Optional[int]:
        """
        After how many failed consecutive check runs an alert notification should be sent. Possible values are between 1 and 5. (Default `1`).
        """
        return pulumi.get(self, "failed_run_threshold")


@pulumi.output_type
class TcpCheckAlertSettingsTimeBasedEscalation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minutesFailingThreshold":
            suggest = "minutes_failing_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TcpCheckAlertSettingsTimeBasedEscalation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TcpCheckAlertSettingsTimeBasedEscalation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TcpCheckAlertSettingsTimeBasedEscalation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 minutes_failing_threshold: Optional[int] = None):
        """
        :param int minutes_failing_threshold: After how many minutes after a check starts failing an alert should be sent. Possible values are `5`, `10`, `15`, and `30`. (Default `5`).
        """
        if minutes_failing_threshold is not None:
            pulumi.set(__self__, "minutes_failing_threshold", minutes_failing_threshold)

    @property
    @pulumi.getter(name="minutesFailingThreshold")
    def minutes_failing_threshold(self) -> Optional[int]:
        """
        After how many minutes after a check starts failing an alert should be sent. Possible values are `5`, `10`, `15`, and `30`. (Default `5`).
        """
        return pulumi.get(self, "minutes_failing_threshold")


@pulumi.output_type
class TcpCheckRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipFamily":
            suggest = "ip_family"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TcpCheckRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TcpCheckRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TcpCheckRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: str,
                 port: int,
                 assertions: Optional[Sequence['outputs.TcpCheckRequestAssertion']] = None,
                 data: Optional[str] = None,
                 ip_family: Optional[str] = None):
        """
        :param str hostname: The hostname or IP to connect to. Do not include a scheme or a port in this value.
        :param int port: The port number to connect to.
        :param Sequence['TcpCheckRequestAssertionArgs'] assertions: A request can have multiple assertions.
        :param str data: The data to send to the target host.
        :param str ip_family: The IP family to use when executing the TCP check. The value can be either `IPv4` or `IPv6`.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)
        if assertions is not None:
            pulumi.set(__self__, "assertions", assertions)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if ip_family is not None:
            pulumi.set(__self__, "ip_family", ip_family)

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        The hostname or IP to connect to. Do not include a scheme or a port in this value.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port number to connect to.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def assertions(self) -> Optional[Sequence['outputs.TcpCheckRequestAssertion']]:
        """
        A request can have multiple assertions.
        """
        return pulumi.get(self, "assertions")

    @property
    @pulumi.getter
    def data(self) -> Optional[str]:
        """
        The data to send to the target host.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="ipFamily")
    def ip_family(self) -> Optional[str]:
        """
        The IP family to use when executing the TCP check. The value can be either `IPv4` or `IPv6`.
        """
        return pulumi.get(self, "ip_family")


@pulumi.output_type
class TcpCheckRequestAssertion(dict):
    def __init__(__self__, *,
                 comparison: str,
                 source: str,
                 property: Optional[str] = None,
                 target: Optional[str] = None):
        """
        :param str comparison: The type of comparison to be executed between expected and actual value of the assertion. Possible values are `EQUALS`, `NOT_EQUALS`, `HAS_KEY`, `NOT_HAS_KEY`, `HAS_VALUE`, `NOT_HAS_VALUE`, `IS_EMPTY`, `NOT_EMPTY`, `GREATER_THAN`, `LESS_THAN`, `CONTAINS`, `NOT_CONTAINS`, `IS_NULL`, and `NOT_NULL`.
        :param str source: The source of the asserted value. Possible values are `RESPONSE_DATA` and `RESPONSE_TIME`.
        """
        pulumi.set(__self__, "comparison", comparison)
        pulumi.set(__self__, "source", source)
        if property is not None:
            pulumi.set(__self__, "property", property)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def comparison(self) -> str:
        """
        The type of comparison to be executed between expected and actual value of the assertion. Possible values are `EQUALS`, `NOT_EQUALS`, `HAS_KEY`, `NOT_HAS_KEY`, `HAS_VALUE`, `NOT_HAS_VALUE`, `IS_EMPTY`, `NOT_EMPTY`, `GREATER_THAN`, `LESS_THAN`, `CONTAINS`, `NOT_CONTAINS`, `IS_NULL`, and `NOT_NULL`.
        """
        return pulumi.get(self, "comparison")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source of the asserted value. Possible values are `RESPONSE_DATA` and `RESPONSE_TIME`.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def property(self) -> Optional[str]:
        return pulumi.get(self, "property")


@pulumi.output_type
class TcpCheckRetryStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseBackoffSeconds":
            suggest = "base_backoff_seconds"
        elif key == "maxDurationSeconds":
            suggest = "max_duration_seconds"
        elif key == "maxRetries":
            suggest = "max_retries"
        elif key == "sameRegion":
            suggest = "same_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TcpCheckRetryStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TcpCheckRetryStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TcpCheckRetryStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 base_backoff_seconds: Optional[int] = None,
                 max_duration_seconds: Optional[int] = None,
                 max_retries: Optional[int] = None,
                 same_region: Optional[bool] = None):
        """
        :param str type: Determines which type of retry strategy to use. Possible values are `FIXED`, `LINEAR`, or `EXPONENTIAL`.
        :param int base_backoff_seconds: The number of seconds to wait before the first retry attempt.
        :param int max_duration_seconds: The total amount of time to continue retrying the check (maximum 600 seconds).
        :param int max_retries: The maximum number of times to retry the check. Value must be between 1 and 10.
        :param bool same_region: Whether retries should be run in the same region as the initial check run.
        """
        pulumi.set(__self__, "type", type)
        if base_backoff_seconds is not None:
            pulumi.set(__self__, "base_backoff_seconds", base_backoff_seconds)
        if max_duration_seconds is not None:
            pulumi.set(__self__, "max_duration_seconds", max_duration_seconds)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if same_region is not None:
            pulumi.set(__self__, "same_region", same_region)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Determines which type of retry strategy to use. Possible values are `FIXED`, `LINEAR`, or `EXPONENTIAL`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="baseBackoffSeconds")
    def base_backoff_seconds(self) -> Optional[int]:
        """
        The number of seconds to wait before the first retry attempt.
        """
        return pulumi.get(self, "base_backoff_seconds")

    @property
    @pulumi.getter(name="maxDurationSeconds")
    def max_duration_seconds(self) -> Optional[int]:
        """
        The total amount of time to continue retrying the check (maximum 600 seconds).
        """
        return pulumi.get(self, "max_duration_seconds")

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[int]:
        """
        The maximum number of times to retry the check. Value must be between 1 and 10.
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter(name="sameRegion")
    def same_region(self) -> Optional[bool]:
        """
        Whether retries should be run in the same region as the initial check run.
        """
        return pulumi.get(self, "same_region")


