"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosWebRule = exports.RosSchedulerRule = exports.RosSceneDefensePolicy = exports.RosProInstance = exports.RosPremiumInstance = exports.RosPort = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosPortProps`
 *
 * @param properties - the TypeScript properties of a `RosPortProps`
 *
 * @returns the result of the validation.
 */
function RosPortPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('backendPort', ros.validateString)(properties.backendPort));
    errors.collect(ros.propertyValidator('instanceId', ros.requiredValidator)(properties.instanceId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('realServers', ros.requiredValidator)(properties.realServers));
    if (properties.realServers && (Array.isArray(properties.realServers) || (typeof properties.realServers) === 'string')) {
        errors.collect(ros.propertyValidator('realServers', ros.validateLength)({
            data: properties.realServers.length,
            min: 0,
            max: 20,
        }));
    }
    errors.collect(ros.propertyValidator('realServers', ros.listValidator(ros.validateString))(properties.realServers));
    errors.collect(ros.propertyValidator('frontendPort', ros.validateString)(properties.frontendPort));
    errors.collect(ros.propertyValidator('frontendProtocol', ros.requiredValidator)(properties.frontendProtocol));
    if (properties.frontendProtocol && (typeof properties.frontendProtocol) !== 'object') {
        errors.collect(ros.propertyValidator('frontendProtocol', ros.validateAllowedValues)({
            data: properties.frontendProtocol,
            allowedValues: ["tcp", "udp"],
        }));
    }
    errors.collect(ros.propertyValidator('frontendProtocol', ros.validateString)(properties.frontendProtocol));
    return errors.wrap('supplied properties not correct for "RosPortProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::Port` resource
 *
 * @param properties - the TypeScript properties of a `RosPortProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::Port` resource.
 */
// @ts-ignore TS6133
function rosPortPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosPortPropsValidator(properties).assertSuccess();
    }
    return {
        'FrontendProtocol': ros.stringToRosTemplate(properties.frontendProtocol),
        'InstanceId': ros.stringToRosTemplate(properties.instanceId),
        'RealServers': ros.listMapper(ros.stringToRosTemplate)(properties.realServers),
        'BackendPort': ros.stringToRosTemplate(properties.backendPort),
        'FrontendPort': ros.stringToRosTemplate(properties.frontendPort),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DDoSPro::Port`, which is used to create a port forwarding rule for an Anti-DDoS Proxy instance.
 * @Note This class does not contain additional functions, so it is recommended to use the `Port` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ddospro-port
 */
class RosPort extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosPort.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrFrontendPort = this.getAtt('FrontendPort');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.frontendProtocol = props.frontendProtocol;
        this.instanceId = props.instanceId;
        this.realServers = props.realServers;
        this.backendPort = props.backendPort;
        this.frontendPort = props.frontendPort;
    }
    get rosProperties() {
        return {
            frontendProtocol: this.frontendProtocol,
            instanceId: this.instanceId,
            realServers: this.realServers,
            backendPort: this.backendPort,
            frontendPort: this.frontendPort,
        };
    }
    renderProperties(props) {
        return rosPortPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosPort = RosPort;
/**
 * The resource type name for this resource class.
 */
RosPort.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DDoSPro::Port";
/**
 * Determine whether the given properties match those of a `RosPremiumInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosPremiumInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosPremiumInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.normalQps && (typeof properties.normalQps) !== 'object') {
        errors.collect(ros.propertyValidator('normalQps', ros.validateRange)({
            data: properties.normalQps,
            min: 500,
            max: 100000,
        }));
    }
    errors.collect(ros.propertyValidator('normalQps', ros.validateNumber)(properties.normalQps));
    if (properties.normalBandwidth && (typeof properties.normalBandwidth) !== 'object') {
        errors.collect(ros.propertyValidator('normalBandwidth', ros.validateRange)({
            data: properties.normalBandwidth,
            min: 10,
            max: 300,
        }));
    }
    errors.collect(ros.propertyValidator('normalBandwidth', ros.validateNumber)(properties.normalBandwidth));
    if (properties.functionVersion && (typeof properties.functionVersion) !== 'object') {
        errors.collect(ros.propertyValidator('functionVersion', ros.validateAllowedValues)({
            data: properties.functionVersion,
            allowedValues: ["0", "1"],
        }));
    }
    errors.collect(ros.propertyValidator('functionVersion', ros.validateString)(properties.functionVersion));
    if (properties.productPlan && (typeof properties.productPlan) !== 'object') {
        errors.collect(ros.propertyValidator('productPlan', ros.validateAllowedValues)({
            data: properties.productPlan,
            allowedValues: ["0", "1", "2", "3"],
        }));
    }
    errors.collect(ros.propertyValidator('productPlan', ros.validateString)(properties.productPlan));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: [1, 2, 3, 4, 5, 6, 12, 24],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    if (properties.portCount && (typeof properties.portCount) !== 'object') {
        errors.collect(ros.propertyValidator('portCount', ros.validateRange)({
            data: properties.portCount,
            min: 5,
            max: 400,
        }));
    }
    errors.collect(ros.propertyValidator('portCount', ros.validateNumber)(properties.portCount));
    if (properties.tags && (Array.isArray(properties.tags) || (typeof properties.tags) === 'string')) {
        errors.collect(ros.propertyValidator('tags', ros.validateLength)({
            data: properties.tags.length,
            min: undefined,
            max: 20,
        }));
    }
    errors.collect(ros.propertyValidator('tags', ros.listValidator(RosPremiumInstance_TagsPropertyValidator))(properties.tags));
    if (properties.burstBandwidthMode && (typeof properties.burstBandwidthMode) !== 'object') {
        errors.collect(ros.propertyValidator('burstBandwidthMode', ros.validateAllowedValues)({
            data: properties.burstBandwidthMode,
            allowedValues: ["0", "1", "2"],
        }));
    }
    errors.collect(ros.propertyValidator('burstBandwidthMode', ros.validateString)(properties.burstBandwidthMode));
    if (properties.periodUnit && (typeof properties.periodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('periodUnit', ros.validateAllowedValues)({
            data: properties.periodUnit,
            allowedValues: ["Month", "Year", "month", "year"],
        }));
    }
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    if (properties.domainCount && (typeof properties.domainCount) !== 'object') {
        errors.collect(ros.propertyValidator('domainCount', ros.validateRange)({
            data: properties.domainCount,
            min: 10,
            max: 200,
        }));
    }
    errors.collect(ros.propertyValidator('domainCount', ros.validateNumber)(properties.domainCount));
    return errors.wrap('supplied properties not correct for "RosPremiumInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::PremiumInstance` resource
 *
 * @param properties - the TypeScript properties of a `RosPremiumInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::PremiumInstance` resource.
 */
// @ts-ignore TS6133
function rosPremiumInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosPremiumInstancePropsValidator(properties).assertSuccess();
    }
    return {
        'BurstBandwidthMode': ros.stringToRosTemplate(properties.burstBandwidthMode),
        'DomainCount': ros.numberToRosTemplate(properties.domainCount),
        'FunctionVersion': ros.stringToRosTemplate(properties.functionVersion),
        'NormalBandwidth': ros.numberToRosTemplate(properties.normalBandwidth),
        'NormalQps': ros.numberToRosTemplate(properties.normalQps),
        'Period': ros.numberToRosTemplate(properties.period),
        'PeriodUnit': ros.stringToRosTemplate(properties.periodUnit),
        'PortCount': ros.numberToRosTemplate(properties.portCount),
        'ProductPlan': ros.stringToRosTemplate(properties.productPlan),
        'Tags': ros.listMapper(rosPremiumInstanceTagsPropertyToRosTemplate)(properties.tags),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DDoSPro::PremiumInstance`, which is used to create an Anti-DDoS Proxy (Outside Chinese Mainland) instance.
 * @Note This class does not contain additional functions, so it is recommended to use the `PremiumInstance` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ddospro-premiuminstance
 */
class RosPremiumInstance extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosPremiumInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrArn = this.getAtt('Arn');
        this.attrInstanceId = this.getAtt('InstanceId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.burstBandwidthMode = props.burstBandwidthMode;
        this.domainCount = props.domainCount;
        this.functionVersion = props.functionVersion;
        this.normalBandwidth = props.normalBandwidth;
        this.normalQps = props.normalQps;
        this.period = props.period;
        this.periodUnit = props.periodUnit;
        this.portCount = props.portCount;
        this.productPlan = props.productPlan;
        this.tags = props.tags;
    }
    get rosProperties() {
        return {
            burstBandwidthMode: this.burstBandwidthMode,
            domainCount: this.domainCount,
            functionVersion: this.functionVersion,
            normalBandwidth: this.normalBandwidth,
            normalQps: this.normalQps,
            period: this.period,
            periodUnit: this.periodUnit,
            portCount: this.portCount,
            productPlan: this.productPlan,
            tags: this.tags,
        };
    }
    renderProperties(props) {
        return rosPremiumInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosPremiumInstance = RosPremiumInstance;
/**
 * The resource type name for this resource class.
 */
RosPremiumInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DDoSPro::PremiumInstance";
/**
 * Determine whether the given properties match those of a `TagsProperty`
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the result of the validation.
 */
function RosPremiumInstance_TagsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "TagsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::PremiumInstance.Tags` resource
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::PremiumInstance.Tags` resource.
 */
// @ts-ignore TS6133
function rosPremiumInstanceTagsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosPremiumInstance_TagsPropertyValidator(properties).assertSuccess();
    return {
        'Value': ros.stringToRosTemplate(properties.value),
        'Key': ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `RosProInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosProInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosProInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.normalQps && (typeof properties.normalQps) !== 'object') {
        errors.collect(ros.propertyValidator('normalQps', ros.validateRange)({
            data: properties.normalQps,
            min: 3000,
            max: 100000,
        }));
    }
    errors.collect(ros.propertyValidator('normalQps', ros.validateNumber)(properties.normalQps));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: [1, 2, 3, 4, 5, 6, 12, 24],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    if (properties.portCount && (typeof properties.portCount) !== 'object') {
        errors.collect(ros.propertyValidator('portCount', ros.validateRange)({
            data: properties.portCount,
            min: 50,
            max: 400,
        }));
    }
    errors.collect(ros.propertyValidator('portCount', ros.validateNumber)(properties.portCount));
    errors.collect(ros.propertyValidator('edition', ros.validateString)(properties.edition));
    if (properties.burstBandwidthMode && (typeof properties.burstBandwidthMode) !== 'object') {
        errors.collect(ros.propertyValidator('burstBandwidthMode', ros.validateAllowedValues)({
            data: properties.burstBandwidthMode,
            allowedValues: ["0", "1", "2"],
        }));
    }
    errors.collect(ros.propertyValidator('burstBandwidthMode', ros.validateString)(properties.burstBandwidthMode));
    if (properties.serviceBandwidth && (typeof properties.serviceBandwidth) !== 'object') {
        errors.collect(ros.propertyValidator('serviceBandwidth', ros.validateRange)({
            data: properties.serviceBandwidth,
            min: 100,
            max: 5000,
        }));
    }
    errors.collect(ros.propertyValidator('serviceBandwidth', ros.validateNumber)(properties.serviceBandwidth));
    errors.collect(ros.propertyValidator('servicePartner', ros.validateString)(properties.servicePartner));
    if (properties.baseBandwidth && (typeof properties.baseBandwidth) !== 'object') {
        errors.collect(ros.propertyValidator('baseBandwidth', ros.validateAllowedValues)({
            data: properties.baseBandwidth,
            allowedValues: [30, 60, 100, 300, 400, 500, 600],
        }));
    }
    errors.collect(ros.propertyValidator('baseBandwidth', ros.validateNumber)(properties.baseBandwidth));
    if (properties.functionVersion && (typeof properties.functionVersion) !== 'object') {
        errors.collect(ros.propertyValidator('functionVersion', ros.validateAllowedValues)({
            data: properties.functionVersion,
            allowedValues: ["0", "1"],
        }));
    }
    errors.collect(ros.propertyValidator('functionVersion', ros.validateString)(properties.functionVersion));
    errors.collect(ros.propertyValidator('bandwidth', ros.validateNumber)(properties.bandwidth));
    if (properties.addressType && (typeof properties.addressType) !== 'object') {
        errors.collect(ros.propertyValidator('addressType', ros.validateAllowedValues)({
            data: properties.addressType,
            allowedValues: ["Ipv4", "Ipv6"],
        }));
    }
    errors.collect(ros.propertyValidator('addressType', ros.validateString)(properties.addressType));
    if (properties.tags && (Array.isArray(properties.tags) || (typeof properties.tags) === 'string')) {
        errors.collect(ros.propertyValidator('tags', ros.validateLength)({
            data: properties.tags.length,
            min: undefined,
            max: 20,
        }));
    }
    errors.collect(ros.propertyValidator('tags', ros.listValidator(RosProInstance_TagsPropertyValidator))(properties.tags));
    if (properties.periodUnit && (typeof properties.periodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('periodUnit', ros.validateAllowedValues)({
            data: properties.periodUnit,
            allowedValues: ["Month", "Year", "month", "year"],
        }));
    }
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    if (properties.domainCount && (typeof properties.domainCount) !== 'object') {
        errors.collect(ros.propertyValidator('domainCount', ros.validateRange)({
            data: properties.domainCount,
            min: 50,
            max: 2000,
        }));
    }
    errors.collect(ros.propertyValidator('domainCount', ros.validateNumber)(properties.domainCount));
    return errors.wrap('supplied properties not correct for "RosProInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::ProInstance` resource
 *
 * @param properties - the TypeScript properties of a `RosProInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::ProInstance` resource.
 */
// @ts-ignore TS6133
function rosProInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosProInstancePropsValidator(properties).assertSuccess();
    }
    return {
        'AddressType': ros.stringToRosTemplate(properties.addressType),
        'Bandwidth': ros.numberToRosTemplate(properties.bandwidth),
        'BaseBandwidth': ros.numberToRosTemplate(properties.baseBandwidth),
        'BurstBandwidthMode': ros.stringToRosTemplate(properties.burstBandwidthMode),
        'DomainCount': ros.numberToRosTemplate(properties.domainCount),
        'Edition': ros.stringToRosTemplate(properties.edition),
        'FunctionVersion': ros.stringToRosTemplate(properties.functionVersion),
        'NormalQps': ros.numberToRosTemplate(properties.normalQps),
        'Period': ros.numberToRosTemplate(properties.period),
        'PeriodUnit': ros.stringToRosTemplate(properties.periodUnit),
        'PortCount': ros.numberToRosTemplate(properties.portCount),
        'ServiceBandwidth': ros.numberToRosTemplate(properties.serviceBandwidth),
        'ServicePartner': ros.stringToRosTemplate(properties.servicePartner),
        'Tags': ros.listMapper(rosProInstanceTagsPropertyToRosTemplate)(properties.tags),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DDoSPro::ProInstance`, which is used to create an Anti-DDoS Proxy (Chinese Mainland) instance.
 * @Note This class does not contain additional functions, so it is recommended to use the `ProInstance` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ddospro-proinstance
 */
class RosProInstance extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosProInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrArn = this.getAtt('Arn');
        this.attrInstanceId = this.getAtt('InstanceId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.addressType = props.addressType;
        this.bandwidth = props.bandwidth;
        this.baseBandwidth = props.baseBandwidth;
        this.burstBandwidthMode = props.burstBandwidthMode;
        this.domainCount = props.domainCount;
        this.edition = props.edition;
        this.functionVersion = props.functionVersion;
        this.normalQps = props.normalQps;
        this.period = props.period;
        this.periodUnit = props.periodUnit;
        this.portCount = props.portCount;
        this.serviceBandwidth = props.serviceBandwidth;
        this.servicePartner = props.servicePartner;
        this.tags = props.tags;
    }
    get rosProperties() {
        return {
            addressType: this.addressType,
            bandwidth: this.bandwidth,
            baseBandwidth: this.baseBandwidth,
            burstBandwidthMode: this.burstBandwidthMode,
            domainCount: this.domainCount,
            edition: this.edition,
            functionVersion: this.functionVersion,
            normalQps: this.normalQps,
            period: this.period,
            periodUnit: this.periodUnit,
            portCount: this.portCount,
            serviceBandwidth: this.serviceBandwidth,
            servicePartner: this.servicePartner,
            tags: this.tags,
        };
    }
    renderProperties(props) {
        return rosProInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosProInstance = RosProInstance;
/**
 * The resource type name for this resource class.
 */
RosProInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DDoSPro::ProInstance";
/**
 * Determine whether the given properties match those of a `TagsProperty`
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the result of the validation.
 */
function RosProInstance_TagsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "TagsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::ProInstance.Tags` resource
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::ProInstance.Tags` resource.
 */
// @ts-ignore TS6133
function rosProInstanceTagsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosProInstance_TagsPropertyValidator(properties).assertSuccess();
    return {
        'Value': ros.stringToRosTemplate(properties.value),
        'Key': ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `RosSceneDefensePolicyProps`
 *
 * @param properties - the TypeScript properties of a `RosSceneDefensePolicyProps`
 *
 * @returns the result of the validation.
 */
function RosSceneDefensePolicyPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('endTime', ros.requiredValidator)(properties.endTime));
    errors.collect(ros.propertyValidator('endTime', ros.validateNumber)(properties.endTime));
    errors.collect(ros.propertyValidator('startTime', ros.requiredValidator)(properties.startTime));
    errors.collect(ros.propertyValidator('startTime', ros.validateNumber)(properties.startTime));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    errors.collect(ros.propertyValidator('template', ros.requiredValidator)(properties.template));
    if (properties.template && (typeof properties.template) !== 'object') {
        errors.collect(ros.propertyValidator('template', ros.validateAllowedValues)({
            data: properties.template,
            allowedValues: ["promotion", "bypass"],
        }));
    }
    errors.collect(ros.propertyValidator('template', ros.validateString)(properties.template));
    return errors.wrap('supplied properties not correct for "RosSceneDefensePolicyProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::SceneDefensePolicy` resource
 *
 * @param properties - the TypeScript properties of a `RosSceneDefensePolicyProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::SceneDefensePolicy` resource.
 */
// @ts-ignore TS6133
function rosSceneDefensePolicyPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosSceneDefensePolicyPropsValidator(properties).assertSuccess();
    }
    return {
        'EndTime': ros.numberToRosTemplate(properties.endTime),
        'Name': ros.stringToRosTemplate(properties.name),
        'StartTime': ros.numberToRosTemplate(properties.startTime),
        'Template': ros.stringToRosTemplate(properties.template),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DDoSPro::SceneDefensePolicy`, which is used to create a scenario-specific custom policy.
 * @Note This class does not contain additional functions, so it is recommended to use the `SceneDefensePolicy` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ddospro-scenedefensepolicy
 */
class RosSceneDefensePolicy extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosSceneDefensePolicy.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrName = this.getAtt('Name');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.endTime = props.endTime;
        this.name = props.name;
        this.startTime = props.startTime;
        this.template = props.template;
    }
    get rosProperties() {
        return {
            endTime: this.endTime,
            name: this.name,
            startTime: this.startTime,
            template: this.template,
        };
    }
    renderProperties(props) {
        return rosSceneDefensePolicyPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosSceneDefensePolicy = RosSceneDefensePolicy;
/**
 * The resource type name for this resource class.
 */
RosSceneDefensePolicy.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DDoSPro::SceneDefensePolicy";
/**
 * Determine whether the given properties match those of a `RosSchedulerRuleProps`
 *
 * @param properties - the TypeScript properties of a `RosSchedulerRuleProps`
 *
 * @returns the result of the validation.
 */
function RosSchedulerRulePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('param', ros.validateString)(properties.param));
    errors.collect(ros.propertyValidator('ruleType', ros.requiredValidator)(properties.ruleType));
    if (properties.ruleType && (typeof properties.ruleType) !== 'object') {
        errors.collect(ros.propertyValidator('ruleType', ros.validateAllowedValues)({
            data: properties.ruleType,
            allowedValues: [2, 3, 5, 6, 8],
        }));
    }
    errors.collect(ros.propertyValidator('ruleType', ros.validateNumber)(properties.ruleType));
    errors.collect(ros.propertyValidator('rules', ros.requiredValidator)(properties.rules));
    errors.collect(ros.propertyValidator('rules', ros.validateString)(properties.rules));
    errors.collect(ros.propertyValidator('ruleName', ros.requiredValidator)(properties.ruleName));
    errors.collect(ros.propertyValidator('ruleName', ros.validateString)(properties.ruleName));
    return errors.wrap('supplied properties not correct for "RosSchedulerRuleProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::SchedulerRule` resource
 *
 * @param properties - the TypeScript properties of a `RosSchedulerRuleProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::SchedulerRule` resource.
 */
// @ts-ignore TS6133
function rosSchedulerRulePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosSchedulerRulePropsValidator(properties).assertSuccess();
    }
    return {
        'RuleName': ros.stringToRosTemplate(properties.ruleName),
        'Rules': ros.stringToRosTemplate(properties.rules),
        'RuleType': ros.numberToRosTemplate(properties.ruleType),
        'Param': ros.stringToRosTemplate(properties.param),
        'ResourceGroupId': ros.stringToRosTemplate(properties.resourceGroupId),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DDoSPro::SchedulerRule`, which is used to create a scheduling rule for Sec-Traffic Manager.
 * @Note This class does not contain additional functions, so it is recommended to use the `SchedulerRule` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ddospro-schedulerrule
 */
class RosSchedulerRule extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosSchedulerRule.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrRuleName = this.getAtt('RuleName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.ruleName = props.ruleName;
        this.rules = props.rules;
        this.ruleType = props.ruleType;
        this.param = props.param;
        this.resourceGroupId = props.resourceGroupId;
    }
    get rosProperties() {
        return {
            ruleName: this.ruleName,
            rules: this.rules,
            ruleType: this.ruleType,
            param: this.param,
            resourceGroupId: this.resourceGroupId,
        };
    }
    renderProperties(props) {
        return rosSchedulerRulePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosSchedulerRule = RosSchedulerRule;
/**
 * The resource type name for this resource class.
 */
RosSchedulerRule.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DDoSPro::SchedulerRule";
/**
 * Determine whether the given properties match those of a `RosWebRuleProps`
 *
 * @param properties - the TypeScript properties of a `RosWebRuleProps`
 *
 * @returns the result of the validation.
 */
function RosWebRulePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('rsType', ros.requiredValidator)(properties.rsType));
    if (properties.rsType && (typeof properties.rsType) !== 'object') {
        errors.collect(ros.propertyValidator('rsType', ros.validateAllowedValues)({
            data: properties.rsType,
            allowedValues: [0, 1],
        }));
    }
    errors.collect(ros.propertyValidator('rsType', ros.validateNumber)(properties.rsType));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('defenseId', ros.validateString)(properties.defenseId));
    errors.collect(ros.propertyValidator('domain', ros.requiredValidator)(properties.domain));
    errors.collect(ros.propertyValidator('domain', ros.validateString)(properties.domain));
    if (properties.instanceIds && (Array.isArray(properties.instanceIds) || (typeof properties.instanceIds) === 'string')) {
        errors.collect(ros.propertyValidator('instanceIds', ros.validateLength)({
            data: properties.instanceIds.length,
            min: 0,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('instanceIds', ros.listValidator(ros.validateString))(properties.instanceIds));
    errors.collect(ros.propertyValidator('rules', ros.requiredValidator)(properties.rules));
    errors.collect(ros.propertyValidator('rules', ros.validateString)(properties.rules));
    errors.collect(ros.propertyValidator('httpsExt', ros.validateString)(properties.httpsExt));
    return errors.wrap('supplied properties not correct for "RosWebRuleProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::WebRule` resource
 *
 * @param properties - the TypeScript properties of a `RosWebRuleProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::WebRule` resource.
 */
// @ts-ignore TS6133
function rosWebRulePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosWebRulePropsValidator(properties).assertSuccess();
    }
    return {
        'Domain': ros.stringToRosTemplate(properties.domain),
        'RsType': ros.numberToRosTemplate(properties.rsType),
        'Rules': ros.stringToRosTemplate(properties.rules),
        'DefenseId': ros.stringToRosTemplate(properties.defenseId),
        'HttpsExt': ros.stringToRosTemplate(properties.httpsExt),
        'InstanceIds': ros.listMapper(ros.stringToRosTemplate)(properties.instanceIds),
        'ResourceGroupId': ros.stringToRosTemplate(properties.resourceGroupId),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DDoSPro::WebRule`, which is used to create a forwarding rule for a website.
 * @Note This class does not contain additional functions, so it is recommended to use the `WebRule` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ddospro-webrule
 */
class RosWebRule extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosWebRule.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDomain = this.getAtt('Domain');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.domain = props.domain;
        this.rsType = props.rsType;
        this.rules = props.rules;
        this.defenseId = props.defenseId;
        this.httpsExt = props.httpsExt;
        this.instanceIds = props.instanceIds;
        this.resourceGroupId = props.resourceGroupId;
    }
    get rosProperties() {
        return {
            domain: this.domain,
            rsType: this.rsType,
            rules: this.rules,
            defenseId: this.defenseId,
            httpsExt: this.httpsExt,
            instanceIds: this.instanceIds,
            resourceGroupId: this.resourceGroupId,
        };
    }
    renderProperties(props) {
        return rosWebRulePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosWebRule = RosWebRule;
/**
 * The resource type name for this resource class.
 */
RosWebRule.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DDoSPro::WebRule";
//# sourceMappingURL=data:application/json;base64,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