"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Port = exports.PortProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ddospro_generated_1 = require("./ddospro.generated");
Object.defineProperty(exports, "PortProperty", { enumerable: true, get: function () { return ddospro_generated_1.RosPort; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::DDoSPro::Port`, which is used to create a port forwarding rule for an Anti-DDoS Proxy instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosPort`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ddospro-port
 */
class Port extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosPort = new ddospro_generated_1.RosPort(this, id, {
            backendPort: props.backendPort,
            instanceId: props.instanceId,
            realServers: props.realServers,
            frontendPort: props.frontendPort,
            frontendProtocol: props.frontendProtocol,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosPort;
        this.attrFrontendPort = rosPort.attrFrontendPort;
    }
}
exports.Port = Port;
//# sourceMappingURL=data:application/json;base64,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