"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PremiumInstance = exports.PremiumInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ddospro_generated_1 = require("./ddospro.generated");
Object.defineProperty(exports, "PremiumInstanceProperty", { enumerable: true, get: function () { return ddospro_generated_1.RosPremiumInstance; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::DDoSPro::PremiumInstance`, which is used to create an Anti-DDoS Proxy (Outside Chinese Mainland) instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosPremiumInstance`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ddospro-premiuminstance
 */
class PremiumInstance extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosPremiumInstance = new ddospro_generated_1.RosPremiumInstance(this, id, {
            normalQps: props.normalQps,
            normalBandwidth: props.normalBandwidth,
            functionVersion: props.functionVersion,
            productPlan: props.productPlan,
            period: props.period,
            portCount: props.portCount,
            tags: props.tags,
            burstBandwidthMode: props.burstBandwidthMode,
            periodUnit: props.periodUnit,
            domainCount: props.domainCount,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosPremiumInstance;
        this.attrArn = rosPremiumInstance.attrArn;
        this.attrInstanceId = rosPremiumInstance.attrInstanceId;
    }
}
exports.PremiumInstance = PremiumInstance;
//# sourceMappingURL=data:application/json;base64,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