"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProInstance = exports.ProInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ddospro_generated_1 = require("./ddospro.generated");
Object.defineProperty(exports, "ProInstanceProperty", { enumerable: true, get: function () { return ddospro_generated_1.RosProInstance; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::DDoSPro::ProInstance`, which is used to create an Anti-DDoS Proxy (Chinese Mainland) instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosProInstance`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ddospro-proinstance
 */
class ProInstance extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosProInstance = new ddospro_generated_1.RosProInstance(this, id, {
            normalQps: props.normalQps,
            period: props.period,
            portCount: props.portCount,
            edition: props.edition,
            burstBandwidthMode: props.burstBandwidthMode,
            serviceBandwidth: props.serviceBandwidth,
            servicePartner: props.servicePartner,
            baseBandwidth: props.baseBandwidth,
            functionVersion: props.functionVersion,
            bandwidth: props.bandwidth,
            addressType: props.addressType,
            tags: props.tags,
            periodUnit: props.periodUnit,
            domainCount: props.domainCount,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosProInstance;
        this.attrArn = rosProInstance.attrArn;
        this.attrInstanceId = rosProInstance.attrInstanceId;
    }
}
exports.ProInstance = ProInstance;
//# sourceMappingURL=data:application/json;base64,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