"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SchedulerRule = exports.SchedulerRuleProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ddospro_generated_1 = require("./ddospro.generated");
Object.defineProperty(exports, "SchedulerRuleProperty", { enumerable: true, get: function () { return ddospro_generated_1.RosSchedulerRule; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::DDoSPro::SchedulerRule`, which is used to create a scheduling rule for Sec-Traffic Manager.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosSchedulerRule`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ddospro-schedulerrule
 */
class SchedulerRule extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosSchedulerRule = new ddospro_generated_1.RosSchedulerRule(this, id, {
            resourceGroupId: props.resourceGroupId,
            param: props.param,
            ruleType: props.ruleType,
            rules: props.rules,
            ruleName: props.ruleName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSchedulerRule;
        this.attrRuleName = rosSchedulerRule.attrRuleName;
    }
}
exports.SchedulerRule = SchedulerRule;
//# sourceMappingURL=data:application/json;base64,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