"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebRule = exports.WebRuleProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ddospro_generated_1 = require("./ddospro.generated");
Object.defineProperty(exports, "WebRuleProperty", { enumerable: true, get: function () { return ddospro_generated_1.RosWebRule; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::DDoSPro::WebRule`, which is used to create a forwarding rule for a website.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosWebRule`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ddospro-webrule
 */
class WebRule extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosWebRule = new ddospro_generated_1.RosWebRule(this, id, {
            rsType: props.rsType,
            resourceGroupId: props.resourceGroupId,
            defenseId: props.defenseId,
            domain: props.domain,
            instanceIds: props.instanceIds,
            rules: props.rules,
            httpsExt: props.httpsExt,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosWebRule;
        this.attrDomain = rosWebRule.attrDomain;
    }
}
exports.WebRule = WebRule;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoid2VicnVsZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIndlYnJ1bGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsOENBQThDO0FBQzlDLDJEQUFpRDtBQUUxQixnR0FGZCw4QkFBVSxPQUVtQjtBQThEdEM7Ozs7R0FJRztBQUNILE1BQWEsT0FBUSxTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBV3JDOzs7O09BSUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQW1CLEVBQUUsbUNBQTJDLElBQUk7UUFDOUcsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztRQUNuQixJQUFJLENBQUMsRUFBRSxHQUFHLEVBQUUsQ0FBQztRQUNiLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBQ25CLElBQUksQ0FBQyxnQ0FBZ0MsR0FBRyxnQ0FBZ0MsQ0FBQztRQUV6RSxNQUFNLFVBQVUsR0FBRyxJQUFJLDhCQUFVLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRztZQUN6QyxNQUFNLEVBQUUsS0FBSyxDQUFDLE1BQU07WUFDcEIsZUFBZSxFQUFFLEtBQUssQ0FBQyxlQUFlO1lBQ3RDLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztZQUMxQixNQUFNLEVBQUUsS0FBSyxDQUFDLE1BQU07WUFDcEIsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLEtBQUssRUFBRSxLQUFLLENBQUMsS0FBSztZQUNsQixRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7U0FDM0IsRUFBRSxnQ0FBZ0MsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLGdDQUFnQyxDQUFDLENBQUM7UUFDcEYsSUFBSSxDQUFDLFFBQVEsR0FBRyxVQUFVLENBQUM7UUFDM0IsSUFBSSxDQUFDLFVBQVUsR0FBRyxVQUFVLENBQUMsVUFBVSxDQUFDO0lBQzVDLENBQUM7Q0FDSjtBQW5DRCwwQkFtQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyByb3MgZnJvbSAnQGFsaWNsb3VkL3Jvcy1jZGstY29yZSc7XG5pbXBvcnQgeyBSb3NXZWJSdWxlIH0gZnJvbSAnLi9kZG9zcHJvLmdlbmVyYXRlZCc7XG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cbmV4cG9ydCB7IFJvc1dlYlJ1bGUgYXMgV2ViUnVsZVByb3BlcnR5IH07XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgV2ViUnVsZWAuXG4gKiBTZWUgaHR0cHM6Ly93d3cuYWxpYmFiYWNsb3VkLmNvbS9oZWxwL3Jvcy9kZXZlbG9wZXItcmVmZXJlbmNlL2FsaXl1bi1kZG9zcHJvLXdlYnJ1bGVcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBXZWJSdWxlUHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZG9tYWluOiBUaGUgZG9tYWluIG5hbWUgb2YgdGhlIHdlYnNpdGUgdGhhdCB5b3Ugd2FudCB0byBhZGQgdG8gdGhlIGluc3RhbmNlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRvbWFpbjogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcnNUeXBlOiBUaGUgYWRkcmVzcyB0eXBlIG9mIHRoZSBvcmlnaW4gc2VydmVyLiBWYWxpZCB2YWx1ZXM6XG4gICAgICogMDogSVAgYWRkcmVzc1xuICAgICAqIDE6IGRvbWFpbiBuYW1lIFRoZSBkb21haW4gbmFtZSBvZiB0aGUgb3JpZ2luIHNlcnZlciBpcyByZXR1cm5lZCBpZiB5b3UgZGVwbG95IHByb3hpZXMsIHN1Y2ggYXMgV2ViIEFwcGxpY2F0aW9uIEZpcmV3YWxsIChXQUYpLCBiZXR3ZWVuIHRoZSBvcmlnaW4gc2VydmVyIGFuZCB0aGUgaW5zdGFuY2UuIEluIHRoaXMgY2FzZSwgdGhlIGFkZHJlc3Mgb2YgdGhlIHByb3h5LCBzdWNoIGFzIHRoZSBDTkFNRSBwcm92aWRlZCBieSBXQUYsIGlzIHJldHVybmVkLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJzVHlwZTogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcnVsZXM6IFRoZSBkZXRhaWxzIG9mIHRoZSBmb3J3YXJkaW5nIHJ1bGUuIFRoZSB2YWx1ZSBpcyBhIHN0cmluZyB0aGF0IGNvbnNpc3RzIG9mIEpTT04gYXJyYXlzLiBFYWNoIGVsZW1lbnQgaW4gYSBKU09OIGFycmF5IGlzIGEgSlNPTiBzdHJ1Y3QgdGhhdCBjb250YWlucyB0aGUgZm9sbG93aW5nIGZpZWxkczogXG4gICAgICogUHJveHlSdWxlczogdGhlIGluZm9ybWF0aW9uIGFib3V0IHRoZSBvcmlnaW4gc2VydmVyLiBUaGUgaW5mb3JtYXRpb24gaW5jbHVkZXMgdGhlIHBvcnQgbnVtYmVyIGFuZCBJUCBhZGRyZXNzLiBUaGlzIGZpZWxkIGlzIHJlcXVpcmVkIGFuZCBtdXN0IGJlIGEgSlNPTiBhcnJheS4gRWFjaCBlbGVtZW50IGluIGEgSlNPTiBhcnJheSBpcyBhIEpTT04gc3RydWN0IHRoYXQgY29udGFpbnMgdGhlIGZvbGxvd2luZyBmaWVsZHM6IFByb3h5UG9ydDogdGhlIHBvcnQgbnVtYmVyLiBUaGlzIGZpZWxkIGlzIHJlcXVpcmVkIGFuZCBtdXN0IGJlIGFuIGludGVnZXI7IFJlYWxTZXJ2ZXJzOiB0aGUgSVAgYWRkcmVzcy4gVGhpcyBmaWVsZCBpcyByZXF1aXJlZCBhbmQgbXVzdCBiZSBhIHN0cmluZyBhcnJheS5cbiAgICAgKiBQcm94eVR5cGU6IHRoZSBwcm90b2NvbCB0eXBlLiBUaGlzIGZpZWxkIGlzIHJlcXVpcmVkIGFuZCBtdXN0IGJlIGEgc3RyaW5nLiBWYWxpZCB2YWx1ZXM6IGh0dHAsIGh0dHBzLCB3ZWJzb2NrZXQsIGFuZCB3ZWJzb2NrZXRzLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJ1bGVzOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkZWZlbnNlSWQ6IFRoZSBJRCBvZiB0aGUgYXNzb2NpYXRlZCBkZWZlbnNlLiBUaGlzIHBhcmFtZXRlciBhcHBsaWVzIHRvIHNjZW5hcmlvcyBpbiB3aGljaCBvdGhlciBjbG91ZCBzZXJ2aWNlcywgc3VjaCBhcyBPYmplY3QgU3RvcmFnZSBTZXJ2aWNlIChPU1MpLCBhcmUgaW50ZWdyYXRlZCB3aXRoIEFudGktRERvUyBQcm8gb3IgQW50aS1ERG9TIFByZW1pdW0uXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVmZW5zZUlkPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgaHR0cHNFeHQ6IFRoZSBhZHZhbmNlZCBIVFRQUyBzZXR0aW5ncy4gVGhpcyBwYXJhbWV0ZXIgdGFrZXMgZWZmZWN0IG9ubHkgd2hlbiB0aGUgdmFsdWUgb2YgdGhlIFByb3h5VHlwZSBwYXJhbWV0ZXIgaW5jbHVkZXMgaHR0cHMuIFRoZSB2YWx1ZSBpcyBhIHN0cmluZyB0aGF0IGNvbnNpc3RzIG9mIGEgSlNPTiBzdHJ1Y3QuIFRoZSBKU09OIHN0cnVjdCBjb250YWlucyB0aGUgZm9sbG93aW5nIGZpZWxkczogXG4gICAgICogSHR0cDJodHRwczogc3BlY2lmaWVzIHdoZXRoZXIgdG8gdHVybiBvbiBFbmZvcmNlIEhUVFBTIFJvdXRpbmcuIFRoaXMgZmllbGQgaXMgb3B0aW9uYWwgYW5kIG11c3QgYmUgYW4gaW50ZWdlci4gVmFsaWQgdmFsdWVzOiAwIGFuZCAxLiBUaGUgdmFsdWUgMCBpbmRpY2F0ZXMgdGhhdCBFbmZvcmNlIEhUVFBTIFJvdXRpbmcgaXMgdHVybmVkIG9mZi4gVGhlIHZhbHVlIDEgaW5kaWNhdGVzIHRoYXQgRW5mb3JjZSBIVFRQUyBSb3V0aW5nIGlzIHR1cm5lZCBvbi4gVGhlIGRlZmF1bHQgdmFsdWUgaXMgMC4gSWYgeW91ciB3ZWJzaXRlIHN1cHBvcnRzIGJvdGggSFRUUCBhbmQgSFRUUFMsIHRoaXMgZmVhdHVyZSBtZWV0cyB5b3VyIGJ1c2luZXNzIHJlcXVpcmVtZW50cy4gSWYgeW91IGVuYWJsZSB0aGlzIGZlYXR1cmUsIGFsbCBIVFRQIHJlcXVlc3RzIHRvIGFjY2VzcyB0aGUgd2Vic2l0ZSBhcmUgcmVkaXJlY3RlZCB0byBIVFRQUyByZXF1ZXN0cyBvbiB0aGUgc3RhbmRhcmQgcG9ydCA0NDMuXG4gICAgICogSHR0cHMyaHR0cDogc3BlY2lmaWVzIHdoZXRoZXIgdG8gdHVybiBvbiBFbmFibGUgSFRUUC4gVGhpcyBmaWVsZCBpcyBvcHRpb25hbCBhbmQgbXVzdCBiZSBhbiBpbnRlZ2VyLiBWYWxpZCB2YWx1ZXM6IDAgYW5kIDEuIFRoZSB2YWx1ZSAwIGluZGljYXRlcyB0aGF0IEVuYWJsZSBIVFRQIGlzIHR1cm5lZCBvZmYuIFRoZSB2YWx1ZSAxIGluZGljYXRlcyB0aGF0IEVuYWJsZSBIVFRQIGlzIHR1cm5lZCBvbi4gVGhlIGRlZmF1bHQgdmFsdWUgaXMgMC4gSWYgeW91ciB3ZWJzaXRlIGRvZXMgbm90IHN1cHBvcnQgSFRUUFMsIHRoaXMgZmVhdHVyZSBtZWV0cyB5b3VyIGJ1c2luZXNzIHJlcXVpcmVtZW50cyBJZiB0aGlzIGZlYXR1cmUgaXMgZW5hYmxlZCwgYWxsIEhUVFBTIHJlcXVlc3RzIGFyZSByZWRpcmVjdGVkIHRvIEhUVFAgcmVxdWVzdHMgYW5kIGZvcndhcmRlZCB0byBvcmlnaW4gc2VydmVycy4gVGhpcyBmZWF0dXJlIGNhbiByZWRpcmVjdCBXZWJTb2NrZXRzIHJlcXVlc3RzIHRvIFdlYlNvY2tldCByZXF1ZXN0cy4gUmVxdWVzdHMgYXJlIHJlZGlyZWN0ZWQgb3ZlciB0aGUgc3RhbmRhcmQgcG9ydCA4MC5cbiAgICAgKiBIdHRwMjogc3BlY2lmaWVzIHdoZXRoZXIgdG8gdHVybiBvbiBFbmFibGUgSFRUUFxcLzIuIFRoaXMgZmllbGQgaXMgb3B0aW9uYWwgYW5kIG11c3QgYmUgYW4gaW50ZWdlci4gVmFsaWQgdmFsdWVzOiAwIGFuZCAxLiBUaGUgdmFsdWUgMCBpbmRpY2F0ZXMgdGhhdCBFbmFibGUgSFRUUFxcLzIgaXMgdHVybmVkIG9mZi4gVGhlIHZhbHVlIDEgaW5kaWNhdGVzIHRoYXQgRW5hYmxlIEhUVFBcXC8yIGlzIHR1cm5lZCBvbi4gVGhlIGRlZmF1bHQgdmFsdWUgaXMgMC4gQWZ0ZXIgeW91IHR1cm4gb24gRW5hYmxlIEhUVFBcXC8yLCB0aGUgcHJvdG9jb2wgdHlwZSBpcyBIVFRQXFwvMi5cbiAgICAgKi9cbiAgICByZWFkb25seSBodHRwc0V4dD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGluc3RhbmNlSWRzOiBBbiBhcnJheSBjb25zaXN0aW5nIG9mIHRoZSBJRHMgb2YgaW5zdGFuY2VzIHRoYXQgeW91IHdhbnQgdG8gYXNzb2NpYXRlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGluc3RhbmNlSWRzPzogQXJyYXk8c3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlPiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHJlc291cmNlR3JvdXBJZDogVGhlIElEIG9mIHRoZSByZXNvdXJjZSBncm91cCB0byB3aGljaCB0aGUgaW5zdGFuY2UgYmVsb25ncyBpbiBSZXNvdXJjZSBNYW5hZ2VtZW50LiBUaGlzIHBhcmFtZXRlciBpcyBlbXB0eSBieSBkZWZhdWx0LCB3aGljaCBpbmRpY2F0ZXMgdGhhdCB0aGUgaW5zdGFuY2UgYmVsb25ncyB0byB0aGUgZGVmYXVsdCByZXNvdXJjZSBncm91cC5cbiAgICAgKi9cbiAgICByZWFkb25seSByZXNvdXJjZUdyb3VwSWQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyBhIGBXZWJSdWxlYC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJV2ViUnVsZSBleHRlbmRzIHJvcy5JUmVzb3VyY2Uge1xuICAgIHJlYWRvbmx5IHByb3BzOiBXZWJSdWxlUHJvcHM7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgRG9tYWluOiBUaGUgZG9tYWluIG5hbWUgb2YgdGhlIHdlYnNpdGUgdGhhdCB5b3Ugd2FudCB0byBhZGQgdG8gdGhlIGluc3RhbmNlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGF0dHJEb21haW46IHJvcy5JUmVzb2x2YWJsZSB8IHN0cmluZztcbn1cbi8qKlxuICogVGhpcyBjbGFzcyBlbmNhcHN1bGF0ZXMgYW5kIGV4dGVuZHMgdGhlIFJPUyByZXNvdXJjZSB0eXBlIGBBTElZVU46OkREb1NQcm86OldlYlJ1bGVgLCB3aGljaCBpcyB1c2VkIHRvIGNyZWF0ZSBhIGZvcndhcmRpbmcgcnVsZSBmb3IgYSB3ZWJzaXRlLlxuICogQE5vdGUgVGhpcyBjbGFzcyBtYXkgaGF2ZSBzb21lIG5ldyBmdW5jdGlvbnMgdG8gZmFjaWxpdGF0ZSBkZXZlbG9wbWVudCwgc28gaXQgaXMgcmVjb21tZW5kZWQgdG8gdXNlIHRoaXMgY2xhc3MgaW5zdGVhZCBvZiBgUm9zV2ViUnVsZWBmb3IgYSBtb3JlIGNvbnZlbmllbnQgZGV2ZWxvcG1lbnQgZXhwZXJpZW5jZS5cbiAqIFNlZSBodHRwczovL3d3dy5hbGliYWJhY2xvdWQuY29tL2hlbHAvcm9zL2RldmVsb3Blci1yZWZlcmVuY2UvYWxpeXVuLWRkb3Nwcm8td2VicnVsZVxuICovXG5leHBvcnQgY2xhc3MgV2ViUnVsZSBleHRlbmRzIHJvcy5SZXNvdXJjZSBpbXBsZW1lbnRzIElXZWJSdWxlIHtcbiAgICBwcm90ZWN0ZWQgc2NvcGU6IHJvcy5Db25zdHJ1Y3Q7XG4gICAgcHJvdGVjdGVkIGlkOiBzdHJpbmc7XG4gICAgcHVibGljIHJlYWRvbmx5IHByb3BzOiBXZWJSdWxlUHJvcHM7XG4gICAgcHJvdGVjdGVkIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OiBib29sZWFuO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIERvbWFpbjogVGhlIGRvbWFpbiBuYW1lIG9mIHRoZSB3ZWJzaXRlIHRoYXQgeW91IHdhbnQgdG8gYWRkIHRvIHRoZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckRvbWFpbjogcm9zLklSZXNvbHZhYmxlIHwgc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogUGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBQYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBQYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogcm9zLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFdlYlJ1bGVQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICAgICAgdGhpcy5zY29wZSA9IHNjb3BlO1xuICAgICAgICB0aGlzLmlkID0gaWQ7XG4gICAgICAgIHRoaXMucHJvcHMgPSBwcm9wcztcbiAgICAgICAgdGhpcy5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCA9IGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50O1xuXG4gICAgICAgIGNvbnN0IHJvc1dlYlJ1bGUgPSBuZXcgUm9zV2ViUnVsZSh0aGlzLCBpZCwgIHtcbiAgICAgICAgICAgIHJzVHlwZTogcHJvcHMucnNUeXBlLFxuICAgICAgICAgICAgcmVzb3VyY2VHcm91cElkOiBwcm9wcy5yZXNvdXJjZUdyb3VwSWQsXG4gICAgICAgICAgICBkZWZlbnNlSWQ6IHByb3BzLmRlZmVuc2VJZCxcbiAgICAgICAgICAgIGRvbWFpbjogcHJvcHMuZG9tYWluLFxuICAgICAgICAgICAgaW5zdGFuY2VJZHM6IHByb3BzLmluc3RhbmNlSWRzLFxuICAgICAgICAgICAgcnVsZXM6IHByb3BzLnJ1bGVzLFxuICAgICAgICAgICAgaHR0cHNFeHQ6IHByb3BzLmh0dHBzRXh0LFxuICAgICAgICB9LCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCAmJiB0aGlzLnN0YWNrLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50KTtcbiAgICAgICAgdGhpcy5yZXNvdXJjZSA9IHJvc1dlYlJ1bGU7XG4gICAgICAgIHRoaXMuYXR0ckRvbWFpbiA9IHJvc1dlYlJ1bGUuYXR0ckRvbWFpbjtcbiAgICB9XG59XG4iXX0=