# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EnvironmentArgs', 'Environment']

@pulumi.input_type
class EnvironmentArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.str],
                 connection_id: Optional[pulumi.Input[_builtins.int]] = None,
                 credential_id: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 dbt_version: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_model_query_history: Optional[pulumi.Input[_builtins.bool]] = None,
                 extended_attributes_id: Optional[pulumi.Input[_builtins.int]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 use_custom_branch: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Environment resource.
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the environment in
        :param pulumi.Input[_builtins.str] type: The type of environment (must be either development or deployment)
        :param pulumi.Input[_builtins.int] connection_id: A connection ID (used with Global Connections)
        :param pulumi.Input[_builtins.int] credential_id: The project ID to which the environment belongs.
        :param pulumi.Input[_builtins.str] custom_branch: The custom branch name to use
        :param pulumi.Input[_builtins.str] dbt_version: Version number of dbt to use in this environment. It needs to be in the format `major.minor.0-latest` (e.g. `1.5.0-latest`), `major.minor.0-pre`, `compatible`, `extended`, `versionless`, `latest` or `latest-fusion`. While `versionless` is still supported, using `latest` or `latest-fusion` is recommended. Defaults to `latest` if no version is provided
        :param pulumi.Input[_builtins.str] deployment_type: The type of environment. Only valid for environments of type 'deployment' and for now can only be 'production', 'staging' or left empty for generic environments
        :param pulumi.Input[_builtins.bool] enable_model_query_history: Whether to enable model query history in this environment. As of Oct 2024, works only for Snowflake and BigQuery.
        :param pulumi.Input[_builtins.int] extended_attributes_id: The ID of the extended attributes applied
        :param pulumi.Input[_builtins.bool] is_active: Whether the environment is active
        :param pulumi.Input[_builtins.str] name: The name of the environment
        :param pulumi.Input[_builtins.bool] use_custom_branch: Whether to use a custom git branch in this environment
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "type", type)
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if custom_branch is not None:
            pulumi.set(__self__, "custom_branch", custom_branch)
        if dbt_version is not None:
            pulumi.set(__self__, "dbt_version", dbt_version)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if enable_model_query_history is not None:
            pulumi.set(__self__, "enable_model_query_history", enable_model_query_history)
        if extended_attributes_id is not None:
            pulumi.set(__self__, "extended_attributes_id", extended_attributes_id)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if use_custom_branch is not None:
            pulumi.set(__self__, "use_custom_branch", use_custom_branch)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.int]:
        """
        Project ID to create the environment in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of environment (must be either development or deployment)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A connection ID (used with Global Connections)
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_id", value)

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The project ID to which the environment belongs.
        """
        return pulumi.get(self, "credential_id")

    @credential_id.setter
    def credential_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "credential_id", value)

    @_builtins.property
    @pulumi.getter(name="customBranch")
    def custom_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The custom branch name to use
        """
        return pulumi.get(self, "custom_branch")

    @custom_branch.setter
    def custom_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_branch", value)

    @_builtins.property
    @pulumi.getter(name="dbtVersion")
    def dbt_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version number of dbt to use in this environment. It needs to be in the format `major.minor.0-latest` (e.g. `1.5.0-latest`), `major.minor.0-pre`, `compatible`, `extended`, `versionless`, `latest` or `latest-fusion`. While `versionless` is still supported, using `latest` or `latest-fusion` is recommended. Defaults to `latest` if no version is provided
        """
        return pulumi.get(self, "dbt_version")

    @dbt_version.setter
    def dbt_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbt_version", value)

    @_builtins.property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of environment. Only valid for environments of type 'deployment' and for now can only be 'production', 'staging' or left empty for generic environments
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_type", value)

    @_builtins.property
    @pulumi.getter(name="enableModelQueryHistory")
    def enable_model_query_history(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable model query history in this environment. As of Oct 2024, works only for Snowflake and BigQuery.
        """
        return pulumi.get(self, "enable_model_query_history")

    @enable_model_query_history.setter
    def enable_model_query_history(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_model_query_history", value)

    @_builtins.property
    @pulumi.getter(name="extendedAttributesId")
    def extended_attributes_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the extended attributes applied
        """
        return pulumi.get(self, "extended_attributes_id")

    @extended_attributes_id.setter
    def extended_attributes_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "extended_attributes_id", value)

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the environment is active
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_active", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the environment
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="useCustomBranch")
    def use_custom_branch(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to use a custom git branch in this environment
        """
        return pulumi.get(self, "use_custom_branch")

    @use_custom_branch.setter
    def use_custom_branch(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_custom_branch", value)


@pulumi.input_type
class _EnvironmentState:
    def __init__(__self__, *,
                 connection_id: Optional[pulumi.Input[_builtins.int]] = None,
                 credential_id: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 dbt_version: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_model_query_history: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.int]] = None,
                 extended_attributes_id: Optional[pulumi.Input[_builtins.int]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 use_custom_branch: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Environment resources.
        :param pulumi.Input[_builtins.int] connection_id: A connection ID (used with Global Connections)
        :param pulumi.Input[_builtins.int] credential_id: The project ID to which the environment belongs.
        :param pulumi.Input[_builtins.str] custom_branch: The custom branch name to use
        :param pulumi.Input[_builtins.str] dbt_version: Version number of dbt to use in this environment. It needs to be in the format `major.minor.0-latest` (e.g. `1.5.0-latest`), `major.minor.0-pre`, `compatible`, `extended`, `versionless`, `latest` or `latest-fusion`. While `versionless` is still supported, using `latest` or `latest-fusion` is recommended. Defaults to `latest` if no version is provided
        :param pulumi.Input[_builtins.str] deployment_type: The type of environment. Only valid for environments of type 'deployment' and for now can only be 'production', 'staging' or left empty for generic environments
        :param pulumi.Input[_builtins.bool] enable_model_query_history: Whether to enable model query history in this environment. As of Oct 2024, works only for Snowflake and BigQuery.
        :param pulumi.Input[_builtins.int] environment_id: The ID of the environment. Duplicated. Here for backward compatibility.
        :param pulumi.Input[_builtins.int] extended_attributes_id: The ID of the extended attributes applied
        :param pulumi.Input[_builtins.bool] is_active: Whether the environment is active
        :param pulumi.Input[_builtins.str] name: The name of the environment
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the environment in
        :param pulumi.Input[_builtins.str] type: The type of environment (must be either development or deployment)
        :param pulumi.Input[_builtins.bool] use_custom_branch: Whether to use a custom git branch in this environment
        """
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if custom_branch is not None:
            pulumi.set(__self__, "custom_branch", custom_branch)
        if dbt_version is not None:
            pulumi.set(__self__, "dbt_version", dbt_version)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if enable_model_query_history is not None:
            pulumi.set(__self__, "enable_model_query_history", enable_model_query_history)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if extended_attributes_id is not None:
            pulumi.set(__self__, "extended_attributes_id", extended_attributes_id)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if use_custom_branch is not None:
            pulumi.set(__self__, "use_custom_branch", use_custom_branch)

    @_builtins.property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A connection ID (used with Global Connections)
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_id", value)

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The project ID to which the environment belongs.
        """
        return pulumi.get(self, "credential_id")

    @credential_id.setter
    def credential_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "credential_id", value)

    @_builtins.property
    @pulumi.getter(name="customBranch")
    def custom_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The custom branch name to use
        """
        return pulumi.get(self, "custom_branch")

    @custom_branch.setter
    def custom_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_branch", value)

    @_builtins.property
    @pulumi.getter(name="dbtVersion")
    def dbt_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version number of dbt to use in this environment. It needs to be in the format `major.minor.0-latest` (e.g. `1.5.0-latest`), `major.minor.0-pre`, `compatible`, `extended`, `versionless`, `latest` or `latest-fusion`. While `versionless` is still supported, using `latest` or `latest-fusion` is recommended. Defaults to `latest` if no version is provided
        """
        return pulumi.get(self, "dbt_version")

    @dbt_version.setter
    def dbt_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbt_version", value)

    @_builtins.property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of environment. Only valid for environments of type 'deployment' and for now can only be 'production', 'staging' or left empty for generic environments
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_type", value)

    @_builtins.property
    @pulumi.getter(name="enableModelQueryHistory")
    def enable_model_query_history(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable model query history in this environment. As of Oct 2024, works only for Snowflake and BigQuery.
        """
        return pulumi.get(self, "enable_model_query_history")

    @enable_model_query_history.setter
    def enable_model_query_history(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_model_query_history", value)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the environment. Duplicated. Here for backward compatibility.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "environment_id", value)

    @_builtins.property
    @pulumi.getter(name="extendedAttributesId")
    def extended_attributes_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the extended attributes applied
        """
        return pulumi.get(self, "extended_attributes_id")

    @extended_attributes_id.setter
    def extended_attributes_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "extended_attributes_id", value)

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the environment is active
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_active", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the environment
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Project ID to create the environment in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of environment (must be either development or deployment)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="useCustomBranch")
    def use_custom_branch(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to use a custom git branch in this environment
        """
        return pulumi.get(self, "use_custom_branch")

    @use_custom_branch.setter
    def use_custom_branch(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_custom_branch", value)


@pulumi.type_token("dbtcloud:index/environment:Environment")
class Environment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_id: Optional[pulumi.Input[_builtins.int]] = None,
                 credential_id: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 dbt_version: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_model_query_history: Optional[pulumi.Input[_builtins.bool]] = None,
                 extended_attributes_id: Optional[pulumi.Input[_builtins.int]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 use_custom_branch: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Resource to manage dbt Cloud environments for the different dbt Cloud projects. In a given dbt Cloud project, one development environment can be defined and as many deployment environments as needed can be created. > In August 2024, dbt Cloud released the "global connection" feature, allowing connections to be defined at the account level and reused across environments and projects. This version of the provider has the connection_id as an optional field but it is recommended to start setting it up in your projects. In future versions, this field will become mandatory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        ci_environment = dbtcloud.Environment("ci_environment",
            dbt_version="latest-fusion",
            name="CI",
            project_id=dbt_project["id"],
            type="deployment",
            credential_id=ci_credential["credentialId"],
            connection_id=my_global_connection["id"])
        # we can also set a deployment environment as being the production one
        prod_environment = dbtcloud.Environment("prod_environment",
            dbt_version="1.7.0-latest",
            name="Prod",
            project_id=dbt_project["id"],
            type="deployment",
            credential_id=prod_credential["credentialId"],
            deployment_type="production",
            connection_id=my_legacy_connection["connectionId"])
        # Creating a development environment
        dev_environment = dbtcloud.Environment("dev_environment",
            dbt_version="latest",
            name="Dev",
            project_id=dbt_project["id"],
            type="development",
            connection_id=my_other_global_connection["id"])
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_environment.prod_environment

          id = "project_id:environment_id"

        }

        import {

          to = dbtcloud_environment.prod_environment

          id = "12345:6789"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/environment:Environment prod_environment "project_id:environment_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/environment:Environment prod_environment 12345:6789
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] connection_id: A connection ID (used with Global Connections)
        :param pulumi.Input[_builtins.int] credential_id: The project ID to which the environment belongs.
        :param pulumi.Input[_builtins.str] custom_branch: The custom branch name to use
        :param pulumi.Input[_builtins.str] dbt_version: Version number of dbt to use in this environment. It needs to be in the format `major.minor.0-latest` (e.g. `1.5.0-latest`), `major.minor.0-pre`, `compatible`, `extended`, `versionless`, `latest` or `latest-fusion`. While `versionless` is still supported, using `latest` or `latest-fusion` is recommended. Defaults to `latest` if no version is provided
        :param pulumi.Input[_builtins.str] deployment_type: The type of environment. Only valid for environments of type 'deployment' and for now can only be 'production', 'staging' or left empty for generic environments
        :param pulumi.Input[_builtins.bool] enable_model_query_history: Whether to enable model query history in this environment. As of Oct 2024, works only for Snowflake and BigQuery.
        :param pulumi.Input[_builtins.int] extended_attributes_id: The ID of the extended attributes applied
        :param pulumi.Input[_builtins.bool] is_active: Whether the environment is active
        :param pulumi.Input[_builtins.str] name: The name of the environment
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the environment in
        :param pulumi.Input[_builtins.str] type: The type of environment (must be either development or deployment)
        :param pulumi.Input[_builtins.bool] use_custom_branch: Whether to use a custom git branch in this environment
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource to manage dbt Cloud environments for the different dbt Cloud projects. In a given dbt Cloud project, one development environment can be defined and as many deployment environments as needed can be created. > In August 2024, dbt Cloud released the "global connection" feature, allowing connections to be defined at the account level and reused across environments and projects. This version of the provider has the connection_id as an optional field but it is recommended to start setting it up in your projects. In future versions, this field will become mandatory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        ci_environment = dbtcloud.Environment("ci_environment",
            dbt_version="latest-fusion",
            name="CI",
            project_id=dbt_project["id"],
            type="deployment",
            credential_id=ci_credential["credentialId"],
            connection_id=my_global_connection["id"])
        # we can also set a deployment environment as being the production one
        prod_environment = dbtcloud.Environment("prod_environment",
            dbt_version="1.7.0-latest",
            name="Prod",
            project_id=dbt_project["id"],
            type="deployment",
            credential_id=prod_credential["credentialId"],
            deployment_type="production",
            connection_id=my_legacy_connection["connectionId"])
        # Creating a development environment
        dev_environment = dbtcloud.Environment("dev_environment",
            dbt_version="latest",
            name="Dev",
            project_id=dbt_project["id"],
            type="development",
            connection_id=my_other_global_connection["id"])
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_environment.prod_environment

          id = "project_id:environment_id"

        }

        import {

          to = dbtcloud_environment.prod_environment

          id = "12345:6789"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/environment:Environment prod_environment "project_id:environment_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/environment:Environment prod_environment 12345:6789
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_id: Optional[pulumi.Input[_builtins.int]] = None,
                 credential_id: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 dbt_version: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_model_query_history: Optional[pulumi.Input[_builtins.bool]] = None,
                 extended_attributes_id: Optional[pulumi.Input[_builtins.int]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 use_custom_branch: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentArgs.__new__(EnvironmentArgs)

            __props__.__dict__["connection_id"] = connection_id
            __props__.__dict__["credential_id"] = credential_id
            __props__.__dict__["custom_branch"] = custom_branch
            __props__.__dict__["dbt_version"] = dbt_version
            __props__.__dict__["deployment_type"] = deployment_type
            __props__.__dict__["enable_model_query_history"] = enable_model_query_history
            __props__.__dict__["extended_attributes_id"] = extended_attributes_id
            __props__.__dict__["is_active"] = is_active
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["use_custom_branch"] = use_custom_branch
            __props__.__dict__["environment_id"] = None
        super(Environment, __self__).__init__(
            'dbtcloud:index/environment:Environment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_id: Optional[pulumi.Input[_builtins.int]] = None,
            credential_id: Optional[pulumi.Input[_builtins.int]] = None,
            custom_branch: Optional[pulumi.Input[_builtins.str]] = None,
            dbt_version: Optional[pulumi.Input[_builtins.str]] = None,
            deployment_type: Optional[pulumi.Input[_builtins.str]] = None,
            enable_model_query_history: Optional[pulumi.Input[_builtins.bool]] = None,
            environment_id: Optional[pulumi.Input[_builtins.int]] = None,
            extended_attributes_id: Optional[pulumi.Input[_builtins.int]] = None,
            is_active: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.int]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            use_custom_branch: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Environment':
        """
        Get an existing Environment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] connection_id: A connection ID (used with Global Connections)
        :param pulumi.Input[_builtins.int] credential_id: The project ID to which the environment belongs.
        :param pulumi.Input[_builtins.str] custom_branch: The custom branch name to use
        :param pulumi.Input[_builtins.str] dbt_version: Version number of dbt to use in this environment. It needs to be in the format `major.minor.0-latest` (e.g. `1.5.0-latest`), `major.minor.0-pre`, `compatible`, `extended`, `versionless`, `latest` or `latest-fusion`. While `versionless` is still supported, using `latest` or `latest-fusion` is recommended. Defaults to `latest` if no version is provided
        :param pulumi.Input[_builtins.str] deployment_type: The type of environment. Only valid for environments of type 'deployment' and for now can only be 'production', 'staging' or left empty for generic environments
        :param pulumi.Input[_builtins.bool] enable_model_query_history: Whether to enable model query history in this environment. As of Oct 2024, works only for Snowflake and BigQuery.
        :param pulumi.Input[_builtins.int] environment_id: The ID of the environment. Duplicated. Here for backward compatibility.
        :param pulumi.Input[_builtins.int] extended_attributes_id: The ID of the extended attributes applied
        :param pulumi.Input[_builtins.bool] is_active: Whether the environment is active
        :param pulumi.Input[_builtins.str] name: The name of the environment
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the environment in
        :param pulumi.Input[_builtins.str] type: The type of environment (must be either development or deployment)
        :param pulumi.Input[_builtins.bool] use_custom_branch: Whether to use a custom git branch in this environment
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentState.__new__(_EnvironmentState)

        __props__.__dict__["connection_id"] = connection_id
        __props__.__dict__["credential_id"] = credential_id
        __props__.__dict__["custom_branch"] = custom_branch
        __props__.__dict__["dbt_version"] = dbt_version
        __props__.__dict__["deployment_type"] = deployment_type
        __props__.__dict__["enable_model_query_history"] = enable_model_query_history
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["extended_attributes_id"] = extended_attributes_id
        __props__.__dict__["is_active"] = is_active
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["type"] = type
        __props__.__dict__["use_custom_branch"] = use_custom_branch
        return Environment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Output[_builtins.int]:
        """
        A connection ID (used with Global Connections)
        """
        return pulumi.get(self, "connection_id")

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> pulumi.Output[_builtins.int]:
        """
        The project ID to which the environment belongs.
        """
        return pulumi.get(self, "credential_id")

    @_builtins.property
    @pulumi.getter(name="customBranch")
    def custom_branch(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The custom branch name to use
        """
        return pulumi.get(self, "custom_branch")

    @_builtins.property
    @pulumi.getter(name="dbtVersion")
    def dbt_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version number of dbt to use in this environment. It needs to be in the format `major.minor.0-latest` (e.g. `1.5.0-latest`), `major.minor.0-pre`, `compatible`, `extended`, `versionless`, `latest` or `latest-fusion`. While `versionless` is still supported, using `latest` or `latest-fusion` is recommended. Defaults to `latest` if no version is provided
        """
        return pulumi.get(self, "dbt_version")

    @_builtins.property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of environment. Only valid for environments of type 'deployment' and for now can only be 'production', 'staging' or left empty for generic environments
        """
        return pulumi.get(self, "deployment_type")

    @_builtins.property
    @pulumi.getter(name="enableModelQueryHistory")
    def enable_model_query_history(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable model query history in this environment. As of Oct 2024, works only for Snowflake and BigQuery.
        """
        return pulumi.get(self, "enable_model_query_history")

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the environment. Duplicated. Here for backward compatibility.
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter(name="extendedAttributesId")
    def extended_attributes_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the extended attributes applied
        """
        return pulumi.get(self, "extended_attributes_id")

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the environment is active
        """
        return pulumi.get(self, "is_active")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the environment
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.int]:
        """
        Project ID to create the environment in
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of environment (must be either development or deployment)
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="useCustomBranch")
    def use_custom_branch(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to use a custom git branch in this environment
        """
        return pulumi.get(self, "use_custom_branch")

