# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetGlobalConnectionResult',
    'AwaitableGetGlobalConnectionResult',
    'get_global_connection',
    'get_global_connection_output',
]

@pulumi.output_type
class GetGlobalConnectionResult:
    """
    A collection of values returned by getGlobalConnection.
    """
    def __init__(__self__, adapter_version=None, apache_spark=None, athena=None, bigquery=None, databricks=None, fabric=None, id=None, is_ssh_tunnel_enabled=None, name=None, oauth_configuration_id=None, postgres=None, private_link_endpoint_id=None, redshift=None, snowflake=None, starburst=None, synapse=None, teradata=None):
        if adapter_version and not isinstance(adapter_version, str):
            raise TypeError("Expected argument 'adapter_version' to be a str")
        pulumi.set(__self__, "adapter_version", adapter_version)
        if apache_spark and not isinstance(apache_spark, dict):
            raise TypeError("Expected argument 'apache_spark' to be a dict")
        pulumi.set(__self__, "apache_spark", apache_spark)
        if athena and not isinstance(athena, dict):
            raise TypeError("Expected argument 'athena' to be a dict")
        pulumi.set(__self__, "athena", athena)
        if bigquery and not isinstance(bigquery, dict):
            raise TypeError("Expected argument 'bigquery' to be a dict")
        pulumi.set(__self__, "bigquery", bigquery)
        if databricks and not isinstance(databricks, dict):
            raise TypeError("Expected argument 'databricks' to be a dict")
        pulumi.set(__self__, "databricks", databricks)
        if fabric and not isinstance(fabric, dict):
            raise TypeError("Expected argument 'fabric' to be a dict")
        pulumi.set(__self__, "fabric", fabric)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if is_ssh_tunnel_enabled and not isinstance(is_ssh_tunnel_enabled, bool):
            raise TypeError("Expected argument 'is_ssh_tunnel_enabled' to be a bool")
        pulumi.set(__self__, "is_ssh_tunnel_enabled", is_ssh_tunnel_enabled)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if oauth_configuration_id and not isinstance(oauth_configuration_id, int):
            raise TypeError("Expected argument 'oauth_configuration_id' to be a int")
        pulumi.set(__self__, "oauth_configuration_id", oauth_configuration_id)
        if postgres and not isinstance(postgres, dict):
            raise TypeError("Expected argument 'postgres' to be a dict")
        pulumi.set(__self__, "postgres", postgres)
        if private_link_endpoint_id and not isinstance(private_link_endpoint_id, str):
            raise TypeError("Expected argument 'private_link_endpoint_id' to be a str")
        pulumi.set(__self__, "private_link_endpoint_id", private_link_endpoint_id)
        if redshift and not isinstance(redshift, dict):
            raise TypeError("Expected argument 'redshift' to be a dict")
        pulumi.set(__self__, "redshift", redshift)
        if snowflake and not isinstance(snowflake, dict):
            raise TypeError("Expected argument 'snowflake' to be a dict")
        pulumi.set(__self__, "snowflake", snowflake)
        if starburst and not isinstance(starburst, dict):
            raise TypeError("Expected argument 'starburst' to be a dict")
        pulumi.set(__self__, "starburst", starburst)
        if synapse and not isinstance(synapse, dict):
            raise TypeError("Expected argument 'synapse' to be a dict")
        pulumi.set(__self__, "synapse", synapse)
        if teradata and not isinstance(teradata, dict):
            raise TypeError("Expected argument 'teradata' to be a dict")
        pulumi.set(__self__, "teradata", teradata)

    @_builtins.property
    @pulumi.getter(name="adapterVersion")
    def adapter_version(self) -> _builtins.str:
        """
        Version of the adapter
        """
        return pulumi.get(self, "adapter_version")

    @_builtins.property
    @pulumi.getter(name="apacheSpark")
    def apache_spark(self) -> 'outputs.GetGlobalConnectionApacheSparkResult':
        """
        Apache Spark connection configuration.
        """
        return pulumi.get(self, "apache_spark")

    @_builtins.property
    @pulumi.getter
    def athena(self) -> 'outputs.GetGlobalConnectionAthenaResult':
        """
        Athena connection configuration.
        """
        return pulumi.get(self, "athena")

    @_builtins.property
    @pulumi.getter
    def bigquery(self) -> 'outputs.GetGlobalConnectionBigqueryResult':
        return pulumi.get(self, "bigquery")

    @_builtins.property
    @pulumi.getter
    def databricks(self) -> 'outputs.GetGlobalConnectionDatabricksResult':
        """
        Databricks connection configuration
        """
        return pulumi.get(self, "databricks")

    @_builtins.property
    @pulumi.getter
    def fabric(self) -> 'outputs.GetGlobalConnectionFabricResult':
        """
        Microsoft Fabric connection configuration.
        """
        return pulumi.get(self, "fabric")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        Connection Identifier
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isSshTunnelEnabled")
    def is_ssh_tunnel_enabled(self) -> _builtins.bool:
        """
        Whether the connection can use an SSH tunnel
        """
        return pulumi.get(self, "is_ssh_tunnel_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Connection name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="oauthConfigurationId")
    def oauth_configuration_id(self) -> _builtins.int:
        return pulumi.get(self, "oauth_configuration_id")

    @_builtins.property
    @pulumi.getter
    def postgres(self) -> 'outputs.GetGlobalConnectionPostgresResult':
        """
        PostgreSQL connection configuration.
        """
        return pulumi.get(self, "postgres")

    @_builtins.property
    @pulumi.getter(name="privateLinkEndpointId")
    def private_link_endpoint_id(self) -> _builtins.str:
        """
        Private Link Endpoint ID. This ID can be found using the `privatelink_endpoint` data source
        """
        return pulumi.get(self, "private_link_endpoint_id")

    @_builtins.property
    @pulumi.getter
    def redshift(self) -> 'outputs.GetGlobalConnectionRedshiftResult':
        """
        Redshift connection configuration
        """
        return pulumi.get(self, "redshift")

    @_builtins.property
    @pulumi.getter
    def snowflake(self) -> 'outputs.GetGlobalConnectionSnowflakeResult':
        """
        Snowflake connection configuration
        """
        return pulumi.get(self, "snowflake")

    @_builtins.property
    @pulumi.getter
    def starburst(self) -> 'outputs.GetGlobalConnectionStarburstResult':
        """
        Starburst/Trino connection configuration.
        """
        return pulumi.get(self, "starburst")

    @_builtins.property
    @pulumi.getter
    def synapse(self) -> 'outputs.GetGlobalConnectionSynapseResult':
        """
        Azure Synapse Analytics connection configuration.
        """
        return pulumi.get(self, "synapse")

    @_builtins.property
    @pulumi.getter
    def teradata(self) -> 'outputs.GetGlobalConnectionTeradataResult':
        """
        Teradata connection configuration.
        """
        return pulumi.get(self, "teradata")


class AwaitableGetGlobalConnectionResult(GetGlobalConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGlobalConnectionResult(
            adapter_version=self.adapter_version,
            apache_spark=self.apache_spark,
            athena=self.athena,
            bigquery=self.bigquery,
            databricks=self.databricks,
            fabric=self.fabric,
            id=self.id,
            is_ssh_tunnel_enabled=self.is_ssh_tunnel_enabled,
            name=self.name,
            oauth_configuration_id=self.oauth_configuration_id,
            postgres=self.postgres,
            private_link_endpoint_id=self.private_link_endpoint_id,
            redshift=self.redshift,
            snowflake=self.snowflake,
            starburst=self.starburst,
            synapse=self.synapse,
            teradata=self.teradata)


def get_global_connection(id: Optional[_builtins.int] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGlobalConnectionResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    my_connection = dbtcloud.get_global_connection(id=1234)
    ```


    :param _builtins.int id: Connection Identifier
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getGlobalConnection:getGlobalConnection', __args__, opts=opts, typ=GetGlobalConnectionResult).value

    return AwaitableGetGlobalConnectionResult(
        adapter_version=pulumi.get(__ret__, 'adapter_version'),
        apache_spark=pulumi.get(__ret__, 'apache_spark'),
        athena=pulumi.get(__ret__, 'athena'),
        bigquery=pulumi.get(__ret__, 'bigquery'),
        databricks=pulumi.get(__ret__, 'databricks'),
        fabric=pulumi.get(__ret__, 'fabric'),
        id=pulumi.get(__ret__, 'id'),
        is_ssh_tunnel_enabled=pulumi.get(__ret__, 'is_ssh_tunnel_enabled'),
        name=pulumi.get(__ret__, 'name'),
        oauth_configuration_id=pulumi.get(__ret__, 'oauth_configuration_id'),
        postgres=pulumi.get(__ret__, 'postgres'),
        private_link_endpoint_id=pulumi.get(__ret__, 'private_link_endpoint_id'),
        redshift=pulumi.get(__ret__, 'redshift'),
        snowflake=pulumi.get(__ret__, 'snowflake'),
        starburst=pulumi.get(__ret__, 'starburst'),
        synapse=pulumi.get(__ret__, 'synapse'),
        teradata=pulumi.get(__ret__, 'teradata'))
def get_global_connection_output(id: Optional[pulumi.Input[_builtins.int]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGlobalConnectionResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    my_connection = dbtcloud.get_global_connection(id=1234)
    ```


    :param _builtins.int id: Connection Identifier
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getGlobalConnection:getGlobalConnection', __args__, opts=opts, typ=GetGlobalConnectionResult)
    return __ret__.apply(lambda __response__: GetGlobalConnectionResult(
        adapter_version=pulumi.get(__response__, 'adapter_version'),
        apache_spark=pulumi.get(__response__, 'apache_spark'),
        athena=pulumi.get(__response__, 'athena'),
        bigquery=pulumi.get(__response__, 'bigquery'),
        databricks=pulumi.get(__response__, 'databricks'),
        fabric=pulumi.get(__response__, 'fabric'),
        id=pulumi.get(__response__, 'id'),
        is_ssh_tunnel_enabled=pulumi.get(__response__, 'is_ssh_tunnel_enabled'),
        name=pulumi.get(__response__, 'name'),
        oauth_configuration_id=pulumi.get(__response__, 'oauth_configuration_id'),
        postgres=pulumi.get(__response__, 'postgres'),
        private_link_endpoint_id=pulumi.get(__response__, 'private_link_endpoint_id'),
        redshift=pulumi.get(__response__, 'redshift'),
        snowflake=pulumi.get(__response__, 'snowflake'),
        starburst=pulumi.get(__response__, 'starburst'),
        synapse=pulumi.get(__response__, 'synapse'),
        teradata=pulumi.get(__response__, 'teradata')))
