# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetNotificationResult',
    'AwaitableGetNotificationResult',
    'get_notification',
    'get_notification_output',
]

@pulumi.output_type
class GetNotificationResult:
    """
    A collection of values returned by getNotification.
    """
    def __init__(__self__, external_email=None, id=None, notification_id=None, notification_type=None, on_cancels=None, on_failures=None, on_successes=None, on_warnings=None, slack_channel_id=None, slack_channel_name=None, state=None, user_id=None):
        if external_email and not isinstance(external_email, str):
            raise TypeError("Expected argument 'external_email' to be a str")
        pulumi.set(__self__, "external_email", external_email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if notification_id and not isinstance(notification_id, int):
            raise TypeError("Expected argument 'notification_id' to be a int")
        pulumi.set(__self__, "notification_id", notification_id)
        if notification_type and not isinstance(notification_type, int):
            raise TypeError("Expected argument 'notification_type' to be a int")
        pulumi.set(__self__, "notification_type", notification_type)
        if on_cancels and not isinstance(on_cancels, list):
            raise TypeError("Expected argument 'on_cancels' to be a list")
        pulumi.set(__self__, "on_cancels", on_cancels)
        if on_failures and not isinstance(on_failures, list):
            raise TypeError("Expected argument 'on_failures' to be a list")
        pulumi.set(__self__, "on_failures", on_failures)
        if on_successes and not isinstance(on_successes, list):
            raise TypeError("Expected argument 'on_successes' to be a list")
        pulumi.set(__self__, "on_successes", on_successes)
        if on_warnings and not isinstance(on_warnings, list):
            raise TypeError("Expected argument 'on_warnings' to be a list")
        pulumi.set(__self__, "on_warnings", on_warnings)
        if slack_channel_id and not isinstance(slack_channel_id, str):
            raise TypeError("Expected argument 'slack_channel_id' to be a str")
        pulumi.set(__self__, "slack_channel_id", slack_channel_id)
        if slack_channel_name and not isinstance(slack_channel_name, str):
            raise TypeError("Expected argument 'slack_channel_name' to be a str")
        pulumi.set(__self__, "slack_channel_name", slack_channel_name)
        if state and not isinstance(state, int):
            raise TypeError("Expected argument 'state' to be a int")
        pulumi.set(__self__, "state", state)
        if user_id and not isinstance(user_id, int):
            raise TypeError("Expected argument 'user_id' to be a int")
        pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="externalEmail")
    def external_email(self) -> _builtins.str:
        """
        The external email to receive the notification
        """
        return pulumi.get(self, "external_email")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="notificationId")
    def notification_id(self) -> _builtins.int:
        """
        The ID of the notification
        """
        return pulumi.get(self, "notification_id")

    @_builtins.property
    @pulumi.getter(name="notificationType")
    def notification_type(self) -> _builtins.int:
        """
        Type of notification (1 = dbt Cloud user email (default): does not require an external_email ; 2 = Slack channel: requires `slack_channel_id` and `slack_channel_name` ; 4 = external email: requires setting an `external_email`)
        """
        return pulumi.get(self, "notification_type")

    @_builtins.property
    @pulumi.getter(name="onCancels")
    def on_cancels(self) -> Sequence[_builtins.int]:
        """
        List of job IDs to trigger the webhook on cancel
        """
        return pulumi.get(self, "on_cancels")

    @_builtins.property
    @pulumi.getter(name="onFailures")
    def on_failures(self) -> Sequence[_builtins.int]:
        """
        List of job IDs to trigger the webhook on failure
        """
        return pulumi.get(self, "on_failures")

    @_builtins.property
    @pulumi.getter(name="onSuccesses")
    def on_successes(self) -> Sequence[_builtins.int]:
        """
        List of job IDs to trigger the webhook on success
        """
        return pulumi.get(self, "on_successes")

    @_builtins.property
    @pulumi.getter(name="onWarnings")
    def on_warnings(self) -> Sequence[_builtins.int]:
        """
        List of job IDs to trigger the webhook on warning
        """
        return pulumi.get(self, "on_warnings")

    @_builtins.property
    @pulumi.getter(name="slackChannelId")
    def slack_channel_id(self) -> _builtins.str:
        """
        The ID of the Slack channel to receive the notification. It can be found at the bottom of the Slack channel settings
        """
        return pulumi.get(self, "slack_channel_id")

    @_builtins.property
    @pulumi.getter(name="slackChannelName")
    def slack_channel_name(self) -> _builtins.str:
        """
        The name of the slack channel
        """
        return pulumi.get(self, "slack_channel_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.int:
        """
        State of the notification (1 = active (default), 2 = inactive)
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.int:
        """
        Internal dbt Cloud User ID. Must be the user_id for an existing user even if the notification is an external one
        """
        return pulumi.get(self, "user_id")


class AwaitableGetNotificationResult(GetNotificationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNotificationResult(
            external_email=self.external_email,
            id=self.id,
            notification_id=self.notification_id,
            notification_type=self.notification_type,
            on_cancels=self.on_cancels,
            on_failures=self.on_failures,
            on_successes=self.on_successes,
            on_warnings=self.on_warnings,
            slack_channel_id=self.slack_channel_id,
            slack_channel_name=self.slack_channel_name,
            state=self.state,
            user_id=self.user_id)


def get_notification(notification_id: Optional[_builtins.int] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNotificationResult:
    """
    Retrieve notification details

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    my_notification = dbtcloud.get_notification(notification_id=12345)
    ```


    :param _builtins.int notification_id: The ID of the notification
    """
    __args__ = dict()
    __args__['notificationId'] = notification_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getNotification:getNotification', __args__, opts=opts, typ=GetNotificationResult).value

    return AwaitableGetNotificationResult(
        external_email=pulumi.get(__ret__, 'external_email'),
        id=pulumi.get(__ret__, 'id'),
        notification_id=pulumi.get(__ret__, 'notification_id'),
        notification_type=pulumi.get(__ret__, 'notification_type'),
        on_cancels=pulumi.get(__ret__, 'on_cancels'),
        on_failures=pulumi.get(__ret__, 'on_failures'),
        on_successes=pulumi.get(__ret__, 'on_successes'),
        on_warnings=pulumi.get(__ret__, 'on_warnings'),
        slack_channel_id=pulumi.get(__ret__, 'slack_channel_id'),
        slack_channel_name=pulumi.get(__ret__, 'slack_channel_name'),
        state=pulumi.get(__ret__, 'state'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_notification_output(notification_id: Optional[pulumi.Input[_builtins.int]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNotificationResult]:
    """
    Retrieve notification details

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    my_notification = dbtcloud.get_notification(notification_id=12345)
    ```


    :param _builtins.int notification_id: The ID of the notification
    """
    __args__ = dict()
    __args__['notificationId'] = notification_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getNotification:getNotification', __args__, opts=opts, typ=GetNotificationResult)
    return __ret__.apply(lambda __response__: GetNotificationResult(
        external_email=pulumi.get(__response__, 'external_email'),
        id=pulumi.get(__response__, 'id'),
        notification_id=pulumi.get(__response__, 'notification_id'),
        notification_type=pulumi.get(__response__, 'notification_type'),
        on_cancels=pulumi.get(__response__, 'on_cancels'),
        on_failures=pulumi.get(__response__, 'on_failures'),
        on_successes=pulumi.get(__response__, 'on_successes'),
        on_warnings=pulumi.get(__response__, 'on_warnings'),
        slack_channel_id=pulumi.get(__response__, 'slack_channel_id'),
        slack_channel_name=pulumi.get(__response__, 'slack_channel_name'),
        state=pulumi.get(__response__, 'state'),
        user_id=pulumi.get(__response__, 'user_id')))
