# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetProjectResult',
    'AwaitableGetProjectResult',
    'get_project',
    'get_project_output',
]

@pulumi.output_type
class GetProjectResult:
    """
    A collection of values returned by getProject.
    """
    def __init__(__self__, created_at=None, dbt_project_subdirectory=None, description=None, docs_job_id=None, freshness_job_id=None, id=None, name=None, project_connection=None, repository=None, semantic_layer_config_id=None, state=None, type=None, updated_at=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if dbt_project_subdirectory and not isinstance(dbt_project_subdirectory, str):
            raise TypeError("Expected argument 'dbt_project_subdirectory' to be a str")
        pulumi.set(__self__, "dbt_project_subdirectory", dbt_project_subdirectory)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if docs_job_id and not isinstance(docs_job_id, int):
            raise TypeError("Expected argument 'docs_job_id' to be a int")
        pulumi.set(__self__, "docs_job_id", docs_job_id)
        if freshness_job_id and not isinstance(freshness_job_id, int):
            raise TypeError("Expected argument 'freshness_job_id' to be a int")
        pulumi.set(__self__, "freshness_job_id", freshness_job_id)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_connection and not isinstance(project_connection, dict):
            raise TypeError("Expected argument 'project_connection' to be a dict")
        pulumi.set(__self__, "project_connection", project_connection)
        if repository and not isinstance(repository, dict):
            raise TypeError("Expected argument 'repository' to be a dict")
        pulumi.set(__self__, "repository", repository)
        if semantic_layer_config_id and not isinstance(semantic_layer_config_id, int):
            raise TypeError("Expected argument 'semantic_layer_config_id' to be a int")
        pulumi.set(__self__, "semantic_layer_config_id", semantic_layer_config_id)
        if state and not isinstance(state, int):
            raise TypeError("Expected argument 'state' to be a int")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, int):
            raise TypeError("Expected argument 'type' to be a int")
        pulumi.set(__self__, "type", type)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        When the project was created
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="dbtProjectSubdirectory")
    def dbt_project_subdirectory(self) -> _builtins.str:
        """
        Subdirectory for the dbt project inside the git repo
        """
        return pulumi.get(self, "dbt_project_subdirectory")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Project description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="docsJobId")
    def docs_job_id(self) -> _builtins.int:
        """
        ID of Job for the documentation
        """
        return pulumi.get(self, "docs_job_id")

    @_builtins.property
    @pulumi.getter(name="freshnessJobId")
    def freshness_job_id(self) -> _builtins.int:
        """
        ID of Job for source freshness
        """
        return pulumi.get(self, "freshness_job_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.int]:
        """
        Project ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Project name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectConnection")
    def project_connection(self) -> 'outputs.GetProjectProjectConnectionResult':
        """
        Details for the connection linked to the project
        """
        return pulumi.get(self, "project_connection")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> 'outputs.GetProjectRepositoryResult':
        """
        Details for the repository linked to the project
        """
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter(name="semanticLayerConfigId")
    def semantic_layer_config_id(self) -> _builtins.int:
        """
        Semantic layer config ID
        """
        return pulumi.get(self, "semantic_layer_config_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.int:
        """
        Project state should be 1 = active, as 2 = deleted
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.int:
        """
        The type of dbt project (default or hybrid)
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        When the project was last updated
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetProjectResult(GetProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectResult(
            created_at=self.created_at,
            dbt_project_subdirectory=self.dbt_project_subdirectory,
            description=self.description,
            docs_job_id=self.docs_job_id,
            freshness_job_id=self.freshness_job_id,
            id=self.id,
            name=self.name,
            project_connection=self.project_connection,
            repository=self.repository,
            semantic_layer_config_id=self.semantic_layer_config_id,
            state=self.state,
            type=self.type,
            updated_at=self.updated_at)


def get_project(id: Optional[_builtins.int] = None,
                name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectResult:
    """
    Retrieve a specific project from dbt Cloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    # projects data sources can use the project_id parameter (preferred uniqueness is ensured)
    project_by_id = dbtcloud.get_project(id=0)
    # or they can use project names
    # the provider will raise an error if more than one project is found with the same name
    project_by_name = dbtcloud.get_project(name="Project name")
    filtered_projects = dbtcloud.get_projects(name_contains="Project")
    all_projects = dbtcloud.get_projects()
    pulumi.export("projectIdDetails", project_by_id)
    pulumi.export("projectNameDetails", project_by_name)
    pulumi.export("filteredProjectsCount", len(filtered_projects.projects))
    pulumi.export("filteredProjects", filtered_projects.projects)
    pulumi.export("projectNames", [project.name for project in filtered_projects.projects])
    ```


    :param _builtins.int id: Project ID
    :param _builtins.str name: Project name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getProject:getProject', __args__, opts=opts, typ=GetProjectResult).value

    return AwaitableGetProjectResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        dbt_project_subdirectory=pulumi.get(__ret__, 'dbt_project_subdirectory'),
        description=pulumi.get(__ret__, 'description'),
        docs_job_id=pulumi.get(__ret__, 'docs_job_id'),
        freshness_job_id=pulumi.get(__ret__, 'freshness_job_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project_connection=pulumi.get(__ret__, 'project_connection'),
        repository=pulumi.get(__ret__, 'repository'),
        semantic_layer_config_id=pulumi.get(__ret__, 'semantic_layer_config_id'),
        state=pulumi.get(__ret__, 'state'),
        type=pulumi.get(__ret__, 'type'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_project_output(id: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectResult]:
    """
    Retrieve a specific project from dbt Cloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    # projects data sources can use the project_id parameter (preferred uniqueness is ensured)
    project_by_id = dbtcloud.get_project(id=0)
    # or they can use project names
    # the provider will raise an error if more than one project is found with the same name
    project_by_name = dbtcloud.get_project(name="Project name")
    filtered_projects = dbtcloud.get_projects(name_contains="Project")
    all_projects = dbtcloud.get_projects()
    pulumi.export("projectIdDetails", project_by_id)
    pulumi.export("projectNameDetails", project_by_name)
    pulumi.export("filteredProjectsCount", len(filtered_projects.projects))
    pulumi.export("filteredProjects", filtered_projects.projects)
    pulumi.export("projectNames", [project.name for project in filtered_projects.projects])
    ```


    :param _builtins.int id: Project ID
    :param _builtins.str name: Project name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getProject:getProject', __args__, opts=opts, typ=GetProjectResult)
    return __ret__.apply(lambda __response__: GetProjectResult(
        created_at=pulumi.get(__response__, 'created_at'),
        dbt_project_subdirectory=pulumi.get(__response__, 'dbt_project_subdirectory'),
        description=pulumi.get(__response__, 'description'),
        docs_job_id=pulumi.get(__response__, 'docs_job_id'),
        freshness_job_id=pulumi.get(__response__, 'freshness_job_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project_connection=pulumi.get(__response__, 'project_connection'),
        repository=pulumi.get(__response__, 'repository'),
        semantic_layer_config_id=pulumi.get(__response__, 'semantic_layer_config_id'),
        state=pulumi.get(__response__, 'state'),
        type=pulumi.get(__response__, 'type'),
        updated_at=pulumi.get(__response__, 'updated_at')))
