# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetUserGroupsResult',
    'AwaitableGetUserGroupsResult',
    'get_user_groups',
    'get_user_groups_output',
]

@pulumi.output_type
class GetUserGroupsResult:
    """
    A collection of values returned by getUserGroups.
    """
    def __init__(__self__, group_ids=None, id=None, user_id=None):
        if group_ids and not isinstance(group_ids, list):
            raise TypeError("Expected argument 'group_ids' to be a list")
        pulumi.set(__self__, "group_ids", group_ids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if user_id and not isinstance(user_id, int):
            raise TypeError("Expected argument 'user_id' to be a int")
        pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Sequence[_builtins.int]:
        """
        IDs of the groups assigned to the user.
        """
        return pulumi.get(self, "group_ids")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource. It is the same as the user_id.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.int:
        """
        The internal ID of a dbt Cloud user.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetUserGroupsResult(GetUserGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserGroupsResult(
            group_ids=self.group_ids,
            id=self.id,
            user_id=self.user_id)


def get_user_groups(user_id: Optional[_builtins.int] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserGroupsResult:
    """
    Gets information about a specific dbt Cloud user's groups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    my_user_groups = dbtcloud.get_user_groups(user_id=12345)
    ```


    :param _builtins.int user_id: The internal ID of a dbt Cloud user.
    """
    __args__ = dict()
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getUserGroups:getUserGroups', __args__, opts=opts, typ=GetUserGroupsResult).value

    return AwaitableGetUserGroupsResult(
        group_ids=pulumi.get(__ret__, 'group_ids'),
        id=pulumi.get(__ret__, 'id'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_user_groups_output(user_id: Optional[pulumi.Input[_builtins.int]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserGroupsResult]:
    """
    Gets information about a specific dbt Cloud user's groups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    my_user_groups = dbtcloud.get_user_groups(user_id=12345)
    ```


    :param _builtins.int user_id: The internal ID of a dbt Cloud user.
    """
    __args__ = dict()
    __args__['userId'] = user_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getUserGroups:getUserGroups', __args__, opts=opts, typ=GetUserGroupsResult)
    return __ret__.apply(lambda __response__: GetUserGroupsResult(
        group_ids=pulumi.get(__response__, 'group_ids'),
        id=pulumi.get(__response__, 'id'),
        user_id=pulumi.get(__response__, 'user_id')))
