# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PostgresCredentialArgs', 'PostgresCredential']

@pulumi.input_type
class PostgresCredentialArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.int],
                 username: pulumi.Input[_builtins.str],
                 default_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 num_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 semantic_layer_credential: Optional[pulumi.Input[_builtins.bool]] = None,
                 target_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PostgresCredential resource.
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the Postgres/Redshift/AlloyDB credential in.
        :param pulumi.Input[_builtins.str] username: Username for Postgres/Redshift/AlloyDB
        :param pulumi.Input[_builtins.str] default_schema: Default schema name. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        :param pulumi.Input[_builtins.bool] is_active: Whether the Postgres/Redshift/AlloyDB credential is active
        :param pulumi.Input[_builtins.int] num_threads: Number of threads to use (required for Redshift)
        :param pulumi.Input[_builtins.str] password: Password for Postgres/Redshift/AlloyDB
        :param pulumi.Input[_builtins.bool] semantic_layer_credential: This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Postgres credential for the Semantic Layer.
        :param pulumi.Input[_builtins.str] target_name: Default schema name
        :param pulumi.Input[_builtins.str] type: Type of connection. One of (postgres/redshift). Use postgres for alloydb connections. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "username", username)
        if default_schema is not None:
            pulumi.set(__self__, "default_schema", default_schema)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if num_threads is not None:
            pulumi.set(__self__, "num_threads", num_threads)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if semantic_layer_credential is not None:
            pulumi.set(__self__, "semantic_layer_credential", semantic_layer_credential)
        if target_name is not None:
            pulumi.set(__self__, "target_name", target_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.int]:
        """
        Project ID to create the Postgres/Redshift/AlloyDB credential in.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        Username for Postgres/Redshift/AlloyDB
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="defaultSchema")
    def default_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default schema name. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        return pulumi.get(self, "default_schema")

    @default_schema.setter
    def default_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_schema", value)

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Postgres/Redshift/AlloyDB credential is active
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_active", value)

    @_builtins.property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of threads to use (required for Redshift)
        """
        return pulumi.get(self, "num_threads")

    @num_threads.setter
    def num_threads(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_threads", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for Postgres/Redshift/AlloyDB
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="semanticLayerCredential")
    def semantic_layer_credential(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Postgres credential for the Semantic Layer.
        """
        return pulumi.get(self, "semantic_layer_credential")

    @semantic_layer_credential.setter
    def semantic_layer_credential(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "semantic_layer_credential", value)

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default schema name
        """
        return pulumi.get(self, "target_name")

    @target_name.setter
    def target_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of connection. One of (postgres/redshift). Use postgres for alloydb connections. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _PostgresCredentialState:
    def __init__(__self__, *,
                 credential_id: Optional[pulumi.Input[_builtins.int]] = None,
                 default_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 num_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 semantic_layer_credential: Optional[pulumi.Input[_builtins.bool]] = None,
                 target_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PostgresCredential resources.
        :param pulumi.Input[_builtins.int] credential_id: The system Postgres/Redshift/AlloyDB credential ID.
        :param pulumi.Input[_builtins.str] default_schema: Default schema name. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        :param pulumi.Input[_builtins.bool] is_active: Whether the Postgres/Redshift/AlloyDB credential is active
        :param pulumi.Input[_builtins.int] num_threads: Number of threads to use (required for Redshift)
        :param pulumi.Input[_builtins.str] password: Password for Postgres/Redshift/AlloyDB
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the Postgres/Redshift/AlloyDB credential in.
        :param pulumi.Input[_builtins.bool] semantic_layer_credential: This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Postgres credential for the Semantic Layer.
        :param pulumi.Input[_builtins.str] target_name: Default schema name
        :param pulumi.Input[_builtins.str] type: Type of connection. One of (postgres/redshift). Use postgres for alloydb connections. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        :param pulumi.Input[_builtins.str] username: Username for Postgres/Redshift/AlloyDB
        """
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if default_schema is not None:
            pulumi.set(__self__, "default_schema", default_schema)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if num_threads is not None:
            pulumi.set(__self__, "num_threads", num_threads)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if semantic_layer_credential is not None:
            pulumi.set(__self__, "semantic_layer_credential", semantic_layer_credential)
        if target_name is not None:
            pulumi.set(__self__, "target_name", target_name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The system Postgres/Redshift/AlloyDB credential ID.
        """
        return pulumi.get(self, "credential_id")

    @credential_id.setter
    def credential_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "credential_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultSchema")
    def default_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default schema name. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        return pulumi.get(self, "default_schema")

    @default_schema.setter
    def default_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_schema", value)

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Postgres/Redshift/AlloyDB credential is active
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_active", value)

    @_builtins.property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of threads to use (required for Redshift)
        """
        return pulumi.get(self, "num_threads")

    @num_threads.setter
    def num_threads(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_threads", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for Postgres/Redshift/AlloyDB
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Project ID to create the Postgres/Redshift/AlloyDB credential in.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="semanticLayerCredential")
    def semantic_layer_credential(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Postgres credential for the Semantic Layer.
        """
        return pulumi.get(self, "semantic_layer_credential")

    @semantic_layer_credential.setter
    def semantic_layer_credential(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "semantic_layer_credential", value)

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default schema name
        """
        return pulumi.get(self, "target_name")

    @target_name.setter
    def target_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of connection. One of (postgres/redshift). Use postgres for alloydb connections. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username for Postgres/Redshift/AlloyDB
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("dbtcloud:index/postgresCredential:PostgresCredential")
class PostgresCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 num_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 semantic_layer_credential: Optional[pulumi.Input[_builtins.bool]] = None,
                 target_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Postgres credential resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        postgres_prod_credential = dbtcloud.PostgresCredential("postgres_prod_credential",
            is_active=True,
            project_id=dbt_project["id"],
            type="postgres",
            default_schema="my_schema",
            username="my_username",
            password="my_password",
            num_threads=16)
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_postgres_credential.my_credential

          id = "project_id:credential_id"

        }

        import {

          to = dbtcloud_postgres_credential.my_credential

          id = "12345:6789"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/postgresCredential:PostgresCredential my_credential "project_id:credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/postgresCredential:PostgresCredential my_credential 12345:6789
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_schema: Default schema name. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        :param pulumi.Input[_builtins.bool] is_active: Whether the Postgres/Redshift/AlloyDB credential is active
        :param pulumi.Input[_builtins.int] num_threads: Number of threads to use (required for Redshift)
        :param pulumi.Input[_builtins.str] password: Password for Postgres/Redshift/AlloyDB
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the Postgres/Redshift/AlloyDB credential in.
        :param pulumi.Input[_builtins.bool] semantic_layer_credential: This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Postgres credential for the Semantic Layer.
        :param pulumi.Input[_builtins.str] target_name: Default schema name
        :param pulumi.Input[_builtins.str] type: Type of connection. One of (postgres/redshift). Use postgres for alloydb connections. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        :param pulumi.Input[_builtins.str] username: Username for Postgres/Redshift/AlloyDB
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PostgresCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Postgres credential resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        postgres_prod_credential = dbtcloud.PostgresCredential("postgres_prod_credential",
            is_active=True,
            project_id=dbt_project["id"],
            type="postgres",
            default_schema="my_schema",
            username="my_username",
            password="my_password",
            num_threads=16)
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_postgres_credential.my_credential

          id = "project_id:credential_id"

        }

        import {

          to = dbtcloud_postgres_credential.my_credential

          id = "12345:6789"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/postgresCredential:PostgresCredential my_credential "project_id:credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/postgresCredential:PostgresCredential my_credential 12345:6789
        ```

        :param str resource_name: The name of the resource.
        :param PostgresCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PostgresCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 num_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 semantic_layer_credential: Optional[pulumi.Input[_builtins.bool]] = None,
                 target_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PostgresCredentialArgs.__new__(PostgresCredentialArgs)

            __props__.__dict__["default_schema"] = default_schema
            __props__.__dict__["is_active"] = is_active
            __props__.__dict__["num_threads"] = num_threads
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["semantic_layer_credential"] = semantic_layer_credential
            __props__.__dict__["target_name"] = target_name
            __props__.__dict__["type"] = type
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["credential_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(PostgresCredential, __self__).__init__(
            'dbtcloud:index/postgresCredential:PostgresCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            credential_id: Optional[pulumi.Input[_builtins.int]] = None,
            default_schema: Optional[pulumi.Input[_builtins.str]] = None,
            is_active: Optional[pulumi.Input[_builtins.bool]] = None,
            num_threads: Optional[pulumi.Input[_builtins.int]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.int]] = None,
            semantic_layer_credential: Optional[pulumi.Input[_builtins.bool]] = None,
            target_name: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'PostgresCredential':
        """
        Get an existing PostgresCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] credential_id: The system Postgres/Redshift/AlloyDB credential ID.
        :param pulumi.Input[_builtins.str] default_schema: Default schema name. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        :param pulumi.Input[_builtins.bool] is_active: Whether the Postgres/Redshift/AlloyDB credential is active
        :param pulumi.Input[_builtins.int] num_threads: Number of threads to use (required for Redshift)
        :param pulumi.Input[_builtins.str] password: Password for Postgres/Redshift/AlloyDB
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the Postgres/Redshift/AlloyDB credential in.
        :param pulumi.Input[_builtins.bool] semantic_layer_credential: This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Postgres credential for the Semantic Layer.
        :param pulumi.Input[_builtins.str] target_name: Default schema name
        :param pulumi.Input[_builtins.str] type: Type of connection. One of (postgres/redshift). Use postgres for alloydb connections. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        :param pulumi.Input[_builtins.str] username: Username for Postgres/Redshift/AlloyDB
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PostgresCredentialState.__new__(_PostgresCredentialState)

        __props__.__dict__["credential_id"] = credential_id
        __props__.__dict__["default_schema"] = default_schema
        __props__.__dict__["is_active"] = is_active
        __props__.__dict__["num_threads"] = num_threads
        __props__.__dict__["password"] = password
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["semantic_layer_credential"] = semantic_layer_credential
        __props__.__dict__["target_name"] = target_name
        __props__.__dict__["type"] = type
        __props__.__dict__["username"] = username
        return PostgresCredential(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> pulumi.Output[_builtins.int]:
        """
        The system Postgres/Redshift/AlloyDB credential ID.
        """
        return pulumi.get(self, "credential_id")

    @_builtins.property
    @pulumi.getter(name="defaultSchema")
    def default_schema(self) -> pulumi.Output[_builtins.str]:
        """
        Default schema name. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        return pulumi.get(self, "default_schema")

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the Postgres/Redshift/AlloyDB credential is active
        """
        return pulumi.get(self, "is_active")

    @_builtins.property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> pulumi.Output[_builtins.int]:
        """
        Number of threads to use (required for Redshift)
        """
        return pulumi.get(self, "num_threads")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Password for Postgres/Redshift/AlloyDB
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.int]:
        """
        Project ID to create the Postgres/Redshift/AlloyDB credential in.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="semanticLayerCredential")
    def semantic_layer_credential(self) -> pulumi.Output[_builtins.bool]:
        """
        This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Postgres credential for the Semantic Layer.
        """
        return pulumi.get(self, "semantic_layer_credential")

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> pulumi.Output[_builtins.str]:
        """
        Default schema name
        """
        return pulumi.get(self, "target_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of connection. One of (postgres/redshift). Use postgres for alloydb connections. Optional only when semantic*layer*credential is set to true; otherwise, this field is required.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        Username for Postgres/Redshift/AlloyDB
        """
        return pulumi.get(self, "username")

