# https://altair-viz.github.io/gallery/density_stack.html

import altair as alt
from vega_datasets import data

source = data.iris()

alt.Chart(source).transform_fold(
    ["petalWidth", "petalLength", "sepalWidth", "sepalLength"],
    as_=["Measurement_type", "value"],
).transform_density(
    density="value",
    bandwidth=0.3,
    groupby=["Measurement_type"],
    extent=[0, 8],
    counts=True,
    steps=200,
).mark_area().encode(
    alt.X("value:Q"), alt.Y("density:Q", stack="zero"), alt.Color("Measurement_type:N")
).properties(width=400, height=100)
