# https://altair-viz.github.io/gallery/trellis_area_sort_array.html

import altair as alt
from vega_datasets import data

source = data.stocks()

alt.Chart(source).transform_filter(alt.datum.symbol != "GOOG").mark_area().encode(
    x="date:T",
    y="price:Q",
    color="symbol:N",
    row=alt.Row("symbol:N", sort=["MSFT", "AAPL", "IBM", "AMZN"]),
).properties(height=50, width=400)
